//Recipes By Hikari_Nova.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import crafttweaker.item.IItemStack;

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;

import mods.modularmachinery.FactoryRecipeThread;
import mods.modularmachinery.MachineModifier;

import mods.modularmachinery.IMachineController;
import mods.modularmachinery.RecipeModifierBuilder;
import mods.modularmachinery.ActiveMachineRecipe;

import mods.modularmachinery.MMEvents;
import mods.modularmachinery.MachineTickEvent;
import mods.modularmachinery.RecipeStartEvent;
import mods.modularmachinery.RecipeTickEvent;
import mods.modularmachinery.RecipeFinishEvent;
import mods.modularmachinery.ControllerGUIRenderEvent;

import novaeng.hypernet.HyperNetHelper;

//托卡马克聚变反应堆
var requireTemp as int = 20000;
var liquidfusionFuelUsage = 6250;
var energyOutput = 125000000 as long;
var plasmaOutput = 200;

HyperNetHelper.proxyMachineForHyperNet("tokmak_reactor");
MachineModifier.setInternalParallelism("tokmak_reactor", 20);

RecipeBuilder.newBuilder("tokmak_reactor_react", "tokmak_reactor", 40, 0, true)
    .addEnergyPerTickInput(4000000).setParallelizeUnaffected(true)
    .addInput(<contenttweaker:programming_circuit_c>).setChance(0).setParallelizeUnaffected(true)
    .addInput(<contenttweaker:programming_circuit_0>).setChance(0).setParallelizeUnaffected(true)
    .addInput(<liquid:liquidfusionfuel> * liquidfusionFuelUsage)
    .addOutput(<liquid:plasma> * plasmaOutput)
    .addEnergyPerTickOutput(energyOutput)
    .addPreTickHandler(function(event as RecipeTickEvent) {
        checkTemp(event, requireTemp, requireTemp * 4);
    })
    .addFinishHandler(function(event as RecipeFinishEvent) {
        event.controller.removeModifier("hasEnoughTemp");
    })
    .addRecipeTooltip("需要温度：" + requireTemp + "Mk，最高：" + (requireTemp * 4) + "Mk", "§2仅在低温加热时消耗能量。", "§a能量消耗不受并行影响。")
    .requireComputationPoint(50.0F)
    .build();

RecipeBuilder.newBuilder("tokmak_reactor_react_liquid_energy", "tokmak_reactor", 40, 1, true)
    .addEnergyPerTickInput(4000000).setParallelizeUnaffected(true)
    .addInput(<contenttweaker:programming_circuit_d>).setChance(0).setParallelizeUnaffected(true)
    .addInput(<contenttweaker:programming_circuit_0>).setChance(0).setParallelizeUnaffected(true)
    .addInput(<liquid:liquidfusionfuel> * liquidfusionFuelUsage)
    .addOutput(<liquid:liquid_energy> * 1)
    .addOutput(<liquid:plasma> * plasmaOutput)
    .addPreTickHandler(function(event as RecipeTickEvent) {
        checkTemp(event, requireTemp, requireTemp * 4);
    })
    .addFinishHandler(function(event as RecipeFinishEvent) {
        event.controller.removeModifier("hasEnoughTemp");
    })
    .addRecipeTooltip("需要温度：" + requireTemp + "Mk，最高：" + (requireTemp * 4) + "Mk", "§2仅在低温加热时消耗能量。", "§a能量消耗不受并行影响。")
    .requireComputationPoint(100.0F)
    .build();
RecipeBuilder.newBuilder("tokmak_reactor_react_1", "tokmak_reactor", 40, 0, true)
    .addEnergyPerTickInput(4000000).setParallelizeUnaffected(true)
    .addInput(<contenttweaker:programming_circuit_c>).setChance(0).setParallelizeUnaffected(true)
    .addInput(<contenttweaker:programming_circuit_a>).setChance(0).setParallelizeUnaffected(true)
    .addFluidInput(<liquid:jfh> * 20)
    .addInput(<liquid:liquidfusionfuel> * liquidfusionFuelUsage)
    .addOutput(<liquid:plasma> * (plasmaOutput * 4))
    .addEnergyPerTickOutput(energyOutput * 4)
    .addPreTickHandler(function(event as RecipeTickEvent) {
        checkTemp(event, requireTemp, requireTemp * 4);
    })
    .addFinishHandler(function(event as RecipeFinishEvent) {
        event.controller.removeModifier("hasEnoughTemp");
    })
    .addRecipeTooltip("需要温度：" + requireTemp + "Mk，最高：" + (requireTemp * 4) + "Mk", "§2仅在低温加热时消耗能量。", "§a能量消耗不受并行影响。")
    .requireComputationPoint(50.0F)
    .build();

RecipeBuilder.newBuilder("tokmak_reactor_react_liquid_energy_1", "tokmak_reactor", 40, 1, true)
    .addEnergyPerTickInput(4000000).setParallelizeUnaffected(true)
    .addInput(<contenttweaker:programming_circuit_d>).setChance(0).setParallelizeUnaffected(true)
    .addInput(<contenttweaker:programming_circuit_a>).setChance(0).setParallelizeUnaffected(true)
    .addFluidInput(<liquid:jfh> * 20)
    .addInput(<liquid:liquidfusionfuel> * liquidfusionFuelUsage)
    .addOutput(<liquid:liquid_energy> * 4)
    .addOutput(<liquid:plasma> * (plasmaOutput * 4))
    .addPreTickHandler(function(event as RecipeTickEvent) {
        checkTemp(event, requireTemp, requireTemp * 4);
    })
    .addFinishHandler(function(event as RecipeFinishEvent) {
        event.controller.removeModifier("hasEnoughTemp");
    })
    .addRecipeTooltip("需要温度：" + requireTemp + "Mk，最高：" + (requireTemp * 4) + "Mk", "§2仅在低温加热时消耗能量。", "§a能量消耗不受并行影响。")
    .requireComputationPoint(100.0F)
    .build();
RecipeBuilder.newBuilder("tokmak_reactor_react_2", "tokmak_reactor", 40, 0, true)
    .addEnergyPerTickInput(4000000).setParallelizeUnaffected(true)
    .addInput(<contenttweaker:programming_circuit_c>).setChance(0).setParallelizeUnaffected(true)
    .addInput(<contenttweaker:programming_circuit_b>).setChance(0).setParallelizeUnaffected(true)
    .addFluidInput(<liquid:jfh> * 20)
    .addFluidInput(<liquid:helium_3> * 500)
    .addInput(<liquid:liquidfusionfuel> * liquidfusionFuelUsage)
    .addOutput(<liquid:plasma> * (plasmaOutput * 4 * 2))
    .addEnergyPerTickOutput(energyOutput * 4 * 2)
    .addPreTickHandler(function(event as RecipeTickEvent) {
        checkTemp(event, requireTemp, requireTemp * 4);
    })
    .addFinishHandler(function(event as RecipeFinishEvent) {
        event.controller.removeModifier("hasEnoughTemp");
    })
    .addRecipeTooltip("需要温度：" + requireTemp + "Mk，最高：" + (requireTemp * 4) + "Mk", "§2仅在低温加热时消耗能量。", "§a能量消耗不受并行影响。")
    .requireComputationPoint(50.0F)
    .build();

RecipeBuilder.newBuilder("tokmak_reactor_react_liquid_energy_2", "tokmak_reactor", 40, 1, true)
    .addEnergyPerTickInput(4000000).setParallelizeUnaffected(true)
    .addInput(<contenttweaker:programming_circuit_d>).setChance(0).setParallelizeUnaffected(true)
    .addInput(<contenttweaker:programming_circuit_b>).setChance(0).setParallelizeUnaffected(true)
    .addFluidInput(<liquid:jfh> * 20)
    .addFluidInput(<liquid:helium_3> * 500)
    .addInput(<liquid:liquidfusionfuel> * liquidfusionFuelUsage)
    .addOutput(<liquid:liquid_energy> * 8)
    .addOutput(<liquid:plasma> * (plasmaOutput * 4 * 2))
    .addPreTickHandler(function(event as RecipeTickEvent) {
        checkTemp(event, requireTemp, requireTemp * 4);
    })
    .addFinishHandler(function(event as RecipeFinishEvent) {
        event.controller.removeModifier("hasEnoughTemp");
    })
    .addRecipeTooltip("需要温度：" + requireTemp + "Mk，最高：" + (requireTemp * 4) + "Mk", "§2仅在低温加热时消耗能量。", "§a能量消耗不受并行影响。")
    .requireComputationPoint(100.0F)
    .build();

MMEvents.onMachinePostTick("tokmak_reactor", function(event as MachineTickEvent) {
    val controller as IMachineController = event.controller;
    if (!controller.isWorking) {
        val data = controller.customData;
        val map = data.asMap();
        val machineTemp = isNull(map["temperature"]) ? 300 : map["temperature"].asInt();
        val newTemp = machineTemp - decreaseTemperature(machineTemp);
        if (newTemp != machineTemp) {
            map["temperature"] = newTemp;
            controller.customData = data;
        }
    }
});

MMEvents.onControllerGUIRender("tokmak_reactor", function(event as ControllerGUIRenderEvent) {
    val controller as IMachineController = event.controller;
    val data = controller.customData.asMap();
    val temperature = isNull(data["temperature"]) ? 300 : data["temperature"].asInt();
    var info as string[] = [
        // "§e//////// §6聚变反应堆监控器 §e////////",
        "§e核心温度：§c" + temperature + "Mk",
    ];
    if (temperature < 10000) {
        info += "§c温度过低";
    }

    event.extraInfo = info;
});

function checkTemp(event as RecipeTickEvent, requireTemp as int, maxTemp as int) {
    val controller as IMachineController = event.controller;
    val data = controller.customData;
    val map = data.asMap();
    val machineTemp = isNull(map["temperature"]) ? 300 : map["temperature"].asInt();
    val parallelism = event.activeRecipe.parallelism;

    if (machineTemp < requireTemp) {
        event.preventProgressing("点火温度不足，尝试手动加热...（要求温度：" + requireTemp + "Mk）");
        map["temperature"] = machineTemp + (increaseTemperature(machineTemp) / 2);
        controller.customData = data;
        if (controller.hasModifier("hasEnoughTemp")) {
            controller.removeModifier("hasEnoughTemp");
        }
        addOutputModifier(controller);
    } else if (machineTemp > maxTemp) {
        event.preventProgressing("温度过高（最高温度：" + maxTemp + "Mk）");
        map["temperature"] = machineTemp - decreaseTemperature(machineTemp);
        controller.customData = data;
    } else {
        if (machineTemp + (increaseTemperature(machineTemp) * parallelism) < maxTemp) {
            map["temperature"] = machineTemp + (increaseTemperature(machineTemp) * parallelism);
            controller.customData = data;
        }
        if (controller.hasModifier("hasEnoughTemp_Out")) {
            controller.removeModifier("hasEnoughTemp_Out");
        }
        addModifier(controller);
    }
}

function addModifier(controller as IMachineController) {
    if (!controller.hasModifier("hasEnoughTemp")) {
        controller.addModifier("hasEnoughTemp", RecipeModifierBuilder.create("modularmachinery:energy", "input", 0, 1, false).build());
    }
}

function addOutputModifier(controller as IMachineController) {
    if (!controller.hasModifier("hasEnoughTemp_Out")) {
        controller.addModifier("hasEnoughTemp_Out", RecipeModifierBuilder.create("modularmachinery:energy", "output", 0, 1, false).build());
    }
}

function increaseTemperature(temperature as int) as int {
    if (temperature >= 20000) {
        return 10;
    } else if (temperature >= 15000) {
        return 12;
    } else if (temperature >= 10000) {
        return 24;
    } else if (temperature >= 5000) {
        return 36;
    } else {
        return 48;
    }
}

function decreaseTemperature(temperature as int) as int {
    if (temperature >= 20000) {
        return 8;
    } else if (temperature >= 15000) {
        return 6;
    } else if (temperature >= 10000) {
        return 4;
    } else if (temperature >= 5000) {
        return 2;
    } else if (temperature >= 301) {
        return 1;
    } else {
        return 0;
    }
}
