//Recipes By Hikari_Nova.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import crafttweaker.item.IItemStack;
import crafttweaker.item.IIngredient;
import crafttweaker.liquid.ILiquidStack;
import crafttweaker.data.IData;

import novaeng.hypernet.HyperNetHelper;

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.RecipeCheckEvent;
import mods.modularmachinery.FactoryRecipeStartEvent;
import mods.modularmachinery.FactoryRecipeTickEvent;
import mods.modularmachinery.FactoryRecipeFinishEvent;
import mods.modularmachinery.RecipeModifierBuilder;
import mods.modularmachinery.SmartInterfaceUpdateEvent;

import mods.modularmachinery.MMEvents;
import mods.modularmachinery.ControllerGUIRenderEvent;

import mods.modularmachinery.IMachineController;
import mods.modularmachinery.SmartInterfaceData;
import mods.modularmachinery.MachineModifier;
import mods.modularmachinery.SmartInterfaceType;
import mods.modularmachinery.FactoryRecipeThread;

//智能强冷裂变反应堆

# 智能数据接口初始化
MachineModifier.addSmartInterfaceType("reactor_ic2_2",
    SmartInterfaceType.create("speed", 1)
        .setHeaderInfo("§e反应速度倍率设置")
        .setValueInfo("§e反应速度倍率：§a%.2fx")
        .setJeiTooltip("反应速度倍率区间：§a%.2fx§f - §a%.0fx", 2)
        .setNotEqualMessage("反应速度倍率过高或过低！")
);

# 反应线程
val reactThread = FactoryRecipeThread.createCoreThread("反应线程 #0");
val maintainerThread = FactoryRecipeThread.createCoreThread("维护线程 #0");

# 反应线程
MachineModifier.setMaxThreads("reactor_ic2_2", 0);
MachineModifier.addCoreThread("reactor_ic2_2", reactThread);
MachineModifier.addCoreThread("reactor_ic2_2", maintainerThread);

HyperNetHelper.proxyMachineForHyperNet("reactor_ic2_2");

// *** int[IIngredient] = value[key] ***
val fuelTypeDef as int[IIngredient] = {
    <ore:dustUranium>                : 1,
    <ic2:nuclear>                    : 2,
    <ic2:nuclear:4>                  : 3,
    <super_solar_panels:crafting:27> : 4,
};

val fuelTypeDefNum as IItemStack[int] = {
    1 : <mekanism:dust:7>,
    2 : <ic2:nuclear>,
    3 : <ic2:nuclear:4>,
    4 : <super_solar_panels:crafting:27>,
};

val fuelHeatDef as int[IIngredient]$orderly = {
    <ore:dustUranium>                : 80000,
    <ic2:nuclear>                    : 1700000,
    <ic2:nuclear:4>                  : 15000000,
    // <super_solar_panels:crafting:27> : 270000000,
};

val coolantDef as int[ILiquidStack]$orderly = {
    <liquid:water> * 50           : 320,
    <liquid:ice> * 50             : 750,
    <liquid:ic2coolant> * 50      : 2000,
    <liquid:liquid_nitrogen> * 50 : 9250,
    <liquid:liquid_helium> * 50   : 9500,
    <liquid:cryotheum> * 50       : 10250,
};

var recipeAmount as int = 1;

//控制器 GUI
MMEvents.onControllerGUIRender("reactor_ic2_2", function(event as ControllerGUIRenderEvent) {
    val ctrl = event.controller;
    val map = ctrl.customData.asMap();
    val remainCoolant = isNull(map["coolantAmount"]) ? 0 : map["coolantAmount"].asFloat();
    val remainFuel = isNull(map["fuelAmount"]) ? 0 : map["fuelAmount"].asFloat();
    val fuelType = isNull(map["fuelType"]) ? -1 : map["fuelType"].asInt();
    val fuelTypeDisplayName = isNull(fuelTypeDefNum[fuelType]) ? "无燃料" : fuelTypeDefNum[fuelType].displayName;
    val nullableMul = ctrl.getSmartInterfaceData("speed");
    val mul as float = isNull(nullableMul) ? 1 as float : nullableMul.value;

    var info as string[] = [
        "§9//////// 裂变反应堆监控器 ////////",
        "§9冷却剂剩余：§b" + remainCoolant + "C",
        "§9热值剩余：§c" + remainFuel + "H§9（§b" + fuelTypeDisplayName + "§9）",
    ];

    if (ctrl.isWorking) {
        val speed = isNull(map["speed"]) ? 1 as float : map["speed"].asFloat();
        info += "§9当前反应倍率：§a" + speed + "x";
    }

    if (remainCoolant < 25000) {
        info += "§e警告：剩余冷却剂数量偏少。";
    }

    info += "§9////////////////////////////////////";

    event.extraInfo = info;
});

//反应堆燃料
# 添加燃料配方
for fuelItem, fuelAmount in fuelHeatDef {
    RecipeBuilder.newBuilder("add_fuel_" + recipeAmount, "reactor_ic2_2", 1, recipeAmount, false)
        .addInput(fuelItem)
        .addPostCheckHandler(function(event as RecipeCheckEvent) {
            if (!checkFuelTypeAndAmount(event, fuelTypeDef[fuelItem])) {
                event.setFailed("反应堆内存在未反应完成的燃料！");
            }
        })
        .addFactoryFinishHandler(function(event as FactoryRecipeFinishEvent) {
            addReactorFuel(event.controller, fuelAmount, fuelTypeDef[fuelItem]);
        })
        .addRecipeTooltip("为反应堆添加 " + fuelAmount + " 点燃料值。")
        .setThreadName("反应线程 #0")
        .build();

    recipeAmount += 1;
}

# 检查输入的燃料类型是否与之前的相同，或内部燃料是否为空
function checkFuelTypeAndAmount(event as RecipeCheckEvent, fuelType as int) as bool {
    val map = event.controller.customData.asMap();
    val ctrlFuelType = isNull(map["fuelType"]) ? -1 : map["fuelType"].asInt();
    val ctrlRemainFuel = isNull(map["fuelAmount"]) ? 0 as float : map["fuelAmount"].asFloat();

    if ((ctrlFuelType == -1 || ctrlFuelType == fuelType) && ctrlRemainFuel < 2000) {
        return true;
    } else {
        return ctrlRemainFuel < 2000;
    }
}

# 向控制器添加燃料
function addReactorFuel(ctrl as IMachineController, amount as int, fuelType as int) {
    val data = ctrl.customData;
    val map = data.asMap();
    val remainFuel = isNull(map["fuelAmount"]) ? 0 as float : map["fuelAmount"].asFloat();
    map["fuelAmount"] = remainFuel + amount;
    map["fuelType"] = fuelType;
    ctrl.customData = data;
}

//冷却剂
# 添加冷却剂配方
recipeAmount = 1;
for fluid, cool in coolantDef {
    RecipeBuilder.newBuilder("add_coolant_" + recipeAmount, "reactor_ic2_2", 200, recipeAmount, true)
        .addFluidPerTickInput(fluid)
        .addPreCheckHandler(function(event as RecipeCheckEvent) {
            if (checkMaxCoolant(event.controller.customData.asMap())) {
                event.setFailed("反应堆内冷却剂已满！");
            }
        })
        .addFactoryPostTickHandler(function(event as FactoryRecipeTickEvent) {
            val thread = event.factoryRecipeThread;
            val activeRecipe = thread.activeRecipe;

            thread.setStatusInfo("添加冷却剂中...");
            if (checkMaxCoolant(event.controller.customData.asMap())) {
                activeRecipe.tick = activeRecipe.totalTick;
            } else {
                activeRecipe.tick = 0;
            }

            addCoolant(event.controller, cool);
        })
        .addRecipeTooltip("为反应堆添加 " + cool + " 点冷却剂值。")
        .setMaxThreads(1)
        .setThreadName("维护线程 #0")
        .build();

    recipeAmount += 1;
}

# 检查冷却剂输入是否已满
function checkMaxCoolant(map as IData[string]) as bool {
    val remainCoolant = isNull(map["coolantAmount"]) ? 0 : map["coolantAmount"].asFloat();
    return remainCoolant >= 750000;
}

# 添加冷却剂
function addCoolant(ctrl as IMachineController, cool as int) {
    val data = ctrl.customData;
    val map = data.asMap();
    val remainCoolant = isNull(map["coolantAmount"]) ? 0 : map["coolantAmount"].asFloat();
    map["coolantAmount"] = remainCoolant + cool;
    ctrl.customData = data;
}

//反应配方部分函数
# 反应配方
RecipeBuilder.newBuilder("react", "reactor_ic2_2", 100, 0, false)
    .addSmartInterfaceDataInput("speed", 0.01, 40)
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val map = event.controller.customData.asMap();
        if (!checkCoolantInputAmount(map)) {
            event.setFailed("反应堆内的冷却剂不足以反应！");
            return;
        }
        if (!checkFuelInputAmount(map)) {
            event.setFailed("反应堆内的燃料不足以反应！");
            return;
        }
    })
    .addFactoryStartHandler(function(event as FactoryRecipeStartEvent) {
        onReactStarted(event);
    })
    .addFactoryPostTickHandler(function(event as FactoryRecipeTickEvent) {
        doReact(event);
    })
    .addOutput(<nuclearcraft:depleted_fuel_ic2>).addItemModifier(function(ctrl as IMachineController, item as IItemStack) {
        return outputDepletedFuel(ctrl, item, 2);
    }).setPreViewNBT({
        display: {
            Lore: [
                "§c燃料类型为浓缩铀核燃料时输出。",
            ],
        }
    })
    .addOutput(<nuclearcraft:depleted_fuel_ic2:1>).addItemModifier(function(ctrl as IMachineController, item as IItemStack) {
        return outputDepletedFuel(ctrl, item, 3);
    }).setPreViewNBT({
        display: {
            Lore: [
                "§c燃料类型为钚铀混合氧化物燃料（MOX）时输出。",
            ],
        }
    })
    // .addOutput(<super_solar_panels:crafting:26>).addItemModifier(function(ctrl as IMachineController, item as IItemStack) {
    //     return outputDepletedFuel(ctrl, item, 4);
    // }).setPreViewNBT({
    //     display: {
    //         Lore: [
    //             "§c燃料类型为质子时输出。",
    //         ],
    //     }
    // })
    // .addOutput(<super_solar_panels:crafting:27>).addItemModifier(function(ctrl as IMachineController, item as IItemStack) {
    //     return outputDepletedFuel(ctrl, item, 4);
    // }).setPreViewNBT({
    //     display: {
    //         Lore: [
    //             "§c燃料类型为质子时输出。",
    //         ],
    //     }
    // })
    .addEnergyPerTickOutput(375000)
    .addRecipeTooltip("只在燃料消耗完毕时完成配方。", "仅在燃料消耗完毕时输出枯竭燃料。")
    .setMaxThreads(1)
    .setThreadName("反应线程 #0")
    .requireComputationPoint(10.0F)
    .build();

# 检查冷却剂输入数量
function checkCoolantInputAmount(map as IData[string]) as bool {
    val remainCoolant = isNull(map["coolantAmount"]) ? 0 : map["coolantAmount"].asFloat();
    return remainCoolant >= 20000;
}

# 检查燃料输入数量
function checkFuelInputAmount(map as IData[string]) as bool {
    val remainFuel = isNull(map["fuelAmount"]) ? 0 : map["fuelAmount"].asFloat();
    return remainFuel >= 2000;
}

# 开始时执行，向控制器添加反应倍率信息
function onReactStarted(event as FactoryRecipeStartEvent) {
    val ctrl = event.controller;
    val thread = event.factoryRecipeThread;
    val data = ctrl.customData;
    val map = data.asMap();

    val nullable = ctrl.getSmartInterfaceData("speed");
    var multiplier as float = isNull(nullable) ? 1 as float : nullable.value;
    if (multiplier < 0.01 || multiplier > 40) {
        multiplier = 1 as float;
        nullable.value = 1;
    }

    thread.addPermanentModifier("energyMul", RecipeModifierBuilder.create("modularmachinery:energy", "output", multiplier, 1, false).build());
    map["speed"] = multiplier;
    ctrl.customData = data;
}

# Tick 事件，消耗燃料与冷却剂，并判断剩余的数量
function doReact(event as FactoryRecipeTickEvent) {
    val ctrl = event.controller;
    val data = ctrl.customData;
    val activeRecipe = event.factoryRecipeThread.activeRecipe;
    val map = data.asMap();
    val remainFuel = isNull(map["fuelAmount"]) ? 0 as float : map["fuelAmount"].asFloat();
    val remainCoolant = isNull(map["coolantAmount"]) ? 0 as float : map["coolantAmount"].asFloat();
    val speed = isNull(map["speed"]) ? 1 as float : map["speed"].asFloat();

    if (remainFuel >= (speed * 50) && remainCoolant >= (speed * 150)) {
        map["fuelAmount"] = remainFuel - (speed * 50);
        map["coolantAmount"] = remainCoolant - (speed * 150);
        ctrl.customData = data;
    } else {
        activeRecipe.tick = activeRecipe.totalTick;
    }
}

# 物品修改器，判断燃料是否消耗完毕并输出物品
function outputDepletedFuel(ctrl as IMachineController, item as IItemStack, fuelType as int) as IItemStack {
    val map = ctrl.customData.asMap();
    val remainFuel = isNull(map["fuelAmount"]) ? 0 as float : map["fuelAmount"].asFloat();
    if (remainFuel >= 2000) {
        return item * 0;
    } else {
        val ctrlFuelType = isNull(map["fuelType"]) ? -1 : map["fuelType"].asInt();
        if (fuelType == ctrlFuelType) {
            return item;
        } else {
            return item * 0;
        }
    }
}
