//Recipes By Hikari_Nova.
//Machiney By Hikari_Nova & nxc_in_china & shadow_zl.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import crafttweaker.item.IItemStack;

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;

import mods.modularmachinery.IMachineController;
import mods.modularmachinery.RecipeModifierBuilder;
import mods.modularmachinery.ActiveMachineRecipe;
import mods.modularmachinery.RecipeAdapterBuilder;
import mods.modularmachinery.MachineModifier;

import mods.modularmachinery.MMEvents;
import mods.modularmachinery.FactoryRecipeThread;
import mods.modularmachinery.FactoryRecipeTickEvent;
import mods.modularmachinery.FactoryRecipeFinishEvent;
import mods.modularmachinery.RecipeCheckEvent;
import mods.modularmachinery.ControllerGUIRenderEvent;

import novaeng.NovaEngUtils;

// 紫珀炉
registerUniversal("purpur_furance",         32,   1,  20.0, 0.05, 100000.0D);
// 紫珀冶炼工厂
registerUniversal("purpur_smelting_plant",  512,  4,  40.0, 0.05, 1000000.0D);
// 旋律合金冶炼工厂
registerUniversal("melodic_smelting_plant", 8192, 16, 80.0, 0.1,  10000000.0D);

// 紫珀冶炼工厂控制器
RecipeBuilder.newBuilder("purpur_smelting_plant_controller", "machine_arm", 2400)
    .addEnergyPerTickInput(2048000)
    .addInputs([
        <liquid:osram_fluid> * 432,
        <modularmachinery:purpur_furance_factory_controller> * 2,
        <modularmachinery:high_temp_melting_factory_controller> * 1,
        <contenttweaker:industrial_circuit_v2> * 24,
        <contenttweaker:coil_v2> * 16,
        <contenttweaker:robot_arm_v2> * 6,
        <contenttweaker:engineering_battery_v2> * 4,
    ])
    .addOutput(<modularmachinery:purpur_smelting_plant_factory_controller>)
    // .requireResearch("purpur_smelting_plant")
    .build();

// 旋律合金冶炼工厂控制器
RecipeBuilder.newBuilder("melodic_smelting_plant_controller", "workshop", 7200)
    .addEnergyPerTickInput(6144000)
    .addInputs([
        <liquid:nitronite_fluid> * 41472,
        <modularmachinery:purpur_smelting_plant_factory_controller> * 1,
        <modularmachinery:high_temp_melting_factory_controller> * 1,
        <contenttweaker:coil_v3> * 18,
        <ore:plateMelodicAlloy> * 24,
        <ore:gearMelodicAlloy> * 12,
        <contenttweaker:engineering_battery_v3> * 8,
        <ore:plateStellarAlloy> * 12,
        <ore:gearStellarAlloy> * 6,
        <contenttweaker:robot_arm_v3> * 16,
        <immersiveengineering:conveyor>.withTag({conveyorType: "immersiveengineering:conveyor"}) * 16,
    ])
    .addOutput(<modularmachinery:melodic_smelting_plant_factory_controller>)
    // .requireResearch("melodic_smelting_plant")
    .build();

function registerUniversal(registryName as string, maxParallelism as int, threadCount as int, energyMul as float, durationMul as float, maxExpStorage as float) {
    val expOutputRecipeName = "exp_output_" + registryName;
    val expStorage = FactoryRecipeThread.createCoreThread("经验存储仓").addRecipe(expOutputRecipeName);

    // 工厂线程数设置
    MachineModifier.setMaxThreads(registryName, threadCount);
    MachineModifier.addCoreThread(registryName, expStorage);

    // 设置最大并行数
    MachineModifier.setInternalParallelism(registryName, maxParallelism);

    // 紫珀炉：配方继承
    RecipeAdapterBuilder.create(registryName, "minecraft:furnace_with_exp")
        .addModifier(RecipeModifierBuilder.create("modularmachinery:duration", "input", durationMul, 1, false).build())
        .addModifier(RecipeModifierBuilder.create("modularmachinery:energy",   "input", energyMul,   1, false).build())
        .addFactoryFinishHandler(function(event as FactoryRecipeFinishEvent) {
            val activeRecipe = event.activeRecipe;
            val experience = activeRecipe.data.experience;
            if (isNull(experience) || experience <= 0) {
                return;
            }

            val parallelism = activeRecipe.parallelism;
            val ctrl = event.controller;
            val ctrlData = ctrl.customData;
            val ctrlDataMap = ctrlData.asMap();
            val ctrlDData = D(ctrlData);

            val ctrlExperience = ctrlDData.getFloat("experience");
            ctrlDataMap["experience"] = min(maxExpStorage, ctrlExperience + (experience * parallelism));
            ctrl.customData = ctrlData;
        })
        .addRecipeTooltip("§c溢出的经验将会被销毁。")
        .setMaxThreads(1)
        .build();

    RecipeBuilder.newBuilder(expOutputRecipeName, registryName, 20, 1000, false)
        .addFluidPerTickOutput(<liquid:xpjuice> * 1)
        .addPreCheckHandler(function(event as RecipeCheckEvent) {
            val experience = event.controller.customData.experience;
            if (isNull(experience) || experience < 0.05) {
                event.setFailed("至少需要存储 0.05 点经验才能够输出液态经验！");
                return;
            }
        })
        .addFactoryPreTickHandler(function(event as FactoryRecipeTickEvent) {
            val ctrl = event.controller;
            val data = ctrl.customData;
            val map = data.asMap();
            val dData = D(data);
            val experience = dData.getFloat("experience");
            val preTickExisted = dData.getBool("preTickExisted");

            if (preTickExisted) {
                val outputCache = dData.getInt("outputCache");

                if (outputCache >= 2) {
                    val toStore = outputCache / 2;
                    map["experience"] = min(maxExpStorage, experience + (toStore as float / 20.0F));
                    map["outputCache"] = outputCache - toStore;

                    ctrl.customData = data;

                    event.factoryRecipeThread.addModifier("exp_output", RecipeModifierBuilder.create("modularmachinery:fluid", "output", outputCache - toStore, 1, false).build());
                }
                return;
            }

            if (experience < 0.05) {
                event.setFailed(true, "至少需要存储 0.05 点经验才能够输出液态经验！");

                map["preTickExisted"] = false;
                ctrl.customData = data;

                return;
            }

            val outputAmount = min(10000.0F, experience / 0.05F) as int;

            map["preTickExisted"] = true;
            map["experience"] = experience - (outputAmount as float / 20.0F);
            map["outputCache"] = outputAmount;

            ctrl.customData = data;

            event.factoryRecipeThread.addModifier("exp_output", RecipeModifierBuilder.create("modularmachinery:fluid", "output", outputAmount, 1, false).build());
        })
        .addFactoryPostTickHandler(function(event as FactoryRecipeTickEvent) {
            val ctrl = event.controller;
            val data = ctrl.customData;
            val map = data.asMap();

            map["preTickExisted"] = false;
            map["outputCache"] = 0;

            ctrl.customData = data;
        })
        .setThreadName("经验存储仓")
        .addRecipeTooltip(["§a0.05§f 点经验 = §a1mb§f 液态经验。", "最高输出速度为 §a10,000mb/t§f。"])
        .setParallelized(false)
        .build();

    MMEvents.onControllerGUIRender(registryName, function(event as ControllerGUIRenderEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val experience = dData.getFloat("experience");

        var info as string[] = [
            "§b经验点数存储：§a" + NovaEngUtils.formatDecimal(experience) + " / " + NovaEngUtils.formatDecimal(maxExpStorage) + "§e（" + NovaEngUtils.formatPercent(experience, maxExpStorage) + "）",
        ];

        event.extraInfo = info;
    });
}

function min(a as float, b as float) as float {
    return a <= b ? a : b;
}
