//Recipes By Hikari_Nova.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.MachineModifier;
import mods.modularmachinery.RecipeAdapterBuilder;
import mods.modularmachinery.RecipeModifierBuilder;

import novaeng.hypernet.HyperNetHelper;

//==============================精密装配机==============================
//工厂线程数设置
MachineModifier.setMaxThreads("precision_assembler", 6);
//并行线程数设置
MachineModifier.setMaxParallelism("precision_assembler", 256);

HyperNetHelper.proxyMachineForHyperNet("precision_assembler");

var recipeCounter = 1;

// 精密装配机：配方继承
# 元件装配室 -> 精密装配机
RecipeAdapterBuilder.create("precision_assembler", "modularmachinery:board_assembly_room")
    .addModifier(RecipeModifierBuilder.create("modularmachinery:duration", "input", 0.5F, 1, false).build())
    .addModifier(RecipeModifierBuilder.create("modularmachinery:energy",   "input", 2.0F, 1, false).build())
    .build();

//力场发生器（等级 1）
RecipeBuilder.newBuilder("field_generator_v1", "precision_assembler", 400, recipeCounter, false)
    .addEnergyPerTickInput(512000)
    .addInputs([
        <ore:circuitUltimate> * 1,
        <contenttweaker:industrial_circuit_v2> * 1,
        <contenttweaker:coil_v2> * 2,
        <ore:netherStar> * 1,
    ])
    .addOutput(<contenttweaker:field_generator_v1> * 1)
    .requireComputationPoint(10.0F)
    .requireResearch("field_generator_v1")
    .build();
recipeCounter += 1;

//工程控制电路（等级 2）
RecipeBuilder.newBuilder("industrial_circuit_v2", "precision_assembler", 800, recipeCounter, false)
    .addEnergyPerTickInput(256000)
    .addInputs([
        <ore:circuitUltimate> * 4,
        <ore:ingotEnergium> * 2,
        <ore:plateWillowalloy> * 2,
    ])
    .addOutput(<contenttweaker:industrial_circuit_v2> * 4)
    .requireComputationPoint(4.0F)
    .build();
recipeCounter += 1;

//传感器（等级 2）
RecipeBuilder.newBuilder("sensor_v2", "precision_assembler", 400, recipeCounter, false)
    .addEnergyPerTickInput(128000)
    .addInputs([
        <contenttweaker:lifesense_processor> * 1,
        <contenttweaker:industrial_circuit_v2> * 1,
        <ore:stickWillowalloy> * 2,
        <mets:neutron_plate> * 2,
        <ore:gemGelidCrystal> * 1,
    ])
    .addOutputs(<contenttweaker:sensor_v2> * 2)
    .requireComputationPoint(6.0F)
    .build();
recipeCounter += 1;

//传感器（等级 3）
RecipeBuilder.newBuilder("sensor_v3", "precision_assembler", 400, recipeCounter, false)
    .addEnergyPerTickInput(128000)
    .addInputs([
        <contenttweaker:exponential_level_processor> * 1,
        <contenttweaker:industrial_circuit_v2> * 1,
        <ore:stickWillowalloy> * 2,
        <mets:neutron_plate> * 2,
        <enderutilities:enderpart:12> * 1,
    ])
    .addOutputs(<contenttweaker:sensor_v3> * 2)
    .requireComputationPoint(30.0F)
    .build();
recipeCounter += 1;

//电动马达（等级 3）
RecipeBuilder.newBuilder("electric_motor_v3", "precision_assembler", 400, recipeCounter, false)
    .addEnergyPerTickInput(128000)
    .addInputs([
        <contenttweaker:coil_v3> * 2,
        <mets:neutron_plate> * 2,
        <contenttweaker:industrial_circuit_v2> * 1,
        <ore:ingotWillowalloy> * 1,
    ])
    .addOutputs(<contenttweaker:electric_motor_v3> * 1)
    .requireComputationPoint(15.0F)
    .build();
recipeCounter += 1;

//机械臂（等级 3）
RecipeBuilder.newBuilder("robot_arm_v3", "precision_assembler", 400, recipeCounter, false)
    .addEnergyPerTickInput(128000)
    .addInputs([
        <contenttweaker:electric_motor_v3> * 2,
        <ore:stickWillowalloy> * 2,
        <contenttweaker:industrial_circuit_v2> * 1,
    ])
    .addOutputs(<contenttweaker:robot_arm_v3> * 1)
    .requireComputationPoint(20.0F)
    .build();
recipeCounter += 1;

//工程电池（等级 3）
RecipeBuilder.newBuilder("engineering_battery_v3", "precision_assembler", 400, recipeCounter, false)
    .addEnergyPerTickInput(128000)
    .addInputs([
        <enderio:item_capacitor_melodic> * 8,
        <mets:neutron_plate> * 2,
        <contenttweaker:industrial_circuit_v2> * 1,
    ])
    .addOutputs(<contenttweaker:engineering_battery_v3> * 1)
    .requireComputationPoint(20.0F)
    .build();
recipeCounter += 1;

//恒星合金导线
RecipeBuilder.newBuilder("stellar_alloy_wire", "precision_assembler", 40, recipeCounter, false)
    .addEnergyPerTickInput(128000)
    .addInput(<ore:plateStellarAlloy> * 1)
    .addOutput(<contenttweaker:stellar_alloy_wire> * 2)
    .build();
recipeCounter += 1;

//无尽导线
RecipeBuilder.newBuilder("infinity_wire", "precision_assembler", 80, recipeCounter, false)
    .addEnergyPerTickInput(4096000)
    .addInput(<ore:plateInfinity> * 1)
    .addOutput(<contenttweaker:infinity_wire> * 2)
    .requireResearch("beyond_limits")
    .build();
recipeCounter += 1;

//中子素线圈盘
RecipeBuilder.newBuilder("neutron_coil_discs", "precision_assembler", 200, recipeCounter, false)
    .addEnergyPerTickInput(512000)
    .addInput(<ore:gearCosmicNeutronium> * 2)
    .addInput(<ore:plateCosmicNeutronium> * 4)
    .addInput(<ore:itemInfinityRod> * 4)
    .addOutput(<contenttweaker:neutron_coil_discs>)
    .build();
recipeCounter += 1;

//水晶矩阵力场控制矩阵
RecipeBuilder.newBuilder("crystalmatrixforcefieldcontrolblock", "precision_assembler", 400, recipeCounter, false)
    .addEnergyPerTickInput(768000)
    .addInput(<ore:blockCrystalMatrix> * 1)
    .addInput(<contenttweaker:extrememachineblock> * 2)
    .addInput(<contenttweaker:coil_v3> * 12)
    .addInput(<contenttweaker:field_generator_v1> * 12)
    .addInput(<contenttweaker:sensor_v2> * 2)
    .addInput(<gravisuite:crafting> * 4)
    .addOutput(<contenttweaker:crystalmatrixforcefieldcontrolblock> * 2)
    .build();
recipeCounter += 1;

//中子矩阵力场控制矩阵
RecipeBuilder.newBuilder("neutronforcefieldcontrolblock", "precision_assembler", 400, recipeCounter, false)
    .addEnergyPerTickInput(768000)
    .addInput(<mets:neutron_plate> * 12)
    .addInput(<contenttweaker:extrememachineblock> * 2)
    .addInput(<contenttweaker:coil_v3> * 12)
    .addInput(<contenttweaker:field_generator_v1> * 12)
    .addInput(<contenttweaker:sensor_v2> * 2)
    .addInput(<gravisuite:crafting> * 4)
    .addOutput(<contenttweaker:neutronforcefieldcontrolblock> * 2)
    .build();
recipeCounter += 1;

//精密装配机-控制器
RecipeBuilder.newBuilder("controller_precision_assembler", "machine_arm", 2400)
    .addEnergyPerTickInput(768000)
    .addInput(<contenttweaker:industrial_circuit_v1> * 24)
    .addInput(<contenttweaker:robot_arm_v2> * 20)
    .addInput(<contenttweaker:electric_motor_v2> * 20)
    .addInput(<contenttweaker:sensor_v1> * 12)
    .addInput(<ore:circuitUltimate> * 30)
    .addInput(<avaritia:resource:1> * 8)
    .addInput(<ore:plateWillowalloy> * 30)
    .addOutput(<modularmachinery:precision_assembler_factory_controller>)
    .requireResearch("precision_assembler")
    .build();

//通用数据存储卡
RecipeBuilder.newBuilder("general_data_card", "precision_assembler", 400, recipeCounter, false)
    .addEnergyPerTickInput(64000)
    .addItemInputs([
        <ore:circuitElite> * 8,
        <mets:neutron_plate> * 4,
        <avaritia:resource:1> * 4,
        <appliedenergistics2:material:43> * 8,
        <appliedenergistics2:material:44> * 8,
    ])
    .addOutput(<contenttweaker:general_data_card> * 12)
    .requireComputationPoint(25.0F)
    .build();
recipeCounter += 1;

// //指数级处理器
// RecipeBuilder.newBuilder("exponential_level_processor", "precision_assembler", 1200, recipeCounter, false)
//     .addEnergyPerTickInput(96000)
//     .addInputs([
//         <liquid:neutron> * 100,
//         <threng:material:14> * 2,
//         <contenttweaker:lifesense_processor> * 4,
//         <ore:ingotCrystalMatrix> * 2,
//         <ore:ingotWillowalloy> * 1,
//     ])
//     .addOutput(<contenttweaker:exponential_level_processor> * 6)
//     .build();
// recipeCounter += 1;

//高级数据模型存储卡
RecipeBuilder.newBuilder("data_model_card", "precision_assembler", 60, recipeCounter)
    .addEnergyPerTickInput(128000)
    .addInput(<liquid:crystalloid> * 5)
    .addInput(<liquid:crystalloidneutron> * 72)
    .addInput(<deepmoblearning:data_model_blank> * 1)
    .addOutput(<contenttweaker:data_model_card> * 1)
    .requireComputationPoint(100.0F)
    .build();
recipeCounter += 1;

//僵尸数据模型
RecipeBuilder.newBuilder("data_model_zombie", "precision_assembler", 600, recipeCounter, false)
    .addEnergyPerTickInput(128000)
    .addInput(<deepmoblearning:data_model_blank>)
    .addInput(<minecraft:rotten_flesh> * 16)
    .addInput(<ore:cropCarrot> * 64)
    .addInput(<ore:cropPotato> * 64)
    .addInput(<ore:ingotIron> * 64)
    .addOutput(<deepmoblearning:data_model_zombie>).setChance(0.5)
    .requireComputationPoint(50.0F)
    .build();
recipeCounter += 1;

//骷髅数据模型
RecipeBuilder.newBuilder("data_model_skeleton", "precision_assembler", 600, recipeCounter, false)
    .addEnergyPerTickInput(128000)
    .addInput(<deepmoblearning:data_model_blank>)
    .addInput(<ore:bone> * 64)
    .addInput(<minecraft:arrow> * 64)
    .addInput(<minecraft:skull> * 64)
    .addOutput(<deepmoblearning:data_model_skeleton>).setChance(0.5)
    .requireComputationPoint(50.0F)
    .build();
recipeCounter += 1;

//苦力怕数据模型
RecipeBuilder.newBuilder("data_model_creeper", "precision_assembler", 900, recipeCounter, false)
    .addEnergyPerTickInput(128000)
    .addInput(<deepmoblearning:data_model_blank>)
    .addInput(<ore:gunpowder> * 64)
    .addInput(<minecraft:skull:4> * 64)
    .addOutput(<deepmoblearning:data_model_creeper>).setChance(0.4)
    .requireComputationPoint(75.0F)
    .build();
recipeCounter += 1;

//蜘蛛数据模型
RecipeBuilder.newBuilder("data_model_spider", "precision_assembler", 600, recipeCounter, false)
    .addEnergyPerTickInput(128000)
    .addInput(<deepmoblearning:data_model_blank>)
    .addInput(<minecraft:spider_eye> * 64)
    .addInput(<ore:string> * 64)
    .addInput(<minecraft:web> * 64)
    .addOutput(<deepmoblearning:data_model_spider>).setChance(0.5)
    .requireComputationPoint(75.0F)
    .build();
recipeCounter += 1;

//史莱姆数据模型
RecipeBuilder.newBuilder("data_model_slime", "precision_assembler", 900, recipeCounter, false)
    .addEnergyPerTickInput(128000)
    .addInput(<deepmoblearning:data_model_blank>)
    .addInput(<ore:slimeballGreen> * 64)
    .addOutput(<deepmoblearning:data_model_slime>).setChance(0.4)
    .requireComputationPoint(150.0F)
    .build();
recipeCounter += 1;

//女巫数据模型
RecipeBuilder.newBuilder("data_model_witch", "precision_assembler", 1200, recipeCounter, false)
    .addEnergyPerTickInput(256000)
    .addInput(<deepmoblearning:data_model_blank>)
    .addInput(<ore:listAllsugar> * 64)
    .addInput(<ore:dustGlowstone> * 64)
    .addInput(<ore:dustRedstone> * 64)
    .addOutput(<deepmoblearning:data_model_witch>).setChance(0.3)
    .requireComputationPoint(200.0F)
    .build();
recipeCounter += 1;

//烈焰人数据模型
RecipeBuilder.newBuilder("data_model_blaze", "precision_assembler", 1200, recipeCounter, false)
    .addEnergyPerTickInput(256000)
    .addInput(<deepmoblearning:data_model_blank>)
    .addInput(<ore:itemBlazeRod> * 64)
    .addInput(<ore:dustSulfur> * 64)
    .addOutput(<deepmoblearning:data_model_blaze>).setChance(0.3)
    .requireComputationPoint(300.0F)
    .build();
recipeCounter += 1;

//恶魂数据模型
RecipeBuilder.newBuilder("data_model_ghast", "precision_assembler", 1500, recipeCounter, false)
    .addEnergyPerTickInput(512000)
    .addInput(<deepmoblearning:data_model_blank>)
    .addInput(<ore:itemGhastTear> * 64)
    .addInput(<ore:gunpowder> * 64)
    .addOutput(<deepmoblearning:data_model_ghast>).setChance(0.2)
    .requireComputationPoint(400.0F)
    .build();
recipeCounter += 1;

//凋灵骷髅数据模型
RecipeBuilder.newBuilder("data_model_wither_skeleton", "precision_assembler", 1500, recipeCounter, false)
    .addEnergyPerTickInput(512000)
    .addInput(<deepmoblearning:data_model_blank>)
    .addInput(<minecraft:skull:1> * 64)
    .addInput(<ore:itemCoal> * 64)
    .addOutput(<deepmoblearning:data_model_wither_skeleton>).setChance(0.2)
    .requireComputationPoint(800.0F)
    .build();
recipeCounter += 1;

//末影人数据模型
RecipeBuilder.newBuilder("data_model_enderman", "precision_assembler", 1200, recipeCounter, false)
    .addEnergyPerTickInput(512000)
    .addInput(<deepmoblearning:data_model_blank>)
    .addInput(<minecraft:ender_pearl> * 16)
    .addInput(<minecraft:end_crystal> * 64)
    .addInput(<enderio:block_enderman_skull> * 64)
    .addOutput(<deepmoblearning:data_model_enderman>).setChance(0.3)
    .requireComputationPoint(600.0F)
    .build();
recipeCounter += 1;

//潜影贝数据模型
RecipeBuilder.newBuilder("data_model_shulker", "precision_assembler", 1500, recipeCounter, false)
    .addEnergyPerTickInput(512000)
    .addInput(<deepmoblearning:data_model_blank>)
    .addInput(<minecraft:shulker_shell> * 64)
    .addOutput(<deepmoblearning:data_model_shulker>).setChance(0.2)
    .requireComputationPoint(800.0F)
    .build();
recipeCounter += 1;

//守卫者数据模型
RecipeBuilder.newBuilder("data_model_guardian", "precision_assembler", 1200, recipeCounter, false)
    .addEnergyPerTickInput(512000)
    .addInput(<deepmoblearning:data_model_blank>)
    .addInput(<ore:shardPrismarine> * 64)
    .addInput(<ore:dustPrismarine> * 64)
    .addInput(<minecraft:fish> * 64)
    .addOutput(<deepmoblearning:data_model_guardian>).setChance(0.3)
    .requireComputationPoint(700.0F)
    .build();
recipeCounter += 1;

//热力膨胀数据模型
RecipeBuilder.newBuilder("data_model_thermal_elemental", "precision_assembler", 1500, recipeCounter, false)
    .addEnergyPerTickInput(512000)
    .addInput(<deepmoblearning:data_model_blank>)
    .addInput(<ore:rodBlizz> * 64)
    .addInput(<ore:rodBasalz> * 64)
    .addInput(<ore:rodBlitz> * 64)
    .addInput(<minecraft:snowball> * 16)
    .addInput(<ore:dustObsidian> * 64)
    .addInput(<ore:dustNiter> * 64)
    .addOutput(<deepmoblearning:data_model_thermal_elemental>).setChance(0.2)
    .requireComputationPoint(700.0F)
    .build();
recipeCounter += 1;

//蓝色史莱姆数据模型
RecipeBuilder.newBuilder("data_model_tinker_slime", "precision_assembler", 1500, recipeCounter, false)
    .addEnergyPerTickInput(512000)
    .addInput(<deepmoblearning:data_model_blank>)
    .addInput(<ore:slimeballBlue> * 64)
    .addInput(<ore:slimeballPurple> * 64)
    .addInput(<ore:slimeballMagma> * 64)
    .addInput(<tconstruct:slime_sapling> * 64)
    .addInput(<tconstruct:slime_sapling:1> * 64)
    .addInput(<tconstruct:slime_sapling:2> * 64)
    .addOutput(<deepmoblearning:data_model_tinker_slime>).setChance(0.2)
    .requireComputationPoint(600.0F)
    .build();
recipeCounter += 1;

//凋灵数据模型
RecipeBuilder.newBuilder("data_model_wither", "precision_assembler", 1800, recipeCounter, false)
    .addEnergyPerTickInput(1024000)
    .addInput(<deepmoblearning:data_model_blank>)
    .addInput(<ore:netherStar> * 64)
    .addOutput(<deepmoblearning:data_model_wither>.withTag({tier: 0})).setChance(0.1)
    .requireComputationPoint(2000.0F)
    .build();
recipeCounter += 1;

//末影龙数据模型
RecipeBuilder.newBuilder("data_model_dragon", "precision_assembler", 1800, recipeCounter, false)
    .addEnergyPerTickInput(1024000)
    .addInput(<deepmoblearning:data_model_blank>)
    .addInput(<minecraft:dragon_egg> * 8)
    .addInput(<draconicevolution:draconium_dust> * 32)
    .addInput(<draconicevolution:dragon_heart>)
    .addInput(<minecraft:skull:5> * 4)
    .addOutput(<deepmoblearning:data_model_dragon>.withTag({tier: 0})).setChance(0.1)
    .requireComputationPoint(3000.0F)
    .build();
recipeCounter += 1;
