//Recipes By Hikari_Nova.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import novaeng.hypernet.HyperNetHelper;

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;

//============================== 机械核心装配机 ==============================
var recipeCounter = 1;

HyperNetHelper.proxyMachineForHyperNet("mach_crafter");

# 机械外壳成型机
RecipeBuilder.newBuilder("mechanical_housing_molding_machine_controller", "mach_crafter", 600, recipeCounter, false)
    .addEnergyPerTickInput(512)
    .addInputs([
        <ore:circuitBasic> * 16,
        <ore:plateSteel> * 12,
        <minecraft:piston> * 8,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:mechanical_housing_molding_machine_controller>)
    .requireResearch("mechanical_housing_molding_machine")
    .build();
recipeCounter += 1;

# 元件装配室
RecipeBuilder.newBuilder("board_assembly_room_controller", "mach_crafter", 600, recipeCounter, false)
    .addEnergyPerTickInput(512)
    .addInputs([
        <ore:circuitBasic> * 16,
        <contenttweaker:robot_arm_v1> * 6,
        <mekanism:machineblock:8> * 4,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:board_assembly_room_controller>)
    .requireResearch("board_assembly_room")
    .build();
recipeCounter += 1;

# 小型钢矿钻
RecipeBuilder.newBuilder("small_ore_drill_controller", "mach_crafter", 600, recipeCounter, false)
    .addEnergyPerTickInput(768)
    .addInputs([
        <ic2:mining_pipe> * 16,
        <ore:plateSteel> * 16,
        <ore:circuitBasic> * 12,
        <contenttweaker:industrial_circuit_v1> * 2,
        <ic2:diamond_drill>.withTag({}) * 1,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:small_ore_drill_factory_controller>)
    .requireResearch("small_ore_drill")
    .build();
recipeCounter += 1;

# 紫珀炉
RecipeBuilder.newBuilder("purpur_furnace_controller", "mach_crafter", 600, recipeCounter, false)
    .addEnergyPerTickInput(512)
    .addInputs([
        <minecraft:chorus_fruit_popped> * 24,
        <ore:circuitBasic> * 8,
        <minecraft:furnace> * 8,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:purpur_furance_factory_controller>)
    .requireResearch("purpur_furnace")
    .build();
recipeCounter += 1;

# 空气燃烧循环器
RecipeBuilder.newBuilder("gas_generator_controller", "mach_crafter", 600, recipeCounter, false)
    .addEnergyPerTickInput(512)
    .addInputs([
        <ore:plateCopper> * 16,
        <contenttweaker:electric_motor_v1> * 4,
        <ic2:crafting:7> * 4,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:gas_generator_controller>)
    .requireResearch("gas_generator")
    .build();
recipeCounter += 1;

# 混合燃料发电机
RecipeBuilder.newBuilder("hybird_generator_controller", "mach_crafter", 600, recipeCounter, false)
    .addEnergyPerTickInput(1024)
    .addInputs([
        <mekanismgenerators:generator:3> * 6,
        <contenttweaker:industrial_circuit_v1> * 4,
        <ic2:crafting:36> * 2,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:hybrid_generator_factory_controller>)
    .requireResearch("hybird_generator")
    .build();
recipeCounter += 1;

# 物品粉碎机
RecipeBuilder.newBuilder("item_shredder_controller", "mach_crafter", 1200, recipeCounter, false)
    .addEnergyPerTickInput(1536)
    .addInputs([
        <ore:plateAdvancedAlloy> * 12,
        <ore:stickWillowalloy> * 8,
        <contenttweaker:electric_motor_v2> * 6,
        <contenttweaker:industrial_circuit_v1> * 4,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:item_shredder_controller>)
    .requireResearch("item_shredder")
    .build();
recipeCounter += 1;

# 燃料电池
RecipeBuilder.newBuilder("biogas_generator_controller", "mach_crafter", 1200, recipeCounter, false)
    .addEnergyPerTickInput(1536)
    .addInputs([
        <ore:dustSkyStone> * 12,
        <contenttweaker:industrial_circuit_v1> * 4,
        <mekanism:gastank>.withTag({tier: 0}) * 4,
        <contenttweaker:electric_motor_v2> * 2,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:biogas_generator_controller>)
    .requireResearch("biogas_generator")
    .build();
recipeCounter += 1;

# 牛牛机...
RecipeBuilder.newBuilder("niu_niu_controller", "mach_crafter", 1200, recipeCounter, false)
    .addEnergyPerTickInput(1536)
    .addInputs([
        <cookingforblockheads:cow_jar> * 12,
        <contenttweaker:robot_arm_v1> * 8,
        <immersiveengineering:wirecoil:2> * 6,
        <contenttweaker:industrial_circuit_v1> * 4,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:niu_niu_controller>)
    .requireResearch("niu_niu")
    .build();
recipeCounter += 1;

# 重水泵
RecipeBuilder.newBuilder("blueprints_beng", "mach_crafter", 1200, recipeCounter, false)
    .addEnergyPerTickInput(4096)
    .addInputs([
        <contenttweaker:industrial_circuit_v1> * 24,
        <contenttweaker:electric_motor_v2> * 32,
        <ic2:te:133> * 4,
        <mekanism:basicblock:14> * 1,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:beng_controller>)
    .requireResearch("beng")
    .build();
recipeCounter += 1;

