//Recipes By Hikari_Nova.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;

import mods.modularmachinery.RecipeAdapterBuilder;
import mods.modularmachinery.MachineModifier;

// 辉光魔力池
RecipeBuilder.newBuilder("illum_pool_controller", "machine_arm", 2400)
    .addEnergyPerTickInput(512000)
    .addInputs([
        <liquid:astralsorcery.liquidstarlight> * 20000,
        <astralsorcery:itemcraftingcomponent:4> * 16,
        <astralsorcery:iteminfusedglass> * 4,
        <botania:pool:3> * 9,
        <astralsorcery:blockstarlightinfuser> * 3,
        <botania:manaresource:1> * 16,
        <botania:shimmerrock> * 16,
        <botania:shimmerwoodplanks> * 32,
        <astralsorcery:itemusabledust> * 64,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:illum_pool_factory_controller> * 1)
    .requireResearch("illum_pool")
    .build();

//设置最大并行数
MachineModifier.setMaxParallelism("illum_pool", 256);
MachineModifier.setMaxThreads("illum_pool", 0);

// 辉光魔力池：配方适配器
RecipeAdapterBuilder.create("illum_pool", "botania:pool")
    .setMaxThreads(1)
    .setThreadName("辉光转化术式")
    .build();
RecipeAdapterBuilder.create("illum_pool", "astralsorcery:starlight_infuser")
    .setMaxThreads(1)
    .setThreadName("辉光转化术式")
    .build();

RecipeBuilder.newBuilder("pool_add_mana", "illum_pool", 20, 0)
    .addInput(<liquid:fluidedmana> * 20)
    .addIllumPoolManaAddHandler(20000)
    .setMaxThreads(1)
    .setThreadName("魔力注入术式")
    .build();

RecipeBuilder.newBuilder("pool_add_illum", "illum_pool", 20, 1)
    .addInput(<astralsorcery:itemusabledust:0> * 1)
    .addIllumPoolIllumAddHandler(40)
    .setMaxThreads(1)
    .setThreadName("魔力注入术式")
    .build();
