//Recipes By Hikari_Nova.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.MachineModifier;

import mods.modularmachinery.RecipeAdapterBuilder;
import mods.modularmachinery.RecipeModifierBuilder;

//==============================能量转换核晶==============================
RecipeBuilder.newBuilder("energized_fuel_v1_gen", "energy_crystal", 800)
    .addInput(<contenttweaker:energized_fuel_v1> * 1)
    .addEnergyPerTickOutput(250000000)
    .addOutput(<contenttweaker:energized_fuel_depleted_v1> * 1)
    .build();

RecipeBuilder.newBuilder("energized_fuel_v2_gen", "energy_crystal", 600)
    .addInput(<contenttweaker:energized_fuel_v2> * 1)
    .addEnergyPerTickOutput(2500000000)
    .addOutput(<contenttweaker:energized_fuel_depleted_v2> * 1)
    .build();

RecipeBuilder.newBuilder("energized_fuel_v3_gen", "energy_crystal", 9000)
    .addInput(<contenttweaker:energized_fuel_v3> * 1)
    .addEnergyPerTickOutput(750000000)
    .addOutput(<contenttweaker:energized_fuel_depleted_v3> * 1)
    .build();

RecipeBuilder.newBuilder("energized_fuel_v4_gen", "energy_crystal", 4500)
    .addInput(<contenttweaker:energized_fuel_v4> * 1)
    .addEnergyPerTickOutput(4000000000)
    .addOutput(<contenttweaker:energized_fuel_depleted_v4> * 1)
    .build();

//星堆
# 混沌碎片
RecipeBuilder.newBuilder("energized_fuel_v4_starburst_reactor_chaos", "starburst_reactor", 20000)
    .addInputs([
        <liquid:crystalloid> * 10000,
        <liquid:cryotheum> * 360000,
        <contenttweaker:energized_fuel_v4> * 1,
    ])
    .addEnergyPerTickOutput(100000000000)
    .addOutputs(<contenttweaker:energized_fuel_depleted_v4> * 1)
    .addOutput(<draconicevolution:chaos_shard> * 64).setMinMaxAmount(100, 1000)
    .build();

# 永恒奇点
RecipeBuilder.newBuilder("energized_fuel_v4_starburst_reactor_singularity", "starburst_reactor", 20000)
    .addInputs([
        <liquid:crystalloidneutron> * 72000,
        <liquid:cryotheum> * 360000,
        <contenttweaker:energized_fuel_v4> * 1,
    ])
    .addEnergyPerTickOutput(100000000000)
    .addOutputs(<contenttweaker:energized_fuel_depleted_v4> * 1)
    .addOutput(<eternalsingularity:eternal_singularity> * 64).setMinMaxAmount(400, 2000)
    .build();

# 反物质球
RecipeBuilder.newBuilder("energized_fuel_v4_starburst_reactor_antimatter", "starburst_reactor", 20000)
    .addInputs([
        <liquid:cryotheum> * 360000,
        <contenttweaker:energized_fuel_v4> * 1,
        <mekanism:antimatterpellet> * 1,
    ])
    .addEnergyPerTickOutput(100000000000)
    .addOutputs(<contenttweaker:energized_fuel_depleted_v4> * 1)
    .addOutput(<mekanism:antimatterpellet> * 64).setMinMaxAmount(40, 240)
    .build();

//释能器
RecipeAdapterBuilder.create("energy_releaser", "modularmachinery:energy_crystal")
    .addModifier(RecipeModifierBuilder.create("modularmachinery:duration", "input",  0.05F, 1, false).build())
    .addModifier(RecipeModifierBuilder.create("modularmachinery:energy",   "output", 8.00F, 1, false).build())
    .addModifier(RecipeModifierBuilder.create("modularmachinery:item",     "output", 0.60F, 1, true).build())
    .build();

//高级释能器
RecipeAdapterBuilder.create("advanced_energy_releaser", "modularmachinery:energy_crystal")
    .addModifier(RecipeModifierBuilder.create("modularmachinery:duration", "input",  0.02F, 1, false).build())
    .addModifier(RecipeModifierBuilder.create("modularmachinery:energy",   "output", 15.0F, 1, false).build())
    .addModifier(RecipeModifierBuilder.create("modularmachinery:item",     "output", 0.60F, 1, true).build())
    .build();

//β 水晶
RecipeAdapterBuilder.create("energy_crystal_2", "modularmachinery:energy_crystal")
    .addModifier(RecipeModifierBuilder.create("modularmachinery:duration", "input",  2.00F,  1, false).build())
    .addModifier(RecipeModifierBuilder.create("modularmachinery:energy",   "output", 6.25F, 1, false).build())
    .build();
