//Recipes By Hikari_Nova.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import crafttweaker.item.IItemStack;
import crafttweaker.item.IIngredient;
import crafttweaker.liquid.ILiquidStack;
import crafttweaker.data.IData;
import crafttweaker.util.IRandom;

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.RecipeCheckEvent;
import mods.modularmachinery.FactoryRecipeStartEvent;
import mods.modularmachinery.FactoryRecipeTickEvent;
import mods.modularmachinery.FactoryRecipeFailureEvent;
import mods.modularmachinery.FactoryRecipeFinishEvent;
import mods.modularmachinery.SmartInterfaceUpdateEvent;
import mods.modularmachinery.MachineStructureFormedEvent;

import mods.modularmachinery.RecipeModifierBuilder;

import mods.modularmachinery.MMEvents;
import mods.modularmachinery.ControllerGUIRenderEvent;

import mods.modularmachinery.IMachineController;
import mods.modularmachinery.SmartInterfaceData;
import mods.modularmachinery.MachineModifier;
import mods.modularmachinery.SmartInterfaceType;
import mods.modularmachinery.FactoryRecipeThread;

import novaeng.hypernet.HyperNetHelper;

// ECO - Y7
# 智能数据接口初始化
MachineModifier.addSmartInterfaceType("eco_y7",
    SmartInterfaceType.create("mode", 0)
        .setHeaderInfo("§b工作模式设置")
        .setValueInfo("工作模式：§b%.0f")
        .setFooterInfo("§b1 §f为脉冲模式，§b2 §f为能量场模式，§b3 §f为拆除电容。")
        .setJeiTooltip("工作模式：§b%.0f", 1)
        .setNotEqualMessage("工作模式不匹配或未初始化！")
);

MachineModifier.addSmartInterfaceType("eco_y7",
    SmartInterfaceType.create("overloadRatio", 1)
        .setHeaderInfo("§e超载倍率设置（仅限能量场模式）")
        .setValueInfo("超载倍率：§e%.2fx")
        .setFooterInfo("§e1.0x §f为不超载。")
        .setJeiTooltip("超载倍率：§e%.2fx", 1)
        .setNotEqualMessage("超载倍率过高或过低！")
);

# 空流体输出配方修改器
val emptyCrystalloidModifier = RecipeModifierBuilder.create("modularmachinery:fluid", "output", 0, 1, false).build();

# 线程
val energyFlowCtrlThread = FactoryRecipeThread.createCoreThread("能量流控制器");
val maintainerThread = FactoryRecipeThread.createCoreThread("机械维护控制器");

HyperNetHelper.proxyMachineForHyperNet("eco_y7");
MachineModifier.setMaxThreads("eco_y7", 0);
MachineModifier.addCoreThread("eco_y7", energyFlowCtrlThread);
MachineModifier.addCoreThread("eco_y7", maintainerThread);

# Y6 控制器配方
RecipeBuilder.newBuilder("controller_y6", "machine_arm", 4800)
    .addEnergyPerTickInput(1536000)
    .addInputs([
        <contenttweaker:industrial_circuit_v2> * 24,
        <contenttweaker:field_generator_v1> * 48,
        <contenttweaker:coil_v3> * 96,
        <custommc:item929> * 64,
        <ic2:iridium_reflector> * 16,
        <ore:ingotCrystalMatrix> * 16,
        <mets:te:37> * 12,
    ])
    .addOutput(<modularmachinery:eco_y6_controller>)
    .requireResearch("eco_y6")
    .build();

# Y7 控制器配方
RecipeBuilder.newBuilder("controller_y7", "workshop", 9600)
    .addEnergyPerTickInput(600000)
    .addInputs([
        <contenttweaker:industrial_circuit_v2> * 32,
        <contenttweaker:field_generator_v1> * 64,
        <contenttweaker:field_generator_v1> * 64,
        <contenttweaker:sensor_v3> * 32,
        <contenttweaker:robot_arm_v3> * 4,
        <gravisuite:crafting:1> * 64,
        <gravisuite:crafting:1> * 64,
        <eternalsingularity:eternal_singularity> * 16,
        <custommc:item170> * 12,
        <ore:itemEnhancedMachineChassi> * 2,
        <ore:itemUnsouledMachineChassi> * 2,
        <modularmachinery:eco_y6_controller> * 1,
    ])
    .addOutput(<modularmachinery:eco_y7_factory_controller>)
    .requireComputationPoint(1200.0F)
    .requireResearch("eco_y7")
    .build();

# 电容效率
val capacitorEfficiency as float[IItemStack] = {
    <draconicevolution:wyvern_energy_core>   : 0.25F,
    <enderio:item_capacitor_stellar>         : 0.50F,
    <mets:te:24>                             : 0.75F,
    <draconicevolution:draconic_energy_core> : 1.00F,
    <draconicadditions:chaotic_energy_core>  : 2.00F,
    <avaritiaio:infinitecapacitor>           : 10.0F,
};
# 电容耐久
val capacitorDurability as int[IItemStack]$orderly = {
    <draconicevolution:wyvern_energy_core>   : 5000,
    <enderio:item_capacitor_stellar>         : 15000,
    <mets:te:24>                             : 100000,
    <draconicevolution:draconic_energy_core> : 40000,
    <draconicadditions:chaotic_energy_core>  : 200000,
    <avaritiaio:infinitecapacitor>           : 1000000,
};
val capacitorTypeMap as int[IItemStack] = {
    <draconicevolution:wyvern_energy_core>   : 1,
    <enderio:item_capacitor_stellar>         : 2,
    <mets:te:24>                             : 3,
    <draconicevolution:draconic_energy_core> : 4,
    <draconicadditions:chaotic_energy_core>  : 5,
    <avaritiaio:infinitecapacitor>           : 6,
};
val typeCapacitorMap as IItemStack[int] = {
    1 : <draconicevolution:wyvern_energy_core>,
    2 : <enderio:item_capacitor_stellar>,
    3 : <mets:te:24>,
    4 : <draconicevolution:draconic_energy_core>,
    5 : <draconicadditions:chaotic_energy_core>,
    6 : <avaritiaio:infinitecapacitor>,
};

# 水晶效率
val crystalEfficiency as float[IItemStack]$orderly = {
    <custommc:item796> : 1.0F,
    <custommc:item800> : 2.5F,
    <custommc:item885> : 10.0F,
};

# 水晶消耗概率
val crystalConsumeChance as float[IItemStack] = {
    <custommc:item796> : 0.04F,
    <custommc:item800> : 0.02F,
    <custommc:item885> : 0.0F,
};

var recipeCounter = 0;
for item, efficiency in crystalEfficiency {
    RecipeBuilder.newBuilder("y7_pulse_" + recipeCounter, "eco_y7", 1000.0F / efficiency, recipeCounter, false)
        .addEnergyPerTickInput(100000000 * efficiency)
        .addInput(item).setChance(crystalConsumeChance[item] * 5.0F)
        .addOutput(<liquid:crystalloid> * (5.0F * efficiency))
        .addSmartInterfaceDataInput("mode", 1)
        .addPostCheckHandler(function(event as RecipeCheckEvent) {
            if (!checkCapacitor(event, (efficiency * 100) as int)) {
                event.setFailed("未安装电容或电容耐久过低！");
                return;
            }
            if (event.controller.activeRecipeList.length > 0) {
                event.setFailed("维护期间无法工作！");
            }
        })
        .addFactoryStartHandler(function(event as FactoryRecipeStartEvent) {
            val ctrl = event.controller;
            val thread = event.factoryRecipeThread;
            val data = ctrl.customData;
            val map = data.asMap();
            val dData = D(data);
            val capEfficiency = getCapacitorEfficiency(
                ctrl, typeCapacitorMap, capacitorTypeMap, capacitorEfficiency
            );

            thread.addModifier("energyInput", RecipeModifierBuilder.create("modularmachinery:energy", "input", capEfficiency, 1, false).build());
            thread.addModifier("crystalloidOutput", RecipeModifierBuilder.create("modularmachinery:fluid", "output", capEfficiency, 1, false).build());

            val fieldStrength = max(dData.getFloat("fieldStrength", 1.0F), 1.0F);
            map["fieldStrength"] = 0.0F;
            ctrl.customData = data;
        })
        .addFactoryPostTickHandler(function(event as FactoryRecipeTickEvent) {
            val thread = event.factoryRecipeThread;
            thread.setStatusInfo("充能中...");
        })
        .addFactoryFinishHandler(function(event as FactoryRecipeFinishEvent) {
            consumeCapacitorDurability(
                event.controller, efficiency * 1.5F, typeCapacitorMap, capacitorTypeMap, capacitorEfficiency
            );
        })
        .addRecipeTooltip("此配方为脉冲模式。")
        .setThreadName("能量流控制器")
        .requireComputationPoint(100.0F * efficiency, true)
        .build();

    RecipeBuilder.newBuilder("y7_energy_field_" + recipeCounter, "eco_y7", 100.0F, recipeCounter + 10, true)
        .addEnergyPerTickInput(150000000 * efficiency)
        .addInput(item).setChance(crystalConsumeChance[item])
        .addFluidPerTickOutput(<liquid:crystalloid> * 1)
        .addSmartInterfaceDataInput("mode", 2)
        .requireComputationPoint(150.0F * efficiency, true)
        .addPostCheckHandler(function(event as RecipeCheckEvent) {
            val ctrl = event.controller;
            val data = ctrl.customData;
            val map = data.asMap();

            if (!checkCapacitor(event, (efficiency * 100) as int)) {
                event.setFailed("未安装电容或电容耐久过低！");
                map["fieldStrength"] = 0.0F;
                ctrl.customData = data;
                return;
            }
            if (event.controller.activeRecipeList.length > 1) {
                map["fieldStrength"] = 0.0F;
                ctrl.customData = data;
                event.setFailed("维护期间无法工作！");
            }
        })
        .addFactoryStartHandler(function(event as FactoryRecipeStartEvent) {
            val ctrl = event.controller;
            val data = ctrl.customData;
            val map = data.asMap();

            map["recipeEfficiency"] = efficiency as float;
            ctrl.customData = data;
        })
        .addFactoryPreTickHandler(function(event as FactoryRecipeTickEvent) {
            val ctrl = event.controller;
            val random = ctrl.world.random;
            val thread = event.factoryRecipeThread;
            val data = ctrl.customData;
            val map = data.asMap();
            val dData = D(data);

            var fieldStrength = dData.getFloat("fieldStrength", 0.0F);
            var crystalloidCache = dData.getFloat("crystalloidCache");
            val ratio = dData.getFloat("overloadRatio", 1.0F);
            val capEfficiency = getCapacitorEfficiency(
                ctrl, typeCapacitorMap, capacitorTypeMap, capacitorEfficiency
            );
            val workEfficiency = 1.0F * dData.getFloat("recipeEfficiency", 1.0F) * fieldStrength * capEfficiency;

            if (fieldStrength >= ratio) {
                if (fieldStrength >= ratio + 0.005F) {
                    fieldStrength -= random.nextFloat(0.0001F, 0.001F) * efficiency;
                    thread.addModifier("energyInput", RecipeModifierBuilder.create("modularmachinery:energy", "input", 0, 1, false).build());
                } else {
                    thread.addModifier("energyInput", RecipeModifierBuilder.create("modularmachinery:energy", "input", max(fieldStrength * capEfficiency, 1.0F) * 0.5F, 1, false).build());
                }
            } else {
                fieldStrength += random.nextFloat(0.00001F, 0.00025F) * efficiency;
                thread.addModifier("energyInput", RecipeModifierBuilder.create("modularmachinery:energy", "input", max(fieldStrength * capEfficiency, 1.0F), 1, false).build());
            }
            map["fieldStrength"] = fieldStrength;

            crystalloidCache += workEfficiency / 4;
            if (crystalloidCache >= 1.0F) {
                val crystalloidCacheInt = crystalloidCache as int;
                thread.addModifier("crystalloidOutput", RecipeModifierBuilder.create("modularmachinery:fluid", "output", crystalloidCacheInt - 1, 0, false).build());
                crystalloidCache -= crystalloidCacheInt;
            } else {
                thread.addModifier("crystalloidOutput", emptyCrystalloidModifier);
            }
            map["crystalloidCache"] = crystalloidCache;

            ctrl.customData = data;
            if (random.nextFloat(0.0F, 1.0F) <= 0.01F * ratio) {
                consumeCapacitorDurability(
                    event.controller, efficiency, typeCapacitorMap, capacitorTypeMap, capacitorEfficiency
                );
            }
        })
        .addFactoryFailureHandler(function(event as FactoryRecipeFailureEvent) {
            val ctrl = event.controller;
            val data = ctrl.customData;
            val map = data.asMap();
            val dData = D(data);
            val fieldStrength = max(dData.getFloat("fieldStrength", 1.0F), 1.0F);

            map["fieldStrength"] = 0.0F;
            ctrl.customData = data;

            val capacitorTypeItem = typeCapacitorMap[dData.getInt("capacitorType")];
            if (isNull(capacitorTypeItem)) {
                writeCapacitorData(ctrl, 0, 0, true);
                return;
            }

            val capacitorType = capacitorTypeMap[capacitorTypeItem];
            if (isNull(capacitorType)) {
                writeCapacitorData(ctrl, 0, 0, true);
                return;
            }

            val maxDurability = capacitorDurability[capacitorTypeItem];
            if (isNull(maxDurability)) {
                writeCapacitorData(ctrl, 0, 0, true);
                return;
            }
            writeCapacitorData(ctrl, capacitorType, -(maxDurability as float * 0.03F * fieldStrength) as int, false);
        })
        .addRecipeTooltip("此配方为能量场模式。", "流体输出仅供参考，具体请查看控制器界面。")
        .setThreadName("能量流控制器")
        .build();

    recipeCounter += 1;
}

# 更换电容
recipeCounter = 0;
for capacitor, durability in capacitorDurability {
    RecipeBuilder.newBuilder("y7_capacitor_" + recipeCounter, "eco_y7", 100, recipeCounter + 20, false)
        .addEnergyPerTickInput(100000)
        .addInput(capacitor * 4)
        .addPreCheckHandler(function(event as RecipeCheckEvent) {
            if (checkCapacitor(event, 1000)) {
                event.setFailed("电容状态良好。");
                return;
            }
            if (event.controller.activeRecipeList.length > 0) {
                event.setFailed("工作中无法更换电容！");
            }
        })
        .addFactoryPostTickHandler(function(event as FactoryRecipeTickEvent) {
            val thread = event.factoryRecipeThread;
            thread.setStatusInfo("正在更换电容...");
        })
        .addFactoryFinishHandler(function(event as FactoryRecipeFinishEvent) {
            val ctrl = event.controller;
            writeCapacitorData(ctrl, capacitorTypeMap[capacitor], durability, true);
        })
        .addRecipeTooltip("电容效率：§a" + (capacitorEfficiency[capacitor] * 100) + "%§f，电容耐久度：§e" + durability, "电容效率会影响流体的输出量与能量的消耗。")
        .setThreadName("机械维护控制器")
        .build();
    recipeCounter += 1;
}

# 拆除电容
RecipeBuilder.newBuilder("y7_remove_capacitor", "eco_y7", 100, 100, false)
    .addSmartInterfaceDataInput("mode", 3)
    .addEnergyPerTickInput(100000)
    .addOutput(<botania:cosmetic:31>).setPreViewNBT({
        display: {
            Lore: [
                "§e根据控制器内电容输出对应数量的电容。",
                "§c此物品仅供参考。",
            ],
        }
    }).addItemModifier(function(ctrl as IMachineController, item as IItemStack) {
        val data = ctrl.customData;
        val dData = D(data);
        val capType = dData.getInt("capacitorType");
        val capTypeItem = typeCapacitorMap[capType];
        val capDurability = dData.getInt("capacitorDurability");
        val capMaxDurability = capacitorDurability[capTypeItem];
        return capTypeItem * ((capDurability * 4) / capMaxDurability);
    })
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val capType = dData.getInt("capacitorType");
        val capTypeItem = typeCapacitorMap[capType];
        val capDurability = dData.getInt("capacitorDurability");
        val capMaxDurability = capacitorDurability[capTypeItem];

        if (capType <= 0 || isNull(capMaxDurability) || isNull(capTypeItem) || (!(capDurability == -1) || capDurability < (capMaxDurability / 4))) {
            event.setFailed("未安装电容或电容耐久过低！");
        }
    })
    .addFactoryFinishHandler(function(event as FactoryRecipeFinishEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val capType = dData.getInt("capacitorType");
        val capTypeItem = typeCapacitorMap[capType];
        val capDurability = dData.getInt("capacitorDurability");
        val capMaxDurability = capacitorDurability[capTypeItem];
        val outputAmount = (capDurability * 4) / capMaxDurability;
        writeCapacitorData(ctrl, capType, -(capMaxDurability / 4 * outputAmount), false);
    })
    .addRecipeTooltip("此配方为电容拆除模式。", "需要有电容的情况下才能工作。")
    .setThreadName("机械维护控制器")
    .build();

MMEvents.onSmartInterfaceUpdate("eco_y7", function(event as SmartInterfaceUpdateEvent) {
    val ctrl = event.controller;
    val newData = event.newData;
    val customData = ctrl.customData;
    val map = customData.asMap();

    var value = newData.value;
    if (newData.interfaceType.contains("overloadRatio")) {
        value = max(min(value, 5.0F), 1.0F);
    }

    map[newData.interfaceType] = value;
    ctrl.customData = customData;
});

MMEvents.onStructureFormed("eco_y7", function(event as MachineStructureFormedEvent) {
    val ctrl = event.controller;
    val data = ctrl.customData;
    val map = data.asMap();
    val dData = D(data);
    val fieldStrength = max(dData.getFloat("fieldStrength", 1.0F), 1.0F);

    map["fieldStrength"] = 0.0F;
    ctrl.customData = data;
});

MMEvents.onControllerGUIRender("eco_y7", function(event as ControllerGUIRenderEvent) {
    val ctrl = event.controller;
    val data = ctrl.customData;
    val dData = D(data);
    val workMode = dData.getFloat("mode");
    val capDurability = dData.getInt("capacitorDurability");
    val capType = dData.getInt("capacitorType");
    val capTypeItem = typeCapacitorMap[capType];
    val capMaxDurability = capacitorDurability[capTypeItem];
    val capEfficiency = getCapacitorEfficiency(
        ctrl, typeCapacitorMap, capacitorTypeMap, capacitorEfficiency
    );

    val fieldStrength = dData.getFloat("fieldStrength", 0.0F);
    val ratio = dData.getFloat("overloadRatio", 1.0F);
    val workEfficiency = 1.0F * dData.getFloat("recipeEfficiency", 1.0F) * fieldStrength * capEfficiency;
    var energyUsageMul = 1.0F;
    if (fieldStrength >= ratio) {
        if (fieldStrength >= ratio + 0.05F) {
            energyUsageMul = 0.0F;
        } else {
            energyUsageMul = max(fieldStrength * capEfficiency, 1.0F) * 0.5F;
        }
    } else {
        energyUsageMul = max(fieldStrength * capEfficiency, 1.0F);
    }

    var info as string[] = [
        "§9//////////// 能量流监控器 ////////////",
    ];

    if (capType <= 0 || isNull(capMaxDurability) || isNull(capTypeItem)) {
        info += "§c错误：未安装电容，无法工作。";
    } else {
        info += "§9电容效率：" + (capEfficiency >= 1.0F ? "§a" : "§c") + (((capEfficiency * 10000) as int) as float / 100) + "%";

        val durabilityPercent = (((capDurability as float / capMaxDurability as float) * 10000) as int) as float / 100;
        info += "§9剩余电容耐久：" + (capDurability < 1000 ? "§c" : "§a") + capDurability + " §9("+ durabilityPercent + "%) (§b" + capTypeItem.displayName + "§9)";

        if (workMode == 2) {
            info += "§9能量场强度：" + (fieldStrength < 1.0F ? "§c" : fieldStrength > 1.005F ? "§6" : "§a") + (((fieldStrength * 10000) as int) as float / 100) + "%";
        }
        info += "§9能量消耗率：§9" + (energyUsageMul > 1.0F ? "§c" : "§a") + (((energyUsageMul * 10000) as int) as float / 100) + "%";
        if (workMode == 2) {
            info += "§9超载率：" + (ratio > 1.0F ? "§c" : "§9") + (((ratio * 10000) as int) as float / 100) + "%";
            info += "§5紫晶素生产速度：" + (((workEfficiency / 4 * 1000) as int) as float / 1000) + " mb/t";
        } else {
            info += "§5紫晶素产出倍率：" + (capEfficiency >= 1.0F ? "§a" : "§c") + (((capEfficiency * 100) as int) as float / 100) + " x";
        }
    }

    info += "§7（监控系统由 ECO 实验室提供。）";

    event.extraInfo = info;
});

function checkCapacitor(event as RecipeCheckEvent, miniumDurability as int) as bool {
    val ctrl = event.controller;
    val data = ctrl.customData;
    val dData = D(data);
    val capacitorType = dData.getInt("capacitorType");
    val capacitorDurability = dData.getInt("capacitorDurability");

    if (capacitorType > 0) {
        return capacitorDurability >= miniumDurability || capacitorDurability == -1;
    } else {
        return false;
    }
}

function consumeCapacitorDurability(
    ctrl as IMachineController,
    efficiency as float,
    typeCapacitorMap as IItemStack[int],
    capacitorTypeMap as int[IItemStack],
    capacitorEfficiency as float[IItemStack]) {
    val data = ctrl.customData;
    val dData = D(data);
    val fieldStrength = max(dData.getFloat("fieldStrength", 1.0F), 1.0F);

    val capacitorTypeItem = typeCapacitorMap[dData.getInt("capacitorType")];
    val capacitorType = capacitorTypeMap[capacitorTypeItem];
    if (isNull(capacitorTypeItem) || isNull(capacitorType)) {
        writeCapacitorData(ctrl, 0, 0, true);
    } else {
        writeCapacitorData(ctrl, capacitorType, -(efficiency * fieldStrength) as int, false);
    }
}

function writeCapacitorData(ctrl as IMachineController, capacitorType as int, durability as int, override as bool) {
    val data = ctrl.customData;
    val map = data.asMap();
    val dData = D(data);

    val capacitorDurability = dData.getInt("capacitorDurability");
    var newDurability = 0;

    if (capacitorDurability == -1) {
        // 不可以直接赋负数，我也不知道为什么。
        // newDurability = -1;
        newDurability = 0 - 1;
    } else {
        if (override) {
            newDurability = durability;
        } else {
            newDurability = max(capacitorDurability as float + durability, 0.0F) as int;
        }
    }

    if (capacitorType == 0) {
        newDurability = 0;
    }

    map["capacitorType"] = capacitorType;
    map["capacitorDurability"] = newDurability;

    ctrl.customData = data;
}

function getCapacitorEfficiency(
    ctrl as IMachineController,
    typeCapacitorMap as IItemStack[int],
    capacitorTypeMap as int[IItemStack],
    capacitorEfficiency as float[IItemStack]) as float {

    val data = ctrl.customData;
    val map = data.asMap();
    val dData = D(data);

    val capacitorTypeItem = typeCapacitorMap[dData.getInt("capacitorType")];
    if (isNull(capacitorTypeItem)) {
        return 1.0F;
    }

    val efficiency = capacitorEfficiency[capacitorTypeItem];
    return isNull(efficiency) ? 1.0F : efficiency;
}

function max(a as float, b as float) as float {
    return a >= b ? a : b;
}

function min(a as float, b as float) as float {
    return a <= b ? a : b;
}