//Recipes By Hikari_Nova.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import crafttweaker.item.IItemStack;

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;

RecipeBuilder.newBuilder("extendable_digital_storage_subsystem_l4_controller", "machine_arm", 1600)
    .addEnergyPerTickInput(64000)
    .addInputs([
        <contenttweaker:hypernet_cpu_t2> * 3,
        <contenttweaker:hypernet_ram_t2> * 6,
        <contenttweaker:industrial_circuit_v1> * 16,
        <ic2:heat_vent> * 6,
        <ic2:component_heat_vent> * 12,
        <appliedenergistics2:paint_ball:23> * 16,
        <ore:plateDenseSteel> * 32,
        <appliedenergistics2:controller> * 1,
    ])
    .addOutputs(<novaeng_core:extendable_digital_storage_subsystem_l4> * 1)
    .requireResearch("extendable_digital_storage_subsystem_l4")
    .build();

RecipeBuilder.newBuilder("extendable_digital_storage_subsystem_l6_controller", "machine_arm", 9600)
    .addEnergyPerTickInput(512000)
    .addInputs([
        <contenttweaker:hypernet_cpu_t2> * 6,
        <contenttweaker:hypernet_ram_t2> * 12,
        <contenttweaker:industrial_circuit_v2> * 16,
        <ic2:advanced_heat_vent> * 12,
        <ic2:component_heat_vent> * 24,
        <appliedenergistics2:paint_ball:21> * 16,
        <ore:plateDenseSteel> * 32,
        <appliedenergistics2:controller> * 1,
    ])
    .addOutputs(<novaeng_core:extendable_digital_storage_subsystem_l6> * 1)
    .requireResearch("extendable_digital_storage_subsystem_l6")
    .build();

RecipeBuilder.newBuilder("extendable_digital_storage_subsystem_l9_controller", "workshop", 9600)
    .addEnergyPerTickInput(8192000)
    .addInputs([
        <liquid:crystalloid> * 6000,
        <contenttweaker:hypernet_cpu_t3> * 4,
        <contenttweaker:hypernet_ram_t3> * 8,
        <contenttweaker:industrial_circuit_v3> * 24,
        <ic2:advanced_heat_vent> * 16,
        <ic2:component_heat_vent> * 32,
        <appliedenergistics2:paint_ball:30> * 16,
        <ore:plateDenseSteel> * 32,
        <appliedenergistics2:controller> * 1,
    ])
    .addOutputs(<novaeng_core:extendable_digital_storage_subsystem_l9> * 1)
    .requireResearch("extendable_digital_storage_subsystem_l9")
    .build();

RecipeBuilder.newBuilder("estorage_cell_item_16m", "board_assembly_room", 400)
    .addEnergyPerTickInput(16000)
    .addInputs([
        <contenttweaker:hypernet_cpu_t2>,
        <contenttweaker:hypernet_ram_t2> * 2,
        <ore:dustRedstone> * 32,
        <appliedenergistics2:material:39> * 4,
        <appliedenergistics2:material:43> * 8,
        <appliedenergistics2:material:44> * 8,
        <appliedenergistics2:material:10> * 64,
        <appliedenergistics2:material:10> * 64,
    ])
    .addOutputs(<novaeng_core:estorage_cell_item_16m>.withTag({}))
    .requireResearch("extendable_digital_storage_subsystem_l4")
    .setParallelized(false)
    .build();

RecipeBuilder.newBuilder("estorage_cell_fluid_16m", "board_assembly_room", 400)
    .addEnergyPerTickInput(16000)
    .addInputs([
        <contenttweaker:hypernet_cpu_t2>,
        <contenttweaker:hypernet_ram_t2> * 2,
        <ore:gemLapis> * 32,
        <appliedenergistics2:material:39> * 4,
        <appliedenergistics2:material:43> * 8,
        <appliedenergistics2:material:44> * 8,
        <appliedenergistics2:material:10> * 64,
        <appliedenergistics2:material:10> * 64,
    ])
    .addOutputs(<novaeng_core:estorage_cell_fluid_16m>.withTag({}))
    .requireResearch("extendable_digital_storage_subsystem_l4")
    .setParallelized(false)
    .build();

RecipeBuilder.newBuilder("estorage_cell_item_64m", "precision_assembler", 600)
    .addEnergyPerTickInput(256000)
    .addInputs([
        <contenttweaker:hypernet_cpu_t2> * 2,
        <contenttweaker:hypernet_ram_t2> * 4,
        <ore:dustRedstone> * 32,
        <mets:neutron_plate> * 16,
        <appliedenergistics2:material:43> * 8,
        <appliedenergistics2:material:44> * 8,
        <ore:gemBoronNitride> * 64,
        <ore:gemBoronNitride> * 64,
        <appliedenergistics2:material:10> * 16,
    ])
    .addOutputs(<novaeng_core:estorage_cell_item_64m>.withTag({}))
    .requireResearch("extendable_digital_storage_subsystem_l6")
    .requireComputationPoint(20.0F)
    .setParallelized(false)
    .build();

RecipeBuilder.newBuilder("estorage_cell_fluid_64m", "precision_assembler", 600)
    .addEnergyPerTickInput(256000)
    .addInputs([
        <contenttweaker:hypernet_cpu_t2> * 2,
        <contenttweaker:hypernet_ram_t2> * 4,
        <ore:gemLapis> * 32,
        <mets:neutron_plate> * 16,
        <appliedenergistics2:material:43> * 8,
        <appliedenergistics2:material:44> * 8,
        <ore:gemBoronNitride> * 64,
        <ore:gemBoronNitride> * 64,
        <appliedenergistics2:material:10> * 16,
    ])
    .addOutputs(<novaeng_core:estorage_cell_fluid_64m>.withTag({}))
    .requireResearch("extendable_digital_storage_subsystem_l6")
    .requireComputationPoint(20.0F)
    .setParallelized(false)
    .build();

RecipeBuilder.newBuilder("estorage_cell_item_256m", "assembly_line", 600)
    .setAssemblyLineProxied()
    .addEnergyPerTickInput(32000000)
    .addInput(<liquid:crystalloid> * 432).setTag("fluid_input_0") // Fluid
    .addInput(<contenttweaker:exponential_level_processor> * 8).setTag("input_0")
    .addInput(<threng:material:14> * 16).setTag("input_1")
    .addInput(<appliedenergistics2:material:43> * 24).setTag("input_2")
    .addInput(<appliedenergistics2:material:44> * 24).setTag("input_3")
    .addInput(<appliedenergistics2:material:47> * 2).setTag("input_line_0")
    .addInput(<ore:dustRedstone> * 64).setTag("input_line_1")
    .addOutput(<novaeng_core:estorage_cell_item_256m> * 1).setTag("output_line_end")
    .requireResearch("extendable_digital_storage_subsystem_l9")
    .requireComputationPoint(100.0F)
    .convertAssemblyLineRecipeToDefaultRecipeAndRegister("acar")
    .setParallelized(false)
    .build();

RecipeBuilder.newBuilder("estorage_cell_fluid_256m", "assembly_line", 600)
    .setAssemblyLineProxied()
    .addEnergyPerTickInput(32000000)
    .addInput(<liquid:crystalloid> * 432).setTag("fluid_input_0") // Fluid
    .addInput(<contenttweaker:exponential_level_processor> * 8).setTag("input_0")
    .addInput(<threng:material:14> * 16).setTag("input_1")
    .addInput(<appliedenergistics2:material:43> * 24).setTag("input_2")
    .addInput(<appliedenergistics2:material:44> * 24).setTag("input_3")
    .addInput(<appliedenergistics2:material:47> * 2).setTag("input_line_0")
    .addInput(<ore:gemLapis> * 64).setTag("input_line_1")
    .addOutput(<novaeng_core:estorage_cell_fluid_256m> * 1).setTag("output_line_end")
    .requireResearch("extendable_digital_storage_subsystem_l9")
    .requireComputationPoint(100.0F)
    .convertAssemblyLineRecipeToDefaultRecipeAndRegister("acar")
    .setParallelized(false)
    .build();

recipes.addShaped(<novaeng_core:estorage_casing> * 2, [
    [<ore:plateDenseSteel>, <ore:plateLapis>, <ore:plateDenseSteel>],
    [<contenttweaker:industrial_circuit_v1>, <modularmachinery:blockcasing:4>, <contenttweaker:industrial_circuit_v1>],
    [<ore:plateDenseSteel>, <ore:plateLapis>, <ore:plateDenseSteel>]
]);

recipes.addShaped(<novaeng_core:estorage_vent> * 2, [
    [<ore:plateDenseSteel>, <ore:plateLapis>, <ore:plateDenseSteel>],
    [<contenttweaker:electric_motor_v2>, <novaeng_core:estorage_casing>, <contenttweaker:electric_motor_v2>],
    [<ore:plateDenseSteel>, <ore:plateLapis>, <ore:plateDenseSteel>]
]);

recipes.addShaped(<novaeng_core:estorage_cell_drive> * 3, [
    [<novaeng_core:estorage_casing>, <novaeng_core:estorage_casing>, <appliedenergistics2:drive>],
    [<contenttweaker:industrial_circuit_v1>, <contenttweaker:industrial_circuit_v1>, <contenttweaker:sensor_v1>],
    [<novaeng_core:estorage_casing>, <novaeng_core:estorage_casing>, <appliedenergistics2:drive>]
]);

recipes.addShaped(<novaeng_core:estorage_energy_cell_l9>, [
    [<novaeng_core:estorage_energy_cell_l6>, <contenttweaker:field_generator_v2>, <novaeng_core:estorage_energy_cell_l6>],
    [<novaeng_core:estorage_energy_cell_l6>, <contenttweaker:industrial_circuit_v3>, <novaeng_core:estorage_energy_cell_l6>],
    [<novaeng_core:estorage_energy_cell_l6>, <contenttweaker:field_generator_v2>, <novaeng_core:estorage_energy_cell_l6>]
]);

recipes.addShaped(<novaeng_core:estorage_energy_cell_l6>, [
    [<novaeng_core:estorage_energy_cell_l4>, <contenttweaker:field_generator_v1>, <novaeng_core:estorage_energy_cell_l4>],
    [<novaeng_core:estorage_energy_cell_l4>, <contenttweaker:industrial_circuit_v2>, <novaeng_core:estorage_energy_cell_l4>],
    [<novaeng_core:estorage_energy_cell_l4>, <contenttweaker:field_generator_v1>, <novaeng_core:estorage_energy_cell_l4>]
]);

recipes.addShaped(<novaeng_core:estorage_energy_cell_l4>, [
    [<appliedenergistics2:dense_energy_cell>, <novaeng_core:estorage_casing>, <appliedenergistics2:dense_energy_cell>],
    [<appliedenergistics2:dense_energy_cell>, <appliedenergistics2:material:23>, <appliedenergistics2:dense_energy_cell>],
    [<appliedenergistics2:dense_energy_cell>, <novaeng_core:estorage_casing>, <appliedenergistics2:dense_energy_cell>]
]);

recipes.addShaped(<novaeng_core:estorage_me_channel>, [
    [<novaeng_core:estorage_casing>, <gravisuite:crafting:1>, <novaeng_core:estorage_casing>],
    [<appliedenergistics2:part:76>, <contenttweaker:industrial_circuit_v1>, <appliedenergistics2:part:76>],
    [<novaeng_core:estorage_casing>, <gravisuite:crafting:1>, <novaeng_core:estorage_casing>]
]);
