//Recipes By Hikari_Nova.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import crafttweaker.item.IItemStack;
import crafttweaker.item.IIngredient;
import crafttweaker.data.IData;
import crafttweaker.world.IWorld;

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.RecipeCheckEvent;
import mods.modularmachinery.RecipeStartEvent;
import mods.modularmachinery.RecipeFinishEvent;
import mods.modularmachinery.RecipeModifierBuilder;
import mods.modularmachinery.IngredientArrayBuilder;

import mods.modularmachinery.MMEvents;
import mods.modularmachinery.ControllerGUIRenderEvent;

import mods.modularmachinery.IMachineController;
import mods.modularmachinery.MachineModifier;

import novaeng.hypernet.HyperNetHelper;

val tuningModifier = RecipeModifierBuilder.create("modularmachinery:energy", "output", 4, 1, false).build();

// 戴森云发射器
# 控制器配方
RecipeBuilder.newBuilder("dyson_cloud_transmitter_controller", "workshop", 7200, 0, false)
    .addEnergyPerTickInput(6144000)
    .addItemInputs([
        <contenttweaker:exponential_level_processor> * 24,
        <contenttweaker:sensor_v3> * 16,
        <contenttweaker:robot_arm_v3> * 16,
        <contenttweaker:electric_motor_v3> * 12,
        <gravisuite:crafting:3> * 8,
        <ore:ingotFallenStarAlloy> * 4,
        // <galacticraftcore:dishbase> * 1,
    ])
    .addOutput(<modularmachinery:dyson_cloud_transmitter_controller>)
    .requireComputationPoint(220.0F)
    .requireResearch("theory_of_dyson_cloud")
    .build();

# 发射戴森云
RecipeBuilder.newBuilder("launch_dyson_cloud", "dyson_cloud_transmitter", 1800, 0, false)
    .addEnergyPerTickInput(10000000)
    .addItemInputs([
        <ic2:crafting:15> * 64,
        <contenttweaker:carbon_nanotube> * 48,
        <mets:neutron_plate> * 64,
        <mets:nano_living_metal> * 64,
        <nuclearcraft:gem:5> * 64,
        <super_solar_panels:crafting:17> * 32,
        <fluxnetworks:fluxcore> * 32,
        <gravisuite:crafting:1> * 32,
        <mets:living_circuit> * 16,
        <enderio:item_capacitor_stellar> * 2,
        <contenttweaker:general_data_card>,
        <appliedenergistics2:material:47>,
    ])
    .addOutput(<contenttweaker:dyson_cloud_pos_data_card>.withTag({
        display: {
            Lore: [
                "§9坐标数据数量：§a1",
            ],
        },
        dysonCloudAmount: 1
    }))
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val world = ctrl.world;
        if (!matchesSpaceStationDim(world)) {
            event.setFailed("只能在空间站维度工作！");
        }
    })
    .addRecipeTooltip("发射戴森云至太阳周围，输出坐标数据。", "§c只能在空间站工作。")
    .build();

/*/ 戴森云能量接收器阵列
# 控制器配方
RecipeBuilder.newBuilder("dyson_cloud_energy_receiver_array_controller", "workshop", 9600, 0, false)
    .addEnergyPerTickInput(204800000)
    .addItemInputs([
        <contenttweaker:infinity_processor> * 8,
        <contenttweaker:exponential_level_processor> * 64,
        <contenttweaker:exponential_level_processor> * 64,
        <contenttweaker:exponential_level_processor> * 64,
        <draconicevolution:particle_generator:2> * 36,
        <contenttweaker:general_data_card> * 32,
        <ore:plateChaoticMetal> * 8,
        <custommc:item170> * 4,
    ])
    .addOutput(<modularmachinery:dyson_cloud_energy_receiver_array_controller>)
    .requireComputationPoint(6800.0F)
    .requireResearch("dyson_cloud_energy_receiver_array")
    .build();

HyperNetHelper.proxyMachineForHyperNet("dyson_cloud_energy_receiver_array");
# 最大并行数
MachineModifier.setMaxParallelism("dyson_cloud_energy_receiver_array", 64);

# 解析运行数据并输出调谐数据
RecipeBuilder.newBuilder("analysis_operation_data", "dyson_cloud_energy_receiver_array", 150, 0, false)
    .addEnergyPerTickInput(10000000)
    // .addPostCheckHandler(function(event as RecipeCheckEvent) {
    //     val ctrl = event.controller;
    //     val world = ctrl.world;
    //     if (!matchesSpaceStationDim(world)) {
    //         event.setFailed("只能在空间站维度工作！");
    //     }
    // })
    .addInput(<contenttweaker:dyson_cloud_operation_data_card>).setTag("receiver_array")
    .addOutput(<contenttweaker:dyson_cloud_tuning_data_card>).setTag("receiver_array")
    .requireComputationPoint(200.0F)
    // .addRecipeTooltip("§c只能在空间站维度工作。")
    .build();
*/
// 戴森云能量接收器
HyperNetHelper.proxyMachineForHyperNet("dyson_cloud_energy_receiver");
# 添加控制器 GUI 信息
MMEvents.onControllerGUIRender("dyson_cloud_energy_receiver", function(event as ControllerGUIRenderEvent) {
    val ctrl = event.controller;
    val data = ctrl.customData;
    val dData = D(data);
    val map = data.asMap();
    val dysonCloudAmount = dData.getInt("dysonCloudAmount", 0);
    val hasTuningData = dData.getBool("hasTuningData");
    val hasGeneralDataCard = dData.getBool("hasGeneralDataCard");
    var generation = dysonCloudAmount * 20;

    var info as string[] = [
        "§6//////////// 戴森云控制器 ////////////",
        "§6已连接戴森云：§a" + dysonCloudAmount + " / 5",
    ];

    if (hasTuningData) {
        info += "§6能量产出：§a" + generation * 4 + "M RF/t（增幅：300%）";
    } else {
        info += "§6能量产出：§a" + generation+ "M RF/t";
    }

    if (hasGeneralDataCard) {
        info += "§a正在收集运行数据...";
    }

    event.extraInfo = info;
});

# 控制器配方
RecipeBuilder.newBuilder("dyson_cloud_energy_receiver_controller", "machine_arm", 7200, 0, false)
    .addEnergyPerTickInput(6144000)
    .addItemInputs([
        <contenttweaker:industrial_circuit_v2> * 16,
        <contenttweaker:sensor_v3> * 4,
        <mets:te:21> * 4,
        <mets:geomagnetic_antenna> * 8,
        <fluxnetworks:fluxcore> * 32,
        <custommc:item929>,
    ])
    .addOutput(<modularmachinery:dyson_cloud_energy_receiver_controller>)
    .requireResearch("theory_of_dyson_cloud")
    .build();

# 写入控制器数据至存储卡
RecipeBuilder.newBuilder("write_dyson_cloud_pos_data", "dyson_cloud_energy_receiver", 20, 0, false)
    .addItemInputs([
        <contenttweaker:general_data_card>,
        <appliedenergistics2:material:47>,
    ])
    .addOutput(<contenttweaker:dyson_cloud_pos_data_card>).setPreViewNBT({
        display: {
            Lore: [
                "§9坐标数据数量：§e?",
            ],
        }
    }).addItemModifier(function(ctrl as IMachineController, item as IItemStack) {
        val data = ctrl.customData;
        val dData = D(data);
        val map = data.asMap();
        val dysonCloudAmount = dData.getInt("dysonCloudAmount", 0);

        map["dysonCloudAmount"] = 0;
        ctrl.customData = data;

        return item.withTag({
            display: {
                Lore: [
                    "§9坐标数据数量：§a" + dysonCloudAmount,
                ],
            },
            dysonCloudAmount: dysonCloudAmount
        });
    })
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val world = ctrl.world;
        // if (!matchesSpaceStationDim(world)) {
        //     event.setFailed("只能在空间站维度工作！");
        //     return;
        // }
        val data = ctrl.customData;
        val dData = D(data);
        val dysonCloudAmount = dData.getInt("dysonCloudAmount", 0);
        if (dysonCloudAmount <= 0) {
            event.setFailed("至少需要连接一个戴森云才能工作！");
        }
    })
    .addRecipeTooltip("将控制器内的数据写入存储卡。")
    .build();

# 戴森云数据读取
RecipeBuilder.newBuilder("read_dyson_cloud_pos_data", "dyson_cloud_energy_receiver", 20, 1, false)
    .addInput(<contenttweaker:dyson_cloud_pos_data_card>).setPreViewNBT({
        display: {
            Lore: [
                "§9坐标数据数量：§a任意",
            ],
        }
    }).setNBTChecker(function(ctrl as IMachineController, item as IItemStack) {
        val dysonCloudAmount = D(item.tag).getInt("dysonCloudAmount", 0);
        if (dysonCloudAmount <= 0) {
            return false;
        }
        val data = ctrl.customData;
        data.asMap()["dysonCloudAmountCache"] = dysonCloudAmount;
        ctrl.customData = data;
        return true;
    })
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val world = ctrl.world;
        // if (!matchesSpaceStationDim(world)) {
        //     event.setFailed("只能在空间站维度工作！");
        //     return;
        // }
        val data = ctrl.customData;
        val dData = D(data);
        val dysonCloudAmount = dData.getInt("dysonCloudAmount", 0);
        if (dysonCloudAmount >= 5) {
            event.setFailed("控制器连接的戴森云数量已达到上限！");
        }
    })
    .addFinishHandler(function(event as RecipeFinishEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val map = data.asMap();
        val dysonCloudAmount = dData.getInt("dysonCloudAmount", 0);
        var dysonCloudAmountCache = dData.getInt("dysonCloudAmountCache", 0);

        if (dysonCloudAmount + dysonCloudAmountCache > 5) {
            map["dysonCloudAmount"] = 5;
        } else {
            map["dysonCloudAmountCache"] = 0;
            map["dysonCloudAmount"] = dysonCloudAmount + dysonCloudAmountCache;
        }
        ctrl.customData = data;
    })
    .addOutput(<contenttweaker:dyson_cloud_pos_data_card>.withTag({
        display: {
            Lore: [
                "§9坐标数据数量：§e?",
                "§e如果所有的数据都被读取入控制器，则返回一张空的通用数据存储卡。",
            ],
        },
    })).addItemModifier(function(ctrl as IMachineController, item as IItemStack) {
        val data = ctrl.customData;
        val dData = D(data);
        val map = data.asMap();
        var dysonCloudAmountCache = dData.getInt("dysonCloudAmountCache", 0);

        if (dysonCloudAmountCache <= 0) {
            return <contenttweaker:general_data_card>;
        } else {
            return <contenttweaker:dyson_cloud_pos_data_card>.withTag({
                display: {
                    Lore: [
                        "§9坐标数据数量：§a" + dysonCloudAmountCache,
                    ],
                },
                dysonCloudAmount: dysonCloudAmountCache
            });
        }
    })
    .addRecipeTooltip("读取戴森云坐标数据。", "每个机器最多存储 §a5§f 个数据。")
    .build();

# 戴森云发电
RecipeBuilder.newBuilder("dyson_cloud_gen", "dyson_cloud_energy_receiver", 200, 2, true)
    .addEnergyPerTickOutput(20000000)
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val world = ctrl.world;
        // if (!matchesSpaceStationDim(world)) {
        //     event.setFailed("只能在空间站维度工作！");
        //     return;
        // }
        val data = ctrl.customData;
        val dData = D(data);
        val map = data.asMap();
        val dysonCloudAmount = dData.getInt("dysonCloudAmount", 0);
        if (dysonCloudAmount <= 0) {
            event.setFailed("至少需要连接一个戴森云才能工作！");
            return;
        }
        if (dData.getBool("checkAnotherRecipes")) {
            event.setFailed("检查坐标数据存储卡中！");
            map["checkAnotherRecipes"] = false;
            ctrl.customData = data;
        }
    })
    .addStartHandler(function(event as RecipeStartEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val dysonCloudAmount = dData.getInt("dysonCloudAmount", 0);
        ctrl.addModifier("dysonCloudMultiplier", RecipeModifierBuilder.create("modularmachinery:energy", "output", dysonCloudAmount, 1, false).build());
    })
    .addFinishHandler(function(event as RecipeFinishEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val map = data.asMap();
        map["checkAnotherRecipes"] = true;
        ctrl.customData = data;
    })
    .requireComputationPoint(25.0F)
    .addRecipeTooltip("每个戴森云可以产出 §a20 MRF§f 能量。")
    .build();

function matchesSpaceStationDim(world as IWorld) as bool {
    return world.provider.dimensionID == -2;
}
