//Recipes By Hikari_Nova.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.MachineModifier;

import novaeng.hypernet.HyperNetHelper;

//==============================水晶注能机==============================
HyperNetHelper.proxyMachineForHyperNet("crystal_injector");

MachineModifier.setMaxThreads("crystal_injector", 4);

# 控制器
RecipeBuilder.newBuilder("crystal_injector_controller", "machine_arm", 600)
    .addEnergyPerTickInput(128000)
    .addInputs([
        <liquid:crystal_matrix> * 2880,
        <contenttweaker:industrial_circuit_v2> * 8,
        <contenttweaker:field_generator_v1> * 12,
        <contenttweaker:robot_arm_v3> * 4,
        <contenttweaker:coil_v3> * 12,
        <ebwizardry:grand_crystal> * 12,
        <ore:ingotTerraAlloy> * 2,
        <modularmachinery:blockcasing> * 1,
    ])
    .addOutputs(<modularmachinery:crystal_injector_factory_controller>)
    .requireResearch("crystal_injector")
    .build();

var recipeCounter = 1;

# 充能燃料单元（等级 1）
RecipeBuilder.newBuilder("energized_fuel_v1", "crystal_injector", 300, recipeCounter, false)
    .addEnergyPerTickInput(256000)
    .addInputs([
        <liquid:pyrotheum> * 10000,
        <contenttweaker:energized_fuel_container_v1> * 1,
        <ore:dustEnergetic> * 48,
        <ore:powderMana> * 16,
        <ore:nuggetCosmicNeutronium> * 1,
    ])
    .addOutputs(<contenttweaker:energized_fuel_v1>)
    .build();
recipeCounter += 1;

# 充能燃料单元（等级 2）
RecipeBuilder.newBuilder("energized_fuel_v2", "crystal_injector", 600, recipeCounter, false)
    .addEnergyPerTickInput(1024000)
    .addInputs([
        <liquid:plasma> * 15000,
        <contenttweaker:energized_fuel_container_v2> * 1,
        <contenttweaker:energized_fuel_v1> * 1,
    ])
    .addOutputs([
        <contenttweaker:energized_fuel_v2> * 1,
        <contenttweaker:energized_fuel_container_v1> * 1,
    ])
    .requireResearch("tokmak_reactor")
    .build();
recipeCounter += 1;

# 充能燃料单元（等级 3）
RecipeBuilder.newBuilder("energized_fuel_v3", "crystal_injector", 1200, recipeCounter, false)
    .addEnergyPerTickInput(4096000)
    .addInputs([
        <liquid:draconic_metal> * 2160,
        <liquid:chaotic_metal> * 72,
        <contenttweaker:energized_fuel_container_v3> * 1,
        <contenttweaker:energized_fuel_v2> * 1,
    ])
    .addOutputs([
        <contenttweaker:energized_fuel_v3> * 1,
        <contenttweaker:energized_fuel_container_v2> * 1,
    ])
    .requireResearch("energy_crystal")
    .build();
recipeCounter += 1;

# 充能燃料单元（等级 4）
RecipeBuilder.newBuilder("energized_fuel_v4", "crystal_injector", 2400, recipeCounter, false)
    .addEnergyPerTickInput(16384000)
    .addInputs([
        <liquid:crystalloid> * 10000,
        <avaritia:resource:5> * 8,
        <contenttweaker:energized_fuel_v3> * 1,
        <contenttweaker:energized_fuel_container_v4> * 1,
    ])
    .addOutputs([
        <contenttweaker:energized_fuel_v4> * 1,
        <contenttweaker:energized_fuel_container_v3> * 1,
    ])
    .requireResearch("beyond_limits")
    .build();
recipeCounter += 1;


// 回收：充能燃料单元（竭尽，等级 1）
RecipeBuilder.newBuilder("energized_fuel_depleted_v1", "crystal_injector", 150, recipeCounter, false)
    .addEnergyPerTickInput(128000)
    .addInputs([
        <contenttweaker:energized_fuel_depleted_v1> * 1,
    ])
    .addOutputs(<contenttweaker:energized_fuel_container_v1> * 1)
    .addOutput(<ore:dustEnergetic> * 8).setChance(0.15)
    .requireResearch("crystal_injector")
    .build();
recipeCounter += 1;

// 回收：充能燃料单元（竭尽，等级 2）
RecipeBuilder.newBuilder("energized_fuel_depleted_v2", "crystal_injector", 300, recipeCounter, false)
    .addEnergyPerTickInput(512000)
    .addInputs([
        <contenttweaker:energized_fuel_depleted_v2> * 1,
    ])
    .addOutputs(<contenttweaker:energized_fuel_container_v2> * 1)
    .addOutput(<liquid:unsteady_plasma> * 10000).setChance(0.25)
    .addOutput(<liquid:unsteady_plasma> * 5000).setChance(0.1)
    .requireResearch("tokmak_reactor")
    .build();
recipeCounter += 1;

// 回收：充能燃料单元（竭尽，等级 3）
RecipeBuilder.newBuilder("energized_fuel_depleted_v3", "crystal_injector", 450, recipeCounter, false)
    .addEnergyPerTickInput(2048000)
    .addInputs([
        <contenttweaker:energized_fuel_depleted_v3> * 1,
    ])
    .addOutputs(<contenttweaker:energized_fuel_container_v3> * 1)
    .addOutput(<liquid:chaotic_metal> * 144).setChance(0.25)
    .requireResearch("energy_crystal")
    .build();
recipeCounter += 1;

// 回收：充能燃料单元（竭尽，等级 4）
RecipeBuilder.newBuilder("energized_fuel_depleted_v4", "crystal_injector", 600, recipeCounter, false)
    .addEnergyPerTickInput(8192000)
    .addInputs([
        <contenttweaker:energized_fuel_depleted_v4> * 1,
    ])
    .addOutputs([
        <contenttweaker:energized_fuel_container_v4> * 1,
        <mekanism:antimatterpellet> * 1
    ])
    .requireResearch("beyond_limits")
    .build();
recipeCounter += 1;

# 注能魔力水晶（等级 1）
RecipeBuilder.newBuilder("mana_crystal_v1", "crystal_injector", 300, recipeCounter, false)
    .addEnergyPerTickInput(102400)
    .addInputs([
        <liquid:fluidedmana> * 250,
        <ebwizardry:magic_crystal> * 1,
    ])
    .addOutputs(<custommc:item794>)
    .build();
recipeCounter += 1;

# 注能魔力水晶（等级 2）
RecipeBuilder.newBuilder("mana_crystal_v2", "crystal_injector", 600, recipeCounter, false)
    .addEnergyPerTickInput(409600)
    .addInputs([
        <liquid:fluidedmana> * 1000,
        <custommc:item794> * 1,
        <ore:elvenDragonstone> * 1,
    ])
    .addOutputs(<custommc:item798>)
    .build();
recipeCounter += 1;

# 注能魔力水晶（等级 3）
RecipeBuilder.newBuilder("mana_crystal_v3", "crystal_injector", 1200, recipeCounter, false)
    .addEnergyPerTickInput(1638400)
    .addInputs([
        <liquid:fluidedmana> * 4000,
        <custommc:item798> * 1,
        <ore:eternalLifeEssence> * 1,
    ])
    .addOutputs(<custommc:item75>)
    .build();
recipeCounter += 1;

# 注能 UU 水晶（等级 1）
RecipeBuilder.newBuilder("uu_crystal_v1", "crystal_injector", 150, recipeCounter, false)
    .addEnergyPerTickInput(204800)
    .addInputs([
        <liquid:ic2uu_matter> * 20000,
        <custommc:item794> * 1,
    ])
    .addOutputs(<custommc:item796>)
    .build();
recipeCounter += 1;

# 注能 UU 水晶（等级 2）
RecipeBuilder.newBuilder("uu_crystal_v2", "crystal_injector", 450, recipeCounter, false)
    .addEnergyPerTickInput(819200)
    .addInputs([
        <liquid:ic2uu_matter> * 300000,
        <custommc:item796> * 1,
    ])
    .addOutputs(<custommc:item800>)
    .build();
recipeCounter += 1;

# 注能 UU 水晶（等级 3）
RecipeBuilder.newBuilder("uu_crystal_v3", "crystal_injector", 1300, recipeCounter, false)
    .addEnergyPerTickInput(3276800)
    .addInputs([
        <liquid:crystalloid> * 800,
        <custommc:item800> * 1,
    ])
    .addOutputs(<custommc:item885>)
    .build();
recipeCounter += 1;

# 异世界水晶
RecipeBuilder.newBuilder("crystal_rgp", "crystal_injector", 2400, recipeCounter, false)
    .addEnergyPerTickInput(160000000)
    .addInputs([
        <liquid:crystalloidneutron> * 288000,
        <liquid:fluidedmana> * 1000,
        <ore:gemCrystalRed> * 6,
        <ore:gemCrystalGreen> * 6,
        <ore:gemCrystalPurple> * 6,
    ])
    .addOutputs(<additions:novaextended-crystal4>)
    .build();
recipeCounter += 1;
