//Recipes By Hikari_Nova.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import crafttweaker.item.IItemStack;
import crafttweaker.item.IIngredient;
import crafttweaker.liquid.ILiquidStack;

import novaeng.hypernet.HyperNetHelper;

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;

// 元件装配室
HyperNetHelper.proxyMachineForHyperNet("board_assembly_room");

var recipeCounter = 1;
var counter = 1;

// CPU 模块（等级 1）
RecipeBuilder.newBuilder("hypernet_cpu_t1", "board_assembly_room", 800, recipeCounter, false)
    .addEnergyPerTickInput(4800)
    .addInputs([
        <liquid:redstone> * 800,
        <appliedenergistics2:material:23> * 2,
        <ore:plateLapis> * 2,
    ])
    .addOutput(<contenttweaker:hypernet_cpu_t1> * 1)
    .requireResearch("cpu_t1")
    .build();
recipeCounter += 1;

// 内存模块（等级 1）
RecipeBuilder.newBuilder("hypernet_ram_t1", "board_assembly_room", 800, recipeCounter, false)
    .addEnergyPerTickInput(4800)
    .addInputs([
        <liquid:gold> * 432,
        <appliedenergistics2:material:23> * 1,
        <appliedenergistics2:material:22> * 1,
        <ore:plateLapis> * 2,
    ])
    .addOutput(<contenttweaker:hypernet_ram_t1> * 1)
    .requireResearch("cpu_t1")
    .build();
recipeCounter += 1;

//工程控制电路（等级 1）
RecipeBuilder.newBuilder("industrial_circuit_v1", "board_assembly_room", 400, recipeCounter, false)
    .addEnergyPerTickInput(9600)
    .addInputs([
        <liquid:redstone> * 800,
        <ore:circuitAdvanced> * 3,
        <ic2:crafting:4> * 1,
    ])
    .addOutput(<contenttweaker:industrial_circuit_v1> * 3)
    .build();
recipeCounter += 1;

//传感器（等级 1）
RecipeBuilder.newBuilder("sensor_v1", "board_assembly_room", 200, recipeCounter, false)
    .addEnergyPerTickInput(4800)
    .addInputs([
        <ore:circuitElite> * 1,
        <contenttweaker:industrial_circuit_v1> * 1,
        <ore:stickTin> * 2,
        <ic2:crafting:4> * 1,
        <ore:crystalPureFluix> * 1,
    ])
    .addOutputs(<contenttweaker:sensor_v1> * 2)
    .build();
recipeCounter += 1;

//电动马达（等级 1）
RecipeBuilder.newBuilder("electric_motor_v1", "board_assembly_room", 200, recipeCounter, false)
    .addEnergyPerTickInput(4800)
    .addInputs([
        <ic2:crafting:5> * 2,
        <ore:plateTin> * 2,
        <ore:stickIron> * 1,
    ])
    .addOutputs(<contenttweaker:electric_motor_v1> * 1)
    .build();
recipeCounter += 1;

//电动马达（等级 2）
RecipeBuilder.newBuilder("electric_motor_v2", "board_assembly_room", 200, recipeCounter, false)
    .addEnergyPerTickInput(9600)
    .addInputs([
        <contenttweaker:coil_v2> * 4,
        <ore:plateWillowalloy> * 4,
        <contenttweaker:industrial_circuit_v1> * 2,
        <ic2:crafting:30> * 1,
    ])
    .addOutputs(<contenttweaker:electric_motor_v2> * 2)
    .build();
recipeCounter += 1;

//机械臂（等级 1）
RecipeBuilder.newBuilder("robot_arm_v1", "board_assembly_room", 200, recipeCounter, false)
    .addEnergyPerTickInput(4800)
    .addInputs([
        <contenttweaker:electric_motor_v1> * 2,
        <ore:stickIron> * 2,
        <ore:circuitAdvanced> * 1,
    ])
    .addOutputs(<contenttweaker:robot_arm_v1> * 1)
    .build();
recipeCounter += 1;

//机械臂（等级 2）
RecipeBuilder.newBuilder("robot_arm_v2", "board_assembly_room", 200, recipeCounter, false)
    .addEnergyPerTickInput(9600)
    .addInputs([
        <contenttweaker:electric_motor_v2> * 2,
        <ore:stickWillowalloy> * 2,
        <contenttweaker:industrial_circuit_v1> * 1,
    ])
    .addOutputs(<contenttweaker:robot_arm_v2> * 1)
    .build();
recipeCounter += 1;

//工程电池（等级 1）
RecipeBuilder.newBuilder("engineering_battery_v1", "board_assembly_room", 200, recipeCounter, false)
    .addEnergyPerTickInput(4800)
    .addInputs([
        <liquid:redstone> * 450,
        <ore:plateTin> * 2,
        <ore:circuitAdvanced> * 1,
    ])
    .addOutputs(<contenttweaker:engineering_battery_v1> * 1)
    .build();
recipeCounter += 1;

//工程电池（等级 2）
RecipeBuilder.newBuilder("engineering_battery_v2", "board_assembly_room", 400, recipeCounter, false)
    .addEnergyPerTickInput(9600)
    .addInputs([
        <ore:dustLithium> * 16,
        <ore:dustGraphite> * 4,
        <ic2:crafting:4> * 1,
        <contenttweaker:industrial_circuit_v1> * 1,
    ])
    .addOutputs(<contenttweaker:engineering_battery_v2> * 1)
    .build();
recipeCounter += 1;

RecipeBuilder.newBuilder("assembly_basic_" + counter, "board_assembly_room", 20, recipeCounter, false)
    .addEnergyPerTickInput(600)
    .addInputs([
        <liquid:redstone> * 10,
        <ore:plateOsmium>
    ])
    .addOutput(<mekanism:controlcircuit>)
    .build();
counter += 1;
recipeCounter += 1;

RecipeBuilder.newBuilder("assembly_basic_" + counter, "board_assembly_room", 20, recipeCounter, false)
    .addEnergyPerTickInput(600)
    .addInputs([
        <ore:plateIron>,
        <ore:plateCopper>,
        <liquid:redstone> * 10,
    ])
    .addOutput(<ic2:crafting:1>)
    .build();
counter += 1;
recipeCounter += 1;

RecipeBuilder.newBuilder("assembly_basic_" + counter, "board_assembly_room", 40, recipeCounter, false)
    .addEnergyPerTickInput(1200)
    .addInputs([
        <ore:circuitBasic>,
        <ore:gemLapis>,
        <ore:dustRedstone>,
        <ore:dustGlowstone>,
    ])
    .addOutput(<ic2:crafting:2>)
    .build();
counter += 1;
recipeCounter += 1;

RecipeBuilder.newBuilder("assembly_basic_" + counter, "board_assembly_room", 40, recipeCounter, false)
    .addEnergyPerTickInput(1200)
    .addInputs([
        <ore:circuitAdvanced> * 2,
        <mekanism:reinforcedalloy> * 2,
        <appliedenergistics2:material:20> * 2,
        <ore:plateSignalum> * 1,
        <mets:superconducting_cable> * 2,
    ])
    .addOutput(<mekanism:controlcircuit:2>)
    .build();
counter += 1;
recipeCounter += 1;

RecipeBuilder.newBuilder("assembly_basic_" + counter, "board_assembly_room", 60, recipeCounter, false)
    .addEnergyPerTickInput(1800)
    .addInputs([
        <ore:circuitAdvanced> * 4,
        <ore:circuitBasic> * 8,
        <contenttweaker:engineering_battery_v1> * 2,
    ])
    .addOutput(<ic2:upgrade:2> * 12)
    .build();
counter += 1;
recipeCounter += 1;

RecipeBuilder.newBuilder("assembly_basic_" + counter, "board_assembly_room", 60, recipeCounter, false)
    .addEnergyPerTickInput(2400)
    .addInputs([
        <ore:circuitAdvanced> * 8,
        <ore:circuitBasic> * 16,
        <contenttweaker:engineering_battery_v2>,
    ])
    .addOutput(<ic2:upgrade:2> * 24)
    .build();
counter += 1;
recipeCounter += 1;

// CPU 模块（等级 2）
RecipeBuilder.newBuilder("hypernet_cpu_t2", "board_assembly_room", 1200, recipeCounter, false)
    .addEnergyPerTickInput(9600)
    .addInputs([
        <liquid:redstone> * 1600,
        <appliedenergistics2:material:23> * 8,
        <threng:material:5> * 6,
        <ic2:heat_vent> * 2,
        <ore:plateEnergium> * 2,
    ])
    .addOutput(<contenttweaker:hypernet_cpu_t2> * 1)
    .requireResearch("cpu_t2")
    .build();
recipeCounter += 1;

// GPU 模块（等级 1）
RecipeBuilder.newBuilder("hypernet_gpu_t1", "board_assembly_room", 1600, recipeCounter, false)
    .addEnergyPerTickInput(14400)
    .addInputs([
        <liquid:redstone> * 2400,
        <appliedenergistics2:material:23> * 16,
        <threng:material:5> * 12,
        <ore:plateEnergium> * 6,
        <ic2:component_heat_vent> * 2,
        <contenttweaker:hypernet_ram_t2> * 2,
    ])
    .addOutput(<contenttweaker:hypernet_gpu_t1> * 1)
    .requireResearch("cpu_t2")
    .build();
recipeCounter += 1;

// 内存模块（等级 2）
RecipeBuilder.newBuilder("hypernet_ram_t2", "board_assembly_room", 1200, recipeCounter, false)
    .addEnergyPerTickInput(9600)
    .addInputs([
        <liquid:gold> * 864,
        <appliedenergistics2:material:23> * 4,
        <appliedenergistics2:material:22> * 4,
        <ic2:heat_vent> * 2,
        <ore:plateEnergium> * 2,
    ])
    .addOutput(<contenttweaker:hypernet_ram_t2> * 1)
    .requireResearch("cpu_t2")
    .build();
recipeCounter += 1;

RecipeBuilder.newBuilder("assembly_basic_" + counter, "board_assembly_room", 80, recipeCounter, false)
    .addEnergyPerTickInput(3600)
    .addInputs([
        <mets:superconducting_cable> * 4,
        <ic2:crafting:2> * 2,
        <ore:ingotPlatinum> * 2,
        <minecraft:diamond>,
    ])
    .addOutput(<mets:super_circuit> * 2)
    .build();
counter += 1;
recipeCounter += 1;

RecipeBuilder.newBuilder("assembly_basic_" + counter, "board_assembly_room", 80, recipeCounter, false)
    .addEnergyPerTickInput(4800)
    .addInputs([
        <ore:circuitElite> * 2,
        <mekanism:atomicalloy> * 2,
        <appliedenergistics2:material:20> * 2,
        <gravisuite:crafting> * 1,
        <ore:plateEnderium> * 1,
    ])
    .addOutput(<mekanism:controlcircuit:3> * 2)
    .build();
counter += 1;
recipeCounter += 1;

RecipeBuilder.newBuilder("assembly_basic_" + counter, "board_assembly_room", 100, recipeCounter, false)
    .addEnergyPerTickInput(6200)
    .addInputs([
        <mets:super_circuit> * 2,
        <mets:super_iridium_compress_plate>,
        <mets:nano_living_metal> * 2,
        <gravisuite:crafting:1> * 2,
    ])
    .addOutput(<mets:living_circuit> * 2)
    .build();
counter += 1;
recipeCounter += 1;

RecipeBuilder.newBuilder("assembly_basic_" + counter, "board_assembly_room", 100, recipeCounter, false)
    .addEnergyPerTickInput(8000)
    .addInputs([
        <mekanism:controlcircuit:3>,
        <mets:living_circuit>,
        <super_solar_panels:crafting:23>,
        <mets:super_iridium_compress_plate>,
    ])
    .addOutput(<super_solar_panels:crafting:44> * 3)
    .build();
counter += 1;
recipeCounter += 1;

RecipeBuilder.newBuilder("assembly_basic_" + counter, "board_assembly_room", 200, recipeCounter, false)
    .addEnergyPerTickInput(10000)
    .addInputs([
        <deepmoblearning:soot_covered_redstone> * 16,
        <ore:circuitElite> * 8,
        <ore:ingotEnergium> * 8,
        <ore:ingotTerraAlloy>,
    ])
    .addOutput(<deepmoblearning:data_model_blank> * 8)
    .build();
counter += 1;
recipeCounter += 1;

# 生命源质处理器
RecipeBuilder.newBuilder("assembly_basic_" + counter, "board_assembly_room", 200, recipeCounter, false)
    .addEnergyPerTickInput(12000)
    .addInputs([
        <ore:circuitAdvanced> * 4,
        <ore:ingotElvenElementium> * 2,
        <mets:nano_living_metal> * 1,
        <bloodmagic:slate:2> * 1,
        <liquid:astralsorcery.liquidstarlight> * 200,
    ])
    .addOutput(<contenttweaker:lifesense_processor> * 4)
    .build();
counter += 1;
recipeCounter += 1;

# 超频升级
val coolants as ILiquidStack[] = [
    <liquid:cryotheum> * 225,
    <liquid:liquid_helium> * 250,
    <liquid:liquid_nitrogen> * 300,
    <liquid:ice> * 1500,
];

counter = 1;
for coolant in coolants {
    RecipeBuilder.newBuilder("assembly_coolant_" + counter, "board_assembly_room", 60, recipeCounter, false)
        .addEnergyPerTickInput(1200)
        .addInput(coolant)
        .addInputs([
            <ore:circuitBasic> * 2,
            <ore:circuitAdvanced> * 1,
            <ore:plateSteel> * 2,
            <ic2:fluid_cell> * 2,
        ])
        .addOutput(<ic2:upgrade>)
        .build();
    recipeCounter += 1;
    counter += 1;
}

# MEK 合金
counter = 1;
RecipeBuilder.newBuilder("assembly_alloy_" + counter, "board_assembly_room", 20, recipeCounter, false)
    .addEnergyPerTickInput(1200)
    .addInput(<ore:ingotIron>)
    .addInput(<liquid:redstone> * 10)
    .addOutput(<mekanism:enrichedalloy>)
    .build();
recipeCounter += 1;
counter += 1;

RecipeBuilder.newBuilder("assembly_alloy_" + counter, "board_assembly_room", 30, recipeCounter, false)
    .addEnergyPerTickInput(1200)
    .addInput(<ore:alloyAdvanced>)
    .addInput(<liquid:diamond> * 10)
    .addOutput(<mekanism:reinforcedalloy>)
    .build();
recipeCounter += 1;
counter += 1;

RecipeBuilder.newBuilder("assembly_alloy_" + counter, "board_assembly_room", 40, recipeCounter, false)
    .addEnergyPerTickInput(1200)
    .addInput(<ore:alloyElite>)
    .addInput(<liquid:obsidian> * 10)
    .addOutput(<mekanism:atomicalloy>)
    .build();
recipeCounter += 1;
counter += 1;

# 玄钢线圈盘
RecipeBuilder.newBuilder("dark_steel_wire_reel", "board_assembly_room", 100, recipeCounter, false)
    .addEnergyPerTickInput(1600)
    .addInput(<ore:gearDarkSteel> * 2)
    .addInput(<ore:plateDarkSteel> * 4)
    .addInput(<ore:itemInfinityRod> * 1)
    .addOutput(<contenttweaker:dark_steel_wire_reel>)
    .build();
recipeCounter += 1;

# 镍导线
RecipeBuilder.newBuilder("nickel_wire", "board_assembly_room", 40, recipeCounter, false)
    .addEnergyPerTickInput(800)
    .addInput(<ore:plateNickel> * 1)
    .addOutput(<contenttweaker:nickel_wire> * 2)
    .build();
recipeCounter += 1;
