//Recipes By Hikari_Nova.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.MachineModifier;
import mods.modularmachinery.IngredientArrayBuilder;

import novaeng.hypernet.HyperNetHelper;

//==============================原子重构机==============================
HyperNetHelper.proxyMachineForHyperNet("atomic_reconstructor");
MachineModifier.setMaxThreads("atomic_reconstructor", 10);

//力场发生器（等级 4）
RecipeBuilder.newBuilder("field_generator_v4", "atomic_reconstructor", 600)
    .addEnergyPerTickInput(50000000)
    .addInputs([
        <contenttweaker:industrial_circuit_v4> * 2,
        <ore:circuitArk> * 2,
        <contenttweaker:coil_v5> * 4,
        <draconicevolution:chaotic_core> * 2,
        <avaritiatweaks:enhancement_crystal> * 1,
    ])
    .addOutputs(<contenttweaker:field_generator_v4> * 2)
    .requireComputationPoint(5000.0F)
    .build();

//工程控制电路（等级 4）
RecipeBuilder.newBuilder("industrial_circuit_v4", "atomic_reconstructor", 600)
    .addEnergyPerTickInput(50000000)
    .addInputs([
        <ore:circuitArk> * 4,
        <ore:ingotInfinity> * 2,
        <ore:plateChaoticMetal> * 2,
        <avaritiatweaks:enhancement_crystal> * 1,
    ])
    .addOutputs(<contenttweaker:industrial_circuit_v4> * 4)
    .requireComputationPoint(1500.0F)
    .build();

//传感器（等级 5）
RecipeBuilder.newBuilder("sensor_v5", "atomic_reconstructor", 600)
    .addEnergyPerTickInput(50000000)
    .addInputs([
        <ore:circuitArk> * 1,
        <contenttweaker:industrial_circuit_v4> * 1,
        <ore:stickWillowalloy> * 2,
        <ore:ingotInfinity> * 1,
        <ebwizardry:astral_diamond> * 1,
    ])
    .addOutputs(<contenttweaker:sensor_v5> * 2)
    .requireComputationPoint(2500.0F)
    .build();

//电动马达（等级 5）
RecipeBuilder.newBuilder("electric_motor_v5", "atomic_reconstructor", 600)
    .addEnergyPerTickInput(50000000)
    .addInputs([
        <contenttweaker:coil_v5> * 2,
        <ore:plateChaoticMetal> * 2,
        <contenttweaker:industrial_circuit_v4> * 1,
        <ore:ingotInfinity> * 1,
    ])
    .addOutputs(<contenttweaker:electric_motor_v5> * 1)
    .requireComputationPoint(2000.0F)
    .build();

//机械臂（等级 5）
RecipeBuilder.newBuilder("robot_arm_v5", "atomic_reconstructor", 600)
    .addEnergyPerTickInput(50000000)
    .addInputs([
        <contenttweaker:electric_motor_v5> * 2,
        <ore:ingotInfinity> * 1,
        <contenttweaker:industrial_circuit_v4> * 1,
    ])
    .addOutputs(<contenttweaker:robot_arm_v5> * 1)
    .requireComputationPoint(2250.0F)
    .build();

//方舟力场控制矩阵
RecipeBuilder.newBuilder("arkforcefieldcontrolblock", "atomic_reconstructor", 1200)
    .addEnergyPerTickInput(100000000)
    .addInput(<ore:ingotArk> * 8)
    .addInput(<contenttweaker:arkmachineblock> * 2)
    .addInput(<contenttweaker:coil_v5> * 12)
    .addInput(<contenttweaker:field_generator_v4> * 12)
    .addInput(<contenttweaker:sensor_v5> * 2)
    .addInput(<contenttweaker:infinity_wire> * 18)
    .addOutput(<contenttweaker:arkforcefieldcontrolblock> * 2)
    .requireComputationPoint(2750.0F)
    .build();

//超量子控制电路
RecipeBuilder.newBuilder("ark_circuit", "atomic_reconstructor", 3600)
    .addEnergyPerTickInput(75000000)
    .addItemInputs([
        <avaritia:resource:5> * 1,
        <contenttweaker:infinity_processor> * 8,
        <ore:ingotArk> * 2,
        <ore:ingotAlloyT2> * 1,
        <appliedenergistics2:material:47> * 2,
    ])
    .addOutput(<additions:novaextended-ark_circuit> * 8)
    .requireComputationPoint(2500.0F)
    .build();

//超级煲
RecipeBuilder.newBuilder("arc_ultimate_stew", "atomic_reconstructor", 1200)
    .addEnergyPerTickInput(100000000)
    .addInput(<liquid:crystalloidneutron> * 20)
    .addInput(<avaritia:ultimate_stew>).setChance(0)
    .addOutput(<avaritia:ultimate_stew>)
    .requireComputationPoint(250.0F)
    .build();

//终望珍珠
RecipeBuilder.newBuilder("arc_endest_pearl", "atomic_reconstructor", 10, 99)
    .addEnergyPerTickInput(175000000)
    .addInput(<minecraft:nether_star> * 1)
    .addInput(<minecraft:ender_eye> * 1)
    .addOutput(<avaritia:endest_pearl> * 1)
    .requireComputationPoint(100.0F)
    .build();

//方舟锭
RecipeBuilder.newBuilder("arc_ark_ingot", "atomic_reconstructor", 6000)
    .addEnergyPerTickInput(45000000)
    .addIngredientArrayInput(
        IngredientArrayBuilder.newBuilder().addIngredients([
            <ore:ingotStellarAlloy>,
            <ore:ingotGelidEnderium>,
            <ore:ingotBoundMetal> * 2,
            <ore:ingotSentientMetal> * 2,
        ])
    )
    .addItemInputs([
        <ore:ingotAdamant>,
        <ore:ingotChaoticMetal>,
        <ore:ingotTerraAlloy>,
        <ore:ingotInfinity>
    ])
    .addOutput(<additions:novaextended-star_ingot> * 2)
    .requireComputationPoint(1000.0F)
    .build();

//紫色异世界水晶碎片
RecipeBuilder.newBuilder("arc_exotic_crystal", "atomic_reconstructor", 600)
    .addEnergyPerTickInput(250000000)
    .addInput(<ore:gemCrystalRed> * 1).setChance(0)
    .addOutput(<contenttweaker:crystalpurple>).setChance(0.01)
    .requireComputationPoint(500.0F)
    .build();

//原子重构机-控制器
RecipeBuilder.newBuilder("controller_arc", "workshop", 9600)
    .addEnergyPerTickInput(256000000)
    .addInputs([
        <contenttweaker:industrial_circuit_v3> * 32,
        <contenttweaker:infinity_processor> * 24,
        <contenttweaker:field_generator_v3> * 16,
        <modularmachinery:blockcasing> * 1,
    ])
    .addOutput(<modularmachinery:atomic_reconstructor_factory_controller>)
    .requireComputationPoint(4200.0F)
    .requireResearch("atomic_reconstructor")
    .build();
