//Recipes By Hikari_Nova.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.MachineModifier;

import novaeng.hypernet.HyperNetHelper;

// HyperNetHelper.proxyMachineForHyperNet("assembly_line");
MachineModifier.setMaxThreads("assembly_line", 4);
MachineModifier.setMaxParallelism("assembly_line", 64);

// 装配线控制器
RecipeBuilder.newBuilder("assembly_line_controller", "machine_arm", 4800)
    .addEnergyPerTickInput(2048000)
    .addInputs([
        <contenttweaker:hypernet_cpu_t2> * 4,
        <contenttweaker:hypernet_ram_t2> * 2,
        <contenttweaker:industrial_circuit_v2> * 16,
        <contenttweaker:robot_arm_v3> * 32,
        <contenttweaker:electric_motor_v3> * 16,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:assembly_line_factory_controller> * 1)
    .requireResearch("assembly_line")
    .build();

var recipeCounter = 0;

//指数级处理器
RecipeBuilder.newBuilder("exponential_level_processor_line", "assembly_line", 300, recipeCounter, false)
    .setAssemblyLineProxied()
    .addEnergyPerTickInput(96000)
    .addInput(<liquid:neutron> * 600)                  .setTag("fluid_input_0") // Fluid
    .addInput(<threng:material:14> * 1)                .setTag("input_0")
    .addInput(<threng:material:14> * 1)                .setTag("input_1")
    .addInput(<contenttweaker:lifesense_processor> * 1).setTag("input_2")
    .addInput(<contenttweaker:lifesense_processor> * 1).setTag("input_3")
    .addInput(<contenttweaker:lifesense_processor> * 1).setTag("input_line_0")
    .addInput(<contenttweaker:lifesense_processor> * 1).setTag("input_line_1")
    .addInput(<ore:ingotCrystalMatrix> * 1)            .setTag("input_line_2")
    .addInput(<ore:ingotCrystalMatrix> * 1)            .setTag("input_line_3")
    .addInput(<ore:plateWillowalloy> * 1)              .setTag("input_line_4")
    .addInput(<ore:plateWillowalloy> * 1)              .setTag("input_line_5")
    .addInput(<ore:plateWillowalloy> * 1)              .setTag("input_line_6")
    .addInput(<ore:plateWillowalloy> * 1)              .setTag("input_line_7")
    .addOutput(<contenttweaker:exponential_level_processor> * 6).setTag("output_line_end")
    .requireComputationPoint(40.0F)
    .convertAssemblyLineRecipeToDefaultRecipeAndRegister("acar")
    .build();
recipeCounter += 1;

//CPU 模块（等级 3）僵尸
RecipeBuilder.newBuilder("cpu_t3_zombie", "assembly_line", 9600, recipeCounter, false)
    .setAssemblyLineProxied()
    .addEnergyPerTickInput(16000000)
    .addGasInput(<gas:nutrientsolution> * 20000)              .setTag("fluid_input_0") // Fluid
    .addInput(<contenttweaker:lifesense_processor> * 1)  .setTag("input_0")
    .addInput(<contenttweaker:lifesense_processor> * 1)  .setTag("input_1")
    .addInput(<contenttweaker:lifesense_processor> * 1)  .setTag("input_2")
    .addInput(<contenttweaker:lifesense_processor> * 1)  .setTag("input_3")
    .addInput(<enderio:item_material:42> * 1)            .setTag("input_line_0")
    .addInput(<deepmoblearning:data_model_zombie> * 1)   .setTag("input_line_1")
    .addInput(<draconicevolution:mob_soul> * 1)          .setTag("input_line_2")
        .setPreViewNBT({display:{Lore:["§a可以是任意生物灵魂。"]}})
    .addInput(<draconicevolution:mob_soul> * 1)          .setTag("input_line_3")
        .setPreViewNBT({display:{Lore:["§a可以是任意生物灵魂。"]}})
    .addInput(<ic2:advanced_heat_vent> * 1)              .setTag("input_line_4")
    .addInput(<ic2:advanced_heat_vent> * 1)              .setTag("input_line_5")
    .addInput(<ic2:advanced_heat_vent> * 1)              .setTag("input_line_6")
    .addInput(<ic2:advanced_heat_vent> * 1)              .setTag("input_line_7")
    .addOutput(<contenttweaker:hypernet_cpu_t3> * 1)     .setTag("output_line_end")
    .requireResearch("cpu_t3")
    .requireComputationPoint(50.0F)
    .convertAssemblyLineRecipeToDefaultRecipeAndRegister("acar")
    .build();
recipeCounter += 1;

//CPU 模块（等级 3）玩家
RecipeBuilder.newBuilder("cpu_t3_player", "assembly_line", 7200, recipeCounter, false)
    .setAssemblyLineProxied()
    .addEnergyPerTickInput(16000000)
    .addGasInput(<gas:nutrientsolution> * 30000)              .setTag("fluid_input_0") // Fluid
    .addInput(<contenttweaker:lifesense_processor> * 1)  .setTag("input_0")
    .addInput(<contenttweaker:lifesense_processor> * 1)  .setTag("input_1")
    .addInput(<contenttweaker:lifesense_processor> * 1)  .setTag("input_2")
    .addInput(<contenttweaker:lifesense_processor> * 1)  .setTag("input_3")
    .addInput(<minecraft:skull:3> * 1)                   .setTag("input_line_0")
        .setPreViewNBT({display:{Lore:["§a可以是任意玩家头颅。"]}})
    .addInput(<minecraft:skull:3> * 1)                   .setTag("input_line_1")
        .setPreViewNBT({display:{Lore:["§a可以是任意玩家头颅。"]}})
    .addInput(<draconicevolution:mob_soul> * 1)          .setTag("input_line_2")
        .setPreViewNBT({display:{Lore:["§a可以是任意生物灵魂。"]}})
    .addInput(<draconicevolution:mob_soul> * 1)          .setTag("input_line_3")
        .setPreViewNBT({display:{Lore:["§a可以是任意生物灵魂。"]}})
    .addInput(<ic2:advanced_heat_vent> * 1)              .setTag("input_line_4")
    .addInput(<ic2:advanced_heat_vent> * 1)              .setTag("input_line_5")
    .addInput(<ic2:advanced_heat_vent> * 1)              .setTag("input_line_6")
    .addInput(<ic2:advanced_heat_vent> * 1)              .setTag("input_line_7")
    .addOutput(<contenttweaker:hypernet_cpu_t3> * 1)     .setTag("output_line_end")
    .requireResearch("cpu_t3")
    .requireComputationPoint(50.0F)
    .convertAssemblyLineRecipeToDefaultRecipeAndRegister("acar")
    .build();
recipeCounter += 1;

//内存模块（等级 3）
RecipeBuilder.newBuilder("ram_t3", "assembly_line", 7200, recipeCounter, false)
    .setAssemblyLineProxied()
    .addEnergyPerTickInput(16000000)
    .addInput(<liquid:gold> * 4320)                            .setTag("fluid_input_0") // Fluid
    .addInput(<appliedenergistics2:material:22> * 32)          .setTag("input_0")
    .addInput(<appliedenergistics2:material:22> * 32)          .setTag("input_1")
    .addInput(<appliedenergistics2:material:22> * 32)          .setTag("input_2")
    .addInput(<appliedenergistics2:material:22> * 32)          .setTag("input_3")
    .addInput(<contenttweaker:exponential_level_processor> * 1).setTag("input_line_0")
    .addInput(<contenttweaker:exponential_level_processor> * 1).setTag("input_line_1")
    .addInput(<ic2:advanced_heat_vent> * 1)                    .setTag("input_line_2")
    .addInput(<ic2:advanced_heat_vent> * 1)                    .setTag("input_line_3")
    .addOutput(<contenttweaker:hypernet_ram_t3> * 1)           .setTag("output_line_end")
    .requireResearch("cpu_t3")
    .requireComputationPoint(50.0F)
    .convertAssemblyLineRecipeToDefaultRecipeAndRegister("acar")
    .build();
recipeCounter += 1;

//GPU 模块（等级 2）
RecipeBuilder.newBuilder("gpu_t2", "assembly_line", 7200, recipeCounter, false)
    .setAssemblyLineProxied()
    .addEnergyPerTickInput(32000000)
    .addInput(<contenttweaker:lifesense_processor> * 1).setTag("input_0")
    .addInput(<contenttweaker:lifesense_processor> * 1).setTag("input_1")
    .addInput(<contenttweaker:lifesense_processor> * 1).setTag("input_2")
    .addInput(<contenttweaker:lifesense_processor> * 1).setTag("input_3")
    .addInput(<contenttweaker:lifesense_processor> * 1).setTag("input_line_0")
    .addInput(<contenttweaker:lifesense_processor> * 1).setTag("input_line_1")
    .addInput(<contenttweaker:lifesense_processor> * 1).setTag("input_line_2")
    .addInput(<contenttweaker:lifesense_processor> * 1).setTag("input_line_3")
    .addInput(<contenttweaker:hypernet_cpu_t3> * 1)    .setTag("input_line_4")
    .addInput(<contenttweaker:hypernet_cpu_t3> * 1)    .setTag("input_line_5")
    .addInput(<contenttweaker:hypernet_ram_t3> * 1)    .setTag("input_line_6")
    .addInput(<contenttweaker:hypernet_ram_t3> * 1)    .setTag("input_line_7")
    .addInput(<mets:advanced_oc_heat_vent> * 1)        .setTag("input_line_8")
    .addInput(<mets:advanced_oc_heat_vent> * 1)        .setTag("input_line_9")
    .addInput(<mets:advanced_heat_vent> * 1)           .setTag("input_line_10")
    .addInput(<mets:advanced_heat_vent> * 1)           .setTag("input_line_11")
    .addOutput(<contenttweaker:hypernet_gpu_t2> * 1)   .setTag("output_line_end")
    .requireResearch("cpu_t3")
    .requireComputationPoint(100.0F)
    .convertAssemblyLineRecipeToDefaultRecipeAndRegister("acar")
    .build();
recipeCounter += 1;

//CPU 模块（等级 4）
RecipeBuilder.newBuilder("cpu_t4", "assembly_line", 9600, recipeCounter, false)
    .setAssemblyLineProxied()
    .addEnergyPerTickInput(128000000)
    .addInput(<liquid:solarium_fluid> * 432)                   .setTag("fluid_input_0") // Fluid
    .addInput(<contenttweaker:exponential_level_processor> * 1).setTag("input_0")
    .addInput(<contenttweaker:exponential_level_processor> * 1).setTag("input_1")
    .addInput(<contenttweaker:exponential_level_processor> * 1).setTag("input_2")
    .addInput(<contenttweaker:exponential_level_processor> * 1).setTag("input_3")
    .addInput(<astralsorcery:itemusabledust> * 64)             .setTag("input_line_0")
    .addInput(<astralsorcery:itemusabledust> * 64)             .setTag("input_line_1")
    .addInput(<astralsorcery:itemusabledust> * 64)             .setTag("input_line_2")
    .addInput(<astralsorcery:itemusabledust> * 64)             .setTag("input_line_3")
    .addInput(<contenttweaker:sensor_v3> * 1)                  .setTag("input_line_4")
    .addInput(<contenttweaker:sensor_v3> * 1)                  .setTag("input_line_5")
    .addInput(<contenttweaker:sensor_v3> * 1)                  .setTag("input_line_6")
    .addInput(<contenttweaker:sensor_v3> * 1)                  .setTag("input_line_7")
    .addInput(<mets:advanced_heat_vent> * 1)                   .setTag("input_line_8")
    .addInput(<mets:advanced_heat_vent> * 1)                   .setTag("input_line_9")
    .addInput(<mets:advanced_heat_vent> * 1)                   .setTag("input_line_10")
    .addInput(<mets:advanced_heat_vent> * 1)                   .setTag("input_line_11")
    .addOutput(<contenttweaker:hypernet_cpu_t4> * 1)           .setTag("output_line_end")
    .requireResearch("cpu_t4")
    .requireComputationPoint(750.0F)
    .convertAssemblyLineRecipeToDefaultRecipeAndRegister("acar")
    .build();
recipeCounter += 1;

//内存模块（等级 4）
RecipeBuilder.newBuilder("ram_t4", "assembly_line", 7200, recipeCounter, false)
    .setAssemblyLineProxied()
    .addEnergyPerTickInput(128000000)
    .addInput(<liquid:gold> * 8640)                            .setTag("fluid_input_0") // Fluid
    .addInput(<appliedenergistics2:material:22> * 64)          .setTag("input_0")
    .addInput(<appliedenergistics2:material:22> * 64)          .setTag("input_1")
    .addInput(<appliedenergistics2:material:22> * 64)          .setTag("input_2")
    .addInput(<appliedenergistics2:material:22> * 64)          .setTag("input_3")
    .addInput(<contenttweaker:exponential_level_processor> * 1).setTag("input_line_0")
    .addInput(<contenttweaker:exponential_level_processor> * 1).setTag("input_line_1")
    .addInput(<contenttweaker:exponential_level_processor> * 1).setTag("input_line_2")
    .addInput(<contenttweaker:exponential_level_processor> * 1).setTag("input_line_3")
    .addInput(<mets:advanced_heat_vent> * 1)                   .setTag("input_line_4")
    .addInput(<mets:advanced_heat_vent> * 1)                   .setTag("input_line_5")
    .addInput(<mets:advanced_heat_vent> * 1)                   .setTag("input_line_6")
    .addInput(<mets:advanced_heat_vent> * 1)                   .setTag("input_line_7")
    .addOutput(<contenttweaker:hypernet_ram_t4> * 1)           .setTag("output_line_end")
    .requireResearch("cpu_t4")
    .requireComputationPoint(750.0F)
    .convertAssemblyLineRecipeToDefaultRecipeAndRegister("acar")
    .build();
recipeCounter += 1;

//GPU 模块（等级 3）
RecipeBuilder.newBuilder("gpu_t3", "assembly_line", 9600, recipeCounter, false)
    .setAssemblyLineProxied()
    .addEnergyPerTickInput(512000000)
    .addInput(<contenttweaker:infinity_processor> * 1).setTag("input_0")
    .addInput(<contenttweaker:infinity_processor> * 1).setTag("input_1")
    .addInput(<contenttweaker:infinity_processor> * 1).setTag("input_2")
    .addInput(<contenttweaker:infinity_processor> * 1).setTag("input_3")
    .addInput(<appliedenergistics2:material:47> * 1)  .setTag("input_line_0")
    .addInput(<contenttweaker:sensor_v4> * 1)         .setTag("input_line_1")
    .addInput(<appliedenergistics2:material:47> * 1)  .setTag("input_line_2")
    .addInput(<contenttweaker:sensor_v4> * 1)         .setTag("input_line_3")
    .addInput(<contenttweaker:infinity_processor> * 1).setTag("input_line_4")
    .addInput(<contenttweaker:infinity_processor> * 1).setTag("input_line_5")
    .addInput(<contenttweaker:infinity_processor> * 1).setTag("input_line_6")
    .addInput(<contenttweaker:infinity_processor> * 1).setTag("input_line_7")
    .addInput(<appliedenergistics2:material:47> * 1)  .setTag("input_line_8")
    .addInput(<contenttweaker:sensor_v4> * 1)         .setTag("input_line_9")
    .addInput(<appliedenergistics2:material:47> * 1)  .setTag("input_line_10")
    .addInput(<contenttweaker:sensor_v4> * 1)         .setTag("input_line_11")
    .addOutput(<contenttweaker:hypernet_gpu_t3> * 1)  .setTag("output_line_end")
    .requireResearch("cpu_t5")
    .requireComputationPoint(2000.0F)
    .convertAssemblyLineRecipeToDefaultRecipeAndRegister("acar")
    .build();
recipeCounter += 1;

//内存模块（等级 5）
RecipeBuilder.newBuilder("ram_t5", "assembly_line", 7200, recipeCounter, false)
    .setAssemblyLineProxied()
    .addEnergyPerTickInput(512000000)
    .addInput(<liquid:gold> * 34560)                  .setTag("fluid_input_0") // Fluid
    .addInput(<appliedenergistics2:material:22> * 64) .setTag("input_0")
    .addInput(<appliedenergistics2:material:22> * 64) .setTag("input_1")
    .addInput(<appliedenergistics2:material:22> * 64) .setTag("input_2")
    .addInput(<appliedenergistics2:material:22> * 64) .setTag("input_3")
    .addInput(<appliedenergistics2:material:22> * 64) .setTag("input_line_0")
    .addInput(<appliedenergistics2:material:22> * 64) .setTag("input_line_1")
    .addInput(<appliedenergistics2:material:22> * 64) .setTag("input_line_2")
    .addInput(<appliedenergistics2:material:22> * 64) .setTag("input_line_3")
    .addInput(<contenttweaker:infinity_processor> * 1).setTag("input_line_4")
    .addInput(<contenttweaker:infinity_processor> * 1).setTag("input_line_5")
    .addInput(<contenttweaker:infinity_processor> * 1).setTag("input_line_6")
    .addInput(<contenttweaker:infinity_processor> * 1).setTag("input_line_7")
    .addInput(<mets:advanced_heat_vent> * 1)          .setTag("input_line_8")
    .addInput(<mets:advanced_heat_vent> * 1)          .setTag("input_line_9")
    .addInput(<mets:advanced_heat_vent> * 1)          .setTag("input_line_10")
    .addInput(<mets:advanced_heat_vent> * 1)          .setTag("input_line_11")
    .addOutput(<contenttweaker:hypernet_ram_t5> * 1)  .setTag("output_line_end")
    .requireResearch("cpu_t5")
    .requireComputationPoint(1500.0F)
    .convertAssemblyLineRecipeToDefaultRecipeAndRegister("acar")
    .build();
recipeCounter += 1;

//力场发生器（等级 2）
RecipeBuilder.newBuilder("field_generator_v2", "assembly_line", 600, recipeCounter, false)
    .setAssemblyLineProxied()
    .addEnergyPerTickInput(4096000)
    .addInput(<ore:circuitExtreme> * 1)                  .setTag("input_0")
    .addInput(<contenttweaker:industrial_circuit_v3> * 1).setTag("input_1")
    .addInput(<contenttweaker:coil_v4> * 1)              .setTag("input_2")
    .addInput(<contenttweaker:coil_v4> * 1)              .setTag("input_3")
    .addInput(<avaritia:endest_pearl> * 1)               .setTag("input_line_0")
    .addOutput(<contenttweaker:field_generator_v2> * 1)  .setTag("output_line_end")
    .requireComputationPoint(190.0F)
    .convertAssemblyLineRecipeToDefaultRecipeAndRegister("acar")
    .build();
recipeCounter += 1;

//落星合金力场控制矩阵
RecipeBuilder.newBuilder("fallenstarforcefieldcontrolblock", "assembly_line", 800, recipeCounter, false)
    .setAssemblyLineProxied()
    .addEnergyPerTickInput(8192000)
    .addInput(<ore:ingotFallenStarAlloy> * 8)                        .setTag("input_0")
    .addInput(<contenttweaker:extrememachineblock> * 2)              .setTag("input_1")
    .addInput(<contenttweaker:coil_v4> * 12)                         .setTag("input_2")
    .addInput(<contenttweaker:field_generator_v2> * 12)              .setTag("input_3")
    .addInput(<contenttweaker:sensor_v3> * 2)                        .setTag("input_line_0")
    .addInput(<gravisuite:crafting:1> * 4)                           .setTag("input_line_1")
    .addOutput(<contenttweaker:fallenstarforcefieldcontrolblock> * 2).setTag("output_line_end")
    .requireComputationPoint(270.0F)
    .convertAssemblyLineRecipeToDefaultRecipeAndRegister("acar")
    .build();
recipeCounter += 1;

//力场发生器（等级 3）
RecipeBuilder.newBuilder("field_generator_v3", "assembly_line", 600, recipeCounter, false)
    .setAssemblyLineProxied()
    .addEnergyPerTickInput(8192000)
    .addInput(<contenttweaker:industrial_circuit_v3> * 1).setTag("input_0")
    .addInput(<contenttweaker:infinity_processor> * 1)   .setTag("input_1")
    .addInput(<contenttweaker:coil_v4> * 1)              .setTag("input_2")
    .addInput(<contenttweaker:coil_v4> * 1)              .setTag("input_3")
    .addInput(<draconicevolution:awakened_core> * 1)     .setTag("input_line_0")
    .addOutput(<contenttweaker:field_generator_v3> * 1)  .setTag("output_line_end")
    .requireResearch("beyond_limits")
    .requireComputationPoint(1500.0F)
    .convertAssemblyLineRecipeToDefaultRecipeAndRegister("acar")
    .build();
recipeCounter += 1;

//寰宇力场控制矩阵
RecipeBuilder.newBuilder("universalforcefieldcontrolblock", "assembly_line", 1200, recipeCounter, false)
    .setAssemblyLineProxied()
    .addEnergyPerTickInput(16384000)
    .addInput(<ore:plateInfinity> * 8)                              .setTag("input_0")
    .addInput(<contenttweaker:extrememachineblock> * 2)             .setTag("input_1")
    .addInput(<contenttweaker:coil_v4> * 12)                        .setTag("input_2")
    .addInput(<contenttweaker:field_generator_v3> * 12)             .setTag("input_3")
    .addInput(<contenttweaker:sensor_v4> * 2)                       .setTag("input_line_0")
    .addInput(<contenttweaker:infinity_wire> * 6)                   .setTag("input_line_1")
    .addOutput(<contenttweaker:universalforcefieldcontrolblock> * 2).setTag("output_line_end")
    .requireResearch("beyond_limits")
    .requireComputationPoint(270.0F)
    .convertAssemblyLineRecipeToDefaultRecipeAndRegister("acar")
    .build();
recipeCounter += 1;

//工程控制电路（等级 3）
RecipeBuilder.newBuilder("industrial_circuit_v3", "assembly_line", 1200, recipeCounter, false)
    .setAssemblyLineProxied()
    .addEnergyPerTickInput(2048000)
    .addInput(<liquid:crystalloidneutron> * 1)                .setTag("fluid_input_0")
    .addInput(<ore:circuitExtreme> * 1)                       .setTag("input_0")
    .addInput(<ore:circuitExtreme> * 1)                       .setTag("input_1")
    .addInput(<ore:circuitExtreme> * 1)                       .setTag("input_2")
    .addInput(<ore:circuitExtreme> * 1)                       .setTag("input_3")
    .addInput(<ore:ingotFallenStarAlloy> * 1)                 .setTag("input_line_0")
    .addInput(<ore:ingotFallenStarAlloy> * 1)                 .setTag("input_line_1")
    .addInput(<ore:plateDraconicMetal> * 1)                   .setTag("input_line_2")
    .addInput(<ore:plateDraconicMetal> * 1)                   .setTag("input_line_3")
    .addInput(<gravisuite:crafting:1> * 4)                    .setTag("input_line_4")
    .addInput(<contenttweaker:carbon_nanotube> * 2)           .setTag("input_line_5")
    .addInput(<gravisuite:crafting:1> * 4)                    .setTag("input_line_6")
    .addInput(<contenttweaker:carbon_nanotube> * 2)           .setTag("input_line_7")
    .addInput(<gravisuite:crafting:1> * 4)                    .setTag("input_line_8")
    .addInput(<contenttweaker:carbon_nanotube> * 2)           .setTag("input_line_9")
    .addInput(<gravisuite:crafting:1> * 4)                    .setTag("input_line_10")
    .addInput(<contenttweaker:carbon_nanotube> * 2)           .setTag("input_line_11")
    .addOutput(<contenttweaker:industrial_circuit_v3> * 4).setTag("output_line_end")
    .requireComputationPoint(120.0F)
    .convertAssemblyLineRecipeToDefaultRecipeAndRegister("acar")
    .build();
recipeCounter += 1;

//传感器（等级 4）
RecipeBuilder.newBuilder("sensor_v4", "assembly_line", 600, recipeCounter, false)
    .setAssemblyLineProxied()
    .addEnergyPerTickInput(1024000)
    .addInput(<contenttweaker:infinity_processor> * 1)   .setTag("input_0")
    .addInput(<contenttweaker:industrial_circuit_v3> * 1).setTag("input_1")
    .addInput(<ore:stickWillowalloy> * 1)                .setTag("input_2")
    .addInput(<ore:stickWillowalloy> * 1)                .setTag("input_3")
    .addInput(<ore:ingotFallenStarAlloy> * 1)            .setTag("input_line_0")
    .addInput(<enderutilities:enderpart:12> * 1)         .setTag("input_line_1")
    .addOutput(<contenttweaker:sensor_v4> * 2)           .setTag("output_line_end")
    .requireResearch("beyond_limits")
    .requireComputationPoint(1250.0F)
    .convertAssemblyLineRecipeToDefaultRecipeAndRegister("acar")
    .build();
recipeCounter += 1;

//电动马达（等级 4）
RecipeBuilder.newBuilder("electric_motor_v4", "assembly_line", 600, recipeCounter, false)
    .setAssemblyLineProxied()
    .addEnergyPerTickInput(1024000)
    .addInput(<contenttweaker:coil_v4> * 1)              .setTag("input_0")
    .addInput(<contenttweaker:coil_v4> * 1)              .setTag("input_1")
    .addInput(<ore:plateDraconicMetal> * 1)              .setTag("input_2")
    .addInput(<ore:plateDraconicMetal> * 1)              .setTag("input_3")
    .addInput(<contenttweaker:industrial_circuit_v3> * 1).setTag("input_line_0")
    .addInput(<ore:ingotFallenStarAlloy> * 1)            .setTag("input_line_1")
    .addOutput(<contenttweaker:electric_motor_v4> * 1)   .setTag("output_line_end")
    .requireResearch("beyond_limits")
    .requireComputationPoint(1000.0F)
    .convertAssemblyLineRecipeToDefaultRecipeAndRegister("acar")
    .build();
recipeCounter += 1;

//工程电池（等级 4）
RecipeBuilder.newBuilder("engineering_battery_v4", "assembly_line", 600, recipeCounter, false)
    .setAssemblyLineProxied()
    .addEnergyPerTickInput(1024000)
    .addInput(<contenttweaker:engineering_battery_v3> * 1) .setTag("input_0")
    .addInput(<ore:ingotFallenStarAlloy> * 1)              .setTag("input_1")
    .addInput(<ore:plateDraconicMetal> * 1)                .setTag("input_2")
    .addInput(<contenttweaker:industrial_circuit_v3> * 1)  .setTag("input_3")
    .addInput(<enderio:item_capacitor_stellar> * 1)        .setTag("input_line_0")
    .addInput(<enderio:item_capacitor_stellar> * 1)        .setTag("input_line_1")
    .addInput(<enderio:item_capacitor_stellar> * 1)        .setTag("input_line_2")
    .addInput(<enderio:item_capacitor_stellar> * 1)        .setTag("input_line_3")
    .addInput(<enderio:item_capacitor_stellar> * 1)        .setTag("input_line_4")
    .addInput(<enderio:item_capacitor_stellar> * 1)        .setTag("input_line_5")
    .addInput(<enderio:item_capacitor_stellar> * 1)        .setTag("input_line_6")
    .addInput(<enderio:item_capacitor_stellar> * 1)        .setTag("input_line_7")
    .addOutput(<contenttweaker:engineering_battery_v4> * 1).setTag("output_line_end")
    .requireComputationPoint(35.0F)
    .convertAssemblyLineRecipeToDefaultRecipeAndRegister("acar")
    .build();
recipeCounter += 1;

//机械臂（等级 4）
RecipeBuilder.newBuilder("robot_arm_v4", "assembly_line", 600, recipeCounter, false)
    .setAssemblyLineProxied()
    .addEnergyPerTickInput(1024000)
    .addInput(<contenttweaker:electric_motor_v4> * 1)    .setTag("input_0")
    .addInput(<contenttweaker:electric_motor_v4> * 1)    .setTag("input_1")
    .addInput(<ore:ingotFallenStarAlloy> * 1)            .setTag("input_2")
    .addInput(<contenttweaker:industrial_circuit_v3> * 1).setTag("input_3")
    .addOutput(<contenttweaker:robot_arm_v4> * 1)        .setTag("output_line_end")
    .requireResearch("beyond_limits")
    .requireComputationPoint(1150.0F)
    .convertAssemblyLineRecipeToDefaultRecipeAndRegister("acar")
    .build();
recipeCounter += 1;

//究极控制电路
RecipeBuilder.newBuilder("circuitEx", "assembly_line", 1200, recipeCounter, false)
    .setAssemblyLineProxied()
    .addEnergyPerTickInput(512000)
    .addInput(<liquid:crystalloid> * 200)                  .setTag("fluid_input_0")
    .addInput(<liquid:terrasteel> * 288)                   .setTag("fluid_input_1")
    .addInput(<liquid:energetic_metal> * 1152)             .setTag("fluid_input_2")
    .addInput(<liquid:signalum> * 2304)                    .setTag("fluid_input_3")
    .addInput(<contenttweaker:industrial_circuit_v2>)      .setTag("input_0")
    .addInput(<contenttweaker:industrial_circuit_v2>)      .setTag("input_1")
    .addInput(<contenttweaker:exponential_level_processor>).setTag("input_2")
    .addInput(<contenttweaker:exponential_level_processor>).setTag("input_3")
    // .addInput(<ore:crystalKyronite> * 4)                   .setTag("input_line_0")
    // .addInput(<ore:crystalPladium> * 8)                    .setTag("input_line_1")
    .addInput(<ore:plateDraconicMetal> * 1)                .setTag("input_line_0")
    .addInput(<ore:plateDraconicMetal> * 1)                .setTag("input_line_1")
    .addInput(<ore:plateDraconicMetal> * 1)                .setTag("input_line_2")
    .addInput(<ore:plateDraconicMetal> * 1)                .setTag("input_line_3")
    .addOutput(<additions:novaextended-extremecircuit> * 4).setTag("output_line_end")
    .requireComputationPoint(100.0F)
    .convertAssemblyLineRecipeToDefaultRecipeAndRegister("acar")
    .build();
recipeCounter += 1;

//无限处理器
RecipeBuilder.newBuilder("infinity_processor", "assembly_line", 1200, recipeCounter, false)
    .setAssemblyLineProxied()
    .addEnergyPerTickInput(512000)
    .addInput(<liquid:steady_ultra_dense_atomic_matter> * 880).setTag("fluid_input_0")
    .addInput(<ore:circuitExtreme> * 1)                       .setTag("input_0")
    .addInput(<ore:circuitExtreme> * 1)                       .setTag("input_1")
    .addInput(<ore:circuitExtreme> * 1)                       .setTag("input_2")
    .addInput(<ore:circuitExtreme> * 1)                       .setTag("input_3")
    // .addInput(<ore:crystalLonsdaleite> * 4)                   .setTag("input_line_0")
    // .addInput(<ore:crystalIonite> * 8)                        .setTag("input_line_1")
    .addInput(<avaritiatweaks:enhancement_crystal> * 1)       .setTag("input_line_0")
    .addInput(<custommc:item170> * 1)                         .setTag("input_line_1")
    .addOutput(<contenttweaker:infinity_processor> * 4)       .setTag("output_line_end")
    .requireResearch("beyond_limits")
    .requireComputationPoint(800.0F)
    .convertAssemblyLineRecipeToDefaultRecipeAndRegister("acar")
    .build();
recipeCounter += 1;
