//Recipes By Hikari_Nova.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import crafttweaker.item.IItemStack;
import crafttweaker.item.IIngredient;
import crafttweaker.liquid.ILiquidStack;
import crafttweaker.data.IData;

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.RecipeCheckEvent;
import mods.modularmachinery.FactoryRecipeStartEvent;
import mods.modularmachinery.FactoryRecipeTickEvent;
import mods.modularmachinery.FactoryRecipeFinishEvent;
import mods.modularmachinery.RecipeModifier;
import mods.modularmachinery.RecipeModifierBuilder;

import mods.modularmachinery.MMEvents;
import mods.modularmachinery.ControllerGUIRenderEvent;

import mods.modularmachinery.IMachineController;
import mods.modularmachinery.SmartInterfaceData;
import mods.modularmachinery.MachineModifier;
import mods.modularmachinery.SmartInterfaceType;
import mods.modularmachinery.FactoryRecipeThread;

import novaeng.hypernet.HyperNetHelper;

// 小型钢矿钻增幅
val smallOreDrillTuningModifier as RecipeModifier[] = [
    RecipeModifierBuilder.create("modularmachinery:duration", "input", 0.25F, 1, false).build(),
    RecipeModifierBuilder.create("modularmachinery:energy", "input", 4, 1, false).build(),
];

// 矿物提取机增幅
val mineralExtractorModifier as RecipeModifier[] = [
    RecipeModifierBuilder.create("modularmachinery:duration", "input", 0.025F, 1, false).build(),
    RecipeModifierBuilder.create("modularmachinery:item", "output", 0.15F, 0, true).build(),
];

//==============================矿物提取机/小型钢矿钻/泰拉钢矿钻==============================
//小型钢矿钻
HyperNetHelper.proxyMachineForHyperNet("small_ore_drill");
MachineModifier.setMaxThreads("small_ore_drill", 2);
RecipeBuilder.newBuilder("small_ore_drill_1", "small_ore_drill", 800)
    .addEnergyPerTickInput(512)
    .addCatalystInput(<thermalinnovation:drill:4>,
        ["谐振钻头可以增强小型钢矿钻的强度。", "工作时间 §ax0.25§f，能量消耗 §cx4"],
        smallOreDrillTuningModifier).setChance(0)
    .addInput(<contenttweaker:programming_circuit_a>).setChance(0)
    .addOutput(<minecraft:iron_ore> * 3).setChance(0.16)
    .addOutput(<minecraft:gold_ore> * 2).setChance(0.09)
    .addOutput(<minecraft:lapis_ore> * 2).setChance(0.13)
    .addOutput(<minecraft:coal_ore> * 4).setChance(0.21)
    .addOutput(<minecraft:redstone_ore> * 3).setChance(0.16)
    .addOutput(<minecraft:diamond_ore> * 2).setChance(0.06)
    .addOutput(<minecraft:emerald_ore> * 2).setChance(0.06)
    .addOutput(<nuclearcraft:ore:4> * 3).setChance(0.15)
    .addOutput(<mets:titanium_ore> * 2).setChance(0.08)
    .addOutput(<mets:niobium_ore>).setChance(0.10)
    .addOutput(<draconicevolution:draconium_ore> * 2).setChance(0.08)
    .addOutput(<environmentaltech:litherite_crystal> * 2).setChance(0.08)
    .setMaxThreads(1)
    .requireComputationPoint(0.25F)
    .build();

//小型钢矿钻
RecipeBuilder.newBuilder("small_ore_drill_2", "small_ore_drill", 600)
    .addEnergyPerTickInput(1024)
    .addCatalystInput(<thermalinnovation:drill:4>,
        ["谐振钻头可以增强小型钢矿钻的强度。", "工作时间 §ax0.25§f，能量消耗 §cx4"],
        smallOreDrillTuningModifier).setChance(0)
    .addInput(<contenttweaker:programming_circuit_b>).setChance(0)
    .addOutput(<thermalfoundation:ore> * 3).setChance(0.2)
    .addOutput(<thermalfoundation:ore:1> * 3).setChance(0.15)
    .addOutput(<thermalfoundation:ore:2> * 2).setChance(0.09)
    .addOutput(<thermalfoundation:ore:3> * 2).setChance(0.10)
    .addOutput(<thermalfoundation:ore:4> * 2).setChance(0.10)
    .addOutput(<thermalfoundation:ore:5> * 2).setChance(0.06)
    .addOutput(<thermalfoundation:ore:6> * 1).setChance(0.04)
    .addOutput(<thermalfoundation:ore:7> * 1).setChance(0.03)
    .addOutput(<nuclearcraft:ore:4> * 3).setChance(0.15)
    .addOutput(<mets:titanium_ore> * 2).setChance(0.08)
    .addOutput(<mets:niobium_ore>).setChance(0.10)
    .addOutput(<environmentaltech:litherite_crystal> * 2).setChance(0.08)
    .setMaxThreads(1)
    .requireComputationPoint(0.25F)
    .build();

# 矿物提取机控制器
RecipeBuilder.newBuilder("mineral_extractor_controller", "mach_crafter", 1200)
    .addEnergyPerTickInput(4096)
    .addInputs([
        <contenttweaker:industrial_circuit_v1> * 24,
        <contenttweaker:sensor_v1> * 4,
        <environmentaltech:laser_core> * 2,
        <mekanism:machineblock2:13> * 2,
        <mets:diamond_lens> * 2,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:mineral_extractor_factory_controller>)
    .requireResearch("mineral_extractor")
    .build();

//矿物提取机-定向-核电工艺
HyperNetHelper.proxyMachineForHyperNet("mineral_extractor");
MachineModifier.setMaxThreads("mineral_extractor", 5);
RecipeBuilder.newBuilder("mineral_extractor_nc", "mineral_extractor", 800)
    .addEnergyPerTickInput(51200)
    .addCatalystInput(<ore:itemPulsatingPowder>,
        ["充能水晶粉可以增强矿物提取机的瞬时激光强度。", "工作时间 §ax0.025§f，所有矿物产出概率 §a+15%§f。"],
        mineralExtractorModifier
    ).setChance(0.15F)
    .addInput(<contenttweaker:programming_circuit_a>).setChance(0)
    .addOutput(<nuclearcraft:ore:3> * 3).setChance(0.15)
    .addOutput(<nuclearcraft:ore:4> * 3).setChance(0.20)
    .addOutput(<nuclearcraft:ore:5> * 3).setChance(0.20)
    .addOutput(<nuclearcraft:ore:6> * 3).setChance(0.20)
    .addOutput(<nuclearcraft:ore:7> * 3).setChance(0.20)
    .requireComputationPoint(1.5F)
    .setMaxThreads(1)
    .build();

//矿物提取机-定向-铁铜锡
RecipeBuilder.newBuilder("mineral_extractor_1", "mineral_extractor", 600)
    .addEnergyPerTickInput(76800)
    .addCatalystInput(<ore:itemPulsatingPowder>,
        ["充能水晶粉可以增强矿物提取机的瞬时激光强度。", "工作时间 §ax0.025§f，所有矿物产出概率 §a+15%§f。"],
        mineralExtractorModifier
    ).setChance(0.15F)
    .addInput(<contenttweaker:programming_circuit_b>).setChance(0)
    .addOutput(<minecraft:iron_ore> * 2).setChance(0.33)
    .addOutput(<ic2:resource:1> * 2).setChance(0.33)
    .addOutput(<ic2:resource:2> * 2).setChance(0.33)
    .requireComputationPoint(1.5F)
    .setMaxThreads(1)
    .build();

//矿物提取机-定向-金银红石青金石铀铅
RecipeBuilder.newBuilder("mineral_extractor_2", "mineral_extractor", 800)
    .addEnergyPerTickInput(51200)
    .addCatalystInput(<ore:itemPulsatingPowder>,
        ["充能水晶粉可以增强矿物提取机的瞬时激光强度。", "工作时间 §ax0.025§f，所有矿物产出概率 §a+15%§f。"],
        mineralExtractorModifier
    ).setChance(0.15F)
    .addInput(<contenttweaker:programming_circuit_c>).setChance(0)
    .addOutput(<minecraft:gold_ore> * 3).setChance(0.06)
    .addOutput(<minecraft:lapis_ore> * 3).setChance(0.14)
    .addOutput(<minecraft:redstone_ore> * 3).setChance(0.18)
    .addOutput(<thermalfoundation:ore:2> * 3).setChance(0.08)
    .addOutput(<nuclearcraft:ore:2> * 3).setChance(0.12)
    .addOutput(<nuclearcraft:ore:4> * 3).setChance(0.08)
    .requireComputationPoint(1.5F)
    .setMaxThreads(1)
    .build();

//矿物提取机-定向-钻石绿宝石钛镍空间碎片
RecipeBuilder.newBuilder("mineral_extractor_3", "mineral_extractor", 1000)
    .addEnergyPerTickInput(76800)
    .addCatalystInput(<ore:itemPulsatingPowder>,
        ["充能水晶粉可以增强矿物提取机的瞬时激光强度。", "工作时间 §ax0.025§f，所有矿物产出概率 §a+15%§f。"],
        mineralExtractorModifier
    ).setChance(0.15F)
    .addInput(<contenttweaker:programming_circuit_d>).setChance(0)
    .addOutput(<minecraft:diamond_ore> * 3).setChance(0.25)
    .addOutput(<minecraft:emerald_ore> * 2).setChance(0.20)
    .addOutput(<mets:titanium_ore> * 2).setChance(0.15)
    .addOutput(<thermalfoundation:ore> * 3).setChance(0.20)
    .requireComputationPoint(1.5F)
    .setMaxThreads(1)
    .build();

//矿物提取机-定向-铌铱铂龙柳钢环境科技水晶
RecipeBuilder.newBuilder("mineral_extractor_4", "mineral_extractor", 800)
    .addEnergyPerTickInput(102400)
    .addCatalystInput(<ore:itemPulsatingPowder>,
        ["充能水晶粉可以增强矿物提取机的瞬时激光强度。", "工作时间 §ax0.025§f，所有矿物产出概率 §a+15%§f。"],
        mineralExtractorModifier
    ).setChance(0.15F)
    .addInput(<contenttweaker:programming_circuit_e>).setChance(0)
    .addOutput(<mets:niobium_ore>).setChance(0.10)
    .addOutput(<thermalfoundation:ore:6> * 1).setChance(0.15)
    .addOutput(<thermalfoundation:ore:7> * 1).setChance(0.15)
    .addOutput(<draconicevolution:draconium_ore> * 2).setChance(0.2)
    .addOutput(<additions:novaextended-ore8> * 1).setChance(0.05)
    .addOutput(<environmentaltech:litherite_crystal> * 4).setChance(0.10)
    .addOutput(<environmentaltech:erodium_crystal> * 2).setChance(0.05)
    .addOutput(<environmentaltech:kyronite_crystal> * 2).setChance(0.05)
    .requireComputationPoint(1.5F)
    .setMaxThreads(1)
    .build();

//泰拉钢矿钻-控制器
// RecipeBuilder.newBuilder("mana_ore_drill_controller", "machine_arm", 1600)
//     .addEnergyPerTickInput(80000)
//     .addInput(<contenttweaker:field_generator_v1> * 16)
//     .addInput(<ore:ingotElvenElementium> * 32)
//     .addInput(<ore:elvenPixieDust> * 32)
//     .addInput(<botania:terrapick>)
//     .addOutput(<modularmachinery:mana_ore_drill_factory_controller>)
//     .build();

//泰拉钢矿钻
MachineModifier.setMaxThreads("mana_ore_drill", 3);
RecipeBuilder.newBuilder("mana_ore_drill_1", "mana_ore_drill", 200)
    .addInputs(<liquid:fluidedmana> * 50)
    .addInput(<contenttweaker:programming_circuit_a>).setChance(0)
    .addOutput(<thermalfoundation:ore> * 3).setChance(0.15)
    .addOutput(<thermalfoundation:ore:1> * 3).setChance(0.15)
    .addOutput(<thermalfoundation:ore:2> * 2).setChance(0.15)
    .addOutput(<thermalfoundation:ore:3> * 2).setChance(0.13)
    .addOutput(<thermalfoundation:ore:4> * 2).setChance(0.11)
    .addOutput(<thermalfoundation:ore:5> * 2).setChance(0.1)
    .addOutput(<minecraft:iron_ore> * 8).setChance(0.15)
    .addOutput(<minecraft:gold_ore> * 6).setChance(0.15)
    .addOutput(<minecraft:lapis_ore> * 5).setChance(0.1)
    .addOutput(<minecraft:redstone_ore> * 6).setChance(0.1)
    .setMaxThreads(1)
    .build();

//泰拉钢矿钻
RecipeBuilder.newBuilder("mana_ore_drill_2", "mana_ore_drill", 200)
    .addInputs(<liquid:fluidedmana> * 50)
    .addInput(<contenttweaker:programming_circuit_b>).setChance(0)
    .addOutput(<thermalfoundation:ore:6> * 1).setChance(0.12)
    .addOutput(<thermalfoundation:ore:7> * 1).setChance(0.1)
    .addOutput(<minecraft:diamond_ore> * 6).setChance(0.15)
    .addOutput(<minecraft:emerald_ore> * 4).setChance(0.15)
    .addOutput(<mets:titanium_ore> * 4).setChance(0.15)
    .addOutput(<mets:niobium_ore> * 2).setChance(0.15)
    .addOutput(<additions:novaextended-ore8>).setChance(0.1)
    .addOutput(<environmentaltech:litherite_crystal> * 6).setChance(0.15)
    .addOutput(<environmentaltech:erodium_crystal> * 4).setChance(0.15)
    .addOutput(<environmentaltech:kyronite_crystal> * 4).setChance(0.15)
    .addOutput(<environmentaltech:pladium_crystal> * 2).setChance(0.1)
    .setMaxThreads(1)
    .build();

//泰拉钢矿钻-定向-核电工艺
RecipeBuilder.newBuilder("mana_ore_drill_3", "mana_ore_drill", 300)
    .addInputs(<liquid:fluidedmana> * 75)
    .addInput(<contenttweaker:programming_circuit_c>).setChance(0)
    .addOutput(<nuclearcraft:ore:3> * 8).setChance(0.2)
    .addOutput(<nuclearcraft:ore:4> * 8).setChance(0.3)
    .addOutput(<nuclearcraft:ore:5> * 8).setChance(0.3)
    .addOutput(<nuclearcraft:ore:6> * 8).setChance(0.3)
    .addOutput(<nuclearcraft:ore:7> * 8).setChance(0.3)
    .setMaxThreads(1)
    .build();

//奥利哈刚矿钻
MachineModifier.setMaxThreads("orichalcos_drill", 4);

# 控制器
RecipeBuilder.newBuilder("orichalcos_drill_controller", "workshop", 1600)
    .addEnergyPerTickInput(80000)
    .addInput(<botania:terrapick>).setNBTChecker(function(ctrl as IMachineController, item as IItemStack) {
        val mana = D(item.tag).getInt("mana", 0);
        return mana >= 1000000000;
    })
    .setPreViewNBT({
        mana: 1000000000,
        display: {
            Lore:["§e泰拉粉碎者内部存储的 Mana 需要大于 1,000,000,000。"]
        }
    })
    .addInputs([
        <contenttweaker:industrial_circuit_v3> * 24,
        <contenttweaker:sensor_v3> * 24,
        <contenttweaker:field_generator_v2> * 16,
    ])
    .addInput(<modularmachinery:mana_ore_drill_factory_controller>)
    .addOutput(<modularmachinery:orichalcos_drill_factory_controller>)
    .requireComputationPoint(550.0F)
    .requireResearch("orichalcos_drill")
    .build();

RecipeBuilder.newBuilder("orichalcos_drill_1", "orichalcos_drill", 100)
    .addInputs(<liquid:fluidedmana> * 25)
    .addInput(<contenttweaker:programming_circuit_a>).setChance(0)
    .addOutput(<thermalfoundation:ore> * 3).setChance(0.25)
    .addOutput(<thermalfoundation:ore:1> * 3).setChance(0.25)
    .addOutput(<thermalfoundation:ore:2> * 2).setChance(0.25)
    .addOutput(<thermalfoundation:ore:3> * 2).setChance(0.23)
    .addOutput(<thermalfoundation:ore:4> * 2).setChance(0.21)
    .addOutput(<thermalfoundation:ore:5> * 2).setChance(0.2)
    .addOutput(<minecraft:iron_ore> * 8).setChance(0.25)
    .addOutput(<minecraft:gold_ore> * 6).setChance(0.25)
    .addOutput(<minecraft:lapis_ore> * 5).setChance(0.2)
    .addOutput(<minecraft:redstone_ore> * 6).setChance(0.2)
    .setMaxThreads(1)
    .build();

//奥利哈刚矿钻
RecipeBuilder.newBuilder("orichalcos_drill_2", "orichalcos_drill", 100)
    .addInputs(<liquid:fluidedmana> * 25)
    .addInput(<contenttweaker:programming_circuit_b>).setChance(0)
    .addOutput(<thermalfoundation:ore:6> * 1).setChance(0.17)
    .addOutput(<thermalfoundation:ore:7> * 1).setChance(0.15)
    .addOutput(<minecraft:diamond_ore> * 6).setChance(0.2)
    .addOutput(<minecraft:emerald_ore> * 4).setChance(0.2)
    .addOutput(<mets:titanium_ore> * 4).setChance(0.2)
    .addOutput(<mets:niobium_ore> * 2).setChance(0.2)
    .addOutput(<additions:novaextended-ore8>).setChance(0.15)
    .setMaxThreads(1)
    .build();

//奥利哈刚矿钻-定向-核电工艺
RecipeBuilder.newBuilder("orichalcos_drill_3", "orichalcos_drill", 150)
    .addInputs(<liquid:fluidedmana> * 20)
    .addInput(<contenttweaker:programming_circuit_c>).setChance(0)
    .addOutput(<nuclearcraft:ore:3> * 8).setChance(0.4)
    .addOutput(<nuclearcraft:ore:4> * 8).setChance(0.5)
    .addOutput(<nuclearcraft:ore:5> * 8).setChance(0.5)
    .addOutput(<nuclearcraft:ore:6> * 8).setChance(0.5)
    .addOutput(<nuclearcraft:ore:7> * 8).setChance(0.5)
    .setMaxThreads(1)
    .build();

//奥利哈刚矿钻-定向-维度矿石
RecipeBuilder.newBuilder("orichalcos_drill_4", "orichalcos_drill", 150)
    .addInputs(<liquid:fluidedmana> * 20)
    .addInput(<contenttweaker:programming_circuit_d>).setChance(0)
    .addOutput(<tconstruct:ore:0> * 5).setChance(0.15)
    .addOutput(<tconstruct:ore:1> * 5).setChance(0.15)
    .addOutput(<draconicevolution:draconium_ore:2> * 4).setChance(0.2)
    .addOutput(<rftools:dimensional_shard_ore:2> * 4).setChance(0.2)
    .addOutput(<environmentaltech:litherite_crystal> * 8).setChance(0.2)
    .addOutput(<environmentaltech:erodium_crystal> * 6).setChance(0.15)
    .addOutput(<environmentaltech:kyronite_crystal> * 6).setChance(0.15)
    .addOutput(<environmentaltech:pladium_crystal> * 4).setChance(0.1)
    .addOutput(<environmentaltech:ionite_crystal> * 2).setChance(0.1)
    .setMaxThreads(1)
    .build();
