//Recipes By Hikari_Nova.
//Model by ModularTech Odyssey: XZ_xiaoyu_XY
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.MachineModifier;
import mods.modularmachinery.FactoryRecipeThread;

import novaeng.hypernet.HyperNetHelper;

//==============================集成式处理车间==============================
HyperNetHelper.proxyMachineForHyperNet("workshop");
// 工厂线程数设置
MachineModifier.setMaxThreads("workshop", 0);

val drone0 = FactoryRecipeThread.createCoreThread("车间无人机 #0");
val drone1 = FactoryRecipeThread.createCoreThread("车间无人机 #1");
val drone2 = FactoryRecipeThread.createCoreThread("车间无人机 #2");
val drone3 = FactoryRecipeThread.createCoreThread("车间无人机 #3");

MachineModifier.addCoreThread("workshop", drone0);
MachineModifier.addCoreThread("workshop", drone1);
MachineModifier.addCoreThread("workshop", drone2);
MachineModifier.addCoreThread("workshop", drone3);

RecipeBuilder.newBuilder("workshop_controller", "machine_arm", 4800)
    .addEnergyPerTickInput(2048000)
    .addInputs([
        <contenttweaker:hypernet_cpu_t2> * 8,
        <contenttweaker:hypernet_ram_t2> * 6,
        <contenttweaker:industrial_circuit_v2> * 16,
        <contenttweaker:exponential_level_processor> * 24,
        <contenttweaker:robot_arm_v3> * 48,
        <contenttweaker:electric_motor_v3> * 16,
        <appliedenergistics2:material:41> * 8,
        <enderio:item_material:44> * 4,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:workshop_factory_controller> * 1)
    .requireResearch("assembly_line")
    .build();

var recipeCounter = 0;

// 托卡马克聚变反应堆
RecipeBuilder.newBuilder("tokmak_reactor_controller", "workshop", 7200, recipeCounter, false)
    .addEnergyPerTickInput(4096000)
    .addInputs([
        <contenttweaker:industrial_circuit_v3> * 32,
        <contenttweaker:field_generator_v1> * 48,
        <contenttweaker:coil_v3> * 64,
        <contenttweaker:coil_v3> * 64,
        <contenttweaker:coil_v4> * 48,
        <mekanismgenerators:reactor> * 1,
    ])
    .addOutputs(<modularmachinery:tokmak_reactor_controller> * 1)
    .requireComputationPoint(150.0F)
    .requireResearch("tokmak_reactor")
    .build();
recipeCounter += 1;

// HyperNet 计算网络中心（等级 3）
RecipeBuilder.newBuilder("computation_center_t3_controller", "workshop", 7200, recipeCounter, false)
    .addEnergyPerTickInput(6144000)
    .addInputs([
        <contenttweaker:industrial_circuit_v3> * 32,
        <contenttweaker:sensor_v3> * 24,
        <contenttweaker:hypernet_cpu_t3> * 8,
        <contenttweaker:hypernet_ram_t3> * 16,
        <fluxnetworks:fluxcore> * 64,
        <fluxnetworks:fluxcore> * 64,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:computation_center_t3_factory_controller> * 1)
    .requireComputationPoint(350.0F)
    .requireResearch("cpu_t3")
    .build();
recipeCounter += 1;

// HyperNet 液冷数据处理计算机（等级 3）
RecipeBuilder.newBuilder("data_processor_t3_controller", "workshop", 7200, recipeCounter, false)
    .addEnergyPerTickInput(6144000)
    .addInputs([
        <liquid:cryotheum> * 64000,
        <contenttweaker:industrial_circuit_v3> * 32,
        <contenttweaker:hypernet_cpu_t3> * 8,
        <contenttweaker:hypernet_ram_t3> * 16,
        <fluxnetworks:fluxcore> * 64,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:data_processor_t3_factory_controller> * 1)
    .requireComputationPoint(250.0F)
    .requireResearch("cpu_t3")
    .build();
recipeCounter += 1;

// HyperNet 数据处理矩阵塔（等级 4）
RecipeBuilder.newBuilder("data_processor_t4_controller", "workshop", 7200, recipeCounter, false)
    .addEnergyPerTickInput(409600000)
    .addInputs([
        <liquid:cryotheum> * 128000,
        <contenttweaker:industrial_circuit_v3> * 16,
        <contenttweaker:infinity_processor> * 12,
        <contenttweaker:hypernet_cpu_t4> * 8,
        <contenttweaker:hypernet_ram_t4> * 16,
        <fluxnetworks:fluxcore> * 64,
        <fluxnetworks:fluxcore> * 64,
        <ore:blockCrystalMatrix> * 16,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:data_processor_t4_factory_controller> * 1)
    .requireComputationPoint(2000.0F)
    .requireResearch("cpu_t4")
    .build();
recipeCounter += 1;

// ECO-T7
RecipeBuilder.newBuilder("eco_t7_controller", "workshop", 7200, recipeCounter, false)
    .addEnergyPerTickInput(10240000)
    .addInputs([
        <contenttweaker:industrial_circuit_v3> * 12,
        <contenttweaker:field_generator_v2> * 4,
        <ore:ingotTerraAlloy> * 4,
        <extrabotany:quantummanabuffer> * 2,
        <ore:blockCrystalMatrix> * 6,
        <botania:pool:3> * 6,
        <modularmachinery:mana_collector_controller>,
    ])
    .addOutputs(<modularmachinery:eco-t7_controller> * 1)
    .requireComputationPoint(650.0F)
    .requireResearch("eco_t7")
    .build();
recipeCounter += 1;

// HyperNet 进阶研究站（等级 3）
RecipeBuilder.newBuilder("research_station_t3_controller", "workshop", 7200, recipeCounter, false)
    .addEnergyPerTickInput(204800000)
    .addInputs([
        <contenttweaker:hypernet_cpu_t3> * 6,
        <contenttweaker:hypernet_ram_t3> * 12,
        <contenttweaker:industrial_circuit_v3> * 24,
        <contenttweaker:field_generator_v3> * 8,
        <draconicevolution:reactor_component:0> * 8,
        <modularmachinery:research_station_t2_factory_controller> * 1,
    ])
    .addOutputs(<modularmachinery:research_station_t3_factory_controller> * 1)
    .requireResearch("beyond_limits")
    .build();
recipeCounter += 1;

// 永恒再生机
RecipeBuilder.newBuilder("regeneration_machine_controller", "workshop", 7200, recipeCounter, false)
    .addEnergyPerTickInput(819200000)
    .addInputs([
        <contenttweaker:industrial_circuit_v4> * 24,
        <contenttweaker:coil_v5> * 24,
        <contenttweaker:sensor_v5> * 6,
        <contenttweaker:antimatter_core> * 2,
        <ore:blockInfinity> * 4,
        <modularmachinery:cnrc_factory_controller>,
    ])
    .addOutputs(<modularmachinery:regeneration_machine_controller> * 1)
    .requireComputationPoint(12000.0F)
    .requireResearch("regeneration_machine")
    .build();
recipeCounter += 1;

// 地心钻探机
RecipeBuilder.newBuilder("geocentric_drill_controller", "workshop", 7200, recipeCounter, false)
    .addEnergyPerTickInput(102400000)
    .addInputs([
        <liquid:crystalloid> * 7680,
        <mets:nano_living_metal> * 384,
        <ore:crystalPladium> * 192,
        <ore:crystalIonite> * 96,
        <contenttweaker:industrial_circuit_v3> * 16,
        <contenttweaker:sensor_v3> * 24,
        <contenttweaker:robot_arm_v4> * 16,
        <contenttweaker:field_generator_v2> * 6,
        <contenttweaker:hypernet_cpu_t3> * 6,
        <contenttweaker:hypernet_ram_t3> * 24,
        <custommc:item170> * 24,
        <modularmachinery:orichalcos_drill_factory_controller>,
        <modularmachinery:mineralis_ritual_controller>,
    ])
    .addOutputs(<novaeng_core:geocentric_drill_controller> * 1)
    .requireComputationPoint(2400.0F)
    .requireResearch("secrets_of_the_planetary_depths")
    .build();
recipeCounter += 1;
