//Recipes By Hikari_Nova.
//Model by ModularTech Odyssey: shadow_zl
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.MachineModifier;
import mods.modularmachinery.RecipeAdapterBuilder;
import mods.modularmachinery.RecipeModifierBuilder;

import novaeng.hypernet.HyperNetHelper;

//==============================数控锻压机床==============================
// 并行线程数设置
MachineModifier.setInternalParallelism("numerical_control_machine",16);
MachineModifier.setMaxParallelism("numerical_control_machine",512);

HyperNetHelper.proxyMachineForHyperNet("numerical_control_machine");

// 数控锻压机床
RecipeBuilder.newBuilder("numerical_control_machine_controller", "machine_arm", 800)
    .addEnergyPerTickInput(96000)
    .addInputs([
        <contenttweaker:hypernet_cpu_t2> * 1,
        <ore:actuator> * 32,
        <contenttweaker:electric_motor_v2> * 24,
        <nuclearcraft:pressurizer> * 6,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:numerical_control_machine_controller> * 1)
    .requireResearch("numerical_control_machine")
    .build();

// 数控锻压机床：配方继承
# 水冷
RecipeAdapterBuilder.create("numerical_control_machine", "nuclearcraft:pressurizer")
    .addModifier(RecipeModifierBuilder.create("modularmachinery:duration", "input", 0.025F, 1, false).build())
    .addModifier(RecipeModifierBuilder.create("modularmachinery:energy",   "input", 250,    1, false).build())
    .addFluidPerTickInput(<liquid:water> * 30)
    .addFluidPerTickOutput(<liquid:steam> * 30)
    .requireComputationPoint(0.25F)
    .build();

# 冷却液冷
RecipeAdapterBuilder.create("numerical_control_machine", "nuclearcraft:pressurizer")
    .addModifier(RecipeModifierBuilder.create("modularmachinery:duration", "input", 0.0125F, 1, false).build())
    .addModifier(RecipeModifierBuilder.create("modularmachinery:energy",   "input", 125,     1, false).build())
    .addFluidPerTickInput(<liquid:ic2coolant> * 3)
    .addFluidPerTickOutput(<liquid:ic2hot_coolant> * 3)
    .requireComputationPoint(0.25F)
    .build();

var recipeCounter = 1000;

// 合金线圈（等级 3）
RecipeBuilder.newBuilder("coil_v3_water", "numerical_control_machine", 60, recipeCounter, false)
    .addEnergyPerTickInput(128000)
    .addInput(<ore:plateDraconicMetal> * 1)
    .addOutput(<contenttweaker:coil_v3> * 3)
    .addFluidPerTickInput(<liquid:water> * 30)
    .addFluidPerTickOutput(<liquid:steam> * 30)
    .requireComputationPoint(0.25F)
    .build();
recipeCounter += 1;

// 合金线圈（等级 3）
RecipeBuilder.newBuilder("coil_v3_coolant", "numerical_control_machine", 30, recipeCounter, false)
    .addEnergyPerTickInput(64000)
    .addInput(<ore:plateDraconicMetal> * 1)
    .addOutput(<contenttweaker:coil_v3> * 3)
    .addFluidPerTickInput(<liquid:ic2coolant> * 3)
    .addFluidPerTickOutput(<liquid:ic2hot_coolant> * 3)
    .requireComputationPoint(0.25F)
    .build();
recipeCounter += 1;

// 合金线圈（等级 4）
RecipeBuilder.newBuilder("coil_v4_water", "numerical_control_machine", 120, recipeCounter, false)
    .addEnergyPerTickInput(1024000)
    .addInputs(<ore:ingotFallenStarAlloy> * 1)
    .addOutputs(<contenttweaker:coil_v4> * 3)
    .addFluidPerTickInput(<liquid:water> * 30)
    .addFluidPerTickOutput(<liquid:steam> * 30)
    .requireComputationPoint(0.25F)
    .build();
recipeCounter += 1;

// 合金线圈（等级 4）
RecipeBuilder.newBuilder("coil_v4_coolant", "numerical_control_machine", 60, recipeCounter, false)
    .addEnergyPerTickInput(512000)
    .addInputs(<ore:ingotFallenStarAlloy> * 1)
    .addOutputs(<contenttweaker:coil_v4> * 3)
    .addFluidPerTickInput(<liquid:ic2coolant> * 3)
    .addFluidPerTickOutput(<liquid:ic2hot_coolant> * 3)
    .requireComputationPoint(0.25F)
    .build();
recipeCounter += 1;

// 合金线圈（等级 5）
RecipeBuilder.newBuilder("coil_v5_water", "numerical_control_machine", 240, recipeCounter, false)
    .addEnergyPerTickInput(16384000)
    .addInputs(<ore:ingotArk> * 1)
    .addOutputs(<contenttweaker:coil_v5> * 3)
    .addFluidPerTickInput(<liquid:water> * 30)
    .addFluidPerTickOutput(<liquid:steam> * 30)
    .requireComputationPoint(0.25F)
    .build();
recipeCounter += 1;

// 合金线圈（等级 5）
RecipeBuilder.newBuilder("coil_v5_coolant", "numerical_control_machine", 120, recipeCounter, false)
    .addEnergyPerTickInput(8192000)
    .addInputs(<ore:ingotArk> * 1)
    .addOutputs(<contenttweaker:coil_v5> * 3)
    .addFluidPerTickInput(<liquid:ic2coolant> * 3)
    .addFluidPerTickOutput(<liquid:ic2hot_coolant> * 3)
    .requireComputationPoint(0.25F)
    .build();
recipeCounter += 1;
