//Recipes By Hikari_Nova.
//Model by ModularTech Odyssey: ohxihh
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.MachineModifier;
import mods.modularmachinery.FactoryRecipeThread;

import novaeng.hypernet.HyperNetHelper;

//==============================工业机械臂==============================
val workingMachineArm = FactoryRecipeThread.createCoreThread("工作机械臂");
val maintainerMachineArm = FactoryRecipeThread.createCoreThread("维护机械臂");

// 工厂线程数设置
MachineModifier.setMaxThreads("machine_arm", 0);
MachineModifier.addCoreThread("machine_arm", workingMachineArm);
MachineModifier.addCoreThread("machine_arm", maintainerMachineArm);

// 并行线程数设置
MachineModifier.setMaxParallelism("machine_arm", 32);

HyperNetHelper.proxyMachineForHyperNet("machine_arm");

var recipeCounter = 1;

// 控制器
RecipeBuilder.newBuilder("machine_arm_controller", "mach_crafter", 1200, recipeCounter, false)
    .addEnergyPerTickInput(5120)
    .addInputs([
        <contenttweaker:robot_arm_v2> * 48,
        <contenttweaker:industrial_circuit_v1> * 32,
        <contenttweaker:electric_motor_v2> * 24,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:machine_arm_factory_controller>)
    .requireResearch("machine_arm")
    .build();
recipeCounter += 1;

// HyperNet 液冷数据处理计算机
RecipeBuilder.newBuilder("data_processor_t2_controller", "machine_arm", 800, recipeCounter, false)
    .addEnergyPerTickInput(64000)
    .addInputs([
        <liquid:ic2coolant> * 16000,
        <contenttweaker:hypernet_cpu_t2> * 3,
        <contenttweaker:hypernet_ram_t2> * 6,
        <contenttweaker:industrial_circuit_v1> * 16,
        <ic2:advanced_heat_vent> * 6,
        <ic2:component_heat_vent> * 12,
        <ore:plateCopper> * 32,
        <fluxnetworks:fluxcore> * 24,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:data_processor_t2_factory_controller> * 1)
    .requireResearch("cpu_t2")
    .build();
recipeCounter += 1;

// HyperNet 进阶研究站（等级 2）
RecipeBuilder.newBuilder("research_station_t2_controller", "machine_arm", 2400, recipeCounter, false)
    .addEnergyPerTickInput(768000)
    .addInputs([
        <contenttweaker:hypernet_cpu_t2> * 6,
        <contenttweaker:hypernet_ram_t2> * 12,
        <contenttweaker:industrial_circuit_v2> * 16,
        <mets:diamond_lens> * 4,
        <ic2:advanced_heat_vent> * 8,
        <ic2:component_heat_vent> * 16,
        <ore:plateCopper> * 48,
        <fluxnetworks:fluxcore> * 16,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:research_station_t2_factory_controller> * 1)
    .requireResearch("the_eve_of_a_technological_revolution")
    .build();
recipeCounter += 1;

// HyperNet 计算网络中心（等级 2）
RecipeBuilder.newBuilder("computation_center_t2_controller", "machine_arm", 2400, recipeCounter, false)
    .addEnergyPerTickInput(768000)
    .addInputs([
        <contenttweaker:industrial_circuit_v2> * 32,
        <contenttweaker:sensor_v2> * 24,
        <contenttweaker:hypernet_cpu_t2> * 8,
        <contenttweaker:hypernet_ram_t2> * 16,
        <ic2:advanced_heat_vent> * 10,
        <ic2:component_heat_vent> * 20,
        <ore:plateCopper> * 64,
        <fluxnetworks:fluxcore> * 48,
        <appliedenergistics2:part:76> * 16,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:computation_center_t2_factory_controller> * 1)
    .requireResearch("the_eve_of_a_technological_revolution")
    .build();
recipeCounter += 1;

// 智能强冷裂变反应堆控制器
RecipeBuilder.newBuilder("reactor_ic2_2_controller_t2_cpu", "machine_arm", 800, recipeCounter, false)
    .addEnergyPerTickInput(64000)
    .addInputs([
        <contenttweaker:hypernet_cpu_t2> * 1,
        <contenttweaker:industrial_circuit_v1> * 4,
        <ic2:advanced_heat_vent> * 8,
        <ic2:component_heat_vent> * 24,
        <ic2:containment_plating> * 24,
        <ic2:te:134> * 1,
        <ic2:te:22> * 1,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:reactor_ic2_2_factory_controller> * 1)
    .requireResearch("reactor_ic2_2")
    .build();
recipeCounter += 1;

// 智能强冷裂变反应堆控制器
RecipeBuilder.newBuilder("reactor_ic2_2_controller_t1_cpu", "machine_arm", 800, recipeCounter, false)
    .addEnergyPerTickInput(64000)
    .addInputs([
        <contenttweaker:hypernet_cpu_t1> * 5,
        <contenttweaker:industrial_circuit_v1> * 12,
        <ic2:advanced_heat_vent> * 8,
        <ic2:component_heat_vent> * 24,
        <ic2:containment_plating> * 24,
        <ic2:te:134> * 1,
        <ic2:te:22> * 1,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:reactor_ic2_2_factory_controller> * 1)
    .requireResearch("reactor_ic2_2")
    .build();
recipeCounter += 1;

// 天气发电机控制器
RecipeBuilder.newBuilder("weather_generator_controller", "machine_arm", 800, recipeCounter, false)
    .addEnergyPerTickInput(96000)
    .addInputs([
        <ore:itemVibrantCrystal> * 24,
        <ore:gemCrystalFlux> * 16,
        <ebwizardry:magic_crystal:3> * 8,
        <modularmachinery:solar_panel_0_controller> * 1,
    ])
    .addOutputs(<modularmachinery:weather_generator_controller> * 1)
    .requireResearch("weather_generator")
    .build();
recipeCounter += 1;

// 矿物溶解机控制器
RecipeBuilder.newBuilder("mineral_dissolver_controller", "machine_arm", 1600, recipeCounter, false)
    .addEnergyPerTickInput(256000)
    .addInputs([
        <contenttweaker:industrial_circuit_v1> * 32,
        <contenttweaker:electric_motor_v2> * 24,
        <mekanism:machineblock2:6> * 1,
        <mekanism:machineblock2:7> * 2,
        <mekanism:machineblock2:8> * 4,
        <mekanism:machineblock2:3> * 6,
        <mekanism:machineblock:9> * 8,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:mineral_dissolver_controller> * 1)
    .requireResearch("mineral_dissolver")
    .build();
recipeCounter += 1;

// 物质熵变器
RecipeBuilder.newBuilder("material_entropy_converter_controller", "machine_arm", 3600, recipeCounter, false)
    .addEnergyPerTickInput(768000)
    .addInputs([
        <liquid:crystal_matrix> * 2304,
        <contenttweaker:industrial_circuit_v2> * 12,
        <contenttweaker:field_generator_v1> * 12,
        <ore:ingotAlloyT1> * 6,
        <modularmachinery:ion_generator_controller>,
    ])
    .addOutputs(<modularmachinery:material_entropy_converter_controller> * 1)
    .requireResearch("material_entropy_converter")
    .build();
recipeCounter += 1;

// 魔力收集器
RecipeBuilder.newBuilder("mana_collector_controller", "machine_arm", 3600, recipeCounter, false)
    .addEnergyPerTickInput(768000)
    .addInputs([
        <liquid:crystal_matrix> * 2304,
        <contenttweaker:industrial_circuit_v2> * 16,
        <contenttweaker:field_generator_v1> * 12,
        <ore:elvenPixieDust> * 32,
        <ore:ingotTerrasteel> * 16,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:mana_collector_controller> * 1)
    .requireResearch("mana_collector")
    .build();
recipeCounter += 1;

// 黑莲龙木
RecipeBuilder.newBuilder("black_dragon_lotus_controller", "machine_arm", 3600, recipeCounter, false)
    .addEnergyPerTickInput(768000)
    .addInputs([
        <liquid:crystal_matrix> * 2304,
        <minecraft:chorus_fruit> * 64,
        <ore:elvenDragonstone> * 32,
        <ore:ingotTerraAlloy> * 6,
        <minecraft:skull:5> * 1,
        <modularmachinery:mana_collector_controller>,
    ])
    .addOutputs(<modularmachinery:black_dragon_lotus_controller> * 1)
    .requireResearch("black_dragon_lotus")
    .build();
recipeCounter += 1;

// 泰拉钢矿钻
RecipeBuilder.newBuilder("mana_ore_drill_controller", "machine_arm", 3600, recipeCounter, false)
    .addEnergyPerTickInput(768000)
    .addInputs([
        <botania:terrapick>,
        <contenttweaker:industrial_circuit_v2> * 12,
        <ore:ingotTerraAlloy> * 8,
        <contenttweaker:sensor_v2> * 12,
        <ore:manaPearl> * 36,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:mana_ore_drill_factory_controller> * 1)
    .requireResearch("mana_ore_drill")
    .build();
recipeCounter += 1;

// 大型风力发电机
RecipeBuilder.newBuilder("large_wind_generator", "machine_arm", 1600, recipeCounter, false)
    .addEnergyPerTickInput(96000)
    .addInputs([
        <mets:super_iridium_rotor> * 4,
        <ore:shaftTitanium> * 8,
        <contenttweaker:electric_motor_v2> * 12,
        <enderio:item_capacitor_melodic> * 12,
        <ore:plateCarbon> * 48,
        <ore:plateAdvancedAlloy> * 32,
        <ic2:crafting:4> * 24,
        <contenttweaker:industrial_circuit_v2> * 8,
        <mekanism:basicblock:8> * 50,
    ])
    .addOutputs(<mekanismmultiblockmachine:multiblockgenerator:0> * 1)
    .build();
recipeCounter += 1;

// 大型燃气发电机
RecipeBuilder.newBuilder("large_gas_generator", "machine_arm", 1200, recipeCounter, false)
    .addEnergyPerTickInput(72000)
    .addInputs([
        <ore:plateCarbon> * 36,
        <ic2:crafting:4> * 27,
        <mekanism:electrolyticcore> * 27,
        <enderio:item_capacitor_melodic> * 6,
        <contenttweaker:industrial_circuit_v2> * 10,
        <mekanism:gastank>.withTag({tier: 1}) * 2,
        <mekanism:basicblock:8> * 27,
    ])
    .addOutputs(<mekanismmultiblockmachine:multiblockgenerator:2> * 1)
    .build();
recipeCounter += 1;

// 大型热力发电机
RecipeBuilder.newBuilder("large_heat_generator", "machine_arm", 1000, recipeCounter, false)
    .addEnergyPerTickInput(64000)
    .addInputs([
        <ore:plateCarbon> * 36,
        <ic2:crafting:4> * 18,
        <ic2:crafting:7> * 27,
        <enderio:item_capacitor_melodic> * 4,
        <contenttweaker:industrial_circuit_v2> * 6,
        <mekanism:basicblock:8> * 27,
    ])
    .addOutputs(<mekanismmultiblockmachine:multiblockgenerator:1> * 1)
    .build();
recipeCounter += 1;

// 空的充能燃料容器（等级 1）
RecipeBuilder.newBuilder("energized_fuel_container_v1", "machine_arm", 800, recipeCounter, false)
    .addEnergyPerTickInput(128000)
    .addInputs([
        <contenttweaker:field_generator_v1> * 1,
        <contenttweaker:industrial_circuit_v2> * 2,
        <ore:plateWillowalloy> * 4,
    ])
    .addOutputs(<contenttweaker:energized_fuel_container_v1> * 1)
    .requireResearch("crystal_injector")
    .build();
recipeCounter += 1;

// 空的充能燃料容器（等级 2）
RecipeBuilder.newBuilder("energized_fuel_container_v2", "machine_arm", 1600, recipeCounter, false)
    .addEnergyPerTickInput(512000)
    .addInputs([
        <contenttweaker:field_generator_v1> * 2,
        <contenttweaker:industrial_circuit_v2> * 4,
        <mets:neutron_plate> * 4,
    ])
    .addOutputs(<contenttweaker:energized_fuel_container_v2> * 1)
    .requireResearch("tokmak_reactor")
    .build();
recipeCounter += 1;

// 空的充能燃料容器（等级 3）
RecipeBuilder.newBuilder("energized_fuel_container_v3", "machine_arm", 2400, recipeCounter, false)
    .addEnergyPerTickInput(2048000)
    .addInputs([
        <contenttweaker:field_generator_v2> * 1,
        <contenttweaker:industrial_circuit_v3> * 2,
        <ore:plateDraconicMetal> * 3,
    ])
    .addOutputs(<contenttweaker:energized_fuel_container_v3> * 1)
    .requireResearch("energy_crystal")
    .build();
recipeCounter += 1;

// 空的充能燃料容器（等级 4）
RecipeBuilder.newBuilder("energized_fuel_container_v4", "machine_arm", 3200, recipeCounter, false)
    .addEnergyPerTickInput(8192000)
    .addInputs([
        <contenttweaker:field_generator_v3> * 2,
        <contenttweaker:industrial_circuit_v3> * 4,
        <ore:plateChaoticMetal> * 3,
    ])
    .addOutputs(<contenttweaker:energized_fuel_container_v4> * 1)
    .requireResearch("beyond_limits")
    .build();
recipeCounter += 1;

// ME机械物品输出仓
RecipeBuilder.newBuilder("me_item_output_bus", "machine_arm", 200, recipeCounter)
    .addEnergyPerTickInput(32000)
    .addInputs([
        <modularmachinery:blockoutputbus:4>,
        <appliedenergistics2:interface>,
        <contenttweaker:industrial_circuit_v2> * 2,
        <contenttweaker:robot_arm_v2> * 4
    ])
    .addOutput(<modularmachinery:blockmeitemoutputbus> * 2)
    .build();
recipeCounter += 1;

// ME机械物品输入仓
RecipeBuilder.newBuilder("me_item_input_bus", "machine_arm", 200, recipeCounter)
    .addEnergyPerTickInput(32000)
    .addInputs([
        <modularmachinery:blockinputbus:4>,
        <appliedenergistics2:interface>,
        <contenttweaker:industrial_circuit_v2> * 2,
        <contenttweaker:robot_arm_v2> * 4
    ])
    .addOutput(<modularmachinery:blockmeiteminputbus> * 2)
    .build();
recipeCounter += 1;

// ME机械流体输出仓
RecipeBuilder.newBuilder("me_fluid_output_bus", "machine_arm", 200, recipeCounter)
    .addEnergyPerTickInput(32000)
    .addInputs([
        <modularmachinery:blockfluidoutputhatch:4>,
        <appliedenergistics2:fluid_interface>,
        <contenttweaker:industrial_circuit_v2> * 2,
        <contenttweaker:electric_motor_v2> * 10
    ])
    .addOutput(<modularmachinery:blockmefluidoutputbus> * 2)
    .build();
recipeCounter += 1;

// ME机械流体输入仓
RecipeBuilder.newBuilder("me_fluid_input_bus", "machine_arm", 200, recipeCounter)
    .addEnergyPerTickInput(32000)
    .addInputs([
        <modularmachinery:blockfluidinputhatch:4>,
        <appliedenergistics2:fluid_interface>,
        <contenttweaker:industrial_circuit_v2> * 2,
        <contenttweaker:electric_motor_v2> * 10
    ])
    .addOutput(<modularmachinery:blockmefluidinputbus> * 2)
    .build();
recipeCounter += 1;

// ME机械样板供应器
RecipeBuilder.newBuilder("me_pattern_provider", "machine_arm", 300, recipeCounter)
    .addEnergyPerTickInput(128000)
    .addInputs([
        <modularmachinery:blockmeiteminputbus>,
        <modularmachinery:blockmefluidinputbus>,
        <novaeng_core:estorage_cell_item_16m>,
        <novaeng_core:estorage_cell_fluid_16m>,
        <appliedenergistics2:material:58> * 6,
        <contenttweaker:industrial_circuit_v2> * 12,
        <appliedenergistics2:paint_ball:1> * 12,
    ])
    .addOutput(<modularmachinery:blockmepatternprovider> * 2)
    .build();
recipeCounter += 1;

// 强化机械通风口
RecipeBuilder.newBuilder("reinforced_vent", "machine_arm", 200, recipeCounter)
    .addEnergyPerTickInput(32000)
    .addInputs([
        <modularmachinery:blockcasing:1>,
        <modularmachinery:blockcasing:4>,
        <contenttweaker:electric_motor_v3> * 4,
    ])
    .addOutput(<contenttweaker:reinforced_vent> * 2)
    .build();
recipeCounter += 1;

// 究极机械外壳
RecipeBuilder.newBuilder("extreme_machine_casing", "machine_arm", 200, recipeCounter, false)
    .addEnergyPerTickInput(256000)
    .addInput(<modularmachinery:blockcasing> * 1)
    .addInput(<ore:plateWillowalloy> * 4)
    .addInput(<mekanism:otherdust:5> * 2)
    .addInput(<ore:ingotElectrumFlux> * 1)
    .addOutput(<contenttweaker:extrememachineblock> * 1)
    .build();
recipeCounter += 1;

// 方舟机械外壳
RecipeBuilder.newBuilder("arkmachineblock", "machine_arm", 1200, recipeCounter, false)
    .addEnergyPerTickInput(1024000)
    .addInput(<contenttweaker:extrememachineblock> * 8)
    .addInput(<additions:novaextended-extremecircuit> * 8)
    .addInput(<ore:ingotArk>)
    .addOutput(<contenttweaker:arkmachineblock> * 8)
    .build();
recipeCounter += 1;
