import mods.modularmachinery.MachineModifier;
import mods.modularmachinery.MMEvents;
import mods.modularmachinery.ControllerGUIRenderEvent;
import mods.modularmachinery.MachineTickEvent;
import mods.modularmachinery.RecipeStartEvent;
import mods.modularmachinery.FactoryRecipeThread;
import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.FactoryRecipeStartEvent;
import mods.modularmachinery.IMachineController;
import mods.modularmachinery.RecipeCheckEvent;
import mods.modularmachinery.FactoryRecipeTickEvent;
import mods.modularmachinery.FactoryRecipeFinishEvent;
import mods.modularmachinery.MachineController;
import mods.modularmachinery.RecipeModifierBuilder;
import mods.modularmachinery.SmartInterfaceType;
import mods.modularmachinery.IngredientArrayBuilder;
import novaeng.hypernet.HyperNetHelper;
import crafttweaker.util.Math;
import crafttweaker.world.IWorld;
import crafttweaker.item.IItemStack;
import crafttweaker.item.IIngredient;
import crafttweaker.item.IMutableItemStack;
import crafttweaker.oredict.IOreDictEntry;
import novaeng.hypernet.RegistryHyperNet;
import novaeng.hypernet.research.ResearchCognitionData;

MachineModifier.setInternalParallelism("biogenic_simulation_computer",125);
//研究
    RegistryHyperNet.addResearchCognitionData(ResearchCognitionData.create("simulation", "生物模拟计算",
            <deepmoblearning:simulation_chamber>,    // 预览物品
            10.0,                                 // 科技等级（难度）
            7000*20*60*20,                          // 需要科研点
            7000,                               // 最低每 Tick 算力要求
            [
                "近日ECO实验室勘探组成员13x在花果山脚下失足坠落至某古井内，他绝望的闭上双眼，但等待他的并不是死亡，而是一位不知名吃葱的守井人，它用葱稳稳的接住了13x，并递给他一个前面的倒霉蛋的头作为小小的纪念品，13x定了定神发现居然是失传已久的古物：数据故障人头颅！13x使用了极·真蓄·立棍式，再配合古物的增幅能力成功逃出了古井，但吃葱守井人仍选择留下来继续守望失落少女，感谢守井人的坚持！13x道别守井人后将古物带回实验室，众人见到古物欣喜若狂，连夜翻寻古文献，发现其需配合故障灌注块催化注能，便着手进行相关研发工作。"
            ],
            [
                "§2解锁集成式处理车间配方：生物演化推算计算室",
                "",
                "没有意外的出意外了，研发工作并不顺利，在故障人头颅长毛半年后，它才能勉强为实验室生产一些…骨头？",
                "但ECO实验室真正需要的是压榨头颅进行龙蛋和头颅的量化生产，用来解决下界之星和混沌金属的燃眉之急。",
                "就当众人一筹莫展时，隔壁精神小伙召唤的末影龙被击杀，由于网络不稳定掉线了，龙蛋被遗落在实验室附近。13x苦于研发，终于变成猪脑过载的形状，气不过选择去踢龙蛋出气，一脚过去差点截肢。龙蛋也好巧不巧正好跑到效应放大器上，就在此时，故障人头颅发出了闪光弹一般的光芒，径直向被踢凹进去一块的龙蛋输出大量的未知能量，伴随着强光逐渐消散，效应放大器留下了一颗原始凋零物质！一脸懵逼的众人赶忙将全过程记录下来，根据该记录研发出了ECO实验室转属模拟室！",
                "在初期使用过程中发现，连续高频运转会导致计算过程出错，有极大概率将插入的凋灵数据模型错误的转化为系统故障，于是13x尝试加入碎冰冰进行冷却处理，效果拔群！",
                "",
                "§2§o模型/文案：13xxxj ,§2§o代码/策划：Circulation",
            ],
            [
                "eco_y7"
            ]
    ));
//控制器合成
    RecipeBuilder.newBuilder("biogenic_simulation_computer_factory_controller", "workshop", 4800)
        .addEnergyPerTickInput(20480000)
        .addInputs([
            <modularmachinery:computation_center_t3_factory_controller>,
            <contenttweaker:industrial_circuit_v3> * 12,
            <contenttweaker:sensor_v3> * 16,
            <threng:material:14> * 16
        ])
        .addOutputs(<modularmachinery:biogenic_simulation_computer_factory_controller> * 1)
        .requireResearch("simulation")
        .build();
//聚合粘土
    RecipeBuilder.newBuilder("polymer_clayshop", "workshop", 2000)
        .addEnergyPerTickInput(20480000)
        .addInputs([
            <tconevo:metal:36> * 150,
            <enderio:item_material:76> * 150,
            <tconevo:material> * 75,
            <appliedenergistics2:material:45> * 150
        ])
        .addOutputs(<deepmoblearning:polymer_clay> * 6400)
        .requireResearch("simulation")
        .build();
# 智能数据接口数据类型定义
    MachineModifier.addSmartInterfaceType("biogenic_simulation_computer",
        SmartInterfaceType.create("parallelism", 0)
            .setHeaderInfo("§a操纵线程的并行极限")
            .setValueInfo("当前允许并行：§a%.0f")
            .setFooterInfo("每个并行需要100T算力以运行,最大为32")
    );
# 写入智能数据接口信息
    MMEvents.onMachinePostTick("biogenic_simulation_computer", function(event as MachineTickEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val map = data.asMap();
        val nullable = ctrl.getSmartInterfaceData("parallelism");
        var parallelism = isNull(nullable) ? 1 : nullable.value;

        if (parallelism < 1 || parallelism > 32) {
            nullable.value = 1;
        }

        map["parallelism"] = parallelism;
        ctrl.customData = data;
    });
//循环预设
    val inscriberModels as string[] = [
            "数位演算模块-α",
            "数位演算模块-β",
            "数位演算模块-δ",
            "数位演算模块-Ω"
        ];
    val ysqnames as string[] = [
            "ysqname1",
            "ysqname2",
            "ysqname3",
            "ysqname4"
        ];
    val ysqidxss as string[] = [
            "ysqidxs1",
            "ysqidxs2",
            "ysqidxs3",
            "ysqidxs4"
        ];
    val ysqddcss as string[] = [
            "ysqddcs1",
            "ysqddcs2",
            "ysqddcs3",
            "ysqddcs4"
        ];
//工厂设置
    MachineModifier.setMaxThreads("biogenic_simulation_computer", 0);
    MachineModifier.addCoreThread("biogenic_simulation_computer", FactoryRecipeThread.createCoreThread("数位演算模块-α"));
    MachineModifier.addCoreThread("biogenic_simulation_computer", FactoryRecipeThread.createCoreThread("数位演算模块-β"));
    MachineModifier.addCoreThread("biogenic_simulation_computer", FactoryRecipeThread.createCoreThread("数位演算模块-δ"));
    MachineModifier.addCoreThread("biogenic_simulation_computer", FactoryRecipeThread.createCoreThread("数位演算模块-Ω"));
    HyperNetHelper.proxyMachineForHyperNet("biogenic_simulation_computer");
//GUI
    MMEvents.onControllerGUIRender("biogenic_simulation_computer", function(event as ControllerGUIRenderEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val ysqname1 = dData.getString("ysqname1","暂无");
        val ysqname2 = dData.getString("ysqname2","暂无");
        val ysqname3 = dData.getString("ysqname3","暂无");
        val ysqname4 = dData.getString("ysqname4","暂无");
        val ysqddcs1 = dData.getLong("ysqddcs1",0);
        val ysqddcs2 = dData.getLong("ysqddcs2",0);
        val ysqddcs3 = dData.getLong("ysqddcs3",0);
        val ysqddcs4 = dData.getLong("ysqddcs4",0);
        var info as string[] = [];
        info += "当前记录模型：" + ysqname1;
        info += "当前迭代次数：" + ysqddcs1;
        info += "当前记录模型：" + ysqname2;
        info += "当前迭代次数：" + ysqddcs2;
        info += "当前记录模型：" + ysqname3;
        info += "当前迭代次数：" + ysqddcs3;
        info += "当前记录模型：" + ysqname4;
        info += "当前迭代次数：" + ysqddcs4;
        event.extraInfo = info;
    });
//添加矿词
    <ore:dataModel>.add(itemUtils.getItemsByRegexRegistryName(".*g.data_model.*"));
    <ore:livingMatter>.add(itemUtils.getItemsByRegexRegistryName(".*living_matter.*"));
    <ore:pristine>.add(itemUtils.getItemsByRegexRegistryName(".*pristine_matter.*"));
    <ore:dataModel>.remove(<deepmoblearning:data_model_blank>); 
//写入数据
    for i, ysqname in ysqnames {
        RecipeBuilder.newBuilder("moxll" + i, "biogenic_simulation_computer", 1,0)
            .addItemInput(<ore:dataModel>).setTag("dataModel")
            .setNBTChecker(function(ctrl as IMachineController, item as IItemStack) {
                val id = item.definition.name.replaceAll(".*data_model_","");
                val namesc = item.displayName;
                val name = namesc.replaceAll("[(]缺陷.*|[(]卓越.*|[(]高级.*|[(]自我.*|[(]基础.*","");
                val dataCount = D(item.tag).getInt("dataCount", 0);
                val tier = D(item.tag).getInt("tier", 0);
                val data = ctrl.customData;
                val map = data.asMap();

                map["namehcq"] = name;
                map["idhcq"] = id;
                map["dataCount"] = dataCount;
                map["tier"] = tier;
                ctrl.customData = data;
                return true;
            })
            .addPreCheckHandler(function(event as RecipeCheckEvent) {
                val ctrl = event.controller;
                val data = ctrl.customData;
                val dData = D(data);
                val ysqnamea = dData.getString(ysqname,"暂无");

                if (ysqnamea != "暂无") {
                    event.setFailed("数据模块注入完成，可以开始演算");
                    return;
                }
            })
            .addFactoryFinishHandler(function (event as FactoryRecipeFinishEvent) {
                val ctrl = event.controller;
                val data = ctrl.customData;
                val dData = D(data);
                val map = data.asMap();
                val ysqnamea = dData.getString(ysqname,"暂无");
                val namehcq = dData.getString("namehcq","无");
                val idhcq = dData.getString("idhcq","无");
                val dataCount = dData.getInt("dataCount", 0);
                val tier = dData.getInt("tier", 0);
                var tierend = (tier <= 1) ? (32 * tier + dataCount):(dataCount + (tier - 1) * 10000 + 32);


                if (ysqnamea == "暂无"){
                    map[ysqname] = namehcq;
                    map[ysqidxss[i]] = idhcq;
                    map[ysqddcss[i]] = (tierend as long);
                }

                ctrl.customData = data;
            })
            .addOutput(<deepmoblearning:data_model_blank>)
            .setParallelized(false)
            .addRecipeTooltip("将数据模型写入"+inscriberModels[i])
            .addRecipeTooltip("请将数据模型放入控制器正上方的微型物品输入仓中")
            .setThreadName(inscriberModels[i])
        .build();
    }
//输出产物
    for i, ysqname in ysqnames {
        RecipeBuilder.newBuilder("moni" + i, "biogenic_simulation_computer",60,0)
            .addEnergyPerTickInput(1000000)
            .addItemInput(<deepmoblearning:polymer_clay>)
            .addPreCheckHandler(function(event as RecipeCheckEvent) {
                val ctrl = event.controller;
                val data = ctrl.customData;
                val dData = D(data);
                val ysqnamea = dData.getString(ysqname,"暂无");
                val ysqidxs = dData.getString(ysqidxss[i],"暂无");
                val parallelism = dData.getInt("parallelism",1);                

                if (ysqnamea == "暂无") {
                    event.setFailed("没有数据模型！");
                    return;
                }
                event.activeRecipe.maxParallelism = parallelism;
            })
            .addFactoryStartHandler(function (event as FactoryRecipeStartEvent) {
                val ctrl = event.controller;
                val data = ctrl.customData;
                val dData = D(data);
                val ysqddcs = dData.getInt(ysqddcss[i],0);
                val bl = event.factoryRecipeThread;
                if (ysqddcs < 32){
                    bl.addModifier("duration", RecipeModifierBuilder.create("modularmachinery:duration", "input",60, 1, false).build());
                    bl.addModifier("energy", RecipeModifierBuilder.create("modularmachinery:energy", "input",20, 1, false).build());
                }
            })
            .addItemOutput(<ore:pristine>).addItemModifier(function(ctrl as IMachineController, Item as IItemStack) {
                return outputyuanshiwuzhi(ctrl,ysqddcss[i],ysqidxss[i],Item);
            })
            .addItemOutput(<ore:livingMatter>).addItemModifier(function(ctrl as IMachineController, Item as IItemStack) {
                return outputwuzhi(ctrl,ysqidxss[i]);
            }) 
            .addFactoryFinishHandler(function (event as FactoryRecipeFinishEvent) {
                val ctrl = event.controller;
                val data = ctrl.customData;
                val dData = D(data);
                val map = data.asMap();
                val ysqddcs = dData.getLong(ysqddcss[i],0);
                val bx = event.factoryRecipeThread.activeRecipe.parallelism;

                map[ysqddcss[i]] = ysqddcs + bx;
                ctrl.customData = data;
            })
            .addRecipeTooltip("使用" + inscriberModels[i] + "进行模拟,并且输出物质")
            .addRecipeTooltip("概率继承自模拟室,并且每个等级额外提高2%")
            .addRecipeTooltip("等级为0的模型需要60倍的时间和20倍能量来进行初步推算")
            .setThreadName(inscriberModels[i])
            .requireComputationPoint(100.0F)
        .build();
    }
//修改器
    function outputwuzhi(ctrl as IMachineController,ysqidxss as string) as IItemStack {
        val data = ctrl.customData;
        val dData = D(data);
        val name = dData.getString(ysqidxss,"暂无");
                
            if (name == "creeper"||name == "guardian"||name == "skeleton"||name == "slime"||name == "spider"||name == "witch"||name == "zombie"||name == "thermal_elemental"||name == "tinker_slime"||name == "mo_android"){
                return <deepmoblearning:living_matter_overworldian> * 1;
            }
            if (name == "blaze"||name == "ghast"||name == "wither_skeleton"){
                return <deepmoblearning:living_matter_hellish> * 1;
            } 
            if (name == "dragon"||name == "enderman"||name == "shulker"||name == "wither"){
                return <deepmoblearning:living_matter_extraterrestrial> * 1;
            } 
            if (name == "inf7yentr60py"||name == "chaosguardian"){
                return <deepmoblearning:living_matter_legend> * 1;
            }
    }
    function outputyuanshiwuzhi(ctrl as IMachineController,ysqddcss as string,ysqidxss as string,item as IItemStack) as IItemStack {
        val data = ctrl.customData;
        val world = ctrl.world;
        val Random = world.getRandom().nextInt(1,100);
        val dData = D(data);
        val ysqddcs = dData.getLong(ysqddcss,0);
        val ysqidxs = dData.getString(ysqidxss,"暂无");
        val pristine as IOreDictEntry = <ore:pristine>;
        var IStack as IItemStack[] = [];

        for item in pristine.items{
            if (item.definition.id == "deepmoblearning:pristine_matter_" + ysqidxs) {
                IStack += item;
            }
        }

        var itemsl = 0;        
            if (ysqddcs >= 32){
                if (ysqddcs < 10032){
                    itemsl += (6 >= Random) ? 1:0;
                } else if (ysqddcs < 20032){
                    itemsl += (12 >= Random) ? 1:0;
                } else if (ysqddcs < 30032){
                    itemsl += (14 >= Random) ? 1:0;
                } else {
                    itemsl += (20 >= Random) ? 1:0;
                }
            }
        if (itemsl == 0) {
            return item * 0;
        } else {
            return IStack[0] * 1;
        }
    }
    function outputdata(ctrl as IMachineController,ysqddcss as string,ysqidxss as string,ysqname as string) as IItemStack {
        val data = ctrl.customData;
        val dData = D(data);
        val map = data.asMap();
        val ysqddcs = dData.getLong(ysqddcss,0) as int;
        val ysqidxs = dData.getString(ysqidxss,"暂无");
        val Model as IOreDictEntry = <ore:dataModel>;
        var IStack as IItemStack[] = [];

        for item in Model.items{
            if (item.definition.id == "deepmoblearning:data_model_" + ysqidxs) {
                IStack += item;
            }
        }

        var tiers = 0;
        var dataCounts = 0;
        if (ysqddcs < 32) {
            tiers = 0;
            dataCounts += ysqddcs;
        } else if (ysqddcs < 10032){
            tiers += 1;
            dataCounts += (ysqddcs - 32);
        } else if (ysqddcs < 20032){
            tiers += 2;
            dataCounts += (ysqddcs - 10032);
        } else if (ysqddcs < 30032){
            tiers += 3;
            dataCounts += (ysqddcs - 20032);
        } else {
            tiers += 4;
        }

        map[ysqname] = "暂无";
        map[ysqddcss] = 0;
        map[ysqidxss] = "暂无";
        ctrl.customData = data;

        return IStack[0].withTag({
            totalSimulationCount : ysqddcs,
            tier : tiers,
            dataCount : dataCounts
        });
    }
//模型导出
    for i, ysqname in ysqnames {
        RecipeBuilder.newBuilder("mxdc" + i, "biogenic_simulation_computer", 1)
            .addItemInput(<deepmoblearning:data_model_blank>)
            .addPreCheckHandler(function(event as RecipeCheckEvent) {
                val ctrl = event.controller;
                val data = ctrl.customData;
                val dData = D(data);
                val ysqnamea = dData.getString(ysqname,"暂无"); 

                if (ysqnamea == "暂无") {
                    event.setFailed("没有可以导出的数据");
                    return;
                }
            })
            .addOutput(<ore:dataModel>)
                .setPreViewNBT({display: {Lore: ["§6提取出写入的模型"]}})
            .addItemModifier(function(ctrl as IMachineController, item as IItemStack) {
                return outputdata(ctrl,ysqddcss[i],ysqidxss[i],ysqname);
            })
            .setParallelized(false)
            .addRecipeTooltip("将数据模型从" + inscriberModels[i] + "导出")
            .addRecipeTooltip("会先从哪个数据里导出？谁知道呢，试试不就知道了")
            .setThreadName(inscriberModels[i])
        .build();
    }