//Recipes By Circulation.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 500
#loader crafttweaker reloadable

import mods.modularmachinery.RecipeAdapterBuilder;
import mods.modularmachinery.RecipeModifierBuilder;
import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.MachineModifier;
import novaeng.hypernet.RegistryHyperNet;
import novaeng.hypernet.HyperNetHelper;
import novaeng.hypernet.research.ResearchCognitionData;
import mods.modularmachinery.MMEvents;
import mods.modularmachinery.FactoryRecipeStartEvent;
import mods.modularmachinery.FactoryRecipeFinishEvent;
import mods.modularmachinery.IMachineController;
import mods.modularmachinery.FactoryRecipeThread;
import crafttweaker.item.IItemStack;
import crafttweaker.item.IIngredient;
import mods.modularmachinery.ControllerGUIRenderEvent;
import mods.modularmachinery.RecipeCheckEvent;

// HyperNetHelper.proxyMachineForHyperNet("assembly_line_plus");
MachineModifier.setMaxThreads("assembly_line_plus", 16);
MachineModifier.setMaxParallelism("assembly_line_plus", 64);
HyperNetHelper.proxyMachineForHyperNet("assembly_line_plus");

//  进阶装配线控制器
RegistryHyperNet.addResearchCognitionData(ResearchCognitionData.create("assembly_line_plus", "专业化构造",
        <modularmachinery:assembly_line_plus_factory_controller>,    // 预览物品
        11.0,                                 // 科技等级（难度）
        480000000,                          // 需要科研点
        20000.0F,                               // 最低每 Tick 算力要求
        [
            "近日ECO实验室收到多名匿名信，声称在制作高等级GPU时，被邻桌一闷棍敲昏过去，醒来发现GPU仍未完成。",
            "通过调取监控，发现是Circulation趁13x打盹时偷袭，13x随即起诉Circulation进行补偿，补偿的条件很简单：帮我手搓3级GPU！",
            "由于法院被13x无情收买，Circulation只能认栽进行制作，但不甘于手搓的他，终究将手伸向了那道光——核心素。"
        ],
        [
            "§2解锁集成式处理车间配方：§6专业型特化装配线。",
            "核心素的强大能量不为人知，作为首位发现该元素的他，自然要用实际行动证明。",
            "Circulation随即取来液压钳，撬开装配线，将核心素塞进装配线的控制器。",
            "只听装配线发出了前所未有的悲鸣声，响彻天际…",
            "终于可怜的装配线被核心素完全侵蚀，变成了一种更加申必的存在，生产速度大幅提升。",
            "但是代价就是装配线内置的ai反应不过来了，即使通过核心素来辅助运行，也只能同时生产一种材料了…",
            "",
            "§2§o文案：13xxxj，§2§o代码/策划：Circulation"
        ],
        [
            "atomic_reconstructor"                                 // 前置科技
        ]
));
RecipeBuilder.newBuilder("assembly_line_plus_controller_plus", "workshop", 4800)
    .addEnergyPerTickInput(2048000)
    .addInputs([
        <modularmachinery:assembly_line_factory_controller>,
        <modularmachinery:acar_factory_controller>,
        <contenttweaker:industrial_circuit_v3> * 32,
        <contenttweaker:robot_arm_v4> * 8,
        <contenttweaker:electric_motor_v4> * 16,
        <modularmachinery:data_processor_t3_factory_controller>,
    ])
    .addOutputs(<modularmachinery:assembly_line_plus_factory_controller> * 1)
    .requireResearch("assembly_line_plus")
    .build();
var recipeCounter = 0;
//GUI
    MMEvents.onControllerGUIRender("assembly_line_plus", function(event as ControllerGUIRenderEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val displayname = dData.getString("displayname","null");
        var info as string[] = ["当前标记物：" + displayname];
        info += "";
        info += "标记物即为配方成品";
        info += "";
        info += (displayname == "null") ? "将物品放入控制器正下方微型物品输入仓进行标记":"标记已完成";
        info += (displayname == "null") ? "只能运行标记物的配方":"可以运行标记物对应配方";
        
        event.extraInfo = info;
    });
//写入标记
RecipeBuilder.newBuilder("bjwxr", "assembly_line_plus",20,0, false)
    .addInput(<ore:bjitem>).setTag("sdw").setChance(0)
        .setNBTChecker(function(ctrl as IMachineController, item as IItemStack) {
            val name = item.definition.name;
            val displayname = item.displayName;
            val data = ctrl.customData;
            val map = data.asMap();

            map["name"] = name;
            map["displayname"] = displayname;
            ctrl.customData = data;
            return true;
        })
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val name = dData.getString("name", "null");

        if(name != "null") {
            event.setFailed("标记物已经写入，可以正常运行");
            return;
        }
    })
    .addRecipeTooltip("§a标记物需要放置在控制器正下方的微型物品输入仓内,只需要一个")
    .setParallelized(false)
    .build();
recipeCounter += 1;
//合成
function assembly(Name as string,energy as long,time as int,Inputs as IIngredient[],Output as IIngredient,power as float){
    <ore:bjitem>.add(Output.itemArray[0]);
    RecipeBuilder.newBuilder(Name, "assembly_line_plus",time,1, false)
        .addPostCheckHandler(function(event as RecipeCheckEvent) {
            val ctrl = event.controller;
            val data = ctrl.customData;
            val dData = D(data);
            val name = dData.getString("name", "null");
            val itemname = Output.itemArray[0].name;
            if(name == "null") {
                event.setFailed("标记物不存在，请先标记");
                return;
            } else if(name != itemname) {
                event.setFailed("请输入标记物对应的配方材料");
                return;
            }
        })
        .addEnergyPerTickInput(energy)
        .addInput(<contenttweaker:hxs>).setChance(0.4).setPreViewNBT({display: {Lore: ["§a仅在每次触发线程时消耗"]}}).setParallelizeUnaffected(true)
        .addInputs(Inputs)
        .addOutput(Output)
        .requireComputationPoint(power)
    .build();
}
function assemblyyj(Name as string,energy as long,time as int,Inputs as IIngredient[],Output as IIngredient,power as float,yjm as string){
    <ore:bjitem>.add(Output.itemArray[0]);
    RecipeBuilder.newBuilder(Name, "assembly_line_plus",time,1, false)
        .addPostCheckHandler(function(event as RecipeCheckEvent) {
            val ctrl = event.controller;
            val data = ctrl.customData;
            val dData = D(data);
            val name = dData.getString("name", "null");
            val itemname = Output.itemArray[0].name;
            if(name == "null") {
                event.setFailed("标记物不存在，请先标记");
                return;
            } else if(name != itemname) {
                event.setFailed("请输入标记物对应的配方材料");
                return;
            }
        })
        .addEnergyPerTickInput(energy)
        .addInput(<contenttweaker:hxs>).setChance(0.4).setPreViewNBT({display: {Lore: ["§a仅在每次触发线程时消耗"]}}).setParallelizeUnaffected(true)
        .addInputs(Inputs)
        .addOutput(Output)
        .requireComputationPoint(power)
        .requireResearch(yjm)
    .build();
}
assembly("exponential_level_processor_line_plus", 96000,300/2, [
    <liquid:neutron> * 600,
    <threng:material:14> * 1,
    <threng:material:14> * 1,
    <contenttweaker:lifesense_processor> * 1,
    <contenttweaker:lifesense_processor> * 1,
    <contenttweaker:lifesense_processor> * 1,
    <contenttweaker:lifesense_processor> * 1,
    <ore:ingotCrystalMatrix> * 1,
    <ore:ingotCrystalMatrix> * 1,
    <ore:plateWillowalloy> * 1,
    <ore:plateWillowalloy> * 1,
    <ore:plateWillowalloy> * 1,
    <ore:plateWillowalloy> * 1
], <contenttweaker:exponential_level_processor> * 6, 40.0);
assemblyyj("cpu_t3_zombie_plus", 16000000,9600/2, [
    <gas:nutrientsolution> * 20000, 
    <contenttweaker:lifesense_processor> * 1, 
    <contenttweaker:lifesense_processor> * 1, 
    <contenttweaker:lifesense_processor> * 1, 
    <contenttweaker:lifesense_processor> * 1, 
    <enderio:item_material:42> * 1, 
    <deepmoblearning:data_model_zombie> * 1, 
    <draconicevolution:mob_soul> * 1, 
    <draconicevolution:mob_soul> * 1, 
    <ic2:advanced_heat_vent> * 1, 
    <ic2:advanced_heat_vent> * 1, 
    <ic2:advanced_heat_vent> * 1, 
    <ic2:advanced_heat_vent> * 1
], <contenttweaker:hypernet_cpu_t3> * 1, 50.0, "cpu_t3");
assemblyyj("cpu_t3_player_plus", 16000000,7200/2, [
    <gas:nutrientsolution> * 30000, 
    <contenttweaker:lifesense_processor> * 1, 
    <contenttweaker:lifesense_processor> * 1, 
    <contenttweaker:lifesense_processor> * 1, 
    <contenttweaker:lifesense_processor> * 1, 
    <minecraft:skull:3> * 1, 
    <minecraft:skull:3> * 1, 
    <draconicevolution:mob_soul> * 1, 
    <draconicevolution:mob_soul> * 1, 
    <ic2:advanced_heat_vent> * 1, 
    <ic2:advanced_heat_vent> * 1, 
    <ic2:advanced_heat_vent> * 1, 
    <ic2:advanced_heat_vent> * 1
], <contenttweaker:hypernet_cpu_t3> * 1, 50.0, "cpu_t3");
assemblyyj("ram_t3_plus", 16000000,7200/2, [
    <liquid:gold> * 4320,
    <appliedenergistics2:material:22> * 32,
    <appliedenergistics2:material:22> * 32,
    <appliedenergistics2:material:22> * 32,
    <appliedenergistics2:material:22> * 32,
    <contenttweaker:exponential_level_processor> * 1,
    <contenttweaker:exponential_level_processor> * 1,
    <ic2:advanced_heat_vent> * 1,
    <ic2:advanced_heat_vent> * 1
], <contenttweaker:hypernet_ram_t3> * 1, 50.0, "cpu_t3");
assemblyyj("gpu_t2_plus", 32000000,7200/2, [
    <contenttweaker:lifesense_processor> * 1,
    <contenttweaker:lifesense_processor> * 1,
    <contenttweaker:lifesense_processor> * 1,
    <contenttweaker:lifesense_processor> * 1,
    <contenttweaker:lifesense_processor> * 1,
    <contenttweaker:lifesense_processor> * 1,
    <contenttweaker:lifesense_processor> * 1,
    <contenttweaker:lifesense_processor> * 1,
    <contenttweaker:hypernet_cpu_t3> * 1,
    <contenttweaker:hypernet_cpu_t3> * 1,
    <contenttweaker:hypernet_ram_t3> * 1,
    <contenttweaker:hypernet_ram_t3> * 1,
    <mets:advanced_oc_heat_vent> * 1,
    <mets:advanced_oc_heat_vent> * 1,
    <mets:advanced_heat_vent> * 1,
    <mets:advanced_heat_vent> * 1
], <contenttweaker:hypernet_gpu_t2> * 1, 100.0, "cpu_t3");
assemblyyj("cpu_t4_plus", 128000000,9600/2, [
    <liquid:solarium_fluid> * 432,
    <contenttweaker:exponential_level_processor> * 1,
    <contenttweaker:exponential_level_processor> * 1,
    <contenttweaker:exponential_level_processor> * 1,
    <contenttweaker:exponential_level_processor> * 1,
    <astralsorcery:itemusabledust> * 64,
    <astralsorcery:itemusabledust> * 64,
    <astralsorcery:itemusabledust> * 64,
    <astralsorcery:itemusabledust> * 64,
    <contenttweaker:sensor_v3> * 1,
    <contenttweaker:sensor_v3> * 1,
    <contenttweaker:sensor_v3> * 1,
    <contenttweaker:sensor_v3> * 1,
    <mets:advanced_heat_vent> * 1,
    <mets:advanced_heat_vent> * 1,
    <mets:advanced_heat_vent> * 1,
    <mets:advanced_heat_vent> * 1
], <contenttweaker:hypernet_cpu_t4> * 1, 750.0, "cpu_t4");
assemblyyj("ram_t4_plus", 128000000, 7200/2, [
    <liquid:gold> * 8640,
    <appliedenergistics2:material:22> * 64,
    <appliedenergistics2:material:22> * 64,
    <appliedenergistics2:material:22> * 64,
    <appliedenergistics2:material:22> * 64,
    <contenttweaker:exponential_level_processor> * 1,
    <contenttweaker:exponential_level_processor> * 1,
    <contenttweaker:exponential_level_processor> * 1,
    <contenttweaker:exponential_level_processor> * 1,
    <mets:advanced_heat_vent> * 1,
    <mets:advanced_heat_vent> * 1,
    <mets:advanced_heat_vent> * 1,
    <mets:advanced_heat_vent> * 1
], <contenttweaker:hypernet_ram_t4> * 1, 750.0, "cpu_t4");
assemblyyj("gpu_t3_plus", 512000000, 9600/2, [
    <contenttweaker:infinity_processor> * 1,
    <contenttweaker:infinity_processor> * 1,
    <contenttweaker:infinity_processor> * 1,
    <contenttweaker:infinity_processor> * 1,
    <appliedenergistics2:material:47> * 1,
    <contenttweaker:sensor_v4> * 1,
    <appliedenergistics2:material:47> * 1,
    <contenttweaker:sensor_v4> * 1,
    <contenttweaker:infinity_processor> * 1,
    <contenttweaker:infinity_processor> * 1,
    <contenttweaker:infinity_processor> * 1,
    <contenttweaker:infinity_processor> * 1,
    <appliedenergistics2:material:47> * 1,
    <contenttweaker:sensor_v4> * 1,
    <appliedenergistics2:material:47> * 1,
    <contenttweaker:sensor_v4> * 1
], <contenttweaker:hypernet_gpu_t3> * 1, 2000.0, "cpu_t5");
assemblyyj("ram_t5_plus", 512000000, 7200/2, [
    <liquid:gold> * 34560,
    <appliedenergistics2:material:22> * 64,
    <appliedenergistics2:material:22> * 64,
    <appliedenergistics2:material:22> * 64,
    <appliedenergistics2:material:22> * 64,
    <appliedenergistics2:material:22> * 64,
    <appliedenergistics2:material:22> * 64,
    <appliedenergistics2:material:22> * 64,
    <appliedenergistics2:material:22> * 64,
    <contenttweaker:infinity_processor> * 1,
    <contenttweaker:infinity_processor> * 1,
    <contenttweaker:infinity_processor> * 1,
    <contenttweaker:infinity_processor> * 1,
    <mets:advanced_heat_vent> * 1,
    <mets:advanced_heat_vent> * 1,
    <mets:advanced_heat_vent> * 1,
    <mets:advanced_heat_vent> * 1
], <contenttweaker:hypernet_ram_t5> * 1, 1500.0, "cpu_t5");
assembly("field_generator_v2_plus", 4096000, 600/2, [
    <ore:circuitExtreme> * 1,
    <contenttweaker:industrial_circuit_v3> * 1,
    <contenttweaker:coil_v4> * 1,
    <contenttweaker:coil_v4> * 1,
    <avaritia:endest_pearl> * 1
], <contenttweaker:field_generator_v2> * 1, 190.0);
assembly("fallenstarforcefieldcontrolblock_plus", 8192000, 800/2, [
    <ore:ingotFallenStarAlloy> * 8,
    <contenttweaker:extrememachineblock> * 2,
    <contenttweaker:coil_v4> * 12,
    <contenttweaker:field_generator_v2> * 12,
    <contenttweaker:sensor_v3> * 2,
    <gravisuite:crafting:1> * 4
], <contenttweaker:fallenstarforcefieldcontrolblock> * 2, 270.0);
assemblyyj("field_generator_v3_plus", 8192000, 600/2, [
    <contenttweaker:industrial_circuit_v3> * 1,
    <contenttweaker:infinity_processor> * 1,
    <contenttweaker:coil_v4> * 1,
    <contenttweaker:coil_v4> * 1,
    <draconicevolution:awakened_core> * 1
], <contenttweaker:field_generator_v3> * 1, 1500.0,"beyond_limits");
assemblyyj("universalforcefieldcontrolblock_plus", 16384000, 1200/2, [
    <ore:plateInfinity> * 8,
    <contenttweaker:extrememachineblock> * 2,
    <contenttweaker:coil_v4> * 12,
    <contenttweaker:field_generator_v3> * 12,
    <contenttweaker:sensor_v4> * 2,
    <contenttweaker:infinity_wire> * 6
], <contenttweaker:universalforcefieldcontrolblock> * 2, 270.0,"beyond_limits");
assembly("industrial_circuit_v3_plus", 2048000, 1200/2, [
    <liquid:crystalloidneutron> * 1,
    <ore:circuitExtreme> * 1,
    <ore:circuitExtreme> * 1,
    <ore:circuitExtreme> * 1,
    <ore:circuitExtreme> * 1,
    <ore:ingotFallenStarAlloy> * 1,
    <ore:ingotFallenStarAlloy> * 1,
    <ore:plateDraconicMetal> * 1,
    <ore:plateDraconicMetal> * 1,
    <gravisuite:crafting:1> * 4,
    <contenttweaker:carbon_nanotube> * 2,
    <gravisuite:crafting:1> * 4,
    <contenttweaker:carbon_nanotube> * 2,
    <gravisuite:crafting:1> * 4,
    <contenttweaker:carbon_nanotube> * 2,
    <gravisuite:crafting:1> * 4,
    <contenttweaker:carbon_nanotube> * 2
], <contenttweaker:industrial_circuit_v3> * 4, 120.0);
assemblyyj("sensor_v4_plus", 1024000, 600/2, [
    <contenttweaker:infinity_processor> * 1,
    <contenttweaker:industrial_circuit_v3> * 1,
    <ore:stickWillowalloy> * 1,
    <ore:stickWillowalloy> * 1,
    <ore:ingotFallenStarAlloy> * 1,
    <enderutilities:enderpart:12> * 1
], <contenttweaker:sensor_v4> * 2, 1250.0, "beyond_limits");
assemblyyj("electric_motor_v4_plus", 1024000,600/2, [
    <contenttweaker:coil_v4> * 1,
    <contenttweaker:coil_v4> * 1,
    <ore:plateDraconicMetal> * 1,
    <ore:plateDraconicMetal> * 1,
    <contenttweaker:industrial_circuit_v3> * 1,
    <ore:ingotFallenStarAlloy> * 1
], <contenttweaker:electric_motor_v4> * 1, 1000.0, "beyond_limits");
assembly("engineering_battery_v4_plus", 1024000, 600/2, [
    <contenttweaker:engineering_battery_v3> * 1,
    <ore:ingotFallenStarAlloy> * 1,
    <ore:plateDraconicMetal> * 1,
    <contenttweaker:industrial_circuit_v3> * 1,
    <enderio:item_capacitor_stellar> * 1,
    <enderio:item_capacitor_stellar> * 1,
    <enderio:item_capacitor_stellar> * 1,
    <enderio:item_capacitor_stellar> * 1,
    <enderio:item_capacitor_stellar> * 1,
    <enderio:item_capacitor_stellar> * 1,
    <enderio:item_capacitor_stellar> * 1,
    <enderio:item_capacitor_stellar> * 1,
    <enderio:item_capacitor_stellar> * 1
], <contenttweaker:engineering_battery_v4> * 1, 35.0);
assemblyyj("robot_arm_v4_plus", 1024000, 600/2,[
    <contenttweaker:electric_motor_v4> * 1,
    <contenttweaker:electric_motor_v4> * 1,
    <ore:ingotFallenStarAlloy> * 1,
    <contenttweaker:industrial_circuit_v3> * 1
], <contenttweaker:robot_arm_v4> * 1, 1150.0, "beyond_limits");
assembly("circuitEx_plus", 512000, 1200/2, [
    <liquid:crystalloid> * 200,
    <liquid:terrasteel> * 288,
    <liquid:energetic_metal> * 1152,
    <liquid:signalum> * 2304,
    <contenttweaker:industrial_circuit_v2>,
    <contenttweaker:industrial_circuit_v2>,
    <contenttweaker:exponential_level_processor>,
    <contenttweaker:exponential_level_processor>,
    <ore:plateDraconicMetal> * 1,
    <ore:plateDraconicMetal> * 1,
    <ore:plateDraconicMetal> * 1,
    <ore:plateDraconicMetal> * 1
], <additions:novaextended-extremecircuit> * 4, 100.0); 
assemblyyj("infinity_processor_plus", 512000, 1200/2, [
    <liquid:steady_ultra_dense_atomic_matter> * 880,
    <ore:circuitExtreme> * 1,
    <ore:circuitExtreme> * 1,
    <ore:circuitExtreme> * 1,
    <ore:circuitExtreme> * 1,
    <avaritiatweaks:enhancement_crystal> * 1,
    <custommc:item170> * 1
], <contenttweaker:infinity_processor> * 4, 800.0, "beyond_limits");