//Recipes By Hikari_Nova.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import crafttweaker.item.IItemStack;

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;

import mods.modularmachinery.IMachineController;
import mods.modularmachinery.RecipeModifierBuilder;
import mods.modularmachinery.ActiveMachineRecipe;
import mods.modularmachinery.RecipeAdapterBuilder;
import mods.modularmachinery.MachineModifier;

import mods.modularmachinery.MMEvents;
import mods.modularmachinery.MachineTickEvent;
import mods.modularmachinery.RecipeStartEvent;
import mods.modularmachinery.RecipeFinishEvent;
import mods.modularmachinery.ControllerGUIRenderEvent;

// 相位炼化棱镜 —— 控制器
RecipeBuilder.newBuilder("phase_lense_controller", "machine_arm", 1200)
    .addEnergyPerTickInput(256000)
    .addInputs([
        <modularmachinery:large_metallurgical_complex_controller>,
        <enderio:block_enhanced_alloy_smelter> * 12,
        <ore:obsidian> * 64,
        <ore:blockQuartz> * 64,
        <tconstruct:firewood:1> * 48,
        <ebwizardry:magic_crystal:1> * 24,
        <modularmachinery:blockcasing>,
    ])
    .addOutput(<modularmachinery:phaselense_controller>)
    .requireResearch("phaselense")
    .build();

// 时钟座星图
val horologiumStellationPaper = <custommc:item129>.withTag({display: {Lore: ["§f诡异的§e时钟座§f隐藏在时间的各个角落中，无法§b以普通形式§f观测", "§f利用五大星座的星图作为线索，你成功观测到了§e时钟座。", "§f吸纳了§5奥力哈钢§f的§e时钟座§6星图§f有着超越时间的力量，任何以它指引的星能机器将§b不分昼夜的运行。"], Name: "§e时钟座§6星图"}});
// 天炉座星图
val celestialFurnaceStellationPaper = <custommc:item833>.withTag({display: {Lore: ["§f只在§b亏凸月§f和§b盈凸月§f时可被观测到的§6天炉座", "§f在月亮背后绽放着§6烈火§f般的璀璨光彩。", "§b相位炼化棱镜§f需此星图方能利用§6天炉座§f的炽热高温。"], Name: "§6天炉座§f星图"}});

//设置最大并行数
MachineModifier.setInternalParallelism("phaselense", 16);
MachineModifier.setMaxParallelism("phaselense", 256);

// 相位炼化棱镜：配方继承
# 时钟座 + 天炉座
RecipeAdapterBuilder.create("phaselense", "nuclearcraft:alloy_furnace")
    .addModifier(RecipeModifierBuilder.create("modularmachinery:duration", "input", 0.05, 1, false).build())
    .addModifier(RecipeModifierBuilder.create("modularmachinery:energy",   "input", 1000, 1, false).build())
    .addInput(celestialFurnaceStellationPaper).setChance(0).setParallelizeUnaffected(true)
    .addInput(horologiumStellationPaper).setChance(0).setParallelizeUnaffected(true)
    .build();

# 天炉座
RecipeAdapterBuilder.create("phaselense", "nuclearcraft:alloy_furnace")
    .addModifier(RecipeModifierBuilder.create("modularmachinery:duration", "input", 0.05, 1, false).build())
    .addModifier(RecipeModifierBuilder.create("modularmachinery:energy",   "input", 1000, 1, false).build())
    .addInput(celestialFurnaceStellationPaper).setChance(0).setParallelizeUnaffected(true)
    .setTime(13000, 23999)
    .build();

// 相位炼化棱镜：机制系统
MMEvents.onMachinePostTick("phaselense", function(event as MachineTickEvent) {
    val controller = event.controller;
    val data = controller.customData;
    val map = data.asMap();

    val machineTemp = isNull(data.temperature) ? 300.0F : data.temperature as float;
    val newTemp = machineTemp + (controller.isWorking ? increaseTemperature(machineTemp) : -decreaseTemperature(machineTemp));
    if (newTemp != machineTemp) {
        data.memberSet("temperature", newTemp);
        controller.customData = data;
        val modifier as float = min(1500 as float / machineTemp, 2.5);
        controller.addPermanentModifier("efficiency", RecipeModifierBuilder.create("modularmachinery:duration", "input", modifier, 1, false).build());
    }
});

MMEvents.onControllerGUIRender("phaselense", function(event as ControllerGUIRenderEvent) {
    val controller = event.controller;
    val data = controller.customData;
    val machineTemp = isNull(data.temperature) ? 300.0F : data.temperature as float;
    val modifier as float = min(1500 as float / machineTemp, 2.5) * 100;
    var info as string[] = [
        "§e炉心温度：§c" + (((machineTemp * 10) as int) as float) / 10 + "K",
        "§e烧制时间乘数：" + (modifier >= 100 ? "§c" : "§a") + (((modifier * 100) as int) as float) / 100 + "%",
    ];
    if (machineTemp <= 1500) {
        info += machineTemp <= 1000 ? "§e警告：温度偏低。" : "§e警告：温度过低。";
    }

    event.extraInfo = info;
});

function min(a as float, b as float) as float {
    return a <= b ? a : b;
}

function max(a as float, b as float) as float {
    return a >= b ? a : b;
}

function increaseTemperature(temperature as float) as float {
    if (temperature >= 7500) {
        return 0 as float;
    } else if (temperature >= 4000) {
        return 0.5 as float;
    } else if (temperature >= 1500) {
        return 1 as float;
    } else {
        return 2 as float;
    }
}

function decreaseTemperature(temperature as float) as float {
    if (temperature >= 5000) {
        return 1.5 as float;
    } else if (temperature >= 2500) {
        return 1 as float;
    } else if (temperature >= 300) {
        return 0.5 as float;
    } else {
        return 0 as float;
    }
}