//Recipes By Hikari_Nova & Arco_Iris.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.MachineModifier;
import mods.modularmachinery.RecipeAdapterBuilder;
import mods.modularmachinery.RecipeModifierBuilder;

import novaeng.hypernet.HyperNetHelper;

HyperNetHelper.proxyMachineForHyperNet("iridescentobservatory");

// 五彩观象台控制器
RecipeBuilder.newBuilder("iridescentobservatory_controller", "machine_arm", 2400)
    .addEnergyPerTickInput(384000)
    .addInputs([
        <contenttweaker:sensor_v1> * 48,
        <ore:manaDiamond> * 48,
        <ore:elvenDragonstone> * 24,
        <ore:manaPearl> * 48,
        <ore:elvenPixieDust> * 24,
        <astralsorcery:blockaltar:3> * 1,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:iridescentobservatory_controller> * 1)
    .requireResearch("iridescentobservatory")
    .build();

// 相位灌注机控制器
RecipeBuilder.newBuilder("phaseinsolator_controller", "machine_arm", 2400)
    .addEnergyPerTickInput(384000)
    .addInputs([
        <contenttweaker:sensor_v1> * 24,
        <immersiveengineering:metal_device1:13> * 8,
        <astralsorcery:blocktreebeacon> * 4,
        <ore:goldweave> * 4,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:phaseinsolator_factory_controller> * 1)
    .requireResearch("phaseinsolator")
    .build();

// 相位构筑仪控制器
RecipeBuilder.newBuilder("stellaformer_controller", "machine_arm", 3200)
    .addEnergyPerTickInput(768000)
    .addInputs([
        <contenttweaker:industrial_circuit_v2> * 16,
        <contenttweaker:field_generator_v1> * 16,
        <contenttweaker:sensor_v2> * 12,
        <minecraft:quartz_block> * 48,
        <minecraft:obsidian> * 48,
        <avaritia:resource:1> * 8,
        <modularmachinery:ion_generator_controller> * 2,
    ])
    .addOutputs(<modularmachinery:stellaformer_controller> * 1)
    .requireResearch("stellaformer")
    .build();

// 星能发电机
RecipeBuilder.newBuilder("stellargenerator_controller", "machine_arm", 4000)
    .addEnergyPerTickInput(1024000)
    .addInput(<astralsorcery:itemcelestialcrystal>.withTag({
        astralsorcery: {
            crystalProperties: {
                purity: 100
            }
        }
    })).setPreViewNBT({
        astralsorcery: {
            crystalProperties: {
                collectiveCapability: 0, size: 900, fract: 0, purity: 0, sizeOverride: -1
            }
        },
        display: {
            Lore: [
                "§e水晶石要求纯度 100%，其他属性不限。",
            ],
        }
    }).setChance(0)
    .addInputs([
        <contenttweaker:industrial_circuit_v2> * 12,
        <contenttweaker:field_generator_v1> * 24,
        <contenttweaker:sensor_v2> * 12,
        <gravisuite:crafting:1> * 48,
        <minecraft:quartz_block> * 48,
        <modularmachinery:blockcasing>,
    ])
    .addOutputs(<modularmachinery:stellargenerator_controller> * 1)
    .requireResearch("stellargenerator")
    .build();

# 麒麟座星图
RecipeBuilder.newBuilder("monoceros", "iridescentobservatory", 10000)
    .addEnergyPerTickInput(6400)
    .setTime(13000, 23999)
    .setMoonPhase([4])
    .addInputs([
        <ore:gemCrystalFlux> * 64,
        <ore:blockPsiGem> * 4,
        <botania:storage:4> * 4,
        <botania:storage:2> * 4,
        <ore:paper> * 1,
    ])
    .addOutputs(<custommc:item833>.withTag({
        display: {
            Lore: [
                "§d麒麟座§f只会在§b新月§f出现。",
                "§f机敏的§d麒麟§f遨游宇宙，所有§9天体§f尽收眼底。",
                "§d相位§f引星塔需此星图从§9无垠宇宙中§f牵引§8陨石§f与§8陨铁§f。"
            ],
            Name: "§d麒麟座§f星图"
        }
    }))
    .build();
