import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.RecipeModifierBuilder;
import novaeng.hypernet.HyperNetHelper;
import novaeng.hypernet.RegistryHyperNet;
import novaeng.hypernet.research.ResearchCognitionData;
import mods.modularmachinery.MachineModifier;

var recipeCounter = 1;
var counter = 1;

HyperNetHelper.proxyMachineForHyperNet("falling_star");

//控制器合成
RecipeBuilder.newBuilder("zhuixing", "machine_arm", 800, recipeCounter, false)
    .addEnergyPerTickInput(512000)
    .addInputs([
        <liquid:lifeessence> * 256000,
        <contenttweaker:cxyunshi> * 1,
        <bloodmagic:ritual_stone> * 108,
        <bloodmagic:ritual_controller> * 1,
        <bloodmagic:activation_crystal:1> * 1,
        <contenttweaker:lifesense_processor> * 16,
        <bloodmagic:decorative_brick> * 64,
    ])
    .addOutputs(<modularmachinery:falling_star_controller> * 1)
    .requireResearch("zhuixing")
    .build();
recipeCounter += 1;

//研究
RegistryHyperNet.addResearchCognitionData(ResearchCognitionData.create("zhuixing", "星辰天降(?)",
        <appliedenergistics2:sky_stone_block>,    // 预览物品
        6.8,                                 // 科技等级（难度）
        2520000,                          // 需要科研点
        105.0F,                               // 最低每 Tick 算力要求
        [
            "在陨星事故之后，非官方的坠星仪式一度被完全禁止",
            "不过，Circulation在古籍里发现了一种神秘的仪式，如今的帝国并无踪迹",
            "这种仪式可以修正坠星仪式的结果，防止它破坏环境，但是尝试直接搭建仪式并且激活的尝试失败了",
            "根据生命灵气科的研究，这个仪式在如今无法激活的原因是缺少了一些古代连空气中都逸散的物质",
            "也许科技的力量可以弥补这部分？不过这就需要实验才能证明了",
        ],
        [
            "§2解锁工业机械臂配方：§6§l唤星位标§r§5仪式构建器",
            "灌输进大量的生命源质",
            "以注入恶魔意志的金属稳定其结构",
            "使用催化剂来使仪式展开",
            "所以为什么陨石没砸下来，但是地底的矿脉被改变了？————Nova这般询问到",
            "这不好吗，陨石多破坏环境啊————被Nova一拳打飞的Circulation",
            "§2§o文案：Circulation",
        ],
        [
            "precision_assembler",
            "machine_arm",                                 // 前置科技
        ]
));
//催化剂配方
mods.avaritia.Compressor.add("yunshi",<contenttweaker:yunshi>, -450, <appliedenergistics2:sky_stone_block>);
mods.bloodmagic.BloodAltar.addRecipe(<contenttweaker:cxyunshi>,<contenttweaker:yunshi>,3,1000000,2000,0);
//配方

RecipeBuilder.newBuilder("Os", "falling_star", 40, recipeCounter, false)
    .addLifeEssenceInput(100000,true)
    .addInput(<mekanism:basicblock> * 32)                       .setTag("cailiao")
        .setPreViewNBT({display:{Lore:["§6放入控制器左方的材料输入仓方可识别"]}})
    .addInput(<contenttweaker:cxyunshi> * 1)                      .setTag("cuihua") .setChance(0.08) 
        .setPreViewNBT({display:{Lore:["§6放入控制器右方的催化剂输入仓方可识别"]}})
    .addOutputs(<contenttweaker:huanxing1> * 1)
    .requireComputationPoint(400.0F)
    .requireResearch("zhuixing")
    .addRecipeTooltip("§4注意你的LP存储，这个配方需要§6400万LP§4来完成！")
    .addRecipeTooltip("§4放置§5晶簇块§4来减少配方时间与LP的消耗")
    .build();
recipeCounter += 1;

RecipeBuilder.newBuilder("LT", "falling_star", 20, recipeCounter, false)
    .addLifeEssenceInput(100000,true)
    .addInput(<thermalfoundation:storage> * 32)                       .setTag("cailiao")
        .setPreViewNBT({display:{Lore:["§6放入控制器左方的材料输入仓方可识别"]}})
    .addInput(<contenttweaker:cxyunshi> * 1)                      .setTag("cuihua") .setChance(0.04) 
        .setPreViewNBT({display:{Lore:["§6放入控制器右方的催化剂输入仓方可识别"]}})
    .addOutputs(<contenttweaker:huanxing2> * 1)
    .requireComputationPoint(200.0F)
    .requireResearch("zhuixing")
    .addRecipeTooltip("§4注意你的LP存储，这个配方需要§6200万LP§4来完成！")
    .addRecipeTooltip("§4放置§5晶簇块§4来减少配方时间与LP的消耗")
    .build();
recipeCounter += 1;

RecipeBuilder.newBuilder("STS", "falling_star", 40, recipeCounter, false)
    .addLifeEssenceInput(100000,true)
    .addInput(<appliedenergistics2:quartz_block> * 32)                       .setTag("cailiao")
        .setPreViewNBT({display:{Lore:["§6放入控制器左方的材料输入仓方可识别"]}})
    .addInput(<contenttweaker:cxyunshi> * 1)                      .setTag("cuihua") .setChance(0.08) 
        .setPreViewNBT({display:{Lore:["§6放入控制器右方的催化剂输入仓方可识别"]}})
    .addOutputs(<contenttweaker:huanxing3> * 1)
    .requireComputationPoint(400.0F)
    .requireResearch("zhuixing")
    .addRecipeTooltip("§4注意你的LP存储，这个配方需要§6400万LP§4来完成！")
    .addRecipeTooltip("§4放置§5晶簇块§4来减少配方时间与LP的消耗")
    .build();
recipeCounter += 1;

RecipeBuilder.newBuilder("XJSY", "falling_star", 5, recipeCounter, false)
    .addLifeEssenceInput(100000,true)
    .addInput(<minecraft:quartz_block> * 32)                       .setTag("cailiao")
        .setPreViewNBT({display:{Lore:["§6放入控制器左方的材料输入仓方可识别"]}})
    .addInput(<contenttweaker:cxyunshi> * 1)                      .setTag("cuihua") .setChance(0.01) 
        .setPreViewNBT({display:{Lore:["§6放入控制器右方的催化剂输入仓方可识别"]}})
    .addOutputs(<contenttweaker:huanxing4> * 1)
    .requireComputationPoint(50.0F)
    .requireResearch("zhuixing")
    .addRecipeTooltip("§4注意你的LP存储，这个配方需要§650万LP§4来完成！")
    .addRecipeTooltip("§4放置§5晶簇块§4来减少配方时间与LP的消耗")
    .build();
recipeCounter += 1;

RecipeBuilder.newBuilder("CHK", "falling_star", 100, recipeCounter, false)
    .addLifeEssenceInput(100000,true)
    .addInput(<futuremc:ancient_debris> * 16)                       .setTag("cailiao")
        .setPreViewNBT({display:{Lore:["§6放入控制器左方的材料输入仓方可识别"]}})
    .addInput(<contenttweaker:cxyunshi> * 1)                      .setTag("cuihua") .setChance(0.5) 
        .setPreViewNBT({display:{Lore:["§6放入控制器右方的催化剂输入仓方可识别"]}})
    .addOutputs(<contenttweaker:huanxing5> * 1)
    .requireComputationPoint(1000.0F)
    .requireResearch("zhuixing")
    .addRecipeTooltip("§4注意你的LP存储，这个配方需要§61000万LP§4来完成！")
    .addRecipeTooltip("§4放置§5晶簇块§4来减少配方时间与LP的消耗")
    .build();
recipeCounter += 1;

RecipeBuilder.newBuilder("CHK", "falling_star", 50, recipeCounter, false)
    .addLifeEssenceInput(100000,true)
    .addInput(<ore:blockManyullyn>  * 32)                       .setTag("cailiao")
        .setPreViewNBT({display:{Lore:["§6放入控制器左方的材料输入仓方可识别"]}})
    .addInput(<contenttweaker:cxyunshi> * 1)                      .setTag("cuihua") .setChance(0.1) 
        .setPreViewNBT({display:{Lore:["§6放入控制器右方的催化剂输入仓方可识别"]}})
    .addOutputs(<contenttweaker:huanxing6> * 1)
    .requireComputationPoint(500.0F)
    .requireResearch("zhuixing")
    .addRecipeTooltip("§4注意你的LP存储，这个配方需要§6500万LP§4来完成！")
    .addRecipeTooltip("§4放置§5晶簇块§4来减少配方时间与LP的消耗")
    .build();
recipeCounter += 1;

RecipeBuilder.newBuilder("XZ", "falling_star", 5, recipeCounter, false)
    .addLifeEssenceInput(100000,true)
    .addInput(<thermalfoundation:material:895>  * 32)                       .setTag("cailiao")
        .setPreViewNBT({display:{Lore:["§6放入控制器左方的材料输入仓方可识别"]}})
    .addInput(<contenttweaker:cxyunshi> * 1)                      .setTag("cuihua") .setChance(0.01) 
        .setPreViewNBT({display:{Lore:["§6放入控制器右方的催化剂输入仓方可识别"]}})
    .addOutputs(<contenttweaker:huanxing7> * 1)
    .requireComputationPoint(50.0F)
    .requireResearch("zhuixing")
    .addRecipeTooltip("§4注意你的LP存储，这个配方需要§650万LP§4来完成！")
    .addRecipeTooltip("§4放置§5晶簇块§4来减少配方时间与LP的消耗")
    .build();
recipeCounter += 1;

RecipeBuilder.newBuilder("CT", "falling_star", 20, recipeCounter, false)
    .addLifeEssenceInput(100000,true)
    .addInput(<minecraft:iron_block>  * 32)                       .setTag("cailiao")
        .setPreViewNBT({display:{Lore:["§6放入控制器左方的材料输入仓方可识别"]}})
    .addInput(<contenttweaker:cxyunshi> * 1)                      .setTag("cuihua") .setChance(0.04) 
        .setPreViewNBT({display:{Lore:["§6放入控制器右方的催化剂输入仓方可识别"]}})
    .addOutputs(<contenttweaker:huanxing8> * 1)
    .requireComputationPoint(200.0F)
    .requireResearch("zhuixing")
    .addRecipeTooltip("§4注意你的LP存储，这个配方需要§6200万LP§4来完成！")
    .addRecipeTooltip("§4放置§5晶簇块§4来减少配方时间与LP的消耗")
    .build();
recipeCounter += 1;

RecipeBuilder.newBuilder("MT", "falling_star", 40, recipeCounter, false)
    .addLifeEssenceInput(100000,true)
    .addInput(<ore:blockCoal>  * 32)                       .setTag("cailiao")
        .setPreViewNBT({display:{Lore:["§6放入控制器左方的材料输入仓方可识别"]}})
    .addInput(<contenttweaker:cxyunshi> * 1)                      .setTag("cuihua") .setChance(0.08) 
        .setPreViewNBT({display:{Lore:["§6放入控制器右方的催化剂输入仓方可识别"]}})
    .addOutputs(<contenttweaker:huanxing9> * 1)
    .requireComputationPoint(400.0F)
    .requireResearch("zhuixing")
    .addRecipeTooltip("§4注意你的LP存储，这个配方需要§6400万LP§4来完成！")
    .addRecipeTooltip("§4放置§5晶簇块§4来减少配方时间与LP的消耗")
    .build();
recipeCounter += 1;

RecipeBuilder.newBuilder("XC", "falling_star", 15, recipeCounter, false)
    .addLifeEssenceInput(100000,true)
    .addInput(<ore:blockEmerald>  * 32)                       .setTag("cailiao")
        .setPreViewNBT({display:{Lore:["§6放入控制器左方的材料输入仓方可识别"]}})
    .addInput(<contenttweaker:cxyunshi> * 1)                      .setTag("cuihua") .setChance(0.03) 
        .setPreViewNBT({display:{Lore:["§6放入控制器右方的催化剂输入仓方可识别"]}})
    .addOutputs(<contenttweaker:huanxing10> * 1)
    .requireComputationPoint(150.0F)
    .requireResearch("zhuixing")
    .addRecipeTooltip("§4注意你的LP存储，这个配方需要§6150万LP§4来完成！")
    .addRecipeTooltip("§4放置§5晶簇块§4来减少配方时间与LP的消耗")
    .build();
recipeCounter += 1;

RecipeBuilder.newBuilder("QY", "falling_star", 30, recipeCounter, false)
    .addLifeEssenceInput(100000,true)
    .addInput(<jaopca:block_blockwillowalloy>  * 32)                       .setTag("cailiao")
        .setPreViewNBT({display:{Lore:["§6放入控制器左方的材料输入仓方可识别"]}})
    .addInput(<contenttweaker:cxyunshi> * 1)                      .setTag("cuihua") .setChance(0.06) 
        .setPreViewNBT({display:{Lore:["§6放入控制器右方的催化剂输入仓方可识别"]}})
    .addOutputs(<contenttweaker:huanxing11> * 1)
    .requireComputationPoint(300.0F)
    .requireResearch("zhuixing")
    .addRecipeTooltip("§4注意你的LP存储，这个配方需要§6300万LP§4来完成！")
    .addRecipeTooltip("§4放置§5晶簇块§4来减少配方时间与LP的消耗")
    .build();
recipeCounter += 1;

RecipeBuilder.newBuilder("met", "falling_star", 50, recipeCounter, false)
    .addLifeEssenceInput(100000,true)
    .addInput(<mets:super_lapotron_crystal> * 4)                       .setTag("cailiao")
        .setPreViewNBT({display:{Lore:["§6放入控制器左方的材料输入仓方可识别"]}})
    .addInput(<contenttweaker:cxyunshi> * 1)                      .setTag("cuihua") .setChance(0.1) 
        .setPreViewNBT({display:{Lore:["§6放入控制器右方的催化剂输入仓方可识别"]}})
    .addOutputs(<contenttweaker:huanxing12> * 1)
    .requireComputationPoint(500.0F)
    .requireResearch("zhuixing")
    .addRecipeTooltip("§4注意你的LP存储，这个配方需要§6500万LP§4来完成！")
    .addRecipeTooltip("§4放置§5晶簇块§4来减少配方时间与LP的消耗")
    .build();
recipeCounter += 1;

RecipeBuilder.newBuilder("pl", "falling_star", 30, recipeCounter, false)
    .addLifeEssenceInput(100000,true)
    .addInput(<ore:blockPlatinum> * 32)                       .setTag("cailiao")
        .setPreViewNBT({display:{Lore:["§6放入控制器左方的材料输入仓方可识别"]}})
    .addInput(<contenttweaker:cxyunshi> * 1)                      .setTag("cuihua") .setChance(0.06) 
        .setPreViewNBT({display:{Lore:["§6放入控制器右方的催化剂输入仓方可识别"]}})
    .addOutputs(<contenttweaker:huanxing13> * 1)
    .requireComputationPoint(300.0F)
    .requireResearch("zhuixing")
    .addRecipeTooltip("§4注意你的LP存储，这个配方需要§6300万LP§4来完成！")
    .addRecipeTooltip("§4放置§5晶簇块§4来减少配方时间与LP的消耗")
    .build();
recipeCounter += 1;

RecipeBuilder.newBuilder("Sn", "falling_star", 20, recipeCounter, false)
    .addLifeEssenceInput(100000,true)
    .addInput(<ore:blockTin> * 32)                       .setTag("cailiao")
        .setPreViewNBT({display:{Lore:["§6放入控制器左方的材料输入仓方可识别"]}})
    .addInput(<contenttweaker:cxyunshi> * 1)                      .setTag("cuihua") .setChance(0.04) 
        .setPreViewNBT({display:{Lore:["§6放入控制器右方的催化剂输入仓方可识别"]}})
    .addOutputs(<contenttweaker:huanxing14> * 1)
    .requireComputationPoint(200.0F)
    .requireResearch("zhuixing")
    .addRecipeTooltip("§4注意你的LP存储，这个配方需要§6200万LP§4来完成！")
    .addRecipeTooltip("§4放置§5晶簇块§4来减少配方时间与LP的消耗")
    .build();
recipeCounter += 1;

RecipeBuilder.newBuilder("NC", "falling_star", 20, recipeCounter, false)
    .addLifeEssenceInput(100000,true)
    .addInput(<nuclearcraft:quantum_computer_controller> * 8)                       .setTag("cailiao")
        .setPreViewNBT({display:{Lore:["§6放入控制器左方的材料输入仓方可识别"]}})
    .addInput(<contenttweaker:cxyunshi> * 1)                      .setTag("cuihua") .setChance(0.04) 
        .setPreViewNBT({display:{Lore:["§6放入控制器右方的催化剂输入仓方可识别"]}})
    .addOutputs(<contenttweaker:huanxing15> * 1)
    .requireComputationPoint(200.0F)
    .requireResearch("zhuixing")
    .addRecipeTooltip("§4注意你的LP存储，这个配方需要§6200万LP§4来完成！")
    .addRecipeTooltip("§4放置§5晶簇块§4来减少配方时间与LP的消耗")
    .build();
recipeCounter += 1;

RecipeBuilder.newBuilder("U238", "falling_star", 25, recipeCounter, false)
    .addLifeEssenceInput(100000,true)
    .addInput(<ore:blockUranium> * 32)                       .setTag("cailiao")
        .setPreViewNBT({display:{Lore:["§6放入控制器左方的材料输入仓方可识别"]}})
    .addInput(<contenttweaker:cxyunshi> * 1)                      .setTag("cuihua") .setChance(0.05) 
        .setPreViewNBT({display:{Lore:["§6放入控制器右方的催化剂输入仓方可识别"]}})
    .addOutputs(<contenttweaker:huanxing16> * 1)
    .requireComputationPoint(250.0F)
    .requireResearch("zhuixing")
    .addRecipeTooltip("§4注意你的LP存储，这个配方需要§6250万LP§4来完成！")
    .addRecipeTooltip("§4放置§5晶簇块§4来减少配方时间与LP的消耗")
    .build();
recipeCounter += 1;

RecipeBuilder.newBuilder("Al", "falling_star", 50, recipeCounter, false)
    .addLifeEssenceInput(100000,true)
    .addInput(<thermalfoundation:storage:4> * 32)                       .setTag("cailiao")
        .setPreViewNBT({display:{Lore:["§6放入控制器左方的材料输入仓方可识别"]}})
    .addInput(<contenttweaker:cxyunshi> * 1)                      .setTag("cuihua") .setChance(0.1) 
        .setPreViewNBT({display:{Lore:["§6放入控制器右方的催化剂输入仓方可识别"]}})
    .addOutputs(<contenttweaker:huanxing17> * 1)
    .requireComputationPoint(500.0F)
    .requireResearch("zhuixing")
    .addRecipeTooltip("§4注意你的LP存储，这个配方需要§6500万LP§4来完成！")
    .addRecipeTooltip("§4放置§5晶簇块§4来减少配方时间与LP的消耗")
    .build();
recipeCounter += 1;

RecipeBuilder.newBuilder("TAIGA", "falling_star", 50, recipeCounter, false)
    .addLifeEssenceInput(100000,true)
    .addInput(<taiga:vibranium_block> * 16)                       .setTag("cailiao")
        .setPreViewNBT({display:{Lore:["§6放入控制器左方的材料输入仓方可识别"]}})
    .addInput(<contenttweaker:cxyunshi> * 1)                      .setTag("cuihua") .setChance(0.1) 
        .setPreViewNBT({display:{Lore:["§6放入控制器右方的催化剂输入仓方可识别"]}})
    .addOutputs(<contenttweaker:huanxing18> * 1)
    .requireComputationPoint(500.0F)
    .requireResearch("zhuixing")
    .addRecipeTooltip("§4注意你的LP存储，这个配方需要§6500万LP§4来完成！")
    .addRecipeTooltip("§4放置§5晶簇块§4来减少配方时间与LP的消耗")
    .build();
recipeCounter += 1;

RecipeBuilder.newBuilder("BS", "falling_star", 10, recipeCounter, false)
    .addLifeEssenceInput(100000,true)
    .addInput(<biomesoplenty:biome_essence> * 4)                       .setTag("cailiao")
        .setPreViewNBT({display:{Lore:["§6放入控制器左方的材料输入仓方可识别"]}})
    .addInput(<contenttweaker:cxyunshi> * 1)                      .setTag("cuihua") .setChance(0.02) 
        .setPreViewNBT({display:{Lore:["§6放入控制器右方的催化剂输入仓方可识别"]}})
    .addOutputs(<contenttweaker:huanxing19> * 1)
    .requireComputationPoint(100.0F)
    .requireResearch("zhuixing")
    .addRecipeTooltip("§4注意你的LP存储，这个配方需要§6100万LP§4来完成！")
    .addRecipeTooltip("§4放置§5晶簇块§4来减少配方时间与LP的消耗")
    .build();
recipeCounter += 1;

RecipeBuilder.newBuilder("yixing", "falling_star", 300, recipeCounter, false)
    .addLifeEssenceInput(100000,true)
    .addInput(<modularmachinery:phase_planet_traction_tower_controller> * 1)                       .setTag("cailiao")
        .setPreViewNBT({display:{Lore:["§6放入控制器左方的材料输入仓方可识别"]}})
    .addInput(<contenttweaker:cxyunshi> * 1)                      .setTag("cuihua") .setChance(0.7) 
        .setPreViewNBT({display:{Lore:["§6放入控制器右方的催化剂输入仓方可识别"]}})
    .addOutputs(<contenttweaker:huanxing20> * 1)
    .requireComputationPoint(1000.0F)
    .requireResearch("zhuixing")
    .addRecipeTooltip("§4注意你的LP存储，这个配方需要§63000万LP§4来完成！")
    .addRecipeTooltip("§4放置§5晶簇块§4来减少配方时间与LP的消耗")
    .build();
recipeCounter += 1;

RecipeBuilder.newBuilder("KJH", "falling_star", 50, recipeCounter, false)
    .addLifeEssenceInput(100000,true)
    .addInput(<minecraft:prismarine_crystals> * 32)                       .setTag("cailiao")
        .setPreViewNBT({display:{Lore:["§6放入控制器左方的材料输入仓方可识别"]}})
    .addInput(<contenttweaker:cxyunshi> * 1)                      .setTag("cuihua") .setChance(0.1) 
        .setPreViewNBT({display:{Lore:["§6放入控制器右方的催化剂输入仓方可识别"]}})
    .addOutputs(<contenttweaker:huanxing21> * 1)
    .requireComputationPoint(500.0F)
    .requireResearch("zhuixing")
    .addRecipeTooltip("§4注意你的LP存储，这个配方需要§6500万LP§4来完成！")
    .addRecipeTooltip("§4放置§5晶簇块§4来减少配方时间与LP的消耗")
    .build();
recipeCounter += 1;

RecipeBuilder.newBuilder("YG", "falling_star", 10, recipeCounter, false)
    .addLifeEssenceInput(100000,true)
    .addInput(<minecraft:glowstone> * 32)                       .setTag("cailiao")
        .setPreViewNBT({display:{Lore:["§6放入控制器左方的材料输入仓方可识别"]}})
    .addInput(<contenttweaker:cxyunshi> * 1)                      .setTag("cuihua") .setChance(0.02) 
        .setPreViewNBT({display:{Lore:["§6放入控制器右方的催化剂输入仓方可识别"]}})
    .addOutputs(<contenttweaker:huanxing22> * 1)
    .requireComputationPoint(100.0F)
    .requireResearch("zhuixing")
    .addRecipeTooltip("§4注意你的LP存储，这个配方需要§6100万LP§4来完成！")
    .addRecipeTooltip("§4放置§5晶簇块§4来减少配方时间与LP的消耗")
    .build();
recipeCounter += 1;