import crafttweaker.data.IData;
import crafttweaker.enchantments.IEnchantment;
import crafttweaker.item.IItemStack;
import mods.nuclearcraft.AlloyFurnace;
import moretweaker.draconicevolution.FusionCrafting;
import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.MachineModifier;
import mods.modularmachinery.FactoryRecipeThread;
import novaeng.hypernet.HyperNetHelper;
import novaeng.hypernet.RegistryHyperNet;
import novaeng.hypernet.research.ResearchCognitionData;
import crafttweaker.item.IIngredient;
import crafttweaker.liquid.ILiquidStack;
import mod.mekanism.gas.IGasStack;
import mods.modularmachinery.RecipeAdapterBuilder;
import mods.modularmachinery.RecipeModifierBuilder;
import crafttweaker.item.IItemDefinition;
import mods.modularmachinery.RecipeFinishEvent;
import crafttweaker.events.IEventManager;
import mods.modularmachinery.MMEvents;
import mods.modularmachinery.MachineTickEvent;
import mods.modularmachinery.RecipeStartEvent;
import mods.modularmachinery.ControllerGUIRenderEvent;
import crafttweaker.event.EntityLivingDeathEvent;
import mods.modularmachinery.MachineStructureFormedEvent;
import crafttweaker.event.ItemTossEvent;
import crafttweaker.event.EntityJoinWorldEvent;
import crafttweaker.entity.IEntityItem;
import crafttweaker.world.IBlockPos;
import crafttweaker.util.Math;
import mods.thermalexpansion.InductionSmelter;
import mods.modularmachinery.Sync;
import crafttweaker.world.IWorld;
import mods.modularmachinery.RecipeCheckEvent;
import mods.modularmachinery.IMachineController;
import mods.modularmachinery.SmartInterfaceType;
import mods.modularmachinery.RecipeModifier;
import mods.modularmachinery.FactoryRecipeStartEvent;
import mods.modularmachinery.FactoryRecipeTickEvent;
import mods.modularmachinery.FactoryRecipeFinishEvent;
import mods.modularmachinery.MachineController;
import novaeng.NovaEngUtils;
import mods.modularmachinery.RecipeEvent;
import mods.modularmachinery.RecipeTickEvent;
import mods.modularmachinery.MachineStructureUpdateEvent;

var recipeCounter= 1;
//==============================血之祭坛==============================
//合成
recipes.addShaped(<modularmachinery:xzjt_factory_controller>, [[<modularmachinery:blockcasing>, <bloodmagic:blood_rune>, <modularmachinery:blockcasing>],[<bloodmagic:blood_rune>, <bloodmagic:altar>, <bloodmagic:blood_rune>], [<modularmachinery:blockcasing>, <bloodmagic:blood_rune>, <modularmachinery:blockcasing>]]);
// 工厂线程数设置
MachineModifier.setMaxThreads("xzjt", 0);
MachineModifier.addCoreThread("xzjt", FactoryRecipeThread.createCoreThread("血之合成"));
MachineModifier.addCoreThread("xzjt", FactoryRecipeThread.createCoreThread("血液注入"));
MachineModifier.addCoreThread("xzjt", FactoryRecipeThread.createCoreThread("血液输出"));
MachineModifier.addCoreThread("xzjt", FactoryRecipeThread.createCoreThread("祭坛同步器"));
MachineModifier.addCoreThread("xzjt", FactoryRecipeThread.createCoreThread("灵魂网络链接维持"));
MachineModifier.setInternalParallelism("xzjt", 256);

//参数设置
MMEvents.onStructureUpdate("xzjt", function(event as MachineStructureUpdateEvent) {
    val ctrl = event.controller;
    val data = ctrl.customData;
    val dData = D(data);
    val map = data.asMap();
    val sdfw = ctrl.getBlocksInPattern(<bloodmagic:blood_rune:1>);
    val xjfw = ctrl.getBlocksInPattern(<bloodmagic:blood_rune:3>);
    val zrfw = ctrl.getBlocksInPattern(<bloodmagic:blood_rune:6>);
    val zwfw = ctrl.getBlocksInPattern(<bloodmagic:blood_rune:5>);
    val crfw = ctrl.getBlocksInPattern(<bloodmagic:blood_rune:7>);
    val cjfw = ctrl.getBlocksInPattern(<bloodmagic:blood_rune:9>);
    val sjjz = ctrl.getBlocksInPattern(<contenttweaker:crystalmatrixforcefieldcontrolblock>);
    val lxhj = ctrl.getBlocksInPattern(<contenttweaker:fallenstarforcefieldcontrolblock>);
    val hyjz = ctrl.getBlocksInPattern(<contenttweaker:universalforcefieldcontrolblock>);
    val world=ctrl.world;
    val pos=ctrl.pos;
    val zrsl = 1*Math.clamp(cjfw, 0, 19);
    var jtdj = 0;
    var cpdj = 0;

    val x = ctrl.pos.x;
    val y = ctrl.pos.y;
    val z = ctrl.pos.z;
    val block = world.getBlock(x,y - 4,z);
    val jtdata = block.data;
    val jtxy  = block.data.bloodAltar.upgradeLevel;
    val ccjx  = block.data.bloodAltar.capacity;
        
    if (jtxy == "ONE"){jtdj += 1;}
    if (jtxy == "TWO"){jtdj += 2;}
    if (jtxy == "THREE"){jtdj += 3;}
    if (jtxy == "FOUR"){jtdj += 4;}
    if (jtxy == "FIVE"){jtdj += 5;}
    if (jtxy == "SIX"){jtdj += 6;}
    if (sjjz == 8){cpdj += 1;}
    if (lxhj == 4){cpdj += 1;}
    if (hyjz == 4){cpdj += 2;jtdj += 1;}

    map["sdfw"] = sdfw;
    map["xjfw"] = xjfw;
    map["zwfw"] = zwfw;
    map["crfw"] = crfw;
    map["cjfw"] = zrsl;
    map["zrfw"] = zrfw;
    map["zrfw"] = zrfw;
    map["ccjx"] = ccjx;
    map["jtdj"] = jtdj;
    map["cpdj"] = cpdj;

    ctrl.customData = data;
});

//添加控制器 GUI 信息
//血之祭坛
MMEvents.onControllerGUIRender("xzjt", function(event as ControllerGUIRenderEvent) {
    val ctrl = event.controller;
    val data = ctrl.customData;
    val dData = D(data);
    val map = data.asMap();
    val sdfw = dData.getInt("sdfw", 0);
    val xjfw = dData.getInt("xjfw", 0);
    val zwfw = dData.getInt("zwfw", 0);
    val crfw = dData.getInt("crfw", 0);
    val cjfw = dData.getInt("cjfw", 0);
    val zrfw = dData.getInt("zrfw", 0);
    val ccjx = dData.getInt("ccjx", 0);
    val xycc = dData.getInt("xycc", 0);
    val cpdj = dData.getInt("cpdj", 0);
    var jtdj = dData.getInt("jtdj", 0);
    val sl = 20-cjfw;
    val zwjx = 1.00 * ccjx / 20.0;
    val shl = (20.00*Math.min(pow(1.2,zwfw),zwjx)) as int;
    

    var info as string[] = [
        "§4//////////// 血之祭坛操纵者 ////////////",
        "§4生命源质数量 ：§a" + xycc + " / "+ ccjx,
        "当前祭坛位阶：" + jtdj,"祭坛升级激活数：" + cpdj,
        "速度符文："+sdfw,
        "献祭符文："+xjfw,
        "转位符文："+zwfw,
        "增容符文："+zrfw,
        "超容符文："+crfw,
        "促进符文："+cjfw,
        "当前生命源质最大交互速率：" + shl + "/" + sl + "tick",
    ];


    event.extraInfo = info;
});

//萃取祭坛
MMEvents.onControllerGUIRender("life_extracts_altar", function(event as ControllerGUIRenderEvent) {
    val ctrl = event.controller;
    val data = ctrl.customData;
    val dData = D(data);
    val map = data.asMap();
    val moshi = dData.getInt("moshi", 0);

    var info as string[] = [
        "§4//////////// 生命萃取祭坛 ////////////",
    ];

    if (moshi == 1) {
        info += "§4苦难之井模式：§6开启";
    } else {
        info += "§4苦难之井模式：§6关闭";
    }

    event.extraInfo = info;
});

RecipeBuilder.newBuilder("knzj", "life_extracts_altar", 20)
    .addItemInput(<deepmoblearningbm:digital_agonizer>).setChance(0)
    .addItemInput(<contenttweaker:zbk>.withTag({bdzt:"绑定完成！"})).setChance(0).setPreViewNBT({display:{Lore:["§a必须绑定过血之祭坛控制器的坐标"]}})
    .setNBTChecker(function(ctrl as IMachineController, item as IItemStack) {
        val x = D(item.tag).getInt("x", 0);
        val y = D(item.tag).getInt("y", 0);
        val z = D(item.tag).getInt("z", 0);
        val data = ctrl.customData;
        data.asMap()["x"] = x;
        data.asMap()["y"] = y;
        data.asMap()["z"] = z;
        ctrl.customData = data;
        return true;
    })
    .setPreViewNBT({display:{Lore:["§a必须绑定过血之祭坛控制器的坐标"]}})
    .addPostCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val world = ctrl.world;
        val x = dData.getInt("x", 0);
        val y = dData.getInt("y", 0);
        val z = dData.getInt("z", 0);
        val xzjtctrl = MachineController.getControllerAt(world, x, y, z);
        if (!world.remote) {
        if(isNull(xzjtctrl)) {
            event.setFailed("坐标未找到血之祭坛,或者在已加载区块之外");
            return;
        }else{
            val jtdata = xzjtctrl.customData;
            val djtData = D(jtdata);
            val xycc = djtData.getInt("xycc", 0);
            val ccjx = djtData.getInt("ccjx", 0);
            val block = world.getBlock(x,y - 6,z);
            val controllerId = xzjtctrl.blockState.block.definition.id;

            if (isNull(controllerId)||controllerId != "modularmachinery:xzjt_factory_controller") {
                event.setFailed("绑定的方块错误,请绑定血之祭坛控制器");
                return;
            }
            
            if(isNull(block.data)||isNull(block.data.currentRitual)||block.data.currentRitual != "well_of_suffering"){
                event.setFailed("苦难之井未建立，无法激活");
                return;
            }
        }
        }
    })
    .addStartHandler(function(event as RecipeStartEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val map = data.asMap();

        map["moshi"] = 1;
        ctrl.customData = data;
    })
    .addFinishHandler(function(event as RecipeFinishEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val world = ctrl.world;
        val dData = D(data);
        val x = dData.getInt("x", 0);
        val y = dData.getInt("y", 0);
        val z = dData.getInt("z", 0);
        val xzjtctrl = MachineController.getControllerAt(world, x, y, z);
        if(!isNull(xzjtctrl)) {
            val jtdata = xzjtctrl.customData;
            val djtData = D(jtdata);
            val map = jtdata.asMap();
            val cqmap = data.asMap();
            val xycc = djtData.getInt("xycc", 0);
            val ccjx = djtData.getInt("ccjx", 0);
            val xjfw = 1.0*djtData.getInt("xjfw", 0);

            if(xycc + 4000 + 400 * xjfw > ccjx){map["xycc"] = ccjx;}else{map["xycc"] = xycc + 4000 + 400*xjfw;}
            cqmap["moshi"] = 0;
            xzjtctrl.customData = jtdata;
            ctrl.customData = data;
        }
    })
    .addRecipeTooltip("§4直接将生命源质产出至模块祭坛")
    .addRecipeTooltip("§4需要提前将模块祭坛控制器正下方主仪式石激活苦难之井仪式")
    .addRecipeTooltip("§6每次为祭坛添加的生命源质基础值为4000，支持献祭符文的加成")
    .setParallelized(false)
.build();recipeCounter += 1;
//血液输入
RecipeBuilder.newBuilder("ltshr", "xzjt", 20, recipeCounter, false)
    .addFluidInput(<liquid:lifeessence>*20)
    .addFactoryStartHandler(function(event as FactoryRecipeStartEvent) {
        val ctrl = event.controller;
        val bl = event.factoryRecipeThread;
        val data = ctrl.customData;
        val map = data.asMap();
        val dData = D(data);
        val zwfw = dData.getInt("zwfw", 0);
        val cjfw = dData.getInt("cjfw", 0);
        val ccjx = dData.getInt("ccjx", 0) as double;
        val zwjx = ccjx / 20.0;
        val jsbl = Math.min(pow(1.2,zwfw),zwjx);

        bl.addModifier("typeMultiplier1", RecipeModifierBuilder.create("modularmachinery:duration", "input",-cjfw, 0, false).build());
        bl.addPermanentModifier("typeMultiplier2", RecipeModifierBuilder.create("modularmachinery:fluid", "input",jsbl, 1, false).build());
    })
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val xycc = dData.getInt("xycc", 0);
        val ccjx = dData.getInt("ccjx", 0);
        if (xycc >= ccjx) {
            event.setFailed("§4内部生命源质存储抵达了峰值！");
            return;
        }
    })
    .addFactoryFinishHandler(function (event as FactoryRecipeFinishEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val map = data.asMap();
        val zwfw = dData.getInt("zwfw", 0);
        val xycc = dData.getInt("xycc", 0);
        val jsbl = Math.min(pow(1.2,zwfw),100.00);

        map["xycc"] = xycc + 20.00*jsbl;
        ctrl.customData = data;
    })
    .addRecipeTooltip("§4输入生命源质进入其中")
    .addRecipeTooltip("§4具体速度取决于转位符文与促进符文的数量")
    .addRecipeTooltip("§4转位符文最多允许将单次传输提升到血之祭坛缓存上限的10%")
    .setParallelized(false)
    .setThreadName("血液注入")
.build();recipeCounter += 1;
RecipeBuilder.newBuilder("jtshr", "xzjt", 10, recipeCounter, false)
    .addItemInput(<bloodmagic:sacrificial_dagger>).setChance(0)
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val world = ctrl.world;
        val x = ctrl.pos.x;
        val y = ctrl.pos.y;
        val z = ctrl.pos.z;
        val xycc = dData.getInt("xycc", 0);
        val ccjx = dData.getInt("ccjx", 0);
        if (xycc >= ccjx) {
            event.setFailed("§4内部生命源质存储抵达了峰值！");
            return;
        }
    })
    .addFactoryFinishHandler(function (event as FactoryRecipeFinishEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val world = ctrl.world;
        val x = ctrl.pos.x;
        val y = ctrl.pos.y;
        val z = ctrl.pos.z;
        val dData = D(data);
        val map = data.asMap();
        val zwfw = dData.getInt("zwfw", 0);
        val xycc = dData.getInt("xycc", 0);
        val ccjx = dData.getInt("ccjx", 0);
        val jsbl = pow(1.2,zwfw);
        val block = world.getBlock(x,y - 4,z);
        val jtdata = block.data;
        val jtxy = block.data.bloodAltar.Amount;
        val pos = ctrl.pos.getOffset(down,4);
        
        Sync.addSyncTask(function(){
        if(jtxy + xycc > ccjx){
            map["xycc"] = ccjx;
            if (!world.remote) {
                world.setBlockState(<blockstate:bloodmagic:altar>,{bloodAltar:{Amount:(xycc + jtxy - ccjx)}},pos);
            }  
        } else {
            map["xycc"] = jtxy + xycc;
            if (!world.remote) {
                world.setBlockState(<blockstate:bloodmagic:altar>,{bloodAltar:{Amount:0}},pos);
            }
        }
        ctrl.customData = data;
        });
    })
    .addRecipeTooltip("§4将祭坛内的生命源质转移进模块祭坛")
    .addRecipeTooltip("§4放入匕首后开始自动工作")
    .setParallelized(false)
    .setThreadName("祭坛同步器")
.build();recipeCounter += 1;
RecipeBuilder.newBuilder("czshr", "xzjt", 10, recipeCounter, false)
    .addItemInput(<bloodmagic:sacrificial_dagger:1>).setChance(0)
    .addFactoryFinishHandler(function (event as FactoryRecipeFinishEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val map = data.asMap();
        val zwfw = dData.getInt("zwfw", 0);
        val xycc = dData.getInt("xycc", 0);
        val ccjx = dData.getInt("ccjx", 0);
        val jsbl = Math.min(pow(1.2,zwfw),100.00);

        map["xycc"] = ccjx;
        ctrl.customData = data;
    })
    .addRecipeTooltip("§4让你的祭坛里的生命源质永远是满的")
    .setParallelized(false)
    .setThreadName("血液注入")
.build();recipeCounter += 1;
//血液输出
RecipeBuilder.newBuilder("ltshc", "xzjt", 20, recipeCounter, false)
    .addFactoryStartHandler(function(event as FactoryRecipeStartEvent) {
        val ctrl = event.controller;
        val bl = event.factoryRecipeThread;
        val data = ctrl.customData;
        val map = data.asMap();
        val dData = D(data);
        val zwfw = dData.getInt("zwfw", 0);
        val cjfw = dData.getInt("cjfw", 0);
        val ccjx = dData.getInt("ccjx", 0) as double;
        val zwjx = ccjx / 20.0;
        val jsbl = Math.min(pow(1.2,zwfw),zwjx);

        bl.addModifier("typeMultiplier1", RecipeModifierBuilder.create("modularmachinery:duration", "input",-cjfw, 0, false).build());
        bl.addModifier("typeMultiplier2", RecipeModifierBuilder.create("modularmachinery:fluid", "output",jsbl, 1, false).build());
    })
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val xycc = dData.getInt("xycc", 0);
        val ccjx = dData.getInt("ccjx", 0);
        val zwfw = dData.getInt("zwfw", 0);
        val jsbl = 20*Math.min(pow(1.2,zwfw),100.00);
        if (jsbl > xycc) {
            event.setFailed("§4内部生命源质没有啦！");
            return;
        }
    })
    .addFactoryFinishHandler(function (event as FactoryRecipeFinishEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val map = data.asMap();
        val zwfw = dData.getInt("zwfw", 0);
        val xycc = dData.getInt("xycc", 0);
        val jsbl = Math.min(pow(1.2,zwfw),100.00);

        map["xycc"] = xycc - 20*jsbl;
        ctrl.customData = data;
    })
    .addRecipeTooltip("§4输出生命源质至流体输出仓")
    .addRecipeTooltip("§4具体速度取决于转位符文与促进符文的数量")
    .addRecipeTooltip("§4转位符文最多允许将单次传输提升到血之祭坛缓存上限的10%")
    .setParallelized(false)
    .setThreadName("血液输出")
    .addFluidOutput(<liquid:lifeessence>*20)
.build();recipeCounter += 1;
//灵魂网络
RecipeBuilder.newBuilder("lhwl", "xzjt", 20,recipeCounter)
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val xycc = dData.getInt("xycc", 0);
        val ccjx = dData.getInt("ccjx", 0);
        if (xycc < 10000) {
            event.setFailed("§4内部生命源质不足够进行一次输出！");
            return;
        }
    })
    .addFactoryFinishHandler(function (event as FactoryRecipeFinishEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val map = data.asMap();
        val zwfw = dData.getInt("zwfw", 0);
        val xycc = dData.getInt("xycc", 0);
        val jsbl = Math.min(pow(1.2,zwfw),100.00);

        map["xycc"] = xycc - 10000;
        ctrl.customData = data;
    })
    .addLifeEssenceOutput(250, true)
    .addRecipeTooltip("§4输出生命源质至生命源质输出仓")
    .addRecipeTooltip("§4固定输出速度为500/t")
    .setParallelized(false)
    .setThreadName("灵魂网络链接维持")
.build();
//血之合成
function XZHC(Name as string,need as int,Maxneed as double,jtdjxq as int,Inputs as IIngredient,Output as IIngredient,recipeCounter as int){
    var time = Maxneed/need;
    RecipeBuilder.newBuilder(Name, "xzjt", time, recipeCounter, false)
    .addItemInputs(Inputs)
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val xycc =1.00 * dData.getInt("xycc", 0);
        var jtdj = dData.getInt("jtdj", 0);
        val sdfw = dData.getInt("sdfw", 0);
        val cpdj = dData.getInt("cpdj", 0);
        val yzfb = pow(0.95,cpdj);
        val bx = 1 * pow(4,cpdj);
        val sjneed = (0.2 * sdfw + 1.00) * (need * 1.00);
        val bl = Math.min(sjneed,Maxneed) * yzfb * bx;
        val jsl = 1 * bl;

        if (xycc < jsl) {
            event.setFailed("§4缓存的生命源质无法启动配方！");
            return;
        }
        if (jtdj < jtdjxq){
            event.setFailed("§4祭坛等级不足以运行配方！");
            return;
        }
        event.activeRecipe.maxParallelism = bx;
    })
    .addFactoryStartHandler(function(event as FactoryRecipeStartEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val sdfw = dData.getInt("sdfw", 0);
        val sjneed = (0.2 * sdfw + 1.00) * (need * 1.00);
        val bl = event.factoryRecipeThread;
        var time = Maxneed/need;
        var sjtime = Math.round((1.00 * Maxneed)/(1.00 * sjneed));
        var kjtime = time - sjtime;

        bl.addModifier("sdfwjjjm", RecipeModifierBuilder.create("modularmachinery:duration", "input",-kjtime, 0, false).build());
    })
    .addFactoryPreTickHandler(function(event as FactoryRecipeTickEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val map = data.asMap();
        val xycc = dData.getInt("xycc", 0);
        var jtdj = dData.getInt("jtdj", 0);
        val sdfwxg = 0.2 * dData.getInt("sdfw", 0);
        val cpdj = dData.getInt("cpdj", 0);
        val yzfb = pow(0.95,cpdj);
        val sjneed =(sdfwxg + 1.00) * (need * 1.00);
        var sjtime = Math.round((1.00 * Maxneed)/(1.00 * sjneed));
        val thread = event.factoryRecipeThread;
        val bx = 1.00 * thread.activeRecipe.parallelism;
        val bl = Math.min(sjneed,Maxneed) * yzfb * bx;
        val jsl = 1 * bl;

        if (xycc < jsl) {
            event.preventProgressing("§6剩余的生命源质无法使配方进度继续前进");
            return;
        } else {
            map["xycc"] = xycc - jsl;
            ctrl.customData = data;
        }
    })
    .addOutput(Output)
    .setThreadName("血之合成")
    .addRecipeTooltip("§4所需基础生命源质" + need)
    .addRecipeTooltip("§4所需生命源质总量" + Maxneed)
    .addRecipeTooltip("§4配方所要求最低层级：" + jtdjxq)
    .addRecipeTooltip("§6实际速度与消耗将取决于速度符文")
.build();}

XZHC("yzgd",50,1000,3,<mets:nano_living_metal> * 1,<botania:manaresource:7>,recipeCounter);
XZHC("wbhlyq",2000,100000,4,<astralsorcery:blockgemcrystals:4>.withTag({display: {Lore: ["§6熔炼而出的一片....泡影？", "§6或许可以在4阶以上血之祭坛里用10万生命源质让它充满活力"], Name: "§6维度时空的泡影"}}) * 1,<astralsorcery:blockgemcrystals:2>.withTag({display: {Lore: ["§5你将接触到终极", "§6将它放入神龙以上的聚合核心吧，与2个觉醒龙芯聚合"], Name: "§6万般活力源泉"}}),recipeCounter);
XZHC("xjd",5,3000,2,<minecraft:iron_sword> * 1, <bloodmagic:dagger_of_sacrifice> ,recipeCounter);
XZHC("cxys",2000,1000000,4,<contenttweaker:yunshi> * 1,<contenttweaker:cxyunshi>,recipeCounter);
XZHC("sb0",5,1000,1,<minecraft:stone> * 1,<bloodmagic:slate>,recipeCounter);
XZHC("sb1",5,2000,2,<bloodmagic:slate> * 1,<bloodmagic:slate:1>,recipeCounter);
XZHC("sb2",15,5000,3,<bloodmagic:slate:1> * 1,<bloodmagic:slate:2>,recipeCounter);
XZHC("sb3",20,15000,4,<bloodmagic:slate:2> * 1,<bloodmagic:slate:3>,recipeCounter);
XZHC("sb4",40,30000,5,<bloodmagic:slate:3> * 1,<bloodmagic:slate:4>,recipeCounter);
XZHC("zszs",20,1000,1,<minecraft:book> * 1,<bloodmagic:sanguine_book>,recipeCounter);
XZHC("flykszz",50,1000,3,<botania:manaresource:1> * 1,<appliedenergistics2:material:9>,recipeCounter);
XZHC("xrjhsj",20,10000,3,<bloodmagic:lava_crystal> * 1,<bloodmagic:activation_crystal>,recipeCounter);
XZHC("mwgjf",5,1000,3,<minecraft:ghast_tear> * 1,<bloodmagic:inscription_tool:4>.withTag({uses: 10}),recipeCounter);
XZHC("mwgjs",5,1000,3,<minecraft:lapis_block> * 1,<bloodmagic:inscription_tool:1>.withTag({uses: 10}),recipeCounter);
XZHC("mwgjd",5,1000,3,<minecraft:obsidian> * 1,<bloodmagic:inscription_tool:3>.withTag({uses: 10}),recipeCounter);
XZHC("mwgjh",5,1000,3,<minecraft:magma_cream> * 1,<bloodmagic:inscription_tool:2>.withTag({uses: 10}),recipeCounter);
XZHC("mwgjbm",20,2000,4,<minecraft:coal_block> * 1,<bloodmagic:inscription_tool:5>.withTag({uses: 10}),recipeCounter);
XZHC("mwgjpx",100,200000,6,<minecraft:glowstone> * 1,<bloodmagic:inscription_tool:6>.withTag({uses: 10}),recipeCounter);
XZHC("sfd",50,30000,4,<tconevo:material> * 1,<tconevo:metal:25>,recipeCounter);
XZHC("alhg",200,20000,6,<extrabotany:material:1> * 1,<extrabotany:material:3>,recipeCounter);
XZHC("xrqxbz",2,2000,1,<minecraft:diamond> * 1,<bloodmagic:blood_orb>.withTag({orb: "bloodmagic:weak"}),recipeCounter);
XZHC("xtqxbz",5,5000,2,<minecraft:redstone_block> * 1,<bloodmagic:blood_orb>.withTag({orb: "bloodmagic:apprentice"}),recipeCounter);
XZHC("fsqxbz",20,25000,3,<ore:blockGold> * 1,<bloodmagic:blood_orb>.withTag({orb: "bloodmagic:magician"}),recipeCounter);
XZHC("dsqxbz",30,40000,4,<bloodmagic:blood_shard> * 1,<bloodmagic:blood_orb>.withTag({orb: "bloodmagic:master"}),recipeCounter);
XZHC("xzqxbz",50,80000,5,<minecraft:nether_star> * 1,<bloodmagic:blood_orb>.withTag({orb: "bloodmagic:archmage"}),recipeCounter);
XZHC("zyqxbz",100,200000,6,<bloodmagic:decorative_brick:2> * 1,<bloodmagic:blood_orb>.withTag({orb: "bloodmagic:transcendent"}),recipeCounter);
XZHC("zxgzd",20,10000,4,<deepmoblearning:glitch_infused_ingot> * 1,<deepmoblearningbm:blood_infused_glitch_ingot>,recipeCounter);
XZHC("shard",50,1000,3,<bloodmagic:decorative_brick> * 1,<bloodmagic:blood_shard> * 4,recipeCounter);