import crafttweaker.item.IItemStack;
import crafttweaker.item.IIngredient;
import crafttweaker.data.IData;
import crafttweaker.world.IWorld;
import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.RecipeCheckEvent;
import mods.modularmachinery.RecipeStartEvent;
import mods.modularmachinery.RecipeFinishEvent;
import mods.modularmachinery.RecipeModifierBuilder;
import mods.modularmachinery.IngredientArrayBuilder;
import mods.modularmachinery.FactoryRecipeThread;
import mods.modularmachinery.MMEvents;
import mods.modularmachinery.ControllerGUIRenderEvent;
import mods.modularmachinery.IMachineController;
import mods.modularmachinery.MachineModifier;
import novaeng.hypernet.HyperNetHelper;
import novaeng.hypernet.RegistryHyperNet;
import novaeng.hypernet.research.ResearchCognitionData;
import crafttweaker.util.Math;
import mods.modularmachinery.SmartInterfaceType;
import mods.modularmachinery.RecipeModifier;
import mods.modularmachinery.RecipeAdapterBuilder;
import mods.modularmachinery.FactoryRecipeStartEvent;
import mods.modularmachinery.FactoryRecipeTickEvent;
import mods.modularmachinery.FactoryRecipeFinishEvent;
import mods.modularmachinery.MachineController;
import crafttweaker.liquid.ILiquidStack;
import novaeng.NovaEngUtils;

var recipeCounter = 1;
var em = <bloodmagic:monster_soul>;

//恶魔意志仓
recipes.addShaped(<modularmachinery:blockwillprovideroutput>, [[em,em,em],[em,<bloodmagic:demon_crucible>,em],[em,em,em]]);
recipes.addShaped(<modularmachinery:blockwillproviderinput>,[[em,em,em],[em,<bloodmagic:demon_pylon>,em],[em,em,em]]);

//研究
RegistryHyperNet.addResearchCognitionData(ResearchCognitionData.create("emo", "恶魔意志操纵",<bloodmagic:monster_soul>,    // 预览物品
        6.8,                                 // 科技等级（难度）
        2520000,                          // 需要科研点
        105.0F,                               // 最低每 Tick 算力要求
        [
            "经员工数以千份的投诉，关于《怎么把答辩古法狱火熔炉自动化进行科技改革》大会在“狱火熔炉什么辣鸡”会议室举行。",
            "毕竟ECO实验室发展到现在，这种原始的把所有材料搅在一起,然后大锅一同炖出成品的玩意属实罕见。",
            "在一次大锅炖中,某员工再次不小心把成品感知锭和它的材料魂石一同从炉中捞出，导致熔炉停摆。",
            "晚上员工就做了个噩梦，恶魔痛骂他：你在干什么B东西，差不多得了，我给你画个图纸你按照这个东西搓。",
            "第二天醒来，员工就发现床边上的桌子上摆了一张图纸。员工大惊，连日把图纸上报。"
        ],
        [
            "§2解锁工业机械臂配方：意志集成化模块概念机/精密组装机配方：数字化恶魔意志注入器",
            "经过对图纸的研究，生命灵气科成功推出全新机器",
            "总而言之，测试机器很成功，员工们再也不用承受破烂狱火熔炉了",
            "新机器正式投产，现在人们天天用恶魔意志拌42号混凝土，外加烧烤感知锭作为小食。",
            "首先将感知锭裹上面包糠，然后在炽炎液中油炸3分钟直至两面金黄，捞出后即可随意食用。",
            "吃过的人都直呼&@%6～*@%ag（翻译：五蚂蚁！）————摘自《美食千万家》",
            "§2§o文案：Pigeon_Phi、Circulation，模型:没做完捏.  代码/策划：Circulation"
        ],
        [
            "precision_assembler",
            "machine_arm",                                 // 前置科技
        ]
));

//恶魔意志注入器
recipes.remove(<deepmoblearningbm:digital_will_injector>);

RecipeBuilder.newBuilder("digital_will_injector", "precision_assembler", 600, recipeCounter, false)
    .addEnergyPerTickInput(102400)
    .addInputs([
        <modularmachinery:soul_fabrication_ritual_builder_controller> * 1,
        <bloodmagic:soul_gem:4> * 1,
        <bloodmagic:sentient_sword> * 1,
        <deepmoblearning:machine_casing> * 4,
        <bloodmagic:soul_snare>*64,
        <contenttweaker:industrial_circuit_v2>*16
    ])
    .addOutputs(<deepmoblearningbm:digital_will_injector> * 1)
    .requireResearch("emo")
.build();
recipeCounter += 1;

//控制器合成
RecipeBuilder.newBuilder("emo", "machine_arm", 800, recipeCounter, false)
    .addEnergyPerTickInput(512000)
    .addInputs([<liquid:lifeessence> * 256000,<bloodmagic:demon_crucible>*4,<bloodmagic:demon_pylon>*4,<bloodmagic:soul_forge>*4,<bloodmagic:demon_crystallizer>*4,<contenttweaker:lifesense_processor> * 16,<bloodmagic:decorative_brick> * 64,
    ])
    .addOutputs(<modularmachinery:soul_forge_factory_controller> * 1)
    .requireResearch("emo")
    .build();
recipeCounter += 1;

//==============================恶魔意志操纵==============================
val yizhi = FactoryRecipeThread.createCoreThread("意志注入模块");
val peifang = FactoryRecipeThread.createCoreThread("狱火煅烧模块");
val yizhijq = FactoryRecipeThread.createCoreThread("意志提取模块");
val yizhijqS = FactoryRecipeThread.createCoreThread("意志释放模块");
val yizhiZL = FactoryRecipeThread.createCoreThread("意志注灵模块");

// 工厂线程数设置
MachineModifier.setMaxThreads("soul_forge", 0);
MachineModifier.addCoreThread("soul_forge", yizhi);
MachineModifier.addCoreThread("soul_forge", peifang);
MachineModifier.addCoreThread("soul_forge", yizhijq);
MachineModifier.addCoreThread("soul_forge", yizhijqS);
MachineModifier.addCoreThread("soul_forge", yizhiZL);

//添加控制器 GUI 信息
MMEvents.onControllerGUIRender("soul_forge", function(event as ControllerGUIRenderEvent) {
    val ctrl = event.controller;
    val data = ctrl.customData;
    val dData = D(data);
    val map = data.asMap();
    val souls = 1 * dData.getDouble("souls", 0);
    var info as string[] = [
        "§4//////////// 意志集成处理控制器 ////////////",
        "§4恶魔意志存储量：§a" + souls + " / 100000000",
    ];

    event.extraInfo = info;
});
HyperNetHelper.proxyMachineForHyperNet("soul_forge");

var zrtime = 5;
var yzjx = 100000000.0;
//意志注入模块
RecipeBuilder.newBuilder("yizhi", "soul_forge", 20, recipeCounter, false)
    .addItemInputs([<bloodmagic:monster_soul>.withTag({display: {Lore: ["§6被榨干啦，真的一滴都没有啦"]}}),]).setTag("cailiao")
    .addOutput(<bloodmagic:monster_soul>)
        .setPreViewNBT({display: {Lore: ["§4控制器内的全部恶魔意志都将会提取而出"]}})
    .addItemModifier(function(ctrl as IMachineController, item as IItemStack) {
        val data = ctrl.customData;
        val dData = D(data);
        val map = data.asMap();
        val souls = dData.getDouble("souls", 0);
        map["souls"] = 0;
        ctrl.customData = data;
        return item.withTag({
            souls: souls
        });
    })
    .addRecipeTooltip("§4抽取出控制器内所有恶魔意志")
    .addRecipeTooltip("搬家的时候记得想起这个配方")
    .addRecipeTooltip("§6需要放入底部输入仓")
    .setParallelized(false)
    .setThreadName("意志提取模块")
    .requireResearch("emo")
.build();recipeCounter += 1;
RecipeBuilder.newBuilder("emyzzr", "soul_forge", zrtime, recipeCounter, false)
    .addInput(<bloodmagic:monster_soul:*>).setTag("yizhi")
    .setNBTChecker(function(ctrl as IMachineController, item as IItemStack) {
        val souls = D(item.tag).getDouble("souls", 0);
        val data = ctrl.customData;
        data.asMap()["soulsCache"] = souls;
        ctrl.customData = data;
        return true;
    })
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val souls = dData.getDouble("souls", 0);
        if (souls >= yzjx) {
            event.setFailed("§4当前的恶魔意志已经抵达存储极限！");
            return;
        }
    })
    .addFactoryFinishHandler(function (event as FactoryRecipeFinishEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val map = data.asMap();
        val souls = dData.getDouble("souls", 0);
        var soulsCache = dData.getDouble("soulsCache", 0);

        map["souls"] = souls + soulsCache;
        ctrl.customData = data;
    })
    .addOutput(<bloodmagic:monster_soul>.withTag({display:{Lore:["§6被榨干啦，真的一滴都没有啦"]}}))
    .setParallelized(false)
    .addRecipeTooltip("§4把恶魔意志输入机器,机器内可以缓存的上限为1000万")
    .addRecipeTooltip("§6需要放入顶端的物品输入仓注入恶魔意志")
    .setThreadName("意志注入模块")
    .requireResearch("emo")
.build();recipeCounter += 1;
RecipeBuilder.newBuilder("wxdyhs", "soul_forge", zrtime, recipeCounter, false)
    .addInput(<bloodmagic:soul_gem:0>).setTag("yizhi")
    .setNBTChecker(function(ctrl as IMachineController, item as IItemStack) {
        val souls = D(item.tag).getDouble("souls", 0);
        val data = ctrl.customData;
        data.asMap()["soulsCache"] = souls;
        ctrl.customData = data;
        return true;
    })
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val souls = dData.getDouble("souls", 0);
        if (souls >= yzjx) {
            event.setFailed("§4当前的恶魔意志已经抵达存储极限！");
            return;
        }
    })
    .addFactoryFinishHandler(function (event as FactoryRecipeFinishEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val map = data.asMap();
        val souls = dData.getDouble("souls", 0);
        var soulsCache = dData.getDouble("soulsCache", 0);

        map["souls"] = souls + soulsCache;
        ctrl.customData = data;
    })
    .addOutput(<bloodmagic:soul_gem:0>)
    .setParallelized(false)
    .addRecipeTooltip("§4把恶魔意志输入机器,机器内可以缓存的上限为1000万")
    .addRecipeTooltip("§6需要放入顶端的物品输入仓注入恶魔意志")
    .setThreadName("意志注入模块")
    .requireResearch("emo")
.build();recipeCounter += 1;
RecipeBuilder.newBuilder("xkdyhs", "soul_forge", zrtime, recipeCounter, false)
    .addInput(<bloodmagic:soul_gem:1>).setTag("yizhi")
    .setNBTChecker(function(ctrl as IMachineController, item as IItemStack) {
        val souls = D(item.tag).getDouble("souls", 0);
        val data = ctrl.customData;
        data.asMap()["soulsCache"] = souls;
        ctrl.customData = data;
        return true;
    })
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val souls = dData.getDouble("souls", 0);
        if (souls >= yzjx) {
            event.setFailed("§4当前的恶魔意志已经抵达存储极限！");
            return;
        }
    })
    .addFactoryFinishHandler(function (event as FactoryRecipeFinishEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val map = data.asMap();
        val souls = dData.getDouble("souls", 0);
        var soulsCache = dData.getDouble("soulsCache", 0);

        map["souls"] = souls + soulsCache;
        ctrl.customData = data;
    })
    .addOutput(<bloodmagic:soul_gem:1>)
    .setParallelized(false)
    .addRecipeTooltip("§4把恶魔意志输入机器,机器内可以缓存的上限为1000万")
    .addRecipeTooltip("§6需要放入顶端的物品输入仓注入恶魔意志")
    .setThreadName("意志注入模块")
    .requireResearch("emo")
.build();recipeCounter += 1;
RecipeBuilder.newBuilder("ptdyhs", "soul_forge", zrtime, recipeCounter, false)
    .addInput(<bloodmagic:soul_gem:2>).setTag("yizhi")
    .setNBTChecker(function(ctrl as IMachineController, item as IItemStack) {
        val souls = D(item.tag).getDouble("souls", 0);
        val data = ctrl.customData;
        data.asMap()["soulsCache"] = souls;
        ctrl.customData = data;
        return true;
    })
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val souls = dData.getDouble("souls", 0);
        if (souls >= 10000000.00) {
            event.setFailed("§4当前的恶魔意志已经抵达存储极限！");
            return;
        }
    })
    .addFactoryFinishHandler(function (event as FactoryRecipeFinishEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val map = data.asMap();
        val souls = dData.getDouble("souls", 0);
        var soulsCache = dData.getDouble("soulsCache", 0);

        map["souls"] = souls + soulsCache;
        ctrl.customData = data;
    })
    .addOutput(<bloodmagic:soul_gem:2>)
    .setParallelized(false)
    .addRecipeTooltip("§4把恶魔意志输入机器,机器内可以缓存的上限为1000万")
    .addRecipeTooltip("§6需要放入顶端的物品输入仓注入恶魔意志")
    .setThreadName("意志注入模块")
    .requireResearch("emo")
.build();recipeCounter += 1;
RecipeBuilder.newBuilder("jddyhs", "soul_forge", zrtime, recipeCounter, false)
    .addInput(<bloodmagic:soul_gem:3>).setTag("yizhi")
    .setNBTChecker(function(ctrl as IMachineController, item as IItemStack) {
        val souls = D(item.tag).getDouble("souls", 0);
        val data = ctrl.customData;
        data.asMap()["soulsCache"] = souls;
        ctrl.customData = data;
        return true;
    })
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val souls = dData.getDouble("souls", 0);
        if (souls >= yzjx) {
            event.setFailed("§4当前的恶魔意志已经抵达存储极限！");
            return;
        }
    })
    .addFactoryFinishHandler(function (event as FactoryRecipeFinishEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val map = data.asMap();
        val souls = dData.getDouble("souls", 0);
        var soulsCache = dData.getDouble("soulsCache", 0);

        map["souls"] = souls + soulsCache;
        ctrl.customData = data;
    })
    .addOutput(<bloodmagic:soul_gem:3>)
    .setParallelized(false)
    .addRecipeTooltip("§4把恶魔意志输入机器,机器内可以缓存的上限为1000万")
    .addRecipeTooltip("§6需要放入顶端的物品输入仓注入恶魔意志")
    .setThreadName("意志注入模块")
    .requireResearch("emo")
.build();recipeCounter += 1;
RecipeBuilder.newBuilder("jzdyhs", "soul_forge", zrtime, recipeCounter, false)
    .addInput(<bloodmagic:soul_gem:4>).setTag("yizhi")
    .setNBTChecker(function(ctrl as IMachineController, item as IItemStack) {
        val souls = D(item.tag).getDouble("souls", 0);
        val data = ctrl.customData;
        data.asMap()["soulsCache"] = souls;
        ctrl.customData = data;
        return true;
    })
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val souls = dData.getDouble("souls", 0);
        if (souls >= yzjx) {
            event.setFailed("§4当前的恶魔意志已经抵达存储极限！");
            return;
        }
    })
    .addFactoryFinishHandler(function (event as FactoryRecipeFinishEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val map = data.asMap();
        val souls = dData.getDouble("souls", 0);
        var soulsCache = dData.getDouble("soulsCache", 0);

        map["souls"] = souls + soulsCache;
        ctrl.customData = data;
    })
    .addOutput(<bloodmagic:soul_gem:4>)
    .setParallelized(false)
    .addRecipeTooltip("§4把恶魔意志输入机器,机器内可以缓存的上限为1000万")
    .addRecipeTooltip("§6需要放入顶端的物品输入仓注入恶魔意志")
    .setThreadName("意志注入模块")
    .requireResearch("emo")
.build();recipeCounter += 1;
RecipeBuilder.newBuilder("yzjtzr", "soul_forge", zrtime, recipeCounter, false)
    .addInput(<bloodmagic:item_demon_crystal:*>).setTag("yizhi")
    .setNBTChecker(function(ctrl as IMachineController, item as IItemStack) {
        val souls = D(item.tag).getDouble("souls", 0);
        val data = ctrl.customData;
        data.asMap()["soulsCache"] = souls;
        ctrl.customData = data;
        return true;
    })
    .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val souls = dData.getDouble("souls", 0);
        if (souls >= yzjx) {
            event.setFailed("§4当前的恶魔意志已经抵达存储极限！");
            return;
        }
    })
    .addFactoryFinishHandler(function (event as FactoryRecipeFinishEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val map = data.asMap();
        val souls = dData.getDouble("souls", 0);

        map["souls"] = souls + 50.00;
        ctrl.customData = data;
    })
    .addRecipeTooltip("§4把恶魔意志输入机器,机器内可以缓存的上限为1000万")
    .addRecipeTooltip("§6需要放入顶端的物品输入仓注入50点恶魔意志")
    .setParallelized(false)
    .setThreadName("意志注入模块")
    .requireResearch("emo")
.build();recipeCounter += 1;

//狱火煅烧模块
function YHRecipecreation(Name as string,need as double,minneed as double,Inputs as IIngredient[],Output as IIngredient,recipeCounter as int){
    RecipeBuilder.newBuilder(Name, "soul_forge", 5, recipeCounter, false)
    .addItemInputs(Inputs).setTag("cailiao")
    .addPostCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val souls = dData.getDouble("souls", 0);
        val lxbx = event.activeRecipe.parallelism;
        val bx = 1*Math.floor(souls/need);

        if (souls < minneed * 10.00) {
            event.setFailed("§4缓存的恶魔意志不满足此配方的最低值！");
            return;
        }
        if (bx > 1&&need > 0.00&&bx < lxbx){
            event.activeRecipe.maxParallelism = bx;
        }
    })
    .addFactoryFinishHandler(function (event as FactoryRecipeFinishEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val map = data.asMap();
        val souls = dData.getDouble("souls", 0);
        val thread = event.factoryRecipeThread;
        val bx = 1.00*thread.activeRecipe.parallelism;

        map["souls"] = souls - need * bx;
        ctrl.customData = data;
    })
    .addOutput(Output)
    .setThreadName("狱火煅烧模块")
    .addRecipeTooltip("§4所需最低意志：§6" + minneed * 10.00 + "§4Will")
    .addRecipeTooltip("§4配方消耗意志：§6" + need + "§4Will")
    .addRecipeTooltip("§6材料仅识别底部输入仓内")
    .requireResearch("emo")
.build();}

YHRecipecreation("asfh",0.00,0.00,[<minecraft:redstone>,<ore:dyeWhite>,<minecraft:gunpowder>,<minecraft:coal:*>],<bloodmagic:arcane_ashes>,recipeCounter);recipeCounter += 1;
YHRecipecreation("gzzj",0.00,0.00,[<bloodmagic:soul_gem>,<minecraft:iron_sword>],<bloodmagic:sentient_sword>,recipeCounter);recipeCounter += 1;
YHRecipecreation("gzzf",0.00,0.00,[<bloodmagic:soul_gem>,<minecraft:iron_axe>],<bloodmagic:sentient_axe>,recipeCounter);recipeCounter += 1;
YHRecipecreation("gzzga",0.00,0.00,[<bloodmagic:soul_gem>,<minecraft:iron_pickaxe>],<bloodmagic:sentient_pickaxe>,recipeCounter);recipeCounter += 1;
YHRecipecreation("gzzq",0.00,0.00,[<bloodmagic:soul_gem>,<minecraft:iron_shovel>],<bloodmagic:sentient_shovel>,recipeCounter);recipeCounter += 1;
YHRecipecreation("gzzgj",0.00,0.00,[<minecraft:bow>,<bloodmagic:soul_gem:1>,<minecraft:string>,<minecraft:string>],<bloodmagic:sentient_bow>,recipeCounter);recipeCounter += 1;
YHRecipecreation("hunshi0",1.00,1.00,[<minecraft:gold_ingot>,<minecraft:redstone>,<ore:dyeBlue>,<ore:blockGlass>],<bloodmagic:soul_gem>,recipeCounter);recipeCounter += 1;
YHRecipecreation("hunshi1",20.00,60.00,[<bloodmagic:soul_gem>,<ore:gemDiamond>,<ore:blockRedstone>,<ore:blockLapis>],<bloodmagic:soul_gem:1>,recipeCounter);recipeCounter += 1;
YHRecipecreation("hunshi2",50.00,240.00,[<bloodmagic:soul_gem:1>,<ore:gemDiamond>,<ore:blockGold>,<bloodmagic:slate:2>],<bloodmagic:soul_gem:2>,recipeCounter);recipeCounter += 1;
YHRecipecreation("hunshi3",100.00,1000.00,[<bloodmagic:soul_gem:2>,<bloodmagic:slate:3>,<bloodmagic:blood_shard>,<bloodmagic:item_demon_crystal>],<bloodmagic:soul_gem:3>,recipeCounter);recipeCounter += 1;
YHRecipecreation("hunshi4",500.00,4000.00,[<bloodmagic:soul_gem:3>,<ore:netherStar>],<bloodmagic:soul_gem:4>,recipeCounter);recipeCounter += 1;
YHRecipecreation("gzd",6.00,16.00,[<bloodmagic:soul_gem>,<tconevo:material>],<tconevo:metal:30>,recipeCounter);recipeCounter += 1;
YHRecipecreation("jdljgj",5.00,400.00,[<ore:stickWood>,<bloodmagic:slate:1>,<minecraft:dye:4>,<minecraft:dye:4>],<bloodmagic:node_router>,recipeCounter);recipeCounter += 1;
YHRecipecreation("kjlj",10.00,400.00,[<ore:blockGlass>,<ore:stone>,<bloodmagic:slate>],<bloodmagic:component:10>,recipeCounter);recipeCounter += 1;
YHRecipecreation("lyjd_kz",200.00,400.00,[<ore:blockIron>,<ore:gemDiamond>,<bloodmagic:slate:2>],<bloodmagic:master_routing_node>,recipeCounter);recipeCounter += 1;
YHRecipecreation("lyjd_",5.00,400.00,[<minecraft:glowstone_dust>,<minecraft:redstone>,<ore:blockGlass>,<ore:stone>],<bloodmagic:item_routing_node>,recipeCounter);recipeCounter += 1;
YHRecipecreation("lyjd_input",25.00,400.00,[<minecraft:glowstone_dust>,<minecraft:redstone>,<minecraft:gold_ingot>,<bloodmagic:item_routing_node>],<bloodmagic:input_routing_node>,recipeCounter);recipeCounter += 1;
YHRecipecreation("lyjd_output",25.00,400.00,[<minecraft:glowstone_dust>,<minecraft:redstone>,<minecraft:iron_ingot>,<bloodmagic:item_routing_node>],<bloodmagic:output_routing_node>,recipeCounter);recipeCounter += 1;
YHRecipecreation("gzkj",150.00,240.00,[<minecraft:diamond_chestplate>,<bloodmagic:soul_gem:1>,<minecraft:iron_block>,<minecraft:obsidian>],<bloodmagic:sentient_armour_gem>,recipeCounter);recipeCounter += 1;
YHRecipecreation("lycl",150.00,240.00,[<minecraft:gold_ingot>,<minecraft:redstone>,<ore:blockGlass>,<bloodmagic:item_demon_crystal:*>],<bloodmagic:demon_will_gauge>,recipeCounter);recipeCounter += 1;
YHRecipecreation("emjjt",100.00,500.00,[<bloodmagic:soul_forge>,<ore:stone>,<minecraft:dye:4>,<ore:blockGlass>],<bloodmagic:demon_crystallizer>,recipeCounter);recipeCounter += 1;
YHRecipecreation("emgg",100.00,400.00,[<minecraft:cauldron>,<ore:stone>,<minecraft:dye:4>,<ore:gemDiamond>],<bloodmagic:demon_crucible>,recipeCounter);recipeCounter += 1;
YHRecipecreation("emdn",50.00,400.00,[<minecraft:iron_block>,<ore:stone>,<minecraft:dye:4>,<bloodmagic:item_demon_crystal:*>],<bloodmagic:demon_pylon>,recipeCounter);recipeCounter += 1;
YHRecipecreation("yscx",100.00,500.00,[<bloodmagic:item_demon_crystal:2>,<bloodmagic:item_demon_crystal:2>,<bloodmagic:ritual_diviner>,<bloodmagic:blood_shard>],<bloodmagic:ritual_dismantler>,recipeCounter);recipeCounter += 1;
YHRecipecreation("jingcu0",100.00,1200.00,[<bloodmagic:item_demon_crystal:0>,<bloodmagic:item_demon_crystal:0>,<bloodmagic:item_demon_crystal:0>,<bloodmagic:item_demon_crystal:0>,],<bloodmagic:demon_crystal:0>,recipeCounter);recipeCounter += 1;
YHRecipecreation("jingcu1",100.00,1200.00,[<bloodmagic:item_demon_crystal:1>,<bloodmagic:item_demon_crystal:1>,<bloodmagic:item_demon_crystal:1>,<bloodmagic:item_demon_crystal:1>,],<bloodmagic:demon_crystal:1>,recipeCounter);recipeCounter += 1;
YHRecipecreation("jingcu2",100.00,1200.00,[<bloodmagic:item_demon_crystal:2>,<bloodmagic:item_demon_crystal:2>,<bloodmagic:item_demon_crystal:2>,<bloodmagic:item_demon_crystal:2>,],<bloodmagic:demon_crystal:2>,recipeCounter);recipeCounter += 1;
YHRecipecreation("jingcu3",100.00,1200.00,[<bloodmagic:item_demon_crystal:3>,<bloodmagic:item_demon_crystal:3>,<bloodmagic:item_demon_crystal:3>,<bloodmagic:item_demon_crystal:3>,],<bloodmagic:demon_crystal:3>,recipeCounter);recipeCounter += 1;
YHRecipecreation("jingcu4",100.00,1200.00,[<bloodmagic:item_demon_crystal:4>,<bloodmagic:item_demon_crystal:4>,<bloodmagic:item_demon_crystal:4>,<bloodmagic:item_demon_crystal:4>,],<bloodmagic:demon_crystal:4>,recipeCounter);recipeCounter += 1;
RecipeBuilder.newBuilder("yzyzdasdahs", "soul_forge", 1200, recipeCounter, false)//终焉魂石
    .addItemInputs([
            <bloodmagic:soul_gem:4>.withTag({souls: 16384.0}),
            <contenttweaker:arkforcefieldcontrolblock> * 16,
            <deepmoblearningbm:digital_will_injector>
        ]).setTag("cailiao")
    .addIngredientArrayInput(
        IngredientArrayBuilder.newBuilder()
            .addIngredients([
            <additions:novaextended-crystal4>*8,
            <deepmoblearning:data_model_chaosguardian>.withTag({tier: 4})
            ])
        ).setTag("cailiao")
    .addPostCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val souls = dData.getDouble("souls", 0);

        if (souls < 100000000.00) {
            event.setFailed("§4缓存的恶魔意志不满足此配方的最低值！");
            return;
        }
        if (souls > 1.0E10) {
            event.setFailed("§4终焉魂石发生了互斥！");
            return;
        }
    })
    .addFactoryFinishHandler(function (event as FactoryRecipeFinishEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val map = data.asMap();
        val souls = dData.getDouble("souls", 0);
        val thread = event.factoryRecipeThread;

        map["souls"] = souls - 100000000.00;
        ctrl.customData = data;
    })
    .addOutput(<bloodmagic:soul_gem:4>.withTag({display: {Lore: ["§4无尽意志之源", "§6链接世间生灵灵魂的终点", "§a可以被写入集成意志模块", "§a也可以放入恶魔坩埚无限放出意志（仍然有区块上限）"], Name: "§6[终焉]地狱魂石"}, souls: 1.0E350 as double}))
    .setThreadName("狱火煅烧模块")
    .setParallelized(false)
    .addRecipeTooltip("§4所需最低意志：§6100000000§4Will")
    .addRecipeTooltip("§4配方消耗意志：§6100000000§4Will")
    .addRecipeTooltip("§6材料仅识别底部输入仓内")
    .addRecipeTooltip("§6无法使用注入了终焉魂石的恶魔意志模块制造！")
    .requireResearch("law_of_cycles")
.build();recipeCounter += 1;
//意志提取模块
function TQRecipecreation(Name as string,Inputs as IIngredient,Output as IIngredient,recipeCounter as int){
    RecipeBuilder.newBuilder(Name, "soul_forge", 5, recipeCounter, false)
        .addItemInputs(Inputs).setTag("cailiao")
        .addPostCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val souls = dData.getDouble("souls", 0);
        val lxbx = event.activeRecipe.parallelism;
        val bx = 1*Math.floor(souls/50.00);

        if (souls < 50.00) {
            event.setFailed("§4缓存的恶魔意志不满足此配方的最低值！");
            return;
        }
        if (bx > 1&&bx < lxbx){
            event.activeRecipe.maxParallelism = bx;
        }
    })
        .addFactoryFinishHandler(function (event as FactoryRecipeFinishEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val map = data.asMap();
        val souls = dData.getDouble("souls", 0);
        val thread = event.factoryRecipeThread;
        val bx = 1.00*thread.activeRecipe.parallelism;

        map["souls"] = souls - 50.00*bx;
        ctrl.customData = data;
    })
    .addOutput(Output)
    .setThreadName("意志提取模块")
    .addRecipeTooltip("§4配方消耗意志：§650§4Will")
    .addRecipeTooltip("§6提取基质仅识别底部输入仓内")
    .requireResearch("emo")
.build();}

TQRecipecreation("jingti0",<appliedenergistics2:paint_ball:20>,<bloodmagic:item_demon_crystal:0>,recipeCounter);recipeCounter += 1;
TQRecipecreation("jingti1",<appliedenergistics2:paint_ball:33>,<bloodmagic:item_demon_crystal:1>,recipeCounter);recipeCounter += 1;
TQRecipecreation("jingti2",<appliedenergistics2:paint_ball:24>,<bloodmagic:item_demon_crystal:2>,recipeCounter);recipeCounter += 1;
TQRecipecreation("jingti3",<appliedenergistics2:paint_ball:34>,<bloodmagic:item_demon_crystal:3>,recipeCounter);recipeCounter += 1;
TQRecipecreation("jingti4",<appliedenergistics2:paint_ball:30>,<bloodmagic:item_demon_crystal:4>,recipeCounter);recipeCounter += 1;

//意志释放模块
RecipeBuilder.newBuilder("sanbo", "soul_forge", 10, recipeCounter, false)
    .addItemInputs(<bloodmagic:demon_crucible>).setChance(0).setTag("cailiao")
        .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val souls = dData.getDouble("souls", 0);
        if (souls < 50.00) {
            event.setFailed("§4缓存的恶魔意志不满足此配方的消耗");
            return;
        }
    })
        .addFactoryFinishHandler(function (event as FactoryRecipeFinishEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val map = data.asMap();
        val souls = dData.getDouble("souls", 0);

        map["souls"] = souls - 1000.00;
        ctrl.customData = data;
    })
    .addWillOutput("DEFAULT",1000,0,1000)
    .setParallelized(false)
    .setThreadName("意志释放模块")
    .addRecipeTooltip("§4把控制器内的意志散播到区块之中")
    .addRecipeTooltip("§4在区块中的恶魔意志大于1000后也许会停下(?)")
    .addRecipeTooltip("§6提取基质仅识别底部输入仓内")
    .requireResearch("emo")
.build();recipeCounter += 1;

//意志注灵模块
function ZLRecipecreation(Name as string,Inputs as IIngredient,Output as IIngredient,recipeCounter as int){
    RecipeBuilder.newBuilder(Name, "soul_forge", 10, recipeCounter, false)
        .addItemInputs([Inputs*4,<ebwizardry:crystal_block>]).setTag("cailiao")
        .addPreCheckHandler(function(event as RecipeCheckEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val souls = dData.getDouble("souls", 0);
        if (souls < 10000.00) {
            event.setFailed("§4意志强度不足以操纵注灵祭坛");
            return;
        }
    })
        .addFactoryFinishHandler(function (event as FactoryRecipeFinishEvent) {
        val ctrl = event.controller;
        val data = ctrl.customData;
        val dData = D(data);
        val map = data.asMap();
        val souls = dData.getDouble("souls", 0);

        map["souls"] = souls - 10000.00;
        ctrl.customData = data;
    })
    .addItemInputs(<ebwizardry:imbuement_altar>).setChance(0).setTag("cailiao")
    .addItemInputs(<ebwizardry:receptacle>*4).setChance(0).setTag("cailiao")
    .addOutput(Output)
    .setParallelized(false)
    .setThreadName("意志注灵模块")
    .addRecipeTooltip("§4配方消耗意志：§610000§4Will")
    .addRecipeTooltip("§6消耗巨额的意志自动化操纵注灵祭坛，完成晶块的注灵")
    .addRecipeTooltip("§6仅识别底部输入仓内材料")
    .requireResearch("emo")
.build();}

ZLRecipecreation("ZL1",<ebwizardry:spectral_dust:1>,<ebwizardry:crystal_block:1>,recipeCounter);recipeCounter += 1;
ZLRecipecreation("ZL2",<ebwizardry:spectral_dust:2>,<ebwizardry:crystal_block:2>,recipeCounter);recipeCounter += 1;
ZLRecipecreation("ZL3",<ebwizardry:spectral_dust:3>,<ebwizardry:crystal_block:3>,recipeCounter);recipeCounter += 1;
ZLRecipecreation("ZL4",<ebwizardry:spectral_dust:4>,<ebwizardry:crystal_block:4>,recipeCounter);recipeCounter += 1;
ZLRecipecreation("ZL5",<ebwizardry:spectral_dust:5>,<ebwizardry:crystal_block:5>,recipeCounter);recipeCounter += 1;
ZLRecipecreation("ZL6",<ebwizardry:spectral_dust:6>,<ebwizardry:crystal_block:6>,recipeCounter);recipeCounter += 1;
ZLRecipecreation("ZL7",<ebwizardry:spectral_dust:7>,<ebwizardry:crystal_block:7>,recipeCounter);recipeCounter += 1;