//Recipes By Hikari_Nova.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 890
#loader crafttweaker reloadable

import novaeng.hypernet.RegistryHyperNet;
import novaeng.hypernet.research.ResearchCognitionData;

val baseComputationPoint = 24000.0F;
val baseTFloPsPerTick = 115.0F;

// 7.0 ~ 7.9
# 力场发生器
RegistryHyperNet.addResearchCognitionData(ResearchCognitionData.create("field_generator_v1", "下界之星还是下届之星？",
        <contenttweaker:field_generator_v1>,    // 预览物品
        7.0,                                 // 科技等级（难度）
        baseComputationPoint * (baseTFloPsPerTick + (0.0F * 10)),                          // 需要科研点
        baseTFloPsPerTick + (0.0F * 10),                               // 最低每 Tick 算力要求
        [
            "在击败凋灵之后对其的调查工作期间，我们在其体内发现了一种散发着光芒的物体。",
            "由于形状酷似星星，我们暂且就叫它下界之星。",
            "它在大气中始终保持着悬浮状态，这也有可能是凋灵能够在空中悬浮的原因，目前仍然无法测量它的大致重量。",
            "",
            "如果能够操纵它的悬浮能力，这将为我们的工业水平带来巨大的提升，需要进一步研究。",
        ],
        [
            "通过调整柳钢线圈对下界之星的相对位置和角度，然后施加不同程度的能量脉冲，可以引导下界之星向指定的方向前进，虽然目前为止还不够精确。",
            "接下来我们只需要知道如何把这颗星星封装起来。",
            "",
            "§2§o文案/策划/代码/模型：Hikari_Nova",
        ],
        [
            "precision_assembler"                                 // 前置科技
        ]
));

# 晶金座仪式构建器
RegistryHyperNet.addResearchCognitionData(ResearchCognitionData.create("mineralis_ritual", "晶金座仪式构建",
        <additions:novaextended-novaextended_medal1>,    // 预览物品
        7.0,                                 // 科技等级（难度）
        baseComputationPoint * (baseTFloPsPerTick + (0.0F * 10)),                          // 需要科研点
        baseTFloPsPerTick + (0.0F * 10),                               // 最低每 Tick 算力要求
        [
            "§6晶金座§f拥有着保佑所有矿物工作者的力量，因为它可以点石成金，化枯石为烁金。",
            "§6这种力量经天体水晶与仪式基座，可以将这股力量产生的影响大幅放大，但与之带来的损耗也会加剧。",
        ],
        [
            "§2解锁§6§l晶金座§f§5仪式构建器§2的所有配方§6（首先需要连接 HyperNet 网络）§2。",
            "",
            "§e“晶金座最初由民间星相学家比对过数千张星空彩绘与摄影后，在矿区发现，",
            "§e统御星座的星神大手一挥，便可让朽石化作金银铜铁，但祂似乎从来都在各大矿区处驻足，绝不迁往其他地方。",
            "§e以前的矿工们在极度危险的境地中工作，在深邃不见底的矿坑处不断挖掘，",
            "§e晶金星神的神力使得他们欢呼雀跃，因为他们不用再顶着瓦斯爆炸与缺氧的威胁深入地底，",
            "§e但，晶金星神以往并不存在，祂是听到了矿工的愿望与哀嚎，为拯救而从普通生命中升格。",
            "§e是的，他们一直在慕求这种力量，但与其说是星空赐予了他们，不如说是他们自星空处创造。”",
            "",
            "§2§o模型/策划/代码/文案：§0§m§o“熵寂” iNf7y_Entr60py",
        ],
        [
            "phaselense",                                 // 前置科技
            "shining_with_the_stars",                                 // 前置科技
        ]
));

# 异世界矿物提取机
RegistryHyperNet.addResearchCognitionData(ResearchCognitionData.create("different_world", "虚空之下的世界",
        <rftools:dimensional_shard>,    // 预览物品
        7.1,                                 // 科技等级（难度）
        baseComputationPoint * (baseTFloPsPerTick + (1.0F * 10)),                          // 需要科研点
        baseTFloPsPerTick + (1.0F * 10),                               // 最低每 Tick 算力要求
        [
            "书接上文，科员 A 被吸入拟态黑洞后，就在大家准备为他举行葬礼时，那是一个月黑风高夜，伴随着一道亮光，科员 A 带着满满一包钴和阿迪特回来了，由于奇怪的回归方式，触发了实验室的警报装置。",
            "警卫赶到时也被吓得不轻，科员 A 放下电钻就逃跑了。",
            "他大概是卖掉珍惜的钴和阿迪特远走高飞了，自打那以后我们再也没有见过他，但市场上钴和阿迪特价格的大幅下降无疑是他搞的鬼，看来我们也有必要研究下基岩之下的虚空究竟藏着什么大宝贝！—— 摘自《ECO 实验室十大不可思议事件》",
        ],
        [
            "§2解锁工业机械臂配方：§6异世界§a矿物提取§b机控制器§2。",
            "",
            "§2§o模型/策划：liunian，代码：liunian、Hikari_Nova",
        ],
        [
            "void_miner",                                 // 前置科技
            "precision_assembler",                                 // 前置科技
        ]
));

# 物质熵变器
RegistryHyperNet.addResearchCognitionData(ResearchCognitionData.create("material_entropy_converter", "能量守恒定律",
        <minecraft:gunpowder>,    // 预览物品
        7.1,                                 // 科技等级（难度）
        baseComputationPoint * (baseTFloPsPerTick + (1.0F * 10)),                          // 需要科研点
        baseTFloPsPerTick + (1.0F * 10),                               // 最低每 Tick 算力要求
        [
            "能量既不会凭空产生，也不会凭空消失，它只会从一种形式转化为另一种形式，或者从一个物体转移到其它物体，而能量的总量保持不变。那么用爱发电呢？",
        ],
        [
            "§2解锁工业机械臂配方：§e物§6质§c熵§e变§6器控制器§2。",
            "",
            "“能量既不会凭空产生，也不会凭空消失，它只会从一种形式转化为另一种形式，或者从一个物体转移到其它物体，而能量的总量保持不变。” 博学的科员振振有词的背书。",
            "“那么问题来了，我现在需要混沌碎片，我要怎么操作？” 另一位科员不耐烦地看着他。",
            "“之前不是有个什么莱莎琳，说了个什么炼金术，就按她说的用那个龙心当主材料，龙首和下界之星作为身体配件，重构一个混沌碎片不就好了！” 书生科员为了挽尊开始胡言乱语。",
            "“既然你学富五车，那就按你说的做，要是失败了你赔我材料，小臂崽子！” —— 摘自《物质熵变器竟是外来技术》",
            "",
            "§2§o模型：Doogle007，文案：13XXXJ，策划/代码：Hikari_Nova",
        ],
        [
            "ion_generator",
            "precision_assembler",                                 // 前置科技
        ]
));

# 纯晶合成仪
RegistryHyperNet.addResearchCognitionData(ResearchCognitionData.create("plentiful_crystal", "时刻保持充盈",
        <custommc:item929>,    // 预览物品
        7.2,                                 // 科技等级（难度）
        baseComputationPoint * (baseTFloPsPerTick + (0.2F * 10)),                          // 需要科研点
        baseTFloPsPerTick + (0.2F * 10),                               // 最低每 Tick 算力要求
        [
            "在一次实验中，我们意外的发现充能水晶可以存储大量的能源，尽管它不能够存储太久。",
            "我们可以继续发掘它的潜力，这样它就可以作为工程电池的高效顶替。",
        ],
        [
            "§2解锁§b纯晶合成仪§2的所有配方§6（首先需要连接 HyperNet 网络）§2。",
            "",
            "通过一种特殊的矩阵结构，我们可以把多个脉冲水晶借用外力将其聚合在一起。",
            "问题是，我们无法用正常的物理外力来做到这件事，脉冲水晶互相碰撞导致的能量脉冲会导致机械发生电磁短路。",
            "",
            "因此，我们开发了§b纯晶合成仪§f。",
            "纯晶合成仪通过力场操纵材料，中间无任何物理接触，此外还可以用来传递能量。",
            "",
            "结合后的脉冲水晶表现出相对稳定的状态，虽然它依然不能够持久存储能量，但是它可以在短时间内吸收巨大的能量/能量脉冲。",
            "也许可以用来完成一些某些对能量波动较为敏感的任务？目前还没有发现。",
            "",
            "§2§o文案/策划/代码/模型：Hikari_Nova",
        ],
        [
            "field_generator_v1",
            "precision_assembler",                                 // 前置科技
        ]
));

# Mana 收集器
RegistryHyperNet.addResearchCognitionData(ResearchCognitionData.create("mana_collector", "魔力凝聚",
        <botania:manaresource:1>,    // 预览物品
        7.2,                                 // 科技等级（难度）
        baseComputationPoint * (baseTFloPsPerTick + (2.0F * 10)),                          // 需要科研点
        baseTFloPsPerTick + (2.0F * 10),                               // 最低每 Tick 算力要求
        [
            "根据先前 ECO 实验室通过对神秘花朵的研究，发现空气中有很多四散的魔力，根据拉菲尼的描述，实验室将其命名为 Mana。",
            "随着实验规模的扩大，对 Mana 的需求大幅提升，我们需要一台专门收集空气中的 Mana 的机械。"
        ],
        [
            "§2解锁工业机械臂配方：§aMana 收集器控制器§2。",
            "",
            "Mana 收集器借助奥利哈钢及泰拉钢二者重叠形成强大的万有魔引力定律，将空气中漂浮的魔力聚集在机器内，最终由魔力水晶将其转换为液态存储使用。 —— 摘自《记 Mana 诞辰之初》",
            "",
            "§2§o文案：13XXXJ，模型/策划/代码：Hikari_Nova",
        ],
        [
            "advanced_theory_of_magic",
            "field_generator_v1",
            "precision_assembler",                                 // 前置科技
        ]
));

# 辉光魔力池
RegistryHyperNet.addResearchCognitionData(ResearchCognitionData.create("illum_pool", "闪耀之池",
        <botania:pool:3>,    // 预览物品
        7.2,                                 // 科技等级（难度）
        baseComputationPoint * (baseTFloPsPerTick + (2.0F * 10)),                          // 需要科研点
        baseTFloPsPerTick + (2.0F * 10),                               // 最低每 Tick 算力要求
        [
            "一次意义重大的实验，让大陆上的魔法与星空完美结合在一起。",
            "#FFFF00-00FF7F辉光魔力池§f，魔法容量巨大的容器，魔力存储技术的一大进步。",
        ],
        [
            "§2解锁工业机械臂配方：#FFFF00-00FF7F辉光魔力池控制器§2。",
            "§9最大并行数：§a256",
            "§9基础魔力消耗：§c200%",
            "§e最大并行数与魔力消耗受辉光魔力池上方的天体水晶石属性影响。",
            "",
            "没写完捏。",
            "",
            "§7§o池中不断散发的彩虹光辉，正是星空对我们投出的怀抱。",
            "",
            "§2§o文案/模型/策划/代码/特效：Hikari_Nova",
        ],
        [
            "advanced_theory_of_magic",
            "shining_with_the_stars",
            "mana_collector",
        ]
));

# 黑莲龙木
RegistryHyperNet.addResearchCognitionData(ResearchCognitionData.create("black_dragon_lotus", "末影之中诞生的暗黑莲花",
        <botania:blacklotus:1>,    // 预览物品
        7.3,                                 // 科技等级（难度）
        baseComputationPoint * (baseTFloPsPerTick + (3.0F * 10)),                          // 需要科研点
        baseTFloPsPerTick + (3.0F * 10),                               // 最低每 Tick 算力要求
        [
            "一朵无害的莲花，在与盖亚守护者交流不畅时，他总是会从口袋里掏出几朵扔在实验室人员脸上扬长而去（明明长相一样）。",
            "因数量稀少而备受呵护，在实验室同事熊孩子造访之际，被小孩子当玩具投入了魔力池，竟意外的发现可以转换成魔力。",
        ],
        [
            "§2解锁工业机械臂配方：§e黑§d莲§e龙§d木控制器§2。",
            "",
            "科员一边将小孩赶出去，一边拿着最后一朵黑莲花进行显微分析，发现其物质与黑曜石及末地石极其相似，随后科员尝试使用龙首、龙石作为核心，泰拉钢及少部分奥利哈刚作为稳定剂，尽管外形按照暗黑莲花微观形态复原但仍无法生产暗黑莲花。",
            "",
            "愤怒的科员决定徒手拆除 Mana 收集器控制器，将其中控制器及水晶塞入黑莲龙木，然后使用盈能水晶进行充能，最终以紫颂花为介质成功召唤出了大批量的黑莲花，获得奥斯卡产魔大奖。—— 摘自《电炉的堕落，莲花的崛起》",
            "",
            "§2§o文案：13XXXJ，模型/策划/代码：Hikari_Nova",
        ],
        [
            "plentiful_crystal",
            "mana_collector",
        ]
));

# 泰拉钢矿钻
RegistryHyperNet.addResearchCognitionData(ResearchCognitionData.create("mana_ore_drill", "魔力驱动的机械",
        <botania:elementiumpick>,    // 预览物品
        7.4,                                 // 科技等级（难度）
        baseComputationPoint * (baseTFloPsPerTick + (4.0F * 10)),                          // 需要科研点
        baseTFloPsPerTick + (4.0F * 10),                               // 最低每 Tick 算力要求
        [
            "艾尔夫海姆矿业不发达，必须要有泰拉钢！",
            "挖矿掺了泰拉钢，一机能顶两机用！",
            "矿机掺了泰拉钢，不流失，不蒸发，零浪费！",
            "矿机掺了泰拉钢，原矿秒产一千八！",
        ],
        [
            "§2解锁工业机械臂配方：§a泰拉钢§d矿钻控制器§2。",
            "",
            "随着黑暗莲花的批发，实验室开始大步推进神秘花研究，泰拉粉碎者应运而生。",
            "“充能好慢！” 酷爱挖矿的科员脸上写着一个急。",
            "“听我说你先别急，拿上你的托尔之戒你的魔力也不够用的，戒指充能了吗？” 好心科员劝说道。",
            "“啊啊啊啊又要魔力又要充能又要戒指，我炸了” 挖矿科员蚌不住了，愤怒的他决定将充能一半的镐拿出来用源质钢及精灵尘合成，为了保证充能不流失使用了力场发生器控制变量。",
            "根据 Mana 吸引的原理，使用了大量魔力钢，泰拉钢，奥利哈刚及源质钢使用魔力钻石及彩虹桥方块进行矿物筛选，剔除无效矿物，最终用信标定位矿物位置，完成了举世瞩目的 “泰拉钢矿钻”。—— 摘自《高品质矿机的由来》",
            "",
            "§2§o文案：13XXXJ，模型/策划/代码：Hikari_Nova",
        ],
        [
            "black_dragon_lotus",
            "mineral_extractor",
            "precision_assembler",
        ]
));

# 水晶注能机
RegistryHyperNet.addResearchCognitionData(ResearchCognitionData.create("crystal_injector", "注入最纯净的能量",
        <contenttweaker:energized_fuel_v2>,    // 预览物品
        7.5,                                 // 科技等级（难度）
        baseComputationPoint * (baseTFloPsPerTick + (5.0F * 10)),                          // 需要科研点
        baseTFloPsPerTick + (5.0F * 10),                               // 最低每 Tick 算力要求
        [
            "由 ECO 实验室主导，九转大肠公司提供物料支持开发出 “充能燃料单元”，由于九转大肠公司提倡 “原汁原味” 的公司理念，第一批试作品尽管可以正常使用，但由于其 “特殊的香味”，部分科员出现生理不适的现象，故实验室不得不自行开发一台全新的机器，主要用于燃料单元的制作与回收作业。（顺带能制作一些水晶不是更好吗！）",
        ],
        [
            "§2解锁工业机械臂配方：§b水晶注能机控制器§2。",
            "",
            "实验室在研究神秘花朵时，将魔力水晶投入魔力池中一段时间后，水晶会吸收魔力转换为注能魔力水晶，根据吸收魔力的量，实验室将其分为 3 个等级。",
            "由于等级 2 和 3 需要吸收几何倍率的魔力，鉴于扫地大妈的 gank 频率，决定加入催化剂龙石及盖亚魂锭提速，效果显著。",
            "",
            "此外，注能机还能够混合一系列材料，制作具有包含大量和转化的能源的特殊性质燃料。",
            "通过观察烈焰之炽焱的变化，通过魔力尘、充能混合物及中子素粒进行诱导，制作出 ENG-F-41 系列燃料单元供小工厂基地使用；",
            "根据氘氚反应剩余残渣提纯并与 ENG-F-41 系列进行等比混合制作出 ENG-F-42 系列军用；",
            "根据实验室对混沌龙及末地龙的解析数据，分析出两种产物液体按一定比例混合后在与 ENG-F-42 再次融合，可以产出 ENG-F-43 系列燃料，该系列燃料后期用于航天事业；",
            "ENG-F-44 系列在工程部有设计概念，但由于无法获得相关原料，无法投入生产，也许未来会出现？——《多功能水晶注能机为何会有 12 个端口可以任意摆放？资深玩家教你如何布置》",
            "",
            "另外，为了保证安全性，并降低燃料容器的制作成本，根据燃料的性质，实验室还制定了一系列的燃料容器标准。",
            "§bENG-F-41xx §f对应 §bENG-FC-41xx§f；",
            "§5ENG-F-42xx §f对应 §5ENG-FC-42xx§f；",
            "§6ENG-F-43xx §f对应 §6ENG-FC-43xx§f；",
            "§cENG-F-44xx §f对应 §cENG-FC-44xx§f。",
            "",
            "ENG-F-42 之后的燃料在传统的发电机械中由于蕴含的能量过于强大，存在爆炸风险，因此无法被正常使用。",
            "也许未来能够开发一种能够高效利用这种燃料的全新机械？",
            "",
            "§7§o你知道吗：水晶注能机结构整体可以有 2 个控制器，一个在正面，一个在背面。",
            "",
            "§2§o文案：13XXXJ、Hikari_Nova，模型/策划/代码：Hikari_Nova",
        ],
        [
            "precision_assembler",
        ]
));

# 释能器 / 高级释能器
RegistryHyperNet.addResearchCognitionData(ResearchCognitionData.create("energy_releaser", "释放一切能量",
        <contenttweaker:energized_fuel_depleted_v2>,    // 预览物品
        7.5,                                 // 科技等级（难度）
        baseComputationPoint * (baseTFloPsPerTick + (5.0F * 10)),                          // 需要科研点
        baseTFloPsPerTick + (5.0F * 10),                               // 最低每 Tick 算力要求
        [
            "没写完捏。",
        ],
        [
            "§2解锁工业机械臂配方：§c释能器控制器 / §d高级§c释能器控制器§2。",
            "",
            "没写完捏。",
            "",
            "§2§o模型/策划/代码：Hikari_Nova",
        ],
        [
            "crystal_injector",
            "precision_assembler",
        ]
));

# 电磁发电机
RegistryHyperNet.addResearchCognitionData(ResearchCognitionData.create("di_ci", "磁生电",
        <contenttweaker:sensor_v2>,    // 预览物品
        7.6,                                 // 科技等级（难度）
        baseComputationPoint * (baseTFloPsPerTick + (6.0F * 10)),                          // 需要科研点
        baseTFloPsPerTick + (6.0F * 10),                               // 最低每 Tick 算力要求
        [
            "通过电磁我们可以产生电能。同理，我们可以利用星球的磁场来发电。",
        ],
        [
            "§2解锁工业机械臂配方：§b电磁发电机控制器§2。",
            "",
            "发电量随着高度的变化而变化。",
            "",
            "§a§o你知道吗：电磁发电机的灵感来自无人深空中的“电磁发电机”。",
            "",
            "§2§o模型/策划：IMTIOT，代码：Hikari_Nova",
        ],
        [
            "precision_assembler",
        ]
));

# 能量液化机 / 能量转换器
RegistryHyperNet.addResearchCognitionData(ResearchCognitionData.create("energy_converter", "更高效的能量存储",
        <ic2:fluid_cell>.withTag({Fluid: {FluidName: "liquid_energy", Amount: 1000}}),    // 预览物品
        7.6,                                 // 科技等级（难度）
        baseComputationPoint * (baseTFloPsPerTick + (6.0F * 10)),                          // 需要科研点
        baseTFloPsPerTick + (6.0F * 10),                               // 最低每 Tick 算力要求
        [
            "这是什么？有源变压器？扭一下",
            "",
            "“警告！实验室 A3 区域失火！警告！这不是演习！系统检测该区域无任何生命迹象，已启动封锁。请有序疏散所有科员！” 广播用标准的普通话急促地播放着。本月已经是第四起起火事故，起火地点均为自动化生产车间电线过热。",
            "",
            "随后 Nova 召集全部科员开会：实验室的消防设施是红尖尖铺地板换来的，连续火灾受损被控制在最小范围内，经调查是电线电流过大，据不完全统计，当前用电已经远超理论上限 50%，电线比我家小太阳都热，科员们有没有好点子？",
            "“那么换一种方式传输呢？比如气体” 13X 即答。",
            "“气体的运输及管理成本太高，不如转成液体？”蕾咪随口反驳道。",
            "“那你有办法将电力转换成水吗？” 13X 不解。",
            "“或许我们可以去问问神奇的艾尔夫海姆海螺呢？”",
            "",
            "“到底是谁还在更新流量阈值上限只有 32 位 int 的能量传输协议？”",
        ],
        [
            "§2解锁工业机械臂配方：§a能量§b液化机控制器§2。",
            "§2解锁工业机械臂配方：§a能量§c转换器控制器§2。",
            "§2解锁工业机械臂配方：§2微型§a能量§c转换器控制器§2。",
            "",
            "”蕾咪随即掏出一个梦之木制作的海螺吹响，响声贯彻天际。",
            "“可。” 海螺里传来一声奇怪的回复，随后海螺吐出来一本书《液态魔力的始与终》。",
            "“如果把液态魔力的转换法应用于电力上的话，我懂了！” 蕾咪飞奔回自己的研究室闷头研究，约一周后，能量液化机来到了我们眼前。",
            "伴随着这种研究诞生的，是适用于液态能量的机器接口与对应协议。在 ECO 实验室的助推下，很多发电量与耗电量巨大的设备都支持了液态能量的输入。—— 摘自《液态能量为什么是原谅色？》",
            "",
            "§2§o文案：13XXXJ、iNf7y_Entr60py，倾情出演：Remilia，模型/策划/代码：Hikari_Nova",
        ],
        [
            "advanced_theory_of_magic",
            "precision_assembler",
        ]
));

# 先进流体转换装置
RegistryHyperNet.addResearchCognitionData(ResearchCognitionData.create("advanced_liquid_conversion_machine", "混合流体的终极解决方案",
        <ic2:fluid_cell>.withTag({Fluid: {FluidName: "crystalloidneutron", Amount: 1000}}),    // 预览物品
        7.6,                                 // 科技等级（难度）
        baseComputationPoint * (baseTFloPsPerTick + (6.0F * 10)),                          // 需要科研点
        baseTFloPsPerTick + (6.0F * 10),                               // 最低每 Tick 算力要求
        [
            "没写完捏。",
        ],
        [
            "§2解锁工业机械臂配方：§b先进液体转化装置控制器§2。",
            "",
            "实验室发现紫晶素约半年后，科员 13X 发现紫晶素可以根据一定比例与中子素溶液混合，展现出更强的拟态液体。",
            "该液体经尝试发现可以进行一些不完整的复制操作，复制一半的超级煲，后续无法继续复制，半截超级煲甚至不能吃（无色无味会闹肚子）“我在此地放几个水晶矩阵发电，你就看消耗完了就加一点” 蕾咪随手扔给 13X 一组块。",
            "13X 接过块时因为负重不足，有几块掉进了拟态液体中，拟态液体突然开始兽性大发，在储罐里翻滚，13X 赶忙吧罐子封死，只见那液体在封住的一瞬间液体以爆发式的速度发生了薛定谔般的神奇反应，罐内稳定下来后，里面是一种全新的未知液体，颜色接近薄花色。",
            "13X 想到的第一件事就是将超级煲扔进去，果不其然居然成功复制了，复制的超级煲嘎嘣脆，非常美味！",
            "“就叫他 “中子晶” 吧！” 那一晚，13X 吃了足足十个超级煲！",
            "事后蕾咪发现 13X 在偷吃后，为了弥补被偷吃的煲，使用海量的烈焰之赤焱及极寒之凛冰，结合恒星光伏电池对冷热进行微调，成功复现了中子晶的再造过程。",
            "该机器被命名为 “先进液体转化装置” 从此之后，实验室每年都会举办一届超级煲大胃王比赛！胜出者将奖励 1 个月不限量超级煲食用权！（其实先进液体转化装置还能制作其他液体，但是超级煲太香了，嘿嘿嘿）——摘自《超级煲大胃王比赛指南》",
            "",
            "§2§o文案：13XXXJ、倾情出演：Remilia、模型/策划：Blue_Sky_It，代码：Hikari_Nova",
        ],
        [
            "precision_assembler",
        ]
));

# 终极中子收集器
RegistryHyperNet.addResearchCognitionData(ResearchCognitionData.create("neutron_accretion_plate", "最重的材料：中子素",
        <avaritia:resource:4>,    // 预览物品
        7.7,                                 // 科技等级（难度）
        baseComputationPoint * (baseTFloPsPerTick + (7.0F * 10)),                          // 需要科研点
        baseTFloPsPerTick + (7.0F * 10),                               // 最低每 Tick 算力要求
        [
            "实验室的伽马射线望远镜已经闲置许久，科技的进化使研究星空文明不再需要抬头观星，但对星空得渴求一直是实验室不变的根本。",
            "",
            "Nova 一如既往地观察星空，突然发现一颗神奇的星球，他又黑又小，直径约 9 公里，每秒钟可沿自己的轴线旋转 1145 圈。",
            "按照地球的概念转一圈一天的话，在这个中子星上一秒钟可以经过好几年。",
            "",
            "其密度惊人，高达每立方厘米 1 亿吨。其巨大引力从临近恒星不断夺取大量炙热气体，并不断诱发热核爆炸。它上面很少量的一点物质的质量就高达 5 亿吨！",
            "随后，这颗星球被命名为 ECO J1739-285。",
        ],
        [
            "§2解锁工业机械臂配方：§b终极中子收集器控制器§2。",
            "",
            "随后实验室向其发射挖矿飞船，但由于其过于离谱的引力，最后只有一艘飞船的小部分残骸侥幸飘到了实验室可回收范围内，实验室在太空收集仅有的一小部分中子星残骸，对其进行解构研究。",
            "在砸穿无数铌钛合金合成板的高成本加持下，实验室顶着巨大的赤字压力完成了对其相关研究，将其名称为 “中子素”，同时设计出可抵抗部分中子星引力的机械，在中子星环航轨道上布置进行中子素的大规模量产，但其收集速率仍不高，鉴于其机器造价高昂，中子素被视为一种非常珍贵的材料，在实验室大放光彩。—— 摘自《中子星与中子素》",
            "",
            "§2§o文案：13XXXJ，策划：IMTIOT，模型/代码：Hikari_Nova",
        ],
        [
            "precision_assembler",
        ]
));

# 星能发电机
RegistryHyperNet.addResearchCognitionData(ResearchCognitionData.create("stellargenerator", "来自星空的能量",
        <astralsorcery:itemcraftingcomponent:2>,    // 预览物品
        7.8,                                 // 科技等级（难度）
        baseComputationPoint * (baseTFloPsPerTick + (8.0F * 10)),                          // 需要科研点
        baseTFloPsPerTick + (8.0F * 10),                               // 最低每 Tick 算力要求
        [
            "没写完捏。",
        ],
        [
            "§2解锁工业机械臂配方：§3[§fIRIS§3]§b星能§f发电机控制器§2。",
            "",
            "将§b星能[IRIS]§f转化为电势能的机器。",
            "群星蕴含的力量，或许远超人们的想象。",
            "只能在§b夜晚§f工作，放入§e时钟座星图§f后则无视工作时间。",
            "",
            "§2§o文案/模型/策划/代码：Arco_§b§o[IRIS]",
        ],
        [
            "iridescentobservatory",                                 // 前置科技
            "precision_assembler",
        ]
));

# 相位引星塔
RegistryHyperNet.addResearchCognitionData(ResearchCognitionData.create("phase_planet_traction_tower", "凿洞移星",
        <extendedcrafting:material:40>,    // 预览物品
        7.9,                                 // 科技等级（难度）
        baseComputationPoint * (baseTFloPsPerTick + (9.0F * 10)),                          // 需要科研点
        baseTFloPsPerTick + (9.0F * 10),                               // 最低每 Tick 算力要求
        [
            "在天外陨石中的外星技术，使得方块人的科技飞速发展。",
            "方块人是富有求知欲的，在航天技术成熟后，他们便开始了探索 AE 文明的计划。",
            "但是他们对其所知甚少，进展并不顺利。",
            "ECO 实验室注意到该项目后，为其投入了大量经费以供科学家继续研究。",
            "",
            "但在血魔法师一次灾难性的坠星仪式后，事情却迎来了转机。",
            "这位异想天开的法师在仪式中心投入 AE 的网络控制器，随即一颗庞大的 AE 陨石几乎轰毁了周边的一切。（这也是方块人禁止一切非官方的坠星仪式的缘由）",
            "在其坠星事故后，ECO 实验室封锁其周边所有环境，并派遣了科学家进行调查。",
            "",
            "这颗陨石异常的坚硬，其材料组成绝非我们先前见过的陨石，根据它的材料特性，科学家们将其命名为：“黑陨铁”。",
            "",
            "随后科学家们使用特殊材料的切割机切开了陨石，奇怪的是，里面没有压印板，竟是是一块庞大的星图！",
            "在 ECO 实验室旗下的占星学分部和太空学分部的引导下，最终定位了 AE 人的母星。",
        ],
        [
            "§2解锁集成式处理车间配方：§d相位§f引星塔控制器§2。",
            "",
            "超光速航行了三个月，随着探索船抵达，满目疮痍的恒星系出现在眼前，到处都是战斗的痕迹，凭借残骸勉强能看出飞船和空间站的模样，我们的生物监测器对恒星没有任何反应。",
            "真是可怕。",
            "",
            "§2§o文案：Doogle007，模型/策划：Remilia，代码：Hikari_Nova",
        ],
        [
            "di_ci",
            "iridescentobservatory",
        ]
));

# 叩响新世界的大门
RegistryHyperNet.addResearchCognitionData(ResearchCognitionData.create("the_eve_of_a_technological_revolution", "§9叩响新世界的大门",
        <thermalfoundation:material:262>,    // 预览物品
        7.9,                                 // 科技等级（难度）
        baseComputationPoint * (baseTFloPsPerTick + (9.0F * 10)) * 3,                          // 需要科研点
        baseTFloPsPerTick + (9.0F * 10),                               // 最低每 Tick 算力要求
        [
            "研究站免费换新，旧款研究站可以抵扣 5000 元，新人更享额外补贴2333元，仅第一次有效！有意请联系：希斯特利亚公司~",
            "13X 的办公邮箱里收到一封垃圾邮件。摸鱼的13x无事可做，决定回复一下邮件：给我整个最新款，我要补多少钱？",
            "“叮~” 邮件居然秒回了：原价 11451.4 元，新人补贴价只需 9163 元。13X 看到价格大喜，当天午夜时分将实验室内的研究站及网络中心搬走送往希斯特利亚公司提供的回收地址。",
        ],
        [
            "§9解锁研究认知：叩响新世界的大门§9。",
            "§2解锁工业机械臂配方：§bHyperNet §9进阶研究站（等级 2）控制器§2。",
            "§2解锁工业机械臂配方：§bHyperNet §5计算网络中心§9（等级 2）控制器§2。",
            "",
            "§9现在你可以着手研究科技等级 §68.0§9 以上的科技了。",
            "",
            "Nova 见实验室内研究站和计算网络中心变成了奇怪的形状，大惊失色，就在准备启动追责程序时，13X 站了出来：只要 9163，新时代计算机网络，ECO 值得拥有！",
            "即使 Nova 在试用新机器后很满意，但 13X 本年的绩效大概还是会被没收，铁定的。",
            "据希斯特利亚公司描述，该系列机器使用更加先进的 CPU 及内存制作，大幅提高可研究认知的复杂度，童叟无欺！",
            "",
            "§2§o文案：13XXXJ",
        ],
        [
            "precision_assembler",
        ]
));

# L6 存储子系统
RegistryHyperNet.addResearchCognitionData(ResearchCognitionData.create("extendable_digital_storage_subsystem_l6", "§6赛特斯晶体宽带",
        <novaeng_core:extendable_digital_storage_subsystem_l6>,    // 预览物品
        7.9,                                 // 科技等级（难度）
        baseComputationPoint * (baseTFloPsPerTick + (9.0F * 10)),                          // 需要科研点
        baseTFloPsPerTick + (9.0F * 10),                               // 最低每 Tick 算力要求
        [
            "粒子宽带将存储密度逼近了赛特斯晶格的极限，提高容量的下一步就是改造晶体。",
        ],
        [
            "§2解锁工业机械臂配方：§9ECO - §6L6 §9可扩展存储子系统主机§2。",
            "",
            "掺杂少量赛特斯的立方氮化硼被证明性能更优，但需要高温烧结后重结晶才能使用。",
            "",
            "§6§o⚡ Powered by §b§oNova Engineering§9§o - EStorage",
            "§2§o模型/材质：WI_8614_ice，文案：nxc_in_china，策划/代码：Hikari_Nova",
        ],
        [
            "extendable_digital_storage_subsystem_l4",
            "the_eve_of_a_technological_revolution",
            "precision_assembler",                                 // 前置科技
        ]
));

# ECO-Y6 物质生成机
RegistryHyperNet.addResearchCognitionData(ResearchCognitionData.create("eco_y6", "最初的本质",
        <ic2:misc_resource:3>,    // 预览物品
        7.9,                                 // 科技等级（难度）
        baseComputationPoint * (baseTFloPsPerTick + (9.0F * 10)) * 1.5F,                          // 需要科研点
        baseTFloPsPerTick + (9.0F * 10),                               // 最低每 Tick 算力要求
        [
            "ECO 实验室由于 UU 用量过大，即使召唤扑满给现有 12 台大型物质生成机加速都无济于事，扑满于心不忍召唤来另一位紫色扑满，只见新来的扑满看了看已经加速到极限的大型物质生成机，默默地扔下一本书离开了，实验室众人黑人问号脸时，只见 13X 拾起那本书，封皮上有一行字 ——《致敬 ECO-R2 》。",
        ],
        [
            "§2解锁工业机械臂配方：§bECO-§9Y6 §e物质生成机控制器。",
            "§2解锁水晶注能机配方：§5注能 UU 水晶。",
            "",
            "ECO 实验室已经拥有了复数台复制机，但 UU 总体数量依旧短缺，部分实验原材料仍无法实现复制自由。",
            "实验室骨干们一筹莫展时，有科员在摸鱼时将魔力水晶扔进了 UU 液里浸泡了长达一天一夜而被转化，水晶已经变成紫色，并且吸收大量 UU 液的水晶无法在物质生成机内工作。",
            "但科员们不舍得将如此贵重得水晶弃置，于是决定将物质生成机进行批量压缩，配合立场发生器及水晶矩阵的神秘力量，最终再次加入大量 UU 完成制作。",
            "紫色的水晶在崭新的机器内沉默了许久，就当大家已经准备放弃时，紫色的液体缓缓地流进了复制机内。",
            "兴奋不已的科员们抱头鼠窜，由于该机器负责人拼音首字母为 Y，且该团队有 6 人，故将该机器命名为 Y6。",
            "",
            "此外，在水晶注能机中将魔力水晶放入不定项水晶矩阵溶液内浸泡，经处理的注能机就可以将 UU 注入水晶内实现量产，但由于 UU 的特殊性，3 级 UU 水晶注入 UU 没有任何反应，推测需要另一种新替代品。在 2 级 UU 水晶的加持下，实验室物质短缺情况大幅缓解。—— 摘自《UU 奇迹 —— Y6 的诞生》",
            "",
            "§9§o你知道吗：在整合包最初开发的时期，还有一个名为 ECO-R2 的大型物质生成机。",
            "",
            "§2§o文案：13XXXJ、Hikari_Nova，模型/策划/代码：Hikari_Nova",
        ],
        [
            "the_eve_of_a_technological_revolution",
            "crystal_injector",
            "precision_assembler",
        ]
));
