//Recipes By Hikari_Nova.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import crafttweaker.item.IItemStack;

import novaeng.NovaEngUtils;
import novaeng.hypernet.NetNodeCache;
import novaeng.hypernet.HyperNetHelper;
import novaeng.hypernet.ResearchStation;
import novaeng.hypernet.RegistryHyperNet;
import novaeng.hypernet.ComputationCenterCache;

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.RecipeCheckEvent;
import mods.modularmachinery.RecipeStartEvent;
import mods.modularmachinery.RecipeFinishEvent;

import mods.modularmachinery.IMachineController;

import mods.modularmachinery.MMEvents;
import mods.modularmachinery.MachineTickEvent;
import mods.modularmachinery.FactoryRecipeTickEvent;
import mods.modularmachinery.ControllerGUIRenderEvent;
import mods.modularmachinery.MachineStructureFormedEvent;

// RecipeBuilder.newBuilder("research_station_t3_working_test", "research_station_t3", 100, 0, false)
//     .addEnergyPerTickInput(75000)
//     .addPostCheckHandler(function(event as RecipeCheckEvent) {
//         val ctrl = event.controller;
//         ResearchStation.from(ctrl).onRecipeCheck(event);
//     })
//     .addFactoryPreTickHandler(function(event as FactoryRecipeTickEvent) {
//         val ctrl = event.controller;
//         ResearchStation.from(ctrl).onWorkingTick(event);
//     })
//     .setMaxThreads(1)
//     .build();

// RecipeBuilder.newBuilder("research_station_t1_connect", "research_station_t1", 1, 0, false)
//     .addEnergyPerTickInput(10000)
//     .addInput(<contenttweaker:hypernet_connect_card>).setNBTChecker(function(ctrl as IMachineController, item as IItemStack) {
//         val pos = HyperNetHelper.readConnectCardInfo(ctrl, item);
//         if (isNull(pos)) {
//             return false;
//         } else {
//             val station = ResearchStation.from(ctrl);
//             return station.connectTo(pos);
//         }
//     })
//     .addOutput(<contenttweaker:hypernet_connect_card>).addItemModifier(function(ctrl as IMachineController, item as IItemStack) {
//         val station = ResearchStation.from(ctrl);
//         return station.getConnectCardOutput(item);
//     })
//     .setMaxThreads(1)
//     .build();

// RecipeBuilder.newBuilder("research_station_t2_connect", "research_station_t2", 1, 0, false)
//     .addEnergyPerTickInput(10000)
//     .addInput(<contenttweaker:hypernet_connect_card>).setNBTChecker(function(ctrl as IMachineController, item as IItemStack) {
//         val pos = HyperNetHelper.readConnectCardInfo(ctrl, item);
//         if (isNull(pos)) {
//             return false;
//         } else {
//             val station = ResearchStation.from(ctrl);
//             return station.connectTo(pos);
//         }
//     })
//     .addOutput(<contenttweaker:hypernet_connect_card>).addItemModifier(function(ctrl as IMachineController, item as IItemStack) {
//         val station = ResearchStation.from(ctrl);
//         return station.getConnectCardOutput(item);
//     })
//     .setMaxThreads(1)
//     .build();

// RecipeBuilder.newBuilder("research_station_t3_connect", "research_station_t3", 1, 0, false)
//     .addEnergyPerTickInput(10000)
//     .addInput(<contenttweaker:hypernet_connect_card>).setNBTChecker(function(ctrl as IMachineController, item as IItemStack) {
//         val pos = HyperNetHelper.readConnectCardInfo(ctrl, item);
//         if (isNull(pos)) {
//             return false;
//         } else {
//             val station = ResearchStation.from(ctrl);
//             return station.connectTo(pos);
//         }
//     })
//     .addOutput(<contenttweaker:hypernet_connect_card>).addItemModifier(function(ctrl as IMachineController, item as IItemStack) {
//         val station = ResearchStation.from(ctrl);
//         return station.getConnectCardOutput(item);
//     })
//     .setMaxThreads(1)
//     .build();

// MMEvents.onStructureFormed("research_station_t1", function(event as MachineStructureFormedEvent) {
//     val ctrl = event.controller;
//     ResearchStation.from(ctrl).writeNBT();
// });

// MMEvents.onStructureFormed("research_station_t2", function(event as MachineStructureFormedEvent) {
//     val ctrl = event.controller;
//     ResearchStation.from(ctrl).writeNBT();
// });

// MMEvents.onStructureFormed("research_station_t3", function(event as MachineStructureFormedEvent) {
//     val ctrl = event.controller;
//     ResearchStation.from(ctrl).writeNBT();
// });

// MMEvents.onMachinePreTick("research_station_t1", function(event as MachineTickEvent) {
//     val ctrl = event.controller;
//     ResearchStation.from(ctrl).onMachineTick();
// });

// MMEvents.onMachinePreTick("research_station_t2", function(event as MachineTickEvent) {
//     val ctrl = event.controller;
//     ResearchStation.from(ctrl).onMachineTick();
// });

// MMEvents.onMachinePreTick("research_station_t3", function(event as MachineTickEvent) {
//     val ctrl = event.controller;
//     ResearchStation.from(ctrl).onMachineTick();
// });

MMEvents.onControllerGUIRender("research_station_t1", function(event as ControllerGUIRenderEvent) {
    onGUIRender(event);
});

MMEvents.onControllerGUIRender("research_station_t2", function(event as ControllerGUIRenderEvent) {
    onGUIRender(event);
});

MMEvents.onControllerGUIRender("research_station_t3", function(event as ControllerGUIRenderEvent) {
    onGUIRender(event);
});

function onGUIRender(event as ControllerGUIRenderEvent) {
    val ctrl = event.controller;
    val researchStation = NetNodeCache.getResearchStation(ctrl);

    if (ctrl.ticksExisted % 20 == 0) {
        researchStation.readNBT();
    }

    var info as string[] = [
        "§9//////////// 研究站 ////////////"
    ];

    if (ctrl.isWorking) {
        info += "§9算力消耗：§b" + formatFLOPS(researchStation.computationPointConsumption);
    }

    if (researchStation.connected) {
        info += "§9网络状态：§a已连接";
        info += "§9总算力消耗 / 产出：§b" +
            formatFLOPS(ComputationCenterCache.getComputationPointConsumption()) +
            " / " +
            formatFLOPS(ComputationCenterCache.getComputationPointGeneration());
    } else {
        info += "§9网络状态：§c断开连接";
    }

    info += "§7HyperNet Monitor v1.0";
    info += "§9//////////////////////////////";

    event.extraInfo = info;
}

function formatFLOPS(tflops as float) as string {
    if (tflops < 1000.0F) {
        return NovaEngUtils.formatFloat(tflops, 1) + "T FloPS";
    }
    return NovaEngUtils.formatFloat(tflops / 1000.0F, 1) + "P FloPS";
}
