//Recipes By Hikari_Nova.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import crafttweaker.item.IItemStack;

import novaeng.NovaEngUtils;

import novaeng.hypernet.Database;
import novaeng.hypernet.NetNodeCache;
import novaeng.hypernet.HyperNetHelper;
import novaeng.hypernet.RegistryHyperNet;
import novaeng.hypernet.ComputationCenterCache;

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.RecipeCheckEvent;
import mods.modularmachinery.RecipeStartEvent;
import mods.modularmachinery.RecipeFinishEvent;

import mods.modularmachinery.IMachineController;

import mods.modularmachinery.MMEvents;
import mods.modularmachinery.MachineTickEvent;
import mods.modularmachinery.FactoryRecipeTickEvent;
import mods.modularmachinery.FactoryRecipeStartEvent;
import mods.modularmachinery.FactoryRecipeFinishEvent;
import mods.modularmachinery.ControllerGUIRenderEvent;
import mods.modularmachinery.MachineStructureFormedEvent;

// RecipeBuilder.newBuilder("database_t1_connect", "database_t1", 1, 1, false)
//     .addEnergyPerTickInput(10000)
//     .addInput(<contenttweaker:hypernet_connect_card>).setNBTChecker(function(ctrl as IMachineController, item as IItemStack) {
//         val pos = HyperNetHelper.readConnectCardInfo(ctrl, item);
//         if (isNull(pos)) {
//             return false;
//         } else {
//             val database = Database.from(ctrl);
//             return database.connectTo(pos);
//         }
//     })
//     .addOutput(<contenttweaker:hypernet_connect_card>).addItemModifier(function(ctrl as IMachineController, item as IItemStack) {
//         val database = Database.from(ctrl);
//         return database.getConnectCardOutput(item);
//     })
//     .setMaxThreads(1)
//     .build();

// RecipeBuilder.newBuilder("database_t1_working", "database_t1", 20, 0, true)
//     .addEnergyPerTickInput(10000)
//     .addFactoryPreTickHandler(function(event as FactoryRecipeTickEvent) {
//         val ctrl = event.controller;
//         Database.from(ctrl).onWorkingTick(event);
//     })
//     .setMaxThreads(1)
//     .build();

// MMEvents.onMachinePreTick("database_t1", function(event as MachineTickEvent) {
//     val ctrl = event.controller;
//     Database.from(ctrl).onMachineTick();
// });

MMEvents.onControllerGUIRender("database_t1", function(event as ControllerGUIRenderEvent) {
    onGUIRender(event);
});

function onGUIRender(event as ControllerGUIRenderEvent) {
    val ctrl = event.controller;
    val database = NetNodeCache.getDatabase(ctrl);

    if (ctrl.ticksExisted % 10 == 0) {
        database.readNBT();
    }

    var info as string[] = [
        "§9////////// 网络数据库 //////////"
    ];

    info += "§9已存储的研究认知数量：§b" + database.storedResearchCognition.length + " / " + database.type.maxResearchDataStoreSize;

    if (database.connected) {
        info += "§9网络状态：§a已连接";
        info += "§9总算力消耗 / 产出：§b" +
            formatFLOPS(ComputationCenterCache.getComputationPointConsumption()) +
            " / " +
            formatFLOPS(ComputationCenterCache.getComputationPointGeneration());
    } else {
        info += "§9网络状态：§c断开连接";
    }

    info += "§7HyperNet Monitor v1.0";
    info += "§9//////////////////////////////";

    event.extraInfo = info;
}

function formatPercent(num1 as float, num2 as float) {
    return NovaEngUtils.formatFloat((num1 * 100) as float / num2 as float, 2) + "%";
}

function formatFLOPS(tflops as float) as string {
    if (tflops < 1000.0F) {
        return NovaEngUtils.formatFloat(tflops, 1) + "T FloPS";
    }
    return NovaEngUtils.formatFloat(tflops / 1000.0F, 1) + "P FloPS";
}
