//Recipes By Hikari_Nova.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 50
#loader crafttweaker reloadable

import crafttweaker.item.IItemStack;

import novaeng.NovaEngUtils;

import novaeng.hypernet.NetNodeCache;
import novaeng.hypernet.DataProcessor;
import novaeng.hypernet.HyperNetHelper;
import novaeng.hypernet.RegistryHyperNet;
import novaeng.hypernet.DataProcessorType;
import novaeng.hypernet.ComputationCenterCache;

import mods.modularmachinery.RecipePrimer;
import mods.modularmachinery.RecipeBuilder;
import mods.modularmachinery.RecipeCheckEvent;
import mods.modularmachinery.RecipeStartEvent;
import mods.modularmachinery.RecipeFinishEvent;

import mods.modularmachinery.IMachineController;

import mods.modularmachinery.MMEvents;
import mods.modularmachinery.MachineTickEvent;
import mods.modularmachinery.FactoryRecipeTickEvent;
import mods.modularmachinery.FactoryRecipeStartEvent;
import mods.modularmachinery.FactoryRecipeFinishEvent;
import mods.modularmachinery.ControllerGUIRenderEvent;
import mods.modularmachinery.MachineStructureFormedEvent;

// RecipeBuilder.newBuilder("processor_t1_working", "data_processor_t1", 20, 0, true)
//     .addEnergyPerTickInput(10000)
//     .addPostCheckHandler(function(event as RecipeCheckEvent) {
//         val ctrl = event.controller;
//         DataProcessor.from(ctrl).onRecipeCheck(event);
//     })
//     .addFactoryPreTickHandler(function(event as FactoryRecipeTickEvent) {
//         val ctrl = event.controller;
//         DataProcessor.from(ctrl).onWorkingTick(event, 10000);
//     })
//     .setMaxThreads(1)
//     .build();

// RecipeBuilder.newBuilder("processor_t2_working", "data_processor_t2", 20, 0, true)
//     .addEnergyPerTickInput(250000)
//     .addPostCheckHandler(function(event as RecipeCheckEvent) {
//         val ctrl = event.controller;
//         DataProcessor.from(ctrl).onRecipeCheck(event);
//     })
//     .addFactoryPreTickHandler(function(event as FactoryRecipeTickEvent) {
//         val ctrl = event.controller;
//         DataProcessor.from(ctrl).onWorkingTick(event, 250000);
//     })
//     .setMaxThreads(1)
//     .build();

// RecipeBuilder.newBuilder("processor_t1_circuit", "data_processor_t1", 100, 2, false)
//     .addEnergyPerTickInput(1000)
//     .addInput(<contenttweaker:industrial_circuit_v1>)
//     .addPostCheckHandler(function(event as RecipeCheckEvent) {
//         checkCircuitDurability(event);
//     })
//     .addFactoryFinishHandler(function(event as FactoryRecipeFinishEvent) {
//         restoreCircuitDurability(event.controller);
//     })
//     .setMaxThreads(1)
//     .build();

// RecipeBuilder.newBuilder("processor_t2_circuit", "data_processor_t2", 100, 2, false)
//     .addEnergyPerTickInput(10000)
//     .addInput(<contenttweaker:industrial_circuit_v2>)
//     .addPostCheckHandler(function(event as RecipeCheckEvent) {
//         checkCircuitDurability(event);
//     })
//     .addFactoryFinishHandler(function(event as FactoryRecipeFinishEvent) {
//         restoreCircuitDurability(event.controller);
//     })
//     .setMaxThreads(1)
//     .build();

// RecipeBuilder.newBuilder("processor_t1_connect", "data_processor_t1", 1, 1, false)
//     .addEnergyPerTickInput(10000)
//     .addInput(<contenttweaker:hypernet_connect_card>).setNBTChecker(function(ctrl as IMachineController, item as IItemStack) {
//         val pos = HyperNetHelper.readConnectCardInfo(ctrl, item);
//         if (isNull(pos)) {
//             return false;
//         } else {
//             val processor = DataProcessor.from(ctrl);
//             return processor.connectTo(pos);
//         }
//     })
//     .addOutput(<contenttweaker:hypernet_connect_card>).addItemModifier(function(ctrl as IMachineController, item as IItemStack) {
//         val processor = DataProcessor.from(ctrl);
//         return processor.getConnectCardOutput(item);
//     })
//     .setMaxThreads(1)
//     .build();

// RecipeBuilder.newBuilder("processor_t2_connect", "data_processor_t2", 1, 1, false)
//     .addEnergyPerTickInput(250000)
//     .addInput(<contenttweaker:hypernet_connect_card>).setNBTChecker(function(ctrl as IMachineController, item as IItemStack) {
//         val pos = HyperNetHelper.readConnectCardInfo(ctrl, item);
//         if (isNull(pos)) {
//             return false;
//         } else {
//             val processor = DataProcessor.from(ctrl);
//             return processor.connectTo(pos);
//         }
//     })
//     .addOutput(<contenttweaker:hypernet_connect_card>).addItemModifier(function(ctrl as IMachineController, item as IItemStack) {
//         val processor = DataProcessor.from(ctrl);
//         return processor.getConnectCardOutput(item);
//     })
//     .setMaxThreads(1)
//     .build();

// MMEvents.onStructureFormed("data_processor_t1", function(event as MachineStructureFormedEvent) {
//     val ctrl = event.controller;
//     DataProcessor.from(ctrl).writeNBT();
// });

// MMEvents.onStructureFormed("data_processor_t2", function(event as MachineStructureFormedEvent) {
//     val ctrl = event.controller;
//     DataProcessor.from(ctrl).writeNBT();
// });

// MMEvents.onMachinePreTick("data_processor_t1", function(event as MachineTickEvent) {
//     val ctrl = event.controller;
//     DataProcessor.from(ctrl).onMachineTick();
// });

// MMEvents.onMachinePreTick("data_processor_t2", function(event as MachineTickEvent) {
//     val ctrl = event.controller;
//     DataProcessor.from(ctrl).onMachineTick();
// });

MMEvents.onControllerGUIRender("data_processor_t1", function(event as ControllerGUIRenderEvent) {
    onGUIRender(event);
});

MMEvents.onControllerGUIRender("data_processor_t2", function(event as ControllerGUIRenderEvent) {
    onGUIRender(event);
});

MMEvents.onControllerGUIRender("data_processor_t3", function(event as ControllerGUIRenderEvent) {
    onGUIRender(event);
});

MMEvents.onControllerGUIRender("data_processor_t4", function(event as ControllerGUIRenderEvent) {
    onGUIRender(event);
});

// function checkCircuitDurability(event as RecipeCheckEvent) {
//     val ctrl = event.controller;
//     val processor = DataProcessor.from(ctrl);
//     val type = processor.type;
//     val durability = processor.circuitDurability;
//     if (durability >= type.circuitDurability as float * 0.05F) {
//         event.setFailed("电路板状态良好。");
//     }
// }

// function restoreCircuitDurability(ctrl as IMachineController) {
//     val processor = DataProcessor.from(ctrl);
//     val type = processor.type;
//     processor.circuitDurability = type.circuitDurability;
// }

function onGUIRender(event as ControllerGUIRenderEvent) {
    val ctrl = event.controller;
    val processor = NetNodeCache.getDataProcessor(ctrl);
    val type = processor.type;

    if (ctrl.ticksExisted % 20 == 0) {
        processor.readNBT();
    }

    var info as string[] = [
        "§9////////// 计算机监控 //////////"
    ];

    if (ctrl.isWorking) {
        val maxProvision = processor.maxGeneration;
        val provision = min(processor.computationalLoad, maxProvision);
        info += "§9算力：§b" + formatFLOPS(provision) + " / " + formatFLOPS(maxProvision) + "（负载：§e" + formatPercent(provision / maxProvision, 1.0F) + "§b）";
    }

    val overHeatPercent = processor.storedHU as float / type.overheatThreshold;
    if (overHeatPercent >= 0.85F) {
        info += "§9内部热量：§c" + processor.storedHU + " HU" + "（" + formatPercent(overHeatPercent, 1.0F) + "，触发温控）";
    } else {
        info += "§9内部热量：§c" + processor.storedHU + " HU" + "（" + formatPercent(overHeatPercent, 1.0F) + "）";
    }

    if (processor.connected) {
        info += "§9网络状态：§a已连接";
        info += "§9总算力消耗 / 产出：§b" +
            formatFLOPS(ComputationCenterCache.getComputationPointConsumption()) +
            " / " +
            formatFLOPS(ComputationCenterCache.getComputationPointGeneration());
    } else {
        info += "§9网络状态：§c断开连接";
    }

    info += "§7HyperNet Monitor v1.0";
    info += "§9//////////////////////////////";

    event.extraInfo = info;
}

function formatPercent(num1 as float, num2 as float) as string {
    return NovaEngUtils.formatFloat((num1 as float / num2 as float) * 100.0F, 2) + "%";
}

function formatFLOPS(tflops as float) as string {
    if (tflops < 1000.0F) {
        return NovaEngUtils.formatFloat(tflops, 1) + "T FloPS";
    }
    return NovaEngUtils.formatFloat(tflops / 1000.0F, 1) + "P FloPS";
}

function min(a as float, b as float) as float {
    return a <= b ? a : b;
}
