import novaeng.hypernet.item.ServerModuleItemBuilder;
import novaeng.hypernet.item.ModularServerItemBuilder;
import novaeng.hypernet.server.module.ServerModuleRegistry;
import novaeng.hypernet.server.module.base.ModuleCPUBase;
import novaeng.hypernet.server.module.base.ModuleRAMBase;
import novaeng.hypernet.server.module.base.ModulePSUBase;
import novaeng.hypernet.server.module.base.ModuleCapacitorBase;
import novaeng.hypernet.server.module.base.ModuleCPUHeatRadiatorBase;
import novaeng.hypernet.server.module.base.ModuleRAMHeatRadiatorBase;
import novaeng.hypernet.server.module.base.ModuleCalculateCardExtBase;
import novaeng.hypernet.server.module.base.ModuleSoulCalculateCardBase;
import novaeng.hypernet.server.module.base.ModuleCalculateCardHeatRadiatorBase;

#loader preinit reloadable

// Calculate Card Ext
val calculateCardExtBase = ModuleCalculateCardExtBase.create("module_calculate_card_ext", 10);
ServerModuleRegistry.registryModuleBase(calculateCardExtBase);
ServerModuleItemBuilder.create("module_calculate_card_ext")
    .setBoundedModule(calculateCardExtBase)
    .register();

// Modular Server T1
ModularServerItemBuilder.create("modular_server_t1").register();

// CPU - W T1
val cpuWT1 = ModuleCPUBase.create("cpu_w_t1", 1, 10 * 1000, 5);
ServerModuleRegistry.registryModuleBase(cpuWT1);
ServerModuleItemBuilder.create("cpu_w_t1")
    .setBoundedModule(cpuWT1)
    .register();

// CPU Heat radiator
val cpuHeatRadiator = ModuleCPUHeatRadiatorBase.create("cpu_heat_radiator");
ServerModuleRegistry.registryModuleBase(cpuHeatRadiator);
ServerModuleItemBuilder.create("cpu_heat_radiator")
    .setBoundedModule(cpuHeatRadiator)
    .register();

// RAM T1
val ramT1 = ModuleRAMBase.create("ram_t1", 10);
ServerModuleRegistry.registryModuleBase(ramT1);
ServerModuleItemBuilder.create("ram_t1")
    .setBoundedModule(ramT1)
    .register();

// RAM heat radiator
val ramHeatRadiator = ModuleRAMHeatRadiatorBase.create("ram_heat_radiator");
ServerModuleRegistry.registryModuleBase(ramHeatRadiator);
ServerModuleItemBuilder.create("ram_heat_radiator")
    .setBoundedModule(ramHeatRadiator)
    .register();

// Soul Calculate Card
val soulCalculateCard = ModuleSoulCalculateCardBase.create("module_soul_calculate_card_t1", 10, 2.5D * 1000 * 1000, 50);
ServerModuleRegistry.registryModuleBase(soulCalculateCard);
ServerModuleItemBuilder.create("module_soul_calculate_card_t1")
    .setBoundedModule(soulCalculateCard)
    .register();

// Calculate card heat radiator
val calculateCardHeatRadiator = ModuleCalculateCardHeatRadiatorBase.create("calculate_card_heat_radiator");
ServerModuleRegistry.registryModuleBase(calculateCardHeatRadiator);
ServerModuleItemBuilder.create("calculate_card_heat_radiator")
    .setBoundedModule(calculateCardHeatRadiator)
    .register();

// PSU T1
val psuT1 = ModulePSUBase.create("psu_t1", 100 * 1000);
ServerModuleRegistry.registryModuleBase(psuT1);
ServerModuleItemBuilder.create("psu_t1")
    .setBoundedModule(psuT1)
    .register();