//Recipes By Hikari_Nova.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.

#priority 1000
#loader crafttweaker reloadable

import mods.modularmachinery.MachineModifier;
import mods.modularmachinery.MachineUpgradeHelper;

import novaeng.hypernet.HyperNetHelper;
import novaeng.hypernet.RegistryHyperNet;

import novaeng.hypernet.DatabaseType;
import novaeng.hypernet.DataProcessorType;
import novaeng.hypernet.ResearchStationType;
import novaeng.hypernet.ComputationCenterType;

import novaeng.hypernet.upgrade.type.ProcessorModuleCPUType;
import novaeng.hypernet.upgrade.type.ProcessorModuleGPUType;
import novaeng.hypernet.upgrade.type.ProcessorModuleRAMType;

RegistryHyperNet.setHyperNetConnectCard(<contenttweaker:hypernet_connect_card>);

HyperNetHelper.proxyMachineForHyperNet("space_beacon");
HyperNetHelper.proxyMachineForHyperNet("space_generator");

MachineModifier.setMaxThreads("computation_center_t1", 0);
MachineModifier.setMaxThreads("computation_center_t2", 0);
MachineModifier.setMaxThreads("computation_center_t3", 0);
RegistryHyperNet.addComputationCenter("computation_center_t1");
RegistryHyperNet.addComputationCenter("computation_center_t2");
RegistryHyperNet.addComputationCenter("computation_center_t3");

MachineModifier.setMaxThreads("data_processor_t1", 0);
MachineModifier.setMaxThreads("data_processor_t2", 0);
MachineModifier.setMaxThreads("data_processor_t3", 0);
MachineModifier.setMaxThreads("data_processor_t4", 0);

MachineModifier.setMaxThreads("research_station_t1", 0);
MachineModifier.setMaxThreads("research_station_t2", 0);
MachineModifier.setMaxThreads("research_station_t3", 0);
// RegistryHyperNet.addHyperNetSupportedMachinery("research_station_t1");
// RegistryHyperNet.addHyperNetSupportedMachinery("research_station_t2");
// RegistryHyperNet.addHyperNetSupportedMachinery("research_station_t3");

MachineModifier.setMaxThreads("database_t1", 0);
// RegistryHyperNet.addHyperNetSupportedMachinery("database_t1");

                                                                                                // *基础*能量消耗
RegistryHyperNet.addComputationCenterType(ComputationCenterType.create("computation_center_t1", 5 * 1000,
        // 最大连接数 单次最大算力支持 电路板耐久 最低电路板耐久消耗 最高电路板耐久消耗 电路板耐久消耗概率
        30,         400,           1000,     1,              10,              0.02F)
        .addFixIngredient(950, <contenttweaker:industrial_circuit_v1>)
);

                                                                                                // *基础*能量消耗
RegistryHyperNet.addComputationCenterType(ComputationCenterType.create("computation_center_t2", 100 * 1000,
        // 最大连接数 单次最大算力支持 电路板耐久 最低电路板耐久消耗 最高电路板耐久消耗 电路板耐久消耗概率
        90,         5000,          4000,     4,              20,              0.03F)
        .addFixIngredient(1000, <contenttweaker:industrial_circuit_v1>)
        .addFixIngredient(3800, <contenttweaker:industrial_circuit_v2>)
);

                                                                                                // *基础*能量消耗
RegistryHyperNet.addComputationCenterType(ComputationCenterType.create("computation_center_t3", 5 * 1000 * 1000,
        // 最大连接数 单次最大算力支持 电路板耐久 最低电路板耐久消耗 最高电路板耐久消耗 电路板耐久消耗概率
        180,        700000,        160000,   160,            640,             0.04F)
        .addFixIngredient(1000, <contenttweaker:industrial_circuit_v1>)
        .addFixIngredient(4000, <contenttweaker:industrial_circuit_v2>)
        .addFixIngredient(150000, <contenttweaker:industrial_circuit_v3>)
);

//                                                                                                 // *基础*能量消耗
// RegistryHyperNet.addComputationCenterType(ComputationCenterType.create("computation_center_t4", 100 * 1000 * 1000,
//         // 最大连接数 单次最大算力支持 电路板耐久 最低电路板耐久消耗 最高电路板耐久消耗 电路板耐久消耗概率
//         300,        1000000,  640000,  -1000,         1000,          0.02F)
//         .addFixIngredient(950, <contenttweaker:industrial_circuit_v1>)
//         .addFixIngredient(3950, <contenttweaker:industrial_circuit_v2>)
//         .addFixIngredient(150000, <contenttweaker:industrial_circuit_v3>)
//         .addFixIngredient(600000, <contenttweaker:industrial_circuit_v4>)
// );

                                                                                    // *基础*能量消耗
RegistryHyperNet.addDataProcessorType(DataProcessorType.create("data_processor_t1", 1000,
        // 热量散发量 过热阈值
        40,         9600)
);

                                                                                    // *基础*能量消耗
RegistryHyperNet.addDataProcessorType(DataProcessorType.create("data_processor_t2", 100 * 1000,
        // 热量散发量 过热阈值
        500,        120000)
        .addRadiatorIngredient(1500, [<liquid:ice> * 100], [<liquid:water> * 100])
        .addRadiatorIngredient(1500, [<liquid:liquid_nitrogen> * 8], [<liquid:nitrogen> * 2560])
        .addRadiatorIngredient(1500, [<liquid:cryotheum> * 7], [])
);

                                                                                    // *基础*能量消耗
RegistryHyperNet.addDataProcessorType(DataProcessorType.create("data_processor_t3", 1 * 1000 * 1000,
        // 热量散发量 过热阈值
        6000,       1440000)
        .addRadiatorIngredient(18000, [<liquid:ice> * 1150], [<liquid:water> * 1150])
        .addRadiatorIngredient(18000, [<liquid:liquid_nitrogen> * 95], [<liquid:nitrogen> * 30400])
        .addRadiatorIngredient(18000, [<liquid:cryotheum> * 85], [])
);

                                                                                    // *基础*能量消耗
RegistryHyperNet.addDataProcessorType(DataProcessorType.create("data_processor_t4", 5 * 1000 * 1000,
        // 热量散发量 过热阈值
        32000,      38400000)
        .addRadiatorIngredient(90000, [<liquid:ice> * 6000], [<liquid:water> * 6000])
        .addRadiatorIngredient(90000, [<liquid:liquid_nitrogen> * 485], [<liquid:nitrogen> * 155200])
        .addRadiatorIngredient(90000, [<liquid:cryotheum> * 435], [])
        .setDynamicPatternName("matrix")
);
MachineModifier.setInternalParallelism("data_processor_t4", 10);

                                                                                    // *基础*能量消耗
// RegistryHyperNet.addDataProcessorType(DataProcessorType.create("data_processor_t5", 50 * 1000 * 1000,
//         // 热量散发量 过热阈值     电路板耐久    最低电路板耐久消耗 最高电路板耐久消耗 电路板耐久消耗概率
//         0,          -1,        2000000000, -100000,       100000,        0.02F)
// );

// 数据处理器模块

# CPU
MachineUpgradeHelper.registerSupportedItem(<contenttweaker:hypernet_cpu_t1>);
                             //最低耐久 最高耐久 峰值耗电量           算力产出
ProcessorModuleCPUType.create(14000,   20000,  20 * 1000,          1.0F).register(
        "hypernet_cpu_t1", "§3原始处理器模块§a（等级 1）", 4.0F
);
MachineUpgradeHelper.addFixedUpgrade(<contenttweaker:hypernet_cpu_t1>, "hypernet_cpu_t1");

MachineUpgradeHelper.registerSupportedItem(<contenttweaker:hypernet_cpu_t2>);
                             //最低耐久 最高耐久 峰值耗电量           算力产出
ProcessorModuleCPUType.create(14000,   20000,  90 * 1000,          5.0F).register(
        "hypernet_cpu_t2", "§b先进处理器模块§9（等级 2）", 6.8F
);
MachineUpgradeHelper.addFixedUpgrade(<contenttweaker:hypernet_cpu_t2>, "hypernet_cpu_t2");

MachineUpgradeHelper.registerSupportedItem(<contenttweaker:hypernet_cpu_t3>);
                             //最低耐久 最高耐久 峰值耗电量           算力产出
ProcessorModuleCPUType.create(4000,    40000,  200 * 1000,         50.0F).register(
        "hypernet_cpu_t3", "§2生物处理器模块§6（等级 3）", 8.7F
);
MachineUpgradeHelper.addFixedUpgrade(<contenttweaker:hypernet_cpu_t3>, "hypernet_cpu_t3");

MachineUpgradeHelper.registerSupportedItem(<contenttweaker:hypernet_cpu_t4>);
                             //最低耐久 最高耐久 峰值耗电量           算力产出
ProcessorModuleCPUType.create(14000,   20000,  7.0F * 1000 * 1000, 500.0F).register(
        "hypernet_cpu_t4", "§e光子处理器模块§c（等级 4）", 11.0F
);
MachineUpgradeHelper.addFixedUpgrade(<contenttweaker:hypernet_cpu_t4>, "hypernet_cpu_t4");

# 人造僵尸
MachineUpgradeHelper.registerSupportedItem(<enderio:item_material:42>);
                             //最低耐久 最高耐久 峰值耗电量          算力产出
ProcessorModuleCPUType.create(2000,    20000,  50 * 1000,         20.0F).register(
        "artificial_zombie", "§2生物处理器模块§9（等级 2）", 7.4F
);
MachineUpgradeHelper.addFixedUpgrade(<enderio:item_material:42>, "artificial_zombie");

# GPU
MachineUpgradeHelper.registerSupportedItem(<contenttweaker:hypernet_gpu_t1>);
                                    //最低耐久 最高耐久 峰值耗电量         算力产出
ProcessorModuleGPUType.createGPUType(10000,   14000,  300 * 1000,       20.0F).register(
        "hypernet_gpu_t1", "§b先进图形处理器模块§9（等级 1）", 7.0F
);
MachineUpgradeHelper.addFixedUpgrade(<contenttweaker:hypernet_gpu_t1>, "hypernet_gpu_t1");

MachineUpgradeHelper.registerSupportedItem(<contenttweaker:hypernet_gpu_t2>);
                                    //最低耐久 最高耐久 峰值耗电量         算力产出
ProcessorModuleGPUType.createGPUType(5000,    28000,  1 * 1000 * 1000,  250.0F).register(
        "hypernet_gpu_t2", "§2生物图形处理器模块§6（等级 2）", 9.2F
);
MachineUpgradeHelper.addFixedUpgrade(<contenttweaker:hypernet_gpu_t2>, "hypernet_gpu_t2");

MachineUpgradeHelper.registerSupportedItem(<contenttweaker:hypernet_gpu_t3>);
                                    //最低耐久 最高耐久 峰值耗电量         算力产出
ProcessorModuleGPUType.createGPUType(10000,   14000,  70 * 1000 * 1000, 4.0F * 1000.0F).register(
        "hypernet_gpu_t3", "§9量子图形处理器模块§c（等级 3）", 11.3F
);
MachineUpgradeHelper.addFixedUpgrade(<contenttweaker:hypernet_gpu_t3>, "hypernet_gpu_t3");

# RAM
MachineUpgradeHelper.registerSupportedItem(<contenttweaker:hypernet_ram_t1>);
                             //最低耐久 最高耐久 峰值耗电量           算力上限提供
ProcessorModuleRAMType.create(24000,   32000,  2 * 1000,            2.0F).register(
        "hypernet_ram_t1", "§5内存§9模块§a（等级 1）", 4.0F
);
MachineUpgradeHelper.addFixedUpgrade(<contenttweaker:hypernet_ram_t1>, "hypernet_ram_t1");

MachineUpgradeHelper.registerSupportedItem(<contenttweaker:hypernet_ram_t2>);
                             //最低耐久 最高耐久 峰值耗电量           算力上限提供
ProcessorModuleRAMType.create(24000,   32000,  20 * 1000,           10.0F).register(
        "hypernet_ram_t2", "§5内存§9模块（等级 2）", 6.4F
);
MachineUpgradeHelper.addFixedUpgrade(<contenttweaker:hypernet_ram_t2>, "hypernet_ram_t2");

MachineUpgradeHelper.registerSupportedItem(<contenttweaker:hypernet_ram_t3>);
                             //最低耐久 最高耐久 峰值耗电量           算力上限提供
ProcessorModuleRAMType.create(24000,   32000,  150 * 1000,          100.0F).register(
        "hypernet_ram_t3", "§5内存§9模块§5（等级 3）", 8.4F
);
MachineUpgradeHelper.addFixedUpgrade(<contenttweaker:hypernet_ram_t3>, "hypernet_ram_t3");

MachineUpgradeHelper.registerSupportedItem(<contenttweaker:hypernet_ram_t4>);
                             //最低耐久 最高耐久 峰值耗电量           算力上限提供
ProcessorModuleRAMType.create(24000,   32000,  1000 * 1000,         1000.0F).register(
        "hypernet_ram_t4", "§5内存§9模块§6（等级 4）", 9.7F
);
MachineUpgradeHelper.addFixedUpgrade(<contenttweaker:hypernet_ram_t4>, "hypernet_ram_t4");

MachineUpgradeHelper.registerSupportedItem(<contenttweaker:hypernet_ram_t5>);
                             //最低耐久 最高耐久 峰值耗电量           算力上限提供
ProcessorModuleRAMType.create(24000,   32000,  15.0F * 1000 * 1000, 10 * 1000.0F).register(
        "hypernet_ram_t5", "§5内存§9模块§c（等级 5）", 11.2F
);
MachineUpgradeHelper.addFixedUpgrade(<contenttweaker:hypernet_ram_t5>, "hypernet_ram_t5");

                                                                                          // *基础*能量消耗    最大可研究的认知等级
RegistryHyperNet.addResearchStationType(ResearchStationType.create("research_station_t1", 10 * 1000,          7.9));

                                                                                          // *基础*能量消耗    最大可研究的认知等级
RegistryHyperNet.addResearchStationType(ResearchStationType.create("research_station_t2", 2 * 1000 * 1000,   9.9));

                                                                                          // *基础*能量消耗    最大可研究的认知等级
RegistryHyperNet.addResearchStationType(ResearchStationType.create("research_station_t3", 25 * 1000 * 1000,  14.1));

// RegistryHyperNet.addResearchStationType(ResearchStationType.create("research_station_t4", 10 * 1000 * 1000, 16));

                                                                    // *基础*能量消耗   最多可存储的研究认知数量
RegistryHyperNet.addDatabaseType(DatabaseType.create("database_t1", 5 * 1000,        20));

//                                                                     // *基础*能量消耗   最多可存储的研究认知数量
// RegistryHyperNet.addDatabaseType(DatabaseType.create("database_t2", 25 * 1000,       50));

//                                                                     // *基础*能量消耗   最多可存储的研究认知数量
// RegistryHyperNet.addDatabaseType(DatabaseType.create("database_t3", 500 * 1000,      100));

                                                                    // *基础*能量消耗   最多可存储的研究认知数量
// RegistryHyperNet.addDatabaseType(DatabaseType.create("database_t4", 5 * 1000 * 1000, 1000));
