#loader crafttweaker reloadable
#priority 103

import mods.modularmachinery.MMEvents;
import mods.modularmachinery.MachineModifier;
import mods.modularmachinery.GeoMachineModel;
import mods.modularmachinery.ControllerModelAnimationEvent;

//----------------------------------------------------------------------------------------------------------===微缩宇宙资源采集器
GeoMachineModel.registerGeoMachineModel("miniature_cosmic_resource_collector", // 微缩宇宙资源采集器
    "modularmachinery:geo/miniature_cosmic_resource_collector.geo.json", // geo模型文件路径
    "modularmachinery:textures/miniature_cosmic_resource_collector.png", // 模型贴图路径
    "modularmachinery:animations/miniature_cosmic_resource_collector.animation.json" // animation模型动画路径
);

MachineModifier.setMachineGeoModel("a6_miniature_cosmic_resource_collector", "miniature_cosmic_resource_collector");

MMEvents.onControllerModelAnimation("a6_miniature_cosmic_resource_collector", function(event as ControllerModelAnimationEvent) {
    // 为"安装"状态设置动画 "installation"单次
    event.addAnimation("installation_off");
    event.addAnimation("installation_load_00");
    event.addAnimation("installation_load_01");
    event.addAnimation("installation_load_02");
    event.addAnimation("installation_load_03");
    event.addAnimation("installation_load_04");
    event.addAnimation("installation_load_00");

    val ctrl = event.controller;
    if (!ctrl.isWorking)  // 检查机械是否正在工作。
    {
        // 为"待机"状态设置动画"standby"单次 ==> "standby_circulate"循环
        event.addAnimation("standby");
        event.addAnimation("standby_circulate", true);
        return;
    }

    if (event.controller.activeRecipeList[0].registryName == "a6_miniature_cosmic_resource_collector_01")
    {
        // 为"末地配方"状态设置动画 "ru_01"循环
        event.addAnimation("run_01", true);
    } else if (event.controller.activeRecipeList[0].registryName == "a6_miniature_cosmic_resource_collector_02")
    {
        // 为"地狱配方"状态设置动画 "ru_02"循环
        event.addAnimation("run_02", true);
    } else if (event.controller.activeRecipeList[0].registryName == "a6_miniature_cosmic_resource_collector_03")
    {
        // 为"主世界配方"状态设置动画 "ru_03"循环
        event.addAnimation("run_03", true);
    } else if (event.controller.activeRecipeList[0].registryName == "a6_miniature_cosmic_resource_collector_04")
    {
        // 为"时空塌陷配方"状态设置动画 "ru_04"循环
        event.addAnimation("run_04", true);
    }
});

//----------------------------------------------------------------------------------------------------------===[低压汽轮机]
GeoMachineModel.registerGeoMachineModel("low_pressure_steam_turbines", // 低压汽轮机
    "modularmachinery:geo/sv_steam_turbines/sv1_low_pressure_steam_turbines.geo.json", // geo模型文件路径
    "modularmachinery:textures/low_pressure_steam_turbines.png", // 模型贴图路径
    "modularmachinery:animations/sv_steam_turbines/sv1_low_pressure_steam_turbines.animation.json" // animation模型动画路径
);

MachineModifier.setMachineGeoModel("a7_sv1_low_pressure_steam_turbines", "low_pressure_steam_turbines");

MMEvents.onControllerModelAnimation("a7_sv1_low_pressure_steam_turbines", function(event as ControllerModelAnimationEvent) {
    // 为模型"安装"状态设置动画 "installation"单次
    event.addAnimation("installation");

    val ctrl = event.controller;
    if (ctrl.isWorking)  // 检查机械是否正在工作。
    {
        // 为模型"运行"状态设置动画"run_1"至"ru_5"单次 ==> "run_circulate"循环
        event.addAnimation("run_1");
        event.addAnimation("run_2");
        event.addAnimation("run_3");
        event.addAnimation("run_4");
        event.addAnimation("run_5");
        event.addAnimation("run_circulate", true);
    } else {
        // 为模型"待机"状态设置动画"standby"单次 ==> "standby_circulate"循环
        event.addAnimation("standby");
        event.addAnimation("standby_circulate", true);
    }
});

//----------------------------------------------------------------------------------------------------------===[中压汽轮机]
GeoMachineModel.registerGeoMachineModel("medium_pressure_steam_turbines", // 中压汽轮机
    "modularmachinery:geo/sv_steam_turbines/sv2_medium_pressure_steam_turbines.geo.json", // geo模型文件路径
    "modularmachinery:textures/medium_pressure_steam_turbines.png", // 模型贴图路径
    "modularmachinery:animations/sv_steam_turbines/sv2_medium_pressure_steam_turbines.animation.json" // animation模型动画路径
);

MachineModifier.setMachineGeoModel("a7_sv2_medium_pressure_steam_turbines", "medium_pressure_steam_turbines");

MMEvents.onControllerModelAnimation("a7_sv2_medium_pressure_steam_turbines", function(event as ControllerModelAnimationEvent) {
    // 为模型"安装"状态设置动画 "installation"单次
    event.addAnimation("installation");

    val ctrl = event.controller;
    if (ctrl.isWorking)  // 检查机械是否正在工作。
    {
        // 为模型"运行"状态设置动画"run_1"至"ru_5"单次 ==> "run_circulate"循环
        event.addAnimation("run_1");
        event.addAnimation("run_2");
        event.addAnimation("run_3");
        event.addAnimation("run_4");
        event.addAnimation("run_5");
        event.addAnimation("run_circulate", true);
    } else {
        // 为模型"待机"状态设置动画"standby"单次 ==> "standby_circulate"循环
        event.addAnimation("standby");
        event.addAnimation("standby_circulate", true);
    }
});

//----------------------------------------------------------------------------------------------------------===[高压汽轮机]
GeoMachineModel.registerGeoMachineModel("high_pressure_steam_turbines", // 高压汽轮机
    "modularmachinery:geo/sv_steam_turbines/sv3_high_pressure_steam_turbines.geo.json", // geo模型文件路径
    "modularmachinery:textures/high_pressure_steam_turbines.png", // 模型贴图路径
    "modularmachinery:animations/sv_steam_turbines/sv3_high_pressure_steam_turbines.animation.json" // animation模型动画路径
);

MachineModifier.setMachineGeoModel("a7_sv3_high_pressure_steam_turbines", "high_pressure_steam_turbines");

MMEvents.onControllerModelAnimation("a7_sv3_high_pressure_steam_turbines", function(event as ControllerModelAnimationEvent) {
    // 为模型"安装"状态设置动画 "installation"单次
    event.addAnimation("installation");

    val ctrl = event.controller;
    if (ctrl.isWorking)  // 检查机械是否正在工作。
    {
        // 为模型"运行"状态设置动画"run_1"至"ru_5"单次 ==> "run_circulate"循环
        event.addAnimation("run_1");
        event.addAnimation("run_2");
        event.addAnimation("run_3");
        event.addAnimation("run_4");
        event.addAnimation("run_5");
        event.addAnimation("run_circulate", true);
    } else {
        // 为模型"待机"状态设置动画"standby"单次 ==> "standby_circulate"循环
        event.addAnimation("standby");
        event.addAnimation("standby_circulate", true);
    }
});

//----------------------------------------------------------------------------------------------------------===[超高压汽轮机]
GeoMachineModel.registerGeoMachineModel("ultra_high_pressure_steam_turbines", // 超高压汽轮机
    "modularmachinery:geo/sv_steam_turbines/sv4_ultra_high_pressure_steam_turbines.geo.json", // geo模型文件路径
    "modularmachinery:textures/ultra_high_pressure_steam_turbines.png", // 模型贴图路径
    "modularmachinery:animations/sv_steam_turbines/sv4_ultra_high_pressure_steam_turbines.animation.json" // animation模型动画路径
);

MachineModifier.setMachineGeoModel("a7_sv4_ultra_high_pressure_steam_turbines", "ultra_high_pressure_steam_turbines");

MMEvents.onControllerModelAnimation("a7_sv4_ultra_high_pressure_steam_turbines", function(event as ControllerModelAnimationEvent) {
    // 为模型"安装"状态设置动画 "installation"单次
    event.addAnimation("installation");

    val ctrl = event.controller;
    if (ctrl.isWorking)  // 检查机械是否正在工作。
    {
        // 为模型"运行"状态设置动画"run_1"至"ru_5"单次 ==> "run_circulate"循环
        event.addAnimation("run_1");
        event.addAnimation("run_2");
        event.addAnimation("run_3");
        event.addAnimation("run_4");
        event.addAnimation("run_5");
        event.addAnimation("run_circulate", true);
    } else {
        // 为模型"待机"状态设置动画"standby"单次 ==> "standby_circulate"循环
        event.addAnimation("standby");
        event.addAnimation("standby_circulate", true);
    }
});

//----------------------------------------------------------------------------------------------------------===[亚临界汽轮机]
GeoMachineModel.registerGeoMachineModel("subcritical_steam_turbines", // 亚临界汽轮机
    "modularmachinery:geo/sv_steam_turbines/sv5_subcritical_steam_turbines.geo.json", // geo模型文件路径
    "modularmachinery:textures/subcritical_steam_turbines.png", // 模型贴图路径
    "modularmachinery:animations/sv_steam_turbines/sv5_subcritical_steam_turbines.animation.json" // animation模型动画路径
);

MachineModifier.setMachineGeoModel("a7_sv5_subcritical_steam_turbines", "subcritical_steam_turbines");

MMEvents.onControllerModelAnimation("a7_sv5_subcritical_steam_turbines", function(event as ControllerModelAnimationEvent) {
    // 为模型"安装"状态设置动画 "installation"单次
    event.addAnimation("installation");

    val ctrl = event.controller;
    if (ctrl.isWorking)  // 检查机械是否正在工作。
    {
        // 为模型"运行"状态设置动画"run_1"至"ru_5"单次 ==> "run_circulate"循环
        event.addAnimation("run_1");
        event.addAnimation("run_2");
        event.addAnimation("run_3");
        event.addAnimation("run_4");
        event.addAnimation("run_5");
        event.addAnimation("run_circulate", true);
    } else {
        // 为模型"待机"状态设置动画"standby"单次 ==> "standby_circulate"循环
        event.addAnimation("standby");
        event.addAnimation("standby_circulate", true);
    }
});

//----------------------------------------------------------------------------------------------------------===[超临界汽轮机]
GeoMachineModel.registerGeoMachineModel("supercritical_steam_turbines", // 超临界汽轮机
    "modularmachinery:geo/sv_steam_turbines/sv6_supercritical_steam_turbines.geo.json", // geo模型文件路径
    "modularmachinery:textures/supercritical_steam_turbines.png", // 模型贴图路径
    "modularmachinery:animations/sv_steam_turbines/sv6_supercritical_steam_turbines.animation.json" // animation模型动画路径
);

MachineModifier.setMachineGeoModel("a7_sv6_supercritical_steam_turbines", "supercritical_steam_turbines");

MMEvents.onControllerModelAnimation("a7_sv6_supercritical_steam_turbines", function(event as ControllerModelAnimationEvent) {
    // 为模型"安装"状态设置动画 "installation"单次
    event.addAnimation("installation");

    val ctrl = event.controller;
    if (ctrl.isWorking)  // 检查机械是否正在工作。
    {
        // 为模型"运行"状态设置动画"run_1"至"ru_5"单次 ==> "run_circulate"循环
        event.addAnimation("run_1");
        event.addAnimation("run_2");
        event.addAnimation("run_3");
        event.addAnimation("run_4");
        event.addAnimation("run_5");
        event.addAnimation("run_circulate", true);
    } else {
        // 为模型"待机"状态设置动画"standby"单次 ==> "standby_circulate"循环
        event.addAnimation("standby");
        event.addAnimation("standby_circulate", true);
    }
});

//----------------------------------------------------------------------------------------------------------===[低压汽轮机-纵向]
GeoMachineModel.registerGeoMachineModel("sl_low_pressure_steam_turbines", // 低压汽轮机
    "modularmachinery:geo/sl_steam_turbines/sl1_low_pressure_steam_turbines.geo.json", // geo模型文件路径
    "modularmachinery:textures/low_pressure_steam_turbines.png", // 模型贴图路径
    "modularmachinery:animations/sl_steam_turbines/sl1_low_pressure_steam_turbines.animation.json" // animation模型动画路径
);

MachineModifier.setMachineGeoModel("a7_sl1_low_pressure_steam_turbines_longitudinal", "sl_low_pressure_steam_turbines");

MMEvents.onControllerModelAnimation("a7_sl1_low_pressure_steam_turbines_longitudinal", function(event as ControllerModelAnimationEvent) {
    // 为模型"安装"状态设置动画 "installation"单次
    event.addAnimation("installation");

    val ctrl = event.controller;
    if (ctrl.isWorking)  // 检查机械是否正在工作。
    {
        // 为模型"运行"状态设置动画"run_1"至"ru_5"单次 ==> "run_circulate"循环
        event.addAnimation("run_1");
        event.addAnimation("run_2");
        event.addAnimation("run_3");
        event.addAnimation("run_4");
        event.addAnimation("run_5");
        event.addAnimation("run_circulate", true);
    } else {
        // 为模型"待机"状态设置动画"standby"单次 ==> "standby_circulate"循环
        event.addAnimation("standby");
        event.addAnimation("standby_circulate", true);
    }
});

//----------------------------------------------------------------------------------------------------------===[中压汽轮机-纵向]
GeoMachineModel.registerGeoMachineModel("sl_medium_pressure_steam_turbines", // 中压汽轮机
    "modularmachinery:geo/sl_steam_turbines/sl2_medium_pressure_steam_turbines.geo.json", // geo模型文件路径
    "modularmachinery:textures/medium_pressure_steam_turbines.png", // 模型贴图路径
    "modularmachinery:animations/sl_steam_turbines/sl2_medium_pressure_steam_turbines.animation.json" // animation模型动画路径
);

MachineModifier.setMachineGeoModel("a7_sl2_medium_pressure_steam_turbines_longitudinal", "sl_medium_pressure_steam_turbines");

MMEvents.onControllerModelAnimation("a7_sl2_medium_pressure_steam_turbines_longitudinal", function(event as ControllerModelAnimationEvent) {
    // 为模型"安装"状态设置动画 "installation"单次
    event.addAnimation("installation");

    val ctrl = event.controller;
    if (ctrl.isWorking)  // 检查机械是否正在工作。
    {
        // 为模型"运行"状态设置动画"run_1"至"ru_5"单次 ==> "run_circulate"循环
        event.addAnimation("run_1");
        event.addAnimation("run_2");
        event.addAnimation("run_3");
        event.addAnimation("run_4");
        event.addAnimation("run_5");
        event.addAnimation("run_circulate", true);
    } else {
        // 为模型"待机"状态设置动画"standby"单次 ==> "standby_circulate"循环
        event.addAnimation("standby");
        event.addAnimation("standby_circulate", true);
    }
});

//----------------------------------------------------------------------------------------------------------===[高压汽轮机-纵向]
GeoMachineModel.registerGeoMachineModel("sl_high_pressure_steam_turbines", // 高压汽轮机
    "modularmachinery:geo/sl_steam_turbines/sl3_high_pressure_steam_turbines.geo.json", // geo模型文件路径
    "modularmachinery:textures/high_pressure_steam_turbines.png", // 模型贴图路径
    "modularmachinery:animations/sl_steam_turbines/sl3_high_pressure_steam_turbines.animation.json" // animation模型动画路径
);

MachineModifier.setMachineGeoModel("a7_sl3_high_pressure_steam_turbines_longitudinal", "sl_high_pressure_steam_turbines");

MMEvents.onControllerModelAnimation("a7_sl3_high_pressure_steam_turbines_longitudinal", function(event as ControllerModelAnimationEvent) {
    // 为模型"安装"状态设置动画 "installation"单次
    event.addAnimation("installation");

    val ctrl = event.controller;
    if (ctrl.isWorking)  // 检查机械是否正在工作。
    {
        // 为模型"运行"状态设置动画"run_1"至"ru_5"单次 ==> "run_circulate"循环
        event.addAnimation("run_1");
        event.addAnimation("run_2");
        event.addAnimation("run_3");
        event.addAnimation("run_4");
        event.addAnimation("run_5");
        event.addAnimation("run_circulate", true);
    } else {
        // 为模型"待机"状态设置动画"standby"单次 ==> "standby_circulate"循环
        event.addAnimation("standby");
        event.addAnimation("standby_circulate", true);
    }
});

//----------------------------------------------------------------------------------------------------------===[超高压汽轮机-纵向]
GeoMachineModel.registerGeoMachineModel("sl_ultra_high_pressure_steam_turbines", // 超高压汽轮机
    "modularmachinery:geo/sl_steam_turbines/sl4_ultra_high_pressure_steam_turbines.geo.json", // geo模型文件路径
    "modularmachinery:textures/ultra_high_pressure_steam_turbines.png", // 模型贴图路径
    "modularmachinery:animations/sl_steam_turbines/sl4_ultra_high_pressure_steam_turbines.animation.json" // animation模型动画路径
);

MachineModifier.setMachineGeoModel("a7_sl4_ultra_high_pressure_steam_turbines_longitudinal", "sl_ultra_high_pressure_steam_turbines");

MMEvents.onControllerModelAnimation("a7_sl4_ultra_high_pressure_steam_turbines_longitudinal", function(event as ControllerModelAnimationEvent) {
    // 为模型"安装"状态设置动画 "installation"单次
    event.addAnimation("installation");

    val ctrl = event.controller;
    if (ctrl.isWorking)  // 检查机械是否正在工作。
    {
        // 为模型"运行"状态设置动画"run_1"至"ru_5"单次 ==> "run_circulate"循环
        event.addAnimation("run_1");
        event.addAnimation("run_2");
        event.addAnimation("run_3");
        event.addAnimation("run_4");
        event.addAnimation("run_5");
        event.addAnimation("run_circulate", true);
    } else {
        // 为模型"待机"状态设置动画"standby"单次 ==> "standby_circulate"循环
        event.addAnimation("standby");
        event.addAnimation("standby_circulate", true);
    }
});

//----------------------------------------------------------------------------------------------------------===[亚临界汽轮机-纵向]
GeoMachineModel.registerGeoMachineModel("sl_subcritical_steam_turbines", // 亚临界汽轮机
    "modularmachinery:geo/sl_steam_turbines/sl5_subcritical_steam_turbines.geo.json", // geo模型文件路径
    "modularmachinery:textures/subcritical_steam_turbines.png", // 模型贴图路径
    "modularmachinery:animations/sl_steam_turbines/sl5_subcritical_steam_turbines.animation.json" // animation模型动画路径
);

MachineModifier.setMachineGeoModel("a7_sl5_subcritical_steam_turbines_longitudinal", "sl_subcritical_steam_turbines");

MMEvents.onControllerModelAnimation("a7_sl5_subcritical_steam_turbines_longitudinal", function(event as ControllerModelAnimationEvent) {
    // 为"安装"状态设置动画 "installation"单次
    event.addAnimation("installation");

    val ctrl = event.controller;
    if (ctrl.isWorking)  // 检查机械是否正在工作。
    {
        // 为模型"运行"状态设置动画"run_1"至"ru_5"单次 ==> "run_circulate"循环
        event.addAnimation("run_1");
        event.addAnimation("run_2");
        event.addAnimation("run_3");
        event.addAnimation("run_4");
        event.addAnimation("run_5");
        event.addAnimation("run_circulate", true);
    } else {
        // 为模型"待机"状态设置动画"standby"单次 ==> "standby_circulate"循环
        event.addAnimation("standby");
        event.addAnimation("standby_circulate", true);
    }
});

//----------------------------------------------------------------------------------------------------------===[超临界汽轮机-纵向]
GeoMachineModel.registerGeoMachineModel("sl_supercritical_steam_turbines", // 超临界汽轮机
    "modularmachinery:geo/sl_steam_turbines/sl6_supercritical_steam_turbines.geo.json", // geo模型文件路径
    "modularmachinery:textures/supercritical_steam_turbines.png", // 模型贴图路径
    "modularmachinery:animations/sl_steam_turbines/sl6_supercritical_steam_turbines.animation.json" // animation模型动画路径
);

MachineModifier.setMachineGeoModel("a7_sl6_supercritical_steam_turbines_longitudinal", "sl_supercritical_steam_turbines");

MMEvents.onControllerModelAnimation("a7_sl6_supercritical_steam_turbines_longitudinal", function(event as ControllerModelAnimationEvent) {
    // 为"安装"状态设置动画 "installation"单次
    event.addAnimation("installation");

    val ctrl = event.controller;
    if (ctrl.isWorking)  // 检查机械是否正在工作。
    {
        // 为模型"运行"状态设置动画"run_1"至"ru_5"单次 ==> "run_circulate"循环
        event.addAnimation("run_1");
        event.addAnimation("run_2");
        event.addAnimation("run_3");
        event.addAnimation("run_4");
        event.addAnimation("run_5");
        event.addAnimation("run_circulate", true);
    } else {
        // 为模型"待机"状态设置动画"standby"单次 ==> "standby_circulate"循环
        event.addAnimation("standby");
        event.addAnimation("standby_circulate", true);
    }
});

// //----------------------------------------------------------------------------------------------------------===[大型矿脉勘探机]
// GeoMachineModel.registerGeoMachineModel("vein_explorer", // 大型矿脉勘探机
//     "modularmachinery:geo/vein_explorer.geo.json", // geo模型文件路径
//     "modularmachinery:textures/vein_explorer.png", // 模型贴图路径
//     "modularmachinery:animations/vein_explorer.animation.json" // animation模型动画路径
// );

// MachineModifier.setMachineGeoModel("a10_vein_explorer", "vein_explorer");

// MMEvents.onControllerModelAnimation("a10_vein_explorer", function(event as ControllerModelAnimationEvent) {
//     // 为"安装"状态设置动画
//     event.addAnimation("off");
//     event.addAnimation("standby_load_01");
//     event.addAnimation("standby_load_02");
//     event.addAnimation("standby_load_03");

//     val ctrl = event.controller;
//     if (ctrl.isWorking)  // 检查机械是否正在工作。
//     {
//         // 为"运行"状态设置动画 "run"循环
//         event.addAnimation("run", true);
//     } else {
//         // 为"待机"状态设置动画"standby_circulate"循环
//         event.addAnimation("standby_circulate", true);
//         return;
//     }
// });

MMEvents.onControllerModelAnimation("singularity_core", function(event as ControllerModelAnimationEvent) {
    // 为"安装"状态设置动画
    event.addAnimation("standby_circulate");
    event.addAnimation("standby_circulate_rings3_0");
    event.addAnimation("standby_circulate_rings3_1");
    event.addAnimation("standby_circulate_rings3_2");
    event.addAnimation("standby_circulate_rings3_3");
    event.addAnimation("standby_circulate_rings3_4");

    val ctrl = event.controller;
    if (ctrl.isWorking)  // 检查机械是否正在工作。
    {
        // 为"运行"状态设置动画 "run"循环
        event.addAnimation("rings_3_run_0");
        event.addAnimation("rings_3_run_1", true);
    } else {
        // 为"待机"状态设置动画"standby_circulate"循环
        event.addAnimation("rings_3_run_0");
        event.addAnimation("rings_3_run_1", true);
        return;
    }
});
