//CoT ZS By Hikari_Nova.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.
#priority 1000

#loader contenttweaker

import mods.contenttweaker.VanillaFactory;
import mods.contenttweaker.Item;

function regItem(name as string) {
    val item as Item = VanillaFactory.createItem(name);
    item.creativeTab = <creativetab:misc>;
    item.register();
}

function regItemWithStackSize(name as string, maxStackSize as int) {
    val item as Item = VanillaFactory.createItem(name);
    item.creativeTab = <creativetab:misc>;
    item.maxStackSize = maxStackSize;
    item.register();
}

//通用合金 T1~T3
regItem("universalalloyt1");
regItem("universalalloyt2");
regItem("universalalloyt3");

//三色异世界水晶
regItem("crystalred");
regItem("crystalpurple");
regItem("crystalgreen");

//高级模式存储卡
regItem("data_model_card");
# 铜模式存储卡
regItem("data_model_copper");
# 红石水晶模式存储卡
regItem("data_model_crystal_flux");
# 钻石模式存储卡
regItem("data_model_diamond");
# 红石琥珀金模式存储卡
regItem("data_model_electrum_flux");
# 绿宝石模式存储卡
regItem("data_model_emerald");
# 极寒末影模式存储卡
regItem("data_model_gelid_enderium");
# 极寒水晶模式存储卡
regItem("data_model_gelid_gem");
# 金模式存储卡
regItem("data_model_gold");
# 铱模式存储卡
regItem("data_model_iridium");
# 铁模式存储卡
regItem("data_model_iron");
# 青金石模式存储卡
regItem("data_model_lapis");
# 铅模式存储卡
regItem("data_model_lead");
# 镍模式存储卡
regItem("data_model_nickel");
# 铂模式存储卡
regItem("data_model_platinum");
# 石英模式存储卡
regItem("data_model_quartz");
# 红石模式存储卡
regItem("data_model_redstone");
# 银模式存储卡
regItem("data_model_silver");
# 锡模式存储卡
regItem("data_model_tin");
# 奥利哈刚模式存储卡
regItem("data_model_orichalcos");

//通用数据存储卡
regItem("general_data_card");
# 戴森云坐标数据存储卡
regItem("dyson_cloud_pos_data_card");
# 戴森云能量接收器运行数据存储卡
regItem("dyson_cloud_operation_data_card");
# 戴森云调谐数据存储卡
regItem("dyson_cloud_tuning_data_card");

//编程电路-0x00 ~ 0x0F
var programmingCircuits as string[] = [
    "0",
    "a",
    "b",
    "c",
    "d",
    "e",
    "f"
];
for programmingCircuit in programmingCircuits{
    regItem("programming_circuit_" + programmingCircuit);
}

// //硅晶柱
// regItem("silicon_column");

// //硅晶圆
// regItem("wafer_a");
// regItem("wafer_b");
// regItem("wafer_c");

//生命源质处理器
regItem("lifesense_processor");

//指数级处理器
regItem("exponential_level_processor");

//无限处理器
regItem("infinity_processor");

//反物质核心
regItem("antimatter_core");

// 线圈
for tier in 2 to 6 {
    regItem("coil_v" + tier);
}

// 电动马达
for tier in 1 to 6 {
    regItem("electric_motor_v" + tier);
}

// 机械臂
for tier in 1 to 6 {
    regItem("sensor_v" + tier);
}

// 传感器
for tier in 1 to 6 {
    regItem("robot_arm_v" + tier);
}

// 力场发生器
for tier in 1 to 6 {
    regItem("field_generator_v" + tier);
}

// 工程控制电路
for tier in 1 to 6 {
    regItem("industrial_circuit_v" + tier);
}

// 充能燃料容器
for tier in 1 to 5 {
    regItem("energized_fuel_v" + tier);
}

// 充能燃料容器（竭尽）
for tier in 1 to 5 {
    regItem("energized_fuel_depleted_v" + tier);
}

// 空的充能燃料容器
for tier in 1 to 5 {
    regItem("energized_fuel_container_v" + tier);
}

// 工程电池
for tier in 1 to 5 {
    regItem("engineering_battery_v" + tier);
}

# HyperNet 网络密钥卡
regItemWithStackSize("hypernet_connect_card", 1);

// CPU
for tier in 1 to 5 {
    regItemWithStackSize("hypernet_cpu_t" + tier, 1);
}

// GPU
for tier in 1 to 4 {
    regItemWithStackSize("hypernet_gpu_t" + tier, 1);
}

// RAM
for tier in 1 to 6 {
    regItemWithStackSize("hypernet_ram_t" + tier, 1);
}

# α 物质
regItem("alpha_matter");
# β 物质
regItem("beta_matter");
# Δ 物质
regItem("delta_matter");
# 时空物质聚合体
regItem("polymer_matter");

# 石墨烯
regItem("graphene");
# 碳纳米管
regItem("carbon_nanotube");

# 地心石英水晶块
regItem("geocentric_crystal");
# 地心石英水晶
regItem("geocentric_quartz_crystal");
# 提纯地心石英水晶
regItem("purified_geocentric_quartz_crystal");
# 盈能地心石英水晶
regItem("geocentric_quartz_crystal_charged");

# 时空连续体碎片
regItem("fragments_of_the_space_time_continuum");

# 镍导线
regItem("nickel_wire");
# 恒星合金导线
regItem("stellar_alloy_wire");
# 无尽导线
regItem("infinity_wire");

# 致密奇点
regItem("dense_singularity");
# 超质量临界奇点
regItem("supermassive_singularity");
