//CoT ZS By Hikari_Nova.
//ALL RIGHTS RESERVED
//在未经过原作者的允许下,你不能应用于任何服务器,以及任何更改。
//Under the permission of the author, you cannot be applied to any server, as well as any changes.
#priority 1000

#loader contenttweaker

import mods.contenttweaker.VanillaFactory;
import mods.contenttweaker.Fluid;
import mods.contenttweaker.Color;

var crystalloid = VanillaFactory.createFluid("crystalloid", Color.fromHex("9400d3").getIntColor());
crystalloid.colorize = true;
crystalloid.temperature = 300;
crystalloid.luminosity = 5;
crystalloid.stillLocation = "base:fluids/liquid";
crystalloid.flowingLocation = "base:fluids/liquid_flow";
crystalloid.register();

var crystalloidneutron = VanillaFactory.createFluid("crystalloidneutron", Color.fromHex("87CEFA").getIntColor());
crystalloidneutron.colorize = true;
crystalloidneutron.temperature = 300;
crystalloidneutron.luminosity = 7;
crystalloidneutron.stillLocation = "base:fluids/liquid";
crystalloidneutron.flowingLocation = "base:fluids/liquid_flow";
crystalloidneutron.register();

var liquid_energy = VanillaFactory.createFluid("liquid_energy", Color.fromHex("00FA9A").getIntColor());
liquid_energy.colorize = true;
liquid_energy.temperature = 300;
liquid_energy.luminosity = 10;
liquid_energy.stillLocation = "base:fluids/liquid";
liquid_energy.flowingLocation = "base:fluids/liquid_flow";
liquid_energy.register();

var unsteady_plasma = VanillaFactory.createFluid("unsteady_plasma", Color.fromHex("FFA500").getIntColor());
unsteady_plasma.colorize = true;
unsteady_plasma.temperature = 10800;
unsteady_plasma.luminosity = 15;
unsteady_plasma.stillLocation = "base:fluids/liquid";
unsteady_plasma.flowingLocation = "base:fluids/liquid_flow";
unsteady_plasma.register();

var steady_ultra_dense_atomic_matter = VanillaFactory.createFluid("steady_ultra_dense_atomic_matter", Color.fromHex("1E90FF").getIntColor());
steady_ultra_dense_atomic_matter.colorize = true;
steady_ultra_dense_atomic_matter.temperature = 600;
steady_ultra_dense_atomic_matter.luminosity = 5;
steady_ultra_dense_atomic_matter.stillLocation = "base:fluids/liquid";
steady_ultra_dense_atomic_matter.flowingLocation = "base:fluids/liquid_flow";
steady_ultra_dense_atomic_matter.register();

var space_time_fluids = VanillaFactory.createFluid("space_time_fluids", Color.fromHex("000000").getIntColor());
space_time_fluids.flowingLocation = "contenttweaker:fluids/space_time_fluids";
space_time_fluids.stillLocation = "contenttweaker:fluids/space_time_fluids";
space_time_fluids.luminosity = 1;
space_time_fluids.colorize = false;
space_time_fluids.viscosity = 3000;
space_time_fluids.register();

// 对苯二甲酸
regFluid("d_dicarboxybenzene", 0x404040, 300);
// 乙二醇
regFluid("ethylene_glycol", 0xD2D2D2, 300);
// 三乙基铝
regFluid("triethyl_aluminum", 0xC0C0C0, 300);
// 甲烷
regFluid("methane", 0xFF54DA, 300);
// 四氯化碳
regFluid("carbon_tetrachloride", 0xB100A2, 300);
// 氯仿
regFluid("chloroform", 0xC80096, 300);
// 四氟乙烯
regFluid("tetrafloroethylene", 0x424242, 300);
// 氯化镁
regFluid("magnesium_chloride", 0x8BCEFF, 300);
// 过硫酸铵
regFluid("ammonium_presulfate", 0xC3C3C3, 300);

# ø 物质
regFluid("oslash_matter", 0x0066FF, 1);

# ɸ 物质
regFluid("phi_matter", 0xFF6633, 2000000000);

function regFluid(regName as string, color as int, temperature as int) {
    var fluid = VanillaFactory.createFluid(regName, color);
    fluid.colorize = true;
    fluid.temperature = temperature;
    fluid.stillLocation = "base:fluids/liquid";
    fluid.flowingLocation = "base:fluids/liquid_flow";
    fluid.register();
}
