/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import it.unimi.dsi.fastutil.Hash;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public interface ItemStackHashStrategy
extends Hash.Strategy<ItemStack> {
    public static ItemStackHashStrategyBuilder builder() {
        return new ItemStackHashStrategyBuilder();
    }

    public static ItemStackHashStrategy comparingAllButCount() {
        return ItemStackHashStrategy.builder().compareItem(true).compareDamage(true).compareTag(true).build();
    }

    public static class ItemStackHashStrategyBuilder {
        private boolean item;
        private boolean damage;
        private boolean tag;

        public ItemStackHashStrategyBuilder compareItem(boolean choice) {
            this.item = choice;
            return this;
        }

        public ItemStackHashStrategyBuilder compareDamage(boolean choice) {
            this.damage = choice;
            return this;
        }

        public ItemStackHashStrategyBuilder compareTag(boolean choice) {
            this.tag = choice;
            return this;
        }

        public ItemStackHashStrategy build() {
            return new ItemStackHashStrategy(){

                public int hashCode(@Nullable ItemStack o) {
                    int n;
                    if (o == null || o.func_190926_b()) {
                        n = 0;
                    } else {
                        Object[] objectArray = new Object[3];
                        objectArray[0] = item ? o.func_77973_b() : null;
                        Object object = objectArray[1] = damage ? Integer.valueOf(o.func_77952_i()) : null;
                        objectArray[2] = tag ? (o.func_77978_p() != null && !o.func_77978_p().func_82582_d() ? o.func_77978_p() : null) : null;
                        n = Objects.hash(objectArray);
                    }
                    return n;
                }

                public boolean equals(@Nullable ItemStack a, @Nullable ItemStack b) {
                    if (a == null || a.func_190926_b()) {
                        return b == null || b.func_190926_b();
                    }
                    if (b == null || b.func_190926_b()) {
                        return false;
                    }
                    return this.stackEquals(a, b);
                }
            };
        }

        private boolean stackEquals(ItemStack stackA, ItemStack stackB) {
            if (stackA.func_190926_b() && stackB.func_190926_b()) {
                return true;
            }
            if (stackA.func_190926_b() && !stackB.func_190926_b()) {
                return false;
            }
            if (this.item && stackA.func_77973_b() != stackB.func_77973_b()) {
                return false;
            }
            if (this.damage && stackA.func_77952_i() != stackB.func_77952_i()) {
                return false;
            }
            if (!this.tag) {
                return true;
            }
            NBTTagCompound stackATag = stackA.func_77978_p();
            NBTTagCompound stackBTag = stackB.func_77978_p();
            if ((stackATag == null || stackATag.func_82582_d()) && stackBTag != null && !stackBTag.func_82582_d()) {
                return false;
            }
            if (stackATag != null && !stackATag.func_82582_d()) {
                if (stackBTag == null || stackBTag.func_82582_d()) {
                    return false;
                }
                if (!stackATag.equals((Object)stackBTag)) {
                    return false;
                }
            }
            return stackA.areCapsCompatible(stackB);
        }
    }
}

