/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.util.Platform;
import appeng.util.item.FuzzyItemVariantList;
import appeng.util.item.ItemVariantList;
import appeng.util.item.NormalItemVariantList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.minecraft.item.Item;

public final class ItemList
implements IItemList<IAEItemStack> {
    private final Reference2ObjectMap<Item, ItemVariantList> records = new Reference2ObjectOpenHashMap();
    private final AtomicInteger version = new AtomicInteger(0);

    @Override
    public IAEItemStack findPrecise(IAEItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        ItemVariantList record = (ItemVariantList)this.records.get((Object)itemStack.getItem());
        return record != null ? record.findPrecise(itemStack) : null;
    }

    @Override
    public Collection<IAEItemStack> findFuzzy(IAEItemStack filter, FuzzyMode fuzzy) {
        if (filter == null) {
            return Collections.emptyList();
        }
        ItemVariantList record = (ItemVariantList)this.records.get((Object)filter.getItem());
        return record != null ? record.findFuzzy(filter, fuzzy) : Collections.emptyList();
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public void add(IAEItemStack itemStack) {
        this.version.incrementAndGet();
        if (itemStack == null) {
            return;
        }
        this.getOrCreateRecord(itemStack.getItem()).add(itemStack);
    }

    @Override
    public void addAll(IItemList<IAEItemStack> other, Function<IAEItemStack, IAEItemStack> transformer) {
        this.version.incrementAndGet();
        if (other instanceof ItemList) {
            ItemList otherList = (ItemList)other;
            otherList.records.forEach((key, value) -> {
                ItemVariantList list = (ItemVariantList)this.records.computeIfAbsent(key, this::makeRecordMap);
                Iterator<IAEItemStack> it = value.iterator();
                while (it.hasNext()) {
                    IAEItemStack apply = (IAEItemStack)transformer.apply(it.next());
                    if (apply == null) continue;
                    list.add(apply);
                }
            });
        } else {
            IItemList.super.addAll(other, transformer);
        }
    }

    @Override
    public void addStorage(IAEItemStack itemStack) {
        this.version.incrementAndGet();
        if (itemStack == null) {
            return;
        }
        this.getOrCreateRecord(itemStack.getItem()).addStorage(itemStack);
    }

    @Override
    public void addCrafting(IAEItemStack itemStack) {
        this.version.incrementAndGet();
        if (itemStack == null) {
            return;
        }
        this.getOrCreateRecord(itemStack.getItem()).addCrafting(itemStack);
    }

    @Override
    public void addRequestable(IAEItemStack itemStack) {
        this.version.incrementAndGet();
        if (itemStack == null) {
            return;
        }
        this.getOrCreateRecord(itemStack.getItem()).addRequestable(itemStack);
    }

    @Override
    public IAEItemStack getFirstItem() {
        Iterator<IAEItemStack> iterator = this.iterator();
        if (iterator.hasNext()) {
            IAEItemStack stackType = iterator.next();
            return stackType;
        }
        return null;
    }

    @Override
    public int size() {
        int size = 0;
        for (ItemVariantList entry : this.records.values()) {
            size += entry.size();
        }
        return size;
    }

    @Override
    public Iterator<IAEItemStack> iterator() {
        return new ChainedIterator((Iterator<ItemVariantList>)this.records.values().iterator(), this.version);
    }

    @Override
    public void resetStatus() {
        for (IAEItemStack i : this) {
            i.reset();
        }
    }

    private ItemVariantList getOrCreateRecord(Item item) {
        return (ItemVariantList)this.records.computeIfAbsent((Object)item, this::makeRecordMap);
    }

    private ItemVariantList makeRecordMap(Item item) {
        if (item.func_77645_m() || Platform.isGTDamageableItem(item)) {
            return new FuzzyItemVariantList();
        }
        return new NormalItemVariantList();
    }

    private static class ChainedIterator
    implements Iterator<IAEItemStack> {
        private final AtomicInteger parentVersion;
        private final int version;
        private final Iterator<ItemVariantList> parent;
        private Iterator<IAEItemStack> next;

        public ChainedIterator(Iterator<ItemVariantList> iterator, AtomicInteger parentVersion) {
            this.parent = iterator;
            this.parentVersion = parentVersion;
            this.version = parentVersion.get();
            this.ensureItems();
        }

        @Override
        public boolean hasNext() {
            return this.next != null && this.next.hasNext();
        }

        @Override
        public IAEItemStack next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            if (this.version != this.parentVersion.get()) {
                throw new ConcurrentModificationException();
            }
            IAEItemStack result = this.next.next();
            this.ensureItems();
            return result;
        }

        private void ensureItems() {
            if (this.hasNext()) {
                return;
            }
            while (this.parent.hasNext()) {
                this.next = this.parent.next().iterator();
                if (!this.next.hasNext()) continue;
                return;
            }
            this.next = null;
        }
    }
}

