/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import com.google.common.base.Preconditions;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

final class AESharedItemStack {
    private final ItemStack itemStack;
    private final int itemDamage;
    private final int hashCode;

    public AESharedItemStack(ItemStack itemStack) {
        this(itemStack, itemStack.func_77952_i());
    }

    private AESharedItemStack(ItemStack itemStack, int damage) {
        this.itemStack = itemStack;
        this.itemDamage = damage;
        this.hashCode = this.makeHashCode();
    }

    ItemStack getDefinition() {
        return this.itemStack;
    }

    int getItemDamage() {
        return this.itemDamage;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AESharedItemStack)) {
            return false;
        }
        AESharedItemStack other = (AESharedItemStack)obj;
        Preconditions.checkState((this.itemStack.func_190916_E() == 1 ? 1 : 0) != 0, (Object)"ItemStack#getCount() has to be 1");
        Preconditions.checkArgument((other.itemStack.func_190916_E() == 1 ? 1 : 0) != 0, (Object)"ItemStack#getCount() has to be 1");
        if (this.itemStack == other.itemStack) {
            return true;
        }
        if (this.itemDamage != other.itemDamage) {
            return false;
        }
        return AESharedItemStack.stackEquals(this.itemStack, other.itemStack);
    }

    private static boolean stackEquals(ItemStack stackA, ItemStack stackB) {
        if (stackA.func_190926_b() && stackB.func_190926_b()) {
            return true;
        }
        if (stackA.func_190926_b() && !stackB.func_190926_b()) {
            return false;
        }
        if (stackA.func_77973_b() != stackB.func_77973_b()) {
            return false;
        }
        NBTTagCompound stackATag = stackA.func_77978_p();
        NBTTagCompound stackBTag = stackB.func_77978_p();
        if (stackATag == null || stackATag.func_82582_d()) {
            if (stackBTag != null && !stackBTag.func_82582_d()) {
                return false;
            }
        } else {
            if (stackBTag == null || stackBTag.func_82582_d()) {
                return false;
            }
            if (!stackATag.equals((Object)stackBTag)) {
                return false;
            }
        }
        return stackA.areCapsCompatible(stackB);
    }

    private int makeHashCode() {
        NBTTagCompound tag = this.itemStack.func_77978_p();
        int combinedHashCode = Long.hashCode((long)System.identityHashCode(this.itemStack.func_77973_b()) & 0xFFFFFFFFL | ((long)this.itemDamage & 0xFFFFFFFFL) << 32);
        int tagHashCode = tag != null && !tag.func_82582_d() ? tag.hashCode() : 0;
        return tagHashCode != 0 ? combinedHashCode ^ tagHashCode : combinedHashCode;
    }
}

