/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.powersink;

import appeng.api.config.Actionable;
import appeng.api.config.PowerUnits;
import appeng.tile.powersink.IExternalPowerSink;
import gregtech.api.capability.IEnergyContainer;
import net.minecraft.util.EnumFacing;

public class GTCEEnergyAdapter
implements IEnergyContainer {
    private final IExternalPowerSink sink;
    double EUBuffer;

    GTCEEnergyAdapter(IExternalPowerSink sink) {
        this.sink = sink;
    }

    public long acceptEnergyFromNetwork(EnumFacing enumFacing, long voltage, long amperage) {
        double power = voltage * amperage;
        double oldBuffer = this.EUBuffer;
        this.EUBuffer = this.sink.injectExternalPower(PowerUnits.GTEU, power + this.EUBuffer, Actionable.MODULATE);
        if (this.EUBuffer <= oldBuffer) {
            return amperage;
        }
        if (this.EUBuffer >= power) {
            this.EUBuffer -= power;
            return 0L;
        }
        double usedEU = power + oldBuffer - this.EUBuffer;
        long ampsUsed = (long)Math.ceil(usedEU / (double)voltage);
        this.EUBuffer += usedEU % (double)voltage;
        return ampsUsed;
    }

    public boolean inputsEnergy(EnumFacing enumFacing) {
        return true;
    }

    public long changeEnergy(long l) {
        return 0L;
    }

    public long getEnergyStored() {
        return (long)Math.floor(PowerUnits.AE.convertTo(PowerUnits.GTEU, this.sink.getAECurrentPower()));
    }

    public long getEnergyCapacity() {
        return (long)Math.floor(PowerUnits.AE.convertTo(PowerUnits.GTEU, this.sink.getAEMaxPower()));
    }

    public long getInputAmperage() {
        return 0L;
    }

    public long getInputVoltage() {
        return 0L;
    }

    public long getEnergyCanBeInserted() {
        return this.getEnergyCapacity() - this.getEnergyStored();
    }
}

