/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.tracker;

import appeng.me.Grid;
import java.util.LinkedList;

public class Tracker {
    private final Grid grid;
    private final LinkedList<Integer> timeUsages = new LinkedList();
    private int timeUsageCache = 0;
    private long startTime = 0L;

    public Tracker(Grid grid) {
        this.grid = grid;
    }

    public void startTracking() {
        this.startTime = System.nanoTime() / 1000L;
    }

    public void endTracking() {
        this.updateTimeUsage(System.nanoTime() / 1000L - this.startTime);
    }

    public Grid getGrid() {
        return this.grid;
    }

    public int getTimeUsageAvg() {
        if (this.timeUsages.isEmpty()) {
            return 0;
        }
        return this.timeUsageCache / this.timeUsages.size();
    }

    public int getMaxTimeUsage() {
        if (this.timeUsages.isEmpty()) {
            return 0;
        }
        return this.timeUsages.stream().mapToInt(usage -> usage).max().getAsInt();
    }

    private void updateTimeUsage(long time) {
        int t = (int)time;
        this.timeUsages.addFirst(t);
        this.timeUsageCache += t;
        if (this.timeUsages.size() > 1200) {
            this.timeUsageCache -= this.timeUsages.pollLast().intValue();
        }
    }
}

