/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.tracker;

import appeng.me.Grid;
import appeng.server.tracker.Tracker;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;

public class PerformanceTracker {
    public static final PerformanceTracker INSTANCE = new PerformanceTracker();
    private Map<Grid, Tracker> trackers = new Object2ObjectOpenHashMap();
    private Map<Grid, Tracker> tracking = new Object2ObjectOpenHashMap();

    private PerformanceTracker() {
    }

    public void resetTracker() {
        this.trackers.clear();
        this.tracking.clear();
    }

    public Map<Grid, Tracker> getTrackers() {
        return this.trackers;
    }

    public void startTracking() {
        this.trackers.clear();
        this.trackers = this.tracking;
        this.tracking = new Object2ObjectOpenHashMap();
    }

    public void startTracking(Grid g) {
        Tracker tracker = this.trackers.computeIfAbsent(g, v -> new Tracker(g));
        tracker.startTracking();
        this.tracking.put(g, tracker);
    }

    public void endTracking(Grid g) {
        Tracker tracker = this.tracking.computeIfAbsent(g, v -> new Tracker(g));
        tracker.endTracking();
    }
}

