/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.subcommands;

import appeng.api.AEApi;
import appeng.api.networking.IGridNode;
import appeng.api.util.DimensionalCoord;
import appeng.me.Grid;
import appeng.server.ISubCommand;
import appeng.server.tracker.PerformanceTracker;
import appeng.server.tracker.Tracker;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class PerfTracker
implements ISubCommand {
    @Override
    public String getHelp(MinecraftServer srv) {
        return null;
    }

    @Override
    public void call(MinecraftServer srv, String[] args, ICommandSender sender) {
        if (args.length == 2) {
            if ("reset".equals(args[1])) {
                PerformanceTracker.INSTANCE.resetTracker();
                sender.func_145747_a((ITextComponent)new TextComponentString("\u6027\u80fd\u8ddf\u8e2a\u5668\u5df2\u7ecf\u91cd\u7f6e\u3002"));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "\u7528\u6cd5: /ae2 PerfTracker [reset]"));
            }
            return;
        }
        Map<Grid, Tracker> trackerMap = PerformanceTracker.INSTANCE.getTrackers();
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format("\u6b63\u5728\u6574\u7406\u6240\u6709 AE \u7f51\u7edc\u4e2d 1 \u5206\u949f\u5185\u7684\u6570\u636e ...(\u603b\u7f51\u7edc\u6570\u91cf: %s)", trackerMap.size())));
        trackerMap.values().stream().filter(t -> !t.getGrid().isEmpty()).sorted((o1, o2) -> Integer.compare(o2.getTimeUsageAvg(), o1.getTimeUsageAvg())).limit(10L).forEach(t -> PerfTracker.sendTrackerTimeUsage(t, sender));
    }

    public static void sendTrackerTimeUsage(Tracker tracker, ICommandSender sender) {
        Grid grid = tracker.getGrid();
        IGridNode pivot = grid.getPivot();
        DimensionalCoord location = pivot.getGridBlock().getLocation();
        int playerID = pivot.getPlayerID();
        EntityPlayer player = AEApi.instance().registries().players().findPlayer(playerID);
        int gridSize = grid.getNodes().size();
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format("\u7f51\u7edc\u4f4d\u7f6e\uff08\u4e2d\u5fc3\uff09\uff1a%s\uff0c\u7f51\u7edc\u8282\u70b9\u6570\u91cf\uff1a%s", location, gridSize)));
        if (player == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format("\u6240\u6709\u8005\uff1a\u672a\u77e5 (\u73a9\u5bb6 ID: %s)", playerID)));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format("\u6240\u6709\u8005\uff1a%s (UUID: %s)", player.getDisplayNameString(), player.func_110124_au())));
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format("\u5e73\u5747 Tick \u65f6\u95f4\uff1a%sms", Float.valueOf((float)tracker.getTimeUsageAvg() / 1000.0f))));
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format("\u6700\u5927 Tick \u65f6\u95f4\uff1a%sms", Float.valueOf((float)tracker.getMaxTimeUsage() / 1000.0f))));
        sender.func_145747_a((ITextComponent)new TextComponentString(""));
    }
}

