/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartModel;
import appeng.core.settings.TickRates;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.util.Platform;
import appeng.util.inv.WrapperChainedItemHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class PartP2PItems
extends PartP2PTunnel<PartP2PItems>
implements IItemHandler,
IGridTickable {
    private static final float POWER_DRAIN = 2.0f;
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_items");
    private boolean partVisited = false;
    private int depth;
    private int oldSize = 0;
    private boolean requested;
    private IItemHandler cachedInv;

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public PartP2PItems(ItemStack is) {
        super(is);
    }

    @Override
    public void onNeighborChanged(IBlockAccess w, BlockPos pos, BlockPos neighbor) {
        this.cachedInv = null;
        try {
            if (this.isOutput()) {
                for (PartP2PItems input : this.getInputs()) {
                    if (input == null) continue;
                    input.onTunnelNetworkChange();
                }
            }
        }
        catch (GridAccessException e) {
            e.printStackTrace();
        }
    }

    private IItemHandler getDestination() {
        TunnelCollection itemTunnels;
        this.requested = true;
        if (this.cachedInv != null) {
            return this.cachedInv;
        }
        ArrayList<IItemHandler> outs = new ArrayList<IItemHandler>();
        try {
            itemTunnels = this.getOutputs();
        }
        catch (GridAccessException e) {
            return EmptyHandler.INSTANCE;
        }
        for (PartP2PItems t : itemTunnels) {
            IItemHandler inv = t.getOutputInv();
            if (inv == null || inv == this) continue;
            if (Platform.getRandomInt() % 2 == 0) {
                outs.add(inv);
                continue;
            }
            outs.add(0, inv);
        }
        this.cachedInv = new WrapperChainedItemHandler(outs.toArray(new IItemHandler[outs.size()]));
        return this.cachedInv;
    }

    private IItemHandler getOutputInv() {
        IItemHandler ret = null;
        if (!this.partVisited) {
            this.partVisited = true;
            if (this.getProxy().isActive()) {
                EnumFacing facing = this.getSide().getFacing();
                TileEntity te = this.getTile().func_145831_w().func_175625_s(this.getTile().func_174877_v().func_177972_a(facing));
                if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) {
                    ret = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
                }
            }
            this.partVisited = false;
        }
        return ret;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.ItemTunnel.getMin(), TickRates.ItemTunnel.getMax(), false, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        boolean wasReq = this.requested;
        if (this.requested && this.cachedInv != null) {
            ((WrapperChainedItemHandler)this.cachedInv).cycleOrder();
        }
        this.requested = false;
        return wasReq ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
    }

    @Override
    public void onTunnelNetworkChange() {
        if (!this.isOutput()) {
            this.cachedInv = null;
            int olderSize = this.oldSize;
            this.oldSize = this.getDestination().getSlots();
            if (olderSize != this.oldSize) {
                this.getHost().notifyNeighbors();
            }
        } else {
            try {
                for (PartP2PItems input : this.getInputs()) {
                    if (input == null) continue;
                    input.getHost().notifyNeighbors();
                }
            }
            catch (GridAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capabilityClass) {
        if (capabilityClass == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capabilityClass);
    }

    @Override
    public <T> T getCapability(Capability<T> capabilityClass) {
        if (capabilityClass == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capabilityClass);
    }

    public int getSlots() {
        return this.getDestination().getSlots();
    }

    public ItemStack getStackInSlot(int i) {
        return this.getDestination().getStackInSlot(i);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.depth == 1) {
            return stack;
        }
        ++this.depth;
        ItemStack ret = this.getDestination().insertItem(slot, stack, simulate);
        --this.depth;
        return ret;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.getDestination().extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.getDestination().getSlotLimit(slot);
    }

    public float getPowerDrainPerTick() {
        return 2.0f;
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }
}

