/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.misc;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.ITickManager;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.capabilities.Capabilities;
import appeng.core.settings.TickRates;
import appeng.core.sync.GuiBridge;
import appeng.helpers.IPriorityHost;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.cache.GridStorageCache;
import appeng.me.helpers.MachineSource;
import appeng.me.storage.ITickingMonitor;
import appeng.me.storage.MEInventoryHandler;
import appeng.parts.PartModel;
import appeng.parts.automation.PartUpgradeable;
import appeng.parts.misc.ItemHandlerAdapter;
import appeng.parts.misc.ItemRepositoryAdapter;
import appeng.parts.misc.PartInterface;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.tile.misc.TileInterface;
import appeng.tile.networking.TileCableBus;
import appeng.util.ConfigManager;
import appeng.util.Platform;
import appeng.util.inv.InvOperation;
import appeng.util.prioritylist.FuzzyPriorityList;
import appeng.util.prioritylist.PrecisePriorityList;
import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class PartStorageBus
extends PartUpgradeable
implements IGridTickable,
ICellContainer,
IMEMonitorHandlerReceiver<IAEItemStack>,
IPriorityHost {
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("appliedenergistics2", "part/storage_bus_base");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/storage_bus_off"));
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/storage_bus_on"));
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/storage_bus_has_channel"));
    @CapabilityInject(value=IItemRepository.class)
    public static Capability<IItemRepository> ITEM_REPOSITORY_CAPABILITY = null;
    private static final Set<PartStorageBus> LOADED_STORAGE_BUSES = new ReferenceOpenHashSet();
    protected final IActionSource mySrc;
    protected final AppEngInternalAEInventory Config = new AppEngInternalAEInventory(this, 63);
    protected int priority = 0;
    protected boolean cached = false;
    protected ITickingMonitor monitor = null;
    protected MEInventoryHandler<IAEItemStack> handler = null;
    protected int handlerHash = 0;
    private boolean wasActive = false;
    private byte resetCacheLogic = 0;
    private boolean accessChanged;
    private boolean readOncePass;

    public PartStorageBus(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.ACCESS, AccessRestriction.READ_WRITE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.STORAGE_FILTER, StorageFilter.EXTRACTABLE_ONLY);
        this.getConfigManager().registerSetting(Settings.STICKY_MODE, YesNo.NO);
        this.mySrc = new MachineSource(this);
    }

    @Override
    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.updateStatus();
    }

    private void updateStatus() {
        boolean currentActive = this.getProxy().isActive();
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            try {
                this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
                this.getHost().markForUpdate();
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    @MENetworkEventSubscribe
    public void chanRender(MENetworkChannelsChanged changedChannels) {
        this.updateStatus();
    }

    @Override
    protected int getUpgradeSlots() {
        return 5;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (settingName.name().equals("ACCESS")) {
            this.accessChanged = true;
        }
        this.resetCache(true);
        this.getHost().markForSave();
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        super.onChangeInventory(inv, slot, mc, removedStack, newStack);
        if (inv == this.Config) {
            this.resetCache(true);
        }
    }

    @Override
    public void upgradesChanged() {
        super.upgradesChanged();
        this.resetCache(true);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.Config.readFromNBT(data, "config");
        this.priority = data.func_74762_e("priority");
        this.accessChanged = false;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.Config.writeToNBT(data, "config");
        data.func_74768_a("priority", this.priority);
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.Config;
        }
        return super.getInventoryByName(name);
    }

    protected void resetCache(boolean fullReset) {
        if (this.getHost() == null || this.getHost().getTile() == null || this.getHost().getTile().func_145831_w() == null || this.getHost().getTile().func_145831_w().field_72995_K) {
            return;
        }
        if (fullReset) {
            this.resetCacheLogic = (byte)2;
        } else if (this.resetCacheLogic < 2) {
            this.resetCacheLogic = 1;
        }
        try {
            this.getProxy().getTick().alertDevice(this.getProxy().getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public boolean isValid(Object verificationToken) {
        return this.handler == verificationToken;
    }

    @Override
    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> change, IActionSource source) {
        if (this.getProxy().isActive()) {
            Iterable<IAEItemStack> filteredChanges = this.filterChanges(change);
            AccessRestriction currentAccess = (AccessRestriction)((ConfigManager)this.getConfigManager()).getSetting(Settings.ACCESS);
            if (this.readOncePass) {
                this.readOncePass = false;
                try {
                    this.getProxy().getStorage().postAlterationOfStoredItems(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class), filteredChanges, this.mySrc);
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
                return;
            }
            if (!currentAccess.hasPermission(AccessRestriction.READ)) {
                return;
            }
            try {
                this.getProxy().getStorage().postAlterationOfStoredItems(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class), filteredChanges, source);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onListUpdate() {
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(3.0, 3.0, 15.0, 13.0, 13.0, 16.0);
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 15.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    @Override
    public void onNeighborChanged(IBlockAccess w, BlockPos pos, BlockPos neighbor) {
        if (pos.func_177972_a(this.getSide().getFacing()).equals((Object)neighbor)) {
            TileEntity te = w.func_175625_s(neighbor);
            if (te instanceof TileCableBus) {
                IPart iPart = ((TileCableBus)te).getPart(this.getSide().getOpposite());
                if (iPart == null) {
                    this.resetCache(true);
                    this.resetCache();
                } else if (iPart instanceof PartInterface && this.createHandlerHash(te) != this.handlerHash) {
                    this.resetCache(true);
                    this.resetCache();
                }
            } else if (te == null) {
                this.resetCache(true);
                this.resetCache();
            } else if (te instanceof TileInterface) {
                if (this.createHandlerHash(te) != this.handlerHash) {
                    this.resetCache(true);
                    this.resetCache();
                }
            } else {
                this.resetCache(false);
            }
        }
    }

    @SubscribeEvent
    public static void onChunkUnLoadStatic(ChunkEvent.Unload event) {
        LOADED_STORAGE_BUSES.forEach(storageBus -> storageBus.onChunkUnLoad(event));
    }

    private void onChunkUnLoad(ChunkEvent.Unload event) {
        ChunkPos unloadedChunkPos;
        TileEntity self = this.getHost().getTile();
        if (self.func_145831_w() != event.getWorld()) {
            return;
        }
        BlockPos selfPos = self.func_174877_v();
        ChunkPos selfChunkPos = new ChunkPos(selfPos);
        if (selfChunkPos.equals((Object)(unloadedChunkPos = event.getChunk().func_76632_l()))) {
            return;
        }
        ChunkPos targetChunkPos = new ChunkPos(selfPos.func_177972_a(this.getSide().getFacing()));
        if (targetChunkPos.equals((Object)unloadedChunkPos)) {
            this.handlerHash = 0;
            this.handler = null;
            this.resetCache(true);
        }
    }

    @Override
    public void removeFromWorld() {
        super.removeFromWorld();
        LOADED_STORAGE_BUSES.remove(this);
        if (LOADED_STORAGE_BUSES.isEmpty()) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    @Override
    public void addToWorld() {
        super.addToWorld();
        if (LOADED_STORAGE_BUSES.isEmpty()) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        LOADED_STORAGE_BUSES.add(this);
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 4.0f;
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (Platform.isServer()) {
            Platform.openGUI(player, this.getHost().getTile(), this.getSide(), GuiBridge.GUI_STORAGEBUS);
        }
        return true;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.StorageBus.getMin(), TickRates.StorageBus.getMax(), this.monitor == null, true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.resetCacheLogic != 0) {
            this.resetCache();
        }
        if (this.monitor != null) {
            return this.monitor.onTick();
        }
        return TickRateModulation.SLEEP;
    }

    protected void resetCache() {
        boolean fullReset = this.resetCacheLogic == 2;
        this.resetCacheLogic = 0;
        MEInventoryHandler<IAEItemStack> in = this.getInternalHandler();
        IItemList<Object> before = AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
        if (in != null) {
            if (this.accessChanged) {
                AccessRestriction currentAccess = (AccessRestriction)((ConfigManager)this.getConfigManager()).getSetting(Settings.ACCESS);
                AccessRestriction oldAccess = (AccessRestriction)((ConfigManager)this.getConfigManager()).getOldSetting(Settings.ACCESS);
                if (oldAccess.hasPermission(AccessRestriction.READ) && !currentAccess.hasPermission(AccessRestriction.READ)) {
                    this.readOncePass = true;
                }
                in.setBaseAccess(oldAccess);
                before = in.getAvailableItems(before);
                in.setBaseAccess(currentAccess);
                this.accessChanged = false;
            } else {
                before = in.getAvailableItems(before);
            }
        }
        this.cached = false;
        if (fullReset) {
            this.handlerHash = 0;
        }
        MEInventoryHandler<IAEItemStack> out = this.getInternalHandler();
        IItemList<Object> after = AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
        if (in != out) {
            if (out != null) {
                after = out.getAvailableItems(after);
            }
            Platform.postListChanges(before, after, this, this.mySrc);
        }
    }

    IMEInventory<IAEItemStack> getInventoryWrapper(TileEntity target) {
        IItemRepository handlerRepo;
        EnumFacing targetSide = this.getSide().getFacing().func_176734_d();
        IStorageMonitorableAccessor accessor = (IStorageMonitorableAccessor)target.getCapability(Capabilities.STORAGE_MONITORABLE_ACCESSOR, targetSide);
        if (accessor != null) {
            IStorageMonitorable inventory = accessor.getInventory(this.mySrc);
            if (inventory != null) {
                return inventory.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            }
            return null;
        }
        if (ITEM_REPOSITORY_CAPABILITY != null && target.hasCapability(ITEM_REPOSITORY_CAPABILITY, targetSide) && (handlerRepo = (IItemRepository)target.getCapability(ITEM_REPOSITORY_CAPABILITY, targetSide)) != null) {
            return new ItemRepositoryAdapter(handlerRepo, this);
        }
        IItemHandler handlerExt = (IItemHandler)target.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, targetSide);
        if (handlerExt != null) {
            return new ItemHandlerAdapter(handlerExt, this);
        }
        return null;
    }

    int createHandlerHash(TileEntity target) {
        if (target == null) {
            return 0;
        }
        EnumFacing targetSide = this.getSide().getFacing().func_176734_d();
        if (target.hasCapability(Capabilities.STORAGE_MONITORABLE_ACCESSOR, targetSide)) {
            IStorageMonitorable inventory;
            IStorageMonitorableAccessor accessor = (IStorageMonitorableAccessor)target.getCapability(Capabilities.STORAGE_MONITORABLE_ACCESSOR, targetSide);
            if (accessor != null && (inventory = accessor.getInventory(this.mySrc)) != null) {
                return Objects.hash(target, inventory.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)));
            }
            return Objects.hash(target, target.getCapability(Capabilities.STORAGE_MONITORABLE_ACCESSOR, targetSide));
        }
        IItemHandler itemHandler = (IItemHandler)target.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, targetSide);
        if (itemHandler != null) {
            return Objects.hash(target, itemHandler, itemHandler.getSlots());
        }
        return 0;
    }

    public MEInventoryHandler<IAEItemStack> getInternalHandler() {
        if (this.cached) {
            return this.handler;
        }
        boolean wasSleeping = this.monitor == null;
        this.cached = true;
        TileEntity self = this.getHost().getTile();
        TileEntity target = self.func_145831_w().func_175625_s(self.func_174877_v().func_177972_a(this.getSide().getFacing()));
        int newHandlerHash = this.createHandlerHash(target);
        if (newHandlerHash != 0 && newHandlerHash == this.handlerHash) {
            return this.handler;
        }
        this.handlerHash = newHandlerHash;
        this.handler = null;
        if (this.monitor != null) {
            ((IBaseMonitor)((Object)this.monitor)).removeListener(this);
        }
        this.monitor = null;
        if (target != null) {
            IMEInventory<IAEItemStack> inv = this.getInventoryWrapper(target);
            if (inv instanceof ITickingMonitor) {
                this.monitor = (ITickingMonitor)((Object)inv);
                this.monitor.setActionSource(this.mySrc);
                this.monitor.setMode((StorageFilter)this.getConfigManager().getSetting(Settings.STORAGE_FILTER));
            }
            if (inv != null) {
                this.handler = new MEInventoryHandler<IAEItemStack>(inv, AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
                this.handler.setBaseAccess((AccessRestriction)this.getConfigManager().getSetting(Settings.ACCESS));
                this.handler.setWhitelist(this.getInstalledUpgrades(Upgrades.INVERTER) > 0 ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST);
                this.handler.setPriority(this.priority);
                this.handler.setStorageFilter((StorageFilter)this.getConfigManager().getSetting(Settings.STORAGE_FILTER));
                IItemList<IAEItemStack> priorityList = AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
                int slotsToUse = 18 + this.getInstalledUpgrades(Upgrades.CAPACITY) * 9;
                for (int x = 0; x < this.Config.getSlots() && x < slotsToUse; ++x) {
                    IAEItemStack is = this.Config.getAEStackInSlot(x);
                    if (is == null) continue;
                    priorityList.add(is);
                }
                if (this.getInstalledUpgrades(Upgrades.STICKY) > 0) {
                    this.handler.setSticky(true);
                }
                if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0) {
                    this.handler.setPartitionList(new FuzzyPriorityList(priorityList, (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE)));
                } else {
                    this.handler.setPartitionList(new PrecisePriorityList(priorityList));
                }
                if (inv instanceof IBaseMonitor && ((AccessRestriction)((ConfigManager)this.getConfigManager()).getSetting(Settings.ACCESS)).hasPermission(AccessRestriction.READ)) {
                    ((IBaseMonitor)((Object)inv)).addListener(this, this.handler);
                }
            }
        }
        if (wasSleeping != (this.monitor == null)) {
            try {
                ITickManager tm = this.getProxy().getTick();
                if (this.monitor == null) {
                    tm.sleepDevice(this.getProxy().getNode());
                } else {
                    tm.wakeDevice(this.getProxy().getNode());
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        try {
            ((GridStorageCache)this.getProxy().getGrid().getCache(IStorageGrid.class)).cellUpdate(null);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return this.handler;
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel channel) {
        MEInventoryHandler<IAEItemStack> out;
        if (channel == AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class) && (out = this.getInternalHandler()) != null) {
            return Collections.singletonList(out);
        }
        return Collections.emptyList();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.getHost().markForSave();
        this.resetCache(true);
    }

    @Override
    public void blinkCell(int slot) {
    }

    @Override
    public void saveChanges(ICellInventory<?> cellInventory) {
    }

    @Override
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    @Override
    public ItemStack getItemStackRepresentation() {
        return AEApi.instance().definitions().parts().storageBus().maybeStack(1).orElse(ItemStack.field_190927_a);
    }

    @Override
    public GuiBridge getGuiBridge() {
        return GuiBridge.GUI_STORAGEBUS;
    }

    protected Iterable<IAEItemStack> filterChanges(Iterable<IAEItemStack> change) {
        Enum<?> storageFilter = this.getConfigManager().getSetting(Settings.STORAGE_FILTER);
        if (storageFilter == StorageFilter.EXTRACTABLE_ONLY && this.handler != null) {
            ArrayList<IAEItemStack> filteredList = new ArrayList<IAEItemStack>();
            for (IAEItemStack stack : change) {
                if (!this.handler.passesBlackOrWhitelist(stack)) continue;
                filteredList.add(stack);
            }
            return filteredList;
        }
        return change;
    }
}

