/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.StorageFilter;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.me.storage.ITickingMonitor;
import appeng.util.InventoryAdaptor;
import appeng.util.inv.ItemSlot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class MEMonitorIInventory
implements IMEMonitor<IAEItemStack>,
ITickingMonitor {
    private final InventoryAdaptor adaptor;
    private IItemList<IAEItemStack> cache = AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
    private final HashMap<IMEMonitorHandlerReceiver<IAEItemStack>, Object> listeners = new HashMap();
    private IActionSource mySource;
    private StorageFilter mode = StorageFilter.EXTRACTABLE_ONLY;

    public MEMonitorIInventory(InventoryAdaptor adaptor) {
        this.adaptor = adaptor;
    }

    @Override
    public void addListener(IMEMonitorHandlerReceiver<IAEItemStack> l, Object verificationToken) {
        this.listeners.put(l, verificationToken);
    }

    @Override
    public void removeListener(IMEMonitorHandlerReceiver<IAEItemStack> l) {
        this.listeners.remove(l);
    }

    @Override
    public IAEItemStack injectItems(IAEItemStack input, Actionable type, IActionSource src) {
        ItemStack out = ItemStack.field_190927_a;
        out = type == Actionable.SIMULATE ? this.adaptor.simulateAdd(input.createItemStack()) : this.adaptor.addItems(input.createItemStack());
        if (out.func_190926_b()) {
            return null;
        }
        IAEItemStack o = input.copy();
        o.setStackSize(out.func_190916_E());
        if (type == Actionable.MODULATE) {
            IAEItemStack added = o.copy();
            this.cache.add(added);
            this.postDifference(Collections.singletonList(added));
            this.onTick();
        }
        return o;
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request, Actionable type, IActionSource src) {
        ItemStack out = ItemStack.field_190927_a;
        out = type == Actionable.SIMULATE ? this.adaptor.simulateRemove((int)request.getStackSize(), request.getDefinition(), null) : this.adaptor.removeItems((int)request.getStackSize(), request.getDefinition(), null);
        if (out.func_190926_b()) {
            return null;
        }
        IAEItemStack o = request.copy();
        o.setStackSize(out.func_190916_E());
        if (type == Actionable.MODULATE) {
            IAEItemStack cachedStack = this.cache.findPrecise(request);
            if (cachedStack != null) {
                cachedStack.decStackSize(o.getStackSize());
                this.postDifference(Collections.singletonList((IAEItemStack)o.copy().setStackSize(-o.getStackSize())));
            }
            this.onTick();
        }
        return o;
    }

    @Override
    public IStorageChannel getChannel() {
        return AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    @Override
    public TickRateModulation onTick() {
        boolean changed = false;
        ArrayList<IAEItemStack> changes = new ArrayList<IAEItemStack>();
        IItemList<IAEItemStack> currentlyOnStorage = AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
        for (ItemSlot itemSlot : this.adaptor) {
            if (this.mode == StorageFilter.EXTRACTABLE_ONLY && !itemSlot.isExtractable()) continue;
            currentlyOnStorage.add(itemSlot.getAEItemStack());
        }
        for (IAEItemStack iAEItemStack : this.cache) {
            iAEItemStack.setStackSize(-iAEItemStack.getStackSize());
        }
        this.cache.addAll(currentlyOnStorage);
        for (IAEItemStack iAEItemStack : this.cache) {
            if (iAEItemStack.getStackSize() == 0L) continue;
            changes.add(iAEItemStack);
        }
        this.cache = currentlyOnStorage;
        if (!changes.isEmpty()) {
            this.postDifference(changes);
            changed = true;
        }
        return changed ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
    }

    private void postDifference(Iterable<IAEItemStack> a) {
        if (a != null) {
            Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object>> i = this.listeners.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object> l = i.next();
                IMEMonitorHandlerReceiver<IAEItemStack> key = l.getKey();
                if (key.isValid(l.getValue())) {
                    key.postChange(this, a, this.getActionSource());
                    continue;
                }
                i.remove();
            }
        }
    }

    @Override
    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public boolean isPrioritized(IAEItemStack input) {
        return false;
    }

    @Override
    public boolean canAccept(IAEItemStack input) {
        return true;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public int getSlot() {
        return 0;
    }

    @Override
    public boolean validForPass(int i) {
        return true;
    }

    @Override
    public IItemList<IAEItemStack> getAvailableItems(IItemList out) {
        for (IAEItemStack is : this.cache) {
            out.addStorage(is);
        }
        return out;
    }

    @Override
    public IItemList<IAEItemStack> getStorageList() {
        return this.cache;
    }

    private StorageFilter getMode() {
        return this.mode;
    }

    @Override
    public void setMode(StorageFilter mode) {
        this.mode = mode;
    }

    private IActionSource getActionSource() {
        return this.mySource;
    }

    @Override
    public void setActionSource(IActionSource mySource) {
        this.mySource = mySource;
    }
}

