/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.storage.MEInventoryHandler;
import appeng.me.storage.MEPassThrough;
import appeng.util.Platform;
import appeng.util.prioritylist.FuzzyPriorityList;
import appeng.util.prioritylist.PrecisePriorityList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;

public class BasicCellInventoryHandler<T extends IAEStack<T>>
extends MEInventoryHandler<T>
implements ICellInventoryHandler<T> {
    public BasicCellInventoryHandler(IMEInventory c, IStorageChannel<T> channel) {
        super(c, channel);
        ICellInventory ci = this.getCellInv();
        if (ci != null) {
            ItemStack is;
            int x;
            IItemList<T> priorityList = channel.createList();
            IItemHandler upgrades = ci.getUpgradesInventory();
            IItemHandler config = ci.getConfigInventory();
            FuzzyMode fzMode = ci.getFuzzyMode();
            boolean hasInverter = false;
            boolean hasFuzzy = false;
            boolean hasSticky = false;
            block5: for (x = 0; x < upgrades.getSlots(); ++x) {
                Upgrades u;
                is = upgrades.getStackInSlot(x);
                if (is.func_190926_b() || !(is.func_77973_b() instanceof IUpgradeModule) || (u = ((IUpgradeModule)is.func_77973_b()).getType(is)) == null) continue;
                switch (u) {
                    case FUZZY: {
                        hasFuzzy = true;
                        continue block5;
                    }
                    case INVERTER: {
                        hasInverter = true;
                        continue block5;
                    }
                    case STICKY: {
                        hasSticky = true;
                        continue block5;
                    }
                }
            }
            for (x = 0; x < config.getSlots(); ++x) {
                T configItem;
                is = config.getStackInSlot(x);
                if (is.func_190926_b() || (configItem = channel.createStack(is)) == null) continue;
                priorityList.add(configItem);
            }
            this.setWhitelist(hasInverter ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST);
            if (hasSticky) {
                this.setSticky(true);
            }
            if (!priorityList.isEmpty()) {
                if (hasFuzzy) {
                    this.setPartitionList(new FuzzyPriorityList<T>(priorityList, fzMode));
                } else {
                    this.setPartitionList(new PrecisePriorityList<T>(priorityList));
                }
            }
        }
    }

    @Override
    public ICellInventory getCellInv() {
        IMEInventory o = this.getInternal();
        if (o instanceof MEPassThrough) {
            o = ((MEPassThrough)o).getInternal();
        }
        return (ICellInventory)(o instanceof ICellInventory ? o : null);
    }

    @Override
    public boolean isPreformatted() {
        return !this.getPartitionList().isEmpty();
    }

    @Override
    public boolean isFuzzy() {
        return this.getPartitionList() instanceof FuzzyPriorityList;
    }

    @Override
    public IncludeExclude getIncludeExcludeMode() {
        return this.getWhitelist();
    }

    NBTTagCompound openNbtData() {
        return Platform.openNbtData(this.getCellInv().getItemStack());
    }

    @Override
    protected boolean canExtract(T request) {
        return this.hasReadAccess();
    }

    @Override
    protected boolean shouldItemBeAvailable(T request) {
        return this.hasReadAccess();
    }
}

