/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cache;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.events.MENetworkStorageEvent;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.cache.GridStorageCache;
import appeng.me.storage.ItemWatcher;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NetworkMonitor<T extends IAEStack<T>>
implements IMEMonitor<T> {
    @Nonnull
    private static final Object2ObjectMap<IActionSource, LinkedList<NetworkMonitor<?>>> src2MonitorsMap = new Object2ObjectOpenHashMap();
    private static final Set<IActionSource> nestingSources = new ObjectOpenHashSet();
    protected boolean wasNested = false;
    protected boolean isNested = false;
    @Nonnull
    private final GridStorageCache myGridCache;
    @Nonnull
    private final IStorageChannel<T> myChannel;
    @Nonnull
    private final IItemList<T> cachedList;
    @Nonnull
    private final Object2ObjectMap<IMEMonitorHandlerReceiver<T>, Object> listeners;
    private boolean sendEvent = false;
    private long gridItemCount;
    private long gridFluidCount;
    public boolean forceUpdate;

    public NetworkMonitor(GridStorageCache cache, IStorageChannel<T> chan) {
        this.myGridCache = cache;
        this.myChannel = chan;
        this.cachedList = chan.createList();
        this.listeners = new Object2ObjectOpenHashMap();
    }

    @Override
    public void addListener(IMEMonitorHandlerReceiver<T> l, Object verificationToken) {
        this.listeners.put(l, verificationToken);
    }

    @Override
    public boolean canAccept(T input) {
        return this.getHandler().canAccept(input);
    }

    @Override
    public T extractItems(T request, Actionable mode, IActionSource src) {
        return this.getHandler().extractItems(request, mode, src);
    }

    @Override
    public AccessRestriction getAccess() {
        return this.getHandler().getAccess();
    }

    @Override
    public IItemList<T> getAvailableItems(IItemList<T> out) {
        return this.getHandler().getAvailableItems(out);
    }

    @Override
    public IStorageChannel<T> getChannel() {
        return this.getHandler().getChannel();
    }

    @Override
    public int getPriority() {
        return this.getHandler().getPriority();
    }

    @Override
    public int getSlot() {
        return this.getHandler().getSlot();
    }

    public long getGridCurrentCount() {
        if (this.myChannel == AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
            return this.gridItemCount;
        }
        if (this.myChannel == AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class)) {
            return this.gridFluidCount;
        }
        return 0L;
    }

    public void incGridCurrentCount(long count) {
        if (this.myChannel == AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
            this.gridItemCount += count;
        } else if (this.myChannel == AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class)) {
            this.gridFluidCount += count;
        }
    }

    @Override
    @Nonnull
    public IItemList<T> getStorageList() {
        return this.cachedList;
    }

    @Override
    public T injectItems(T input, Actionable mode, IActionSource src) {
        return this.getHandler().injectItems(input, mode, src);
    }

    @Override
    public boolean isPrioritized(T input) {
        return this.getHandler().isPrioritized(input);
    }

    @Override
    public void removeListener(IMEMonitorHandlerReceiver<T> l) {
        this.listeners.remove(l);
    }

    @Override
    public boolean validForPass(int i) {
        return this.getHandler().validForPass(i);
    }

    @Nullable
    private IMEInventoryHandler<T> getHandler() {
        return this.myGridCache.getInventoryHandler(this.myChannel);
    }

    private Iterator<Map.Entry<IMEMonitorHandlerReceiver<T>, Object>> getListeners() {
        return this.listeners.entrySet().iterator();
    }

    private void notifyListenersOfChange(Iterable<T> diff, IActionSource src) {
        Iterator<Map.Entry<IMEMonitorHandlerReceiver<T>, Object>> i = this.getListeners();
        while (i.hasNext()) {
            Map.Entry<IMEMonitorHandlerReceiver<T>, Object> o = i.next();
            IMEMonitorHandlerReceiver<T> receiver = o.getKey();
            if (receiver.isValid(o.getValue())) {
                receiver.postChange(this, diff, src);
                continue;
            }
            i.remove();
        }
    }

    protected void updateCraftables(Iterable<T> input, IActionSource src) {
        for (IAEStack changedItem : input) {
            if (changedItem.isCraftable()) {
                this.cachedList.add(changedItem);
                continue;
            }
            IAEStack i = this.cachedList.findPrecise(changedItem);
            if (i == null) continue;
            i.setCraftable(false);
        }
    }

    protected void postChange(boolean add, Iterable<T> changes, IActionSource src) {
        src2MonitorsMap.putIfAbsent((Object)src, new LinkedList());
        if (((LinkedList)src2MonitorsMap.get((Object)src)).contains(this)) {
            nestingSources.add(src);
            return;
        }
        ((LinkedList)src2MonitorsMap.get((Object)src)).add(this);
        this.sendEvent = true;
        for (IAEStack change : changes) {
            Collection<ItemWatcher> list;
            if (!add && change != null) {
                change.setStackSize(-change.getStackSize());
            }
            this.incGridCurrentCount(change.getStackSize());
            this.cachedList.addStorage(change);
            if (!this.myGridCache.getInterestManager().containsKey(change) || (list = this.myGridCache.getInterestManager().get(change)).isEmpty()) continue;
            IAEStack fullStack = this.getStorageList().findPrecise(change);
            if (fullStack == null) {
                fullStack = change.copy();
                fullStack.setStackSize(0L);
            }
            this.myGridCache.getInterestManager().enableTransactions();
            for (ItemWatcher iw : list) {
                iw.getHost().onStackChange(this.getStorageList(), fullStack, change, src, this.getChannel());
            }
            this.myGridCache.getInterestManager().disableTransactions();
        }
        this.notifyListenersOfChange(changes, src);
        if (((LinkedList)src2MonitorsMap.get((Object)src)).getFirst() == this) {
            boolean nested = nestingSources.contains(src);
            ((LinkedList)src2MonitorsMap.get((Object)src)).forEach(networkMonitor -> {
                networkMonitor.isNested = nested;
            });
            ((LinkedList)src2MonitorsMap.get((Object)src)).forEach(networkMonitor -> {
                if (networkMonitor.isNested != networkMonitor.wasNested) {
                    networkMonitor.wasNested = networkMonitor.isNested;
                    networkMonitor.setForceUpdate(true);
                }
            });
            src2MonitorsMap.remove((Object)src);
            nestingSources.remove(src);
        }
    }

    public void setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
    }

    void forceUpdate() {
        this.forceUpdate = false;
        this.cachedList.resetStatus();
        this.getAvailableItems(this.cachedList);
        long count = 0L;
        for (IAEStack stack : this.cachedList) {
            Collection<ItemWatcher> list;
            count += stack.getStackSize();
            if (!this.myGridCache.getInterestManager().containsKey(stack) || (list = this.myGridCache.getInterestManager().get(stack)).isEmpty()) continue;
            IAEStack fullStack = this.getStorageList().findPrecise(stack);
            if (fullStack == null) {
                fullStack = stack.copy();
                fullStack.setStackSize(0L);
            }
            this.myGridCache.getInterestManager().enableTransactions();
            for (ItemWatcher iw : list) {
                iw.getHost().onStackChange(this.getStorageList(), fullStack, stack, null, this.getChannel());
            }
            this.myGridCache.getInterestManager().disableTransactions();
        }
        if (this.myChannel == AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
            this.gridItemCount = count;
        } else if (this.myChannel == AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class)) {
            this.gridFluidCount = count;
        }
        Iterator<Map.Entry<IMEMonitorHandlerReceiver<T>, Object>> i = this.getListeners();
        while (i.hasNext()) {
            Map.Entry<IMEMonitorHandlerReceiver<T>, Object> o = i.next();
            IMEMonitorHandlerReceiver<T> receiver = o.getKey();
            if (receiver.isValid(o.getValue())) {
                receiver.onListUpdate();
                continue;
            }
            i.remove();
        }
    }

    void onTick() {
        if (this.forceUpdate) {
            this.forceUpdate();
        }
        if (this.sendEvent) {
            this.sendEvent = false;
            this.myGridCache.getGrid().postEvent(new MENetworkStorageEvent(this, this.myChannel));
        }
    }
}

