/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.networking.IGridNode;
import appeng.api.networking.IMachineSet;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.core.AELog;
import appeng.me.Grid;
import appeng.me.GridCacheWrapper;
import appeng.me.GridNode;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class NetworkEventBus {
    private static final Collection<Class<?>> READ_CLASSES = new ReferenceOpenHashSet();
    private static final Map<Class<? extends MENetworkEvent>, Map<Class<?>, MENetworkEventInfo>> EVENTS = new Reference2ReferenceOpenHashMap();

    void readClass(Class<?> listAs, Class<?> c) {
        if (READ_CLASSES.contains(c)) {
            return;
        }
        READ_CLASSES.add(c);
        try {
            for (Method m : c.getMethods()) {
                MENetworkEventSubscribe s = m.getAnnotation(MENetworkEventSubscribe.class);
                if (s == null) continue;
                Class<?>[] types = m.getParameterTypes();
                if (types.length == 1) {
                    if (MENetworkEvent.class.isAssignableFrom(types[0])) {
                        MENetworkEventInfo thisEvent;
                        Reference2ObjectOpenHashMap classEvents = EVENTS.get(types[0]);
                        if (classEvents == null) {
                            classEvents = new Reference2ObjectOpenHashMap();
                            EVENTS.put((Class<MENetworkEvent>)types[0], (Map<Class<?>, MENetworkEventInfo>)classEvents);
                        }
                        if ((thisEvent = classEvents.get(listAs)) == null) {
                            thisEvent = new MENetworkEventInfo();
                        }
                        thisEvent.Add(types[0], c, MethodHandles.lookup().unreflect(m));
                        classEvents.put(listAs, thisEvent);
                        continue;
                    }
                    throw new IllegalStateException("Invalid ME Network Event Subscriber, " + m.getName() + "s Parameter must extend MENetworkEvent.");
                }
                throw new IllegalStateException("Invalid ME Network Event Subscriber, " + m.getName() + " must have exactly 1 parameter.");
            }
        }
        catch (Throwable t) {
            throw new IllegalStateException("Error while adding " + c.getName() + " to event bus", t);
        }
    }

    MENetworkEvent postEvent(Grid g, MENetworkEvent e) {
        Map<Class<?>, MENetworkEventInfo> subscribers = EVENTS.get(e.getClass());
        int x = 0;
        try {
            if (subscribers != null) {
                for (Map.Entry<Class<?>, MENetworkEventInfo> subscriber : subscribers.entrySet()) {
                    MENetworkEventInfo target = subscriber.getValue();
                    GridCacheWrapper cache = g.getCaches().get(subscriber.getKey());
                    if (cache != null) {
                        ++x;
                        target.invoke(cache.getCache(), e);
                    }
                    IMachineSet machines = g.getMachines(subscriber.getKey());
                    ArrayList work = new ArrayList(machines.size());
                    machines.forEach(work::add);
                    for (IGridNode obj : work) {
                        if (!machines.contains(obj)) continue;
                        ++x;
                        target.invoke(obj.getMachine(), e);
                    }
                }
            }
        }
        catch (NetworkEventDone networkEventDone) {
            // empty catch block
        }
        e.setVisitedObjects(x);
        return e;
    }

    MENetworkEvent postEventTo(Grid grid, GridNode node, MENetworkEvent e) {
        Map<Class<?>, MENetworkEventInfo> subscribers = EVENTS.get(e.getClass());
        int x = 0;
        try {
            MENetworkEventInfo target;
            if (subscribers != null && (target = subscribers.get(node.getMachineClass())) != null) {
                ++x;
                target.invoke(node.getMachine(), e);
            }
        }
        catch (NetworkEventDone networkEventDone) {
            // empty catch block
        }
        e.setVisitedObjects(x);
        return e;
    }

    private class MENetworkEventInfo {
        private final List<EventMethod> methods = new ObjectArrayList();

        private MENetworkEventInfo() {
        }

        private void Add(Class<?> Event2, Class<?> ObjClass, MethodHandle ObjMethod) {
            this.methods.add(new EventMethod(Event2, ObjClass, ObjMethod));
        }

        private void invoke(Object obj, MENetworkEvent e) throws NetworkEventDone {
            for (EventMethod em : this.methods) {
                em.invoke(obj, e);
            }
        }
    }

    private static class NetworkEventDone
    extends Throwable {
        private static final long serialVersionUID = -3079021487019171205L;

        private NetworkEventDone() {
        }
    }

    private class EventMethod {
        private final Class<?> objClass;
        private final MethodHandle objMethod;
        private final Class<?> objEvent;

        public EventMethod(Class<?> Event2, Class<?> ObjClass, MethodHandle ObjMethod) {
            this.objClass = ObjClass;
            this.objMethod = ObjMethod;
            this.objEvent = Event2;
        }

        private void invoke(Object obj, MENetworkEvent e) throws NetworkEventDone {
            try {
                this.objMethod.invoke(obj, e);
            }
            catch (Throwable e1) {
                AELog.error("[AppEng] Network Event caused exception:", new Object[0]);
                AELog.error("Class: %1s, Object: %2s", obj.getClass().getName(), obj.toString());
                AELog.info(e1);
                throw new IllegalStateException(e1);
            }
            if (e.isCanceled()) {
                throw new NetworkEventDone();
            }
        }
    }
}

