/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.misc;

import appeng.api.AEApi;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.AppEng;
import appeng.core.localization.GuiText;
import appeng.helpers.InvalidPatternHelper;
import appeng.helpers.PatternHelper;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import appeng.util.item.ItemStackHashStrategy;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEncodedPattern
extends AEBaseItem
implements ICraftingPatternItem {
    private static final ItemStackHashStrategy hashStrategy = ItemStackHashStrategy.comparingAllButCount();
    private static final Map<ItemStack, ItemStack> SIMPLE_CACHE = new Object2ObjectOpenCustomHashMap((Hash.Strategy)hashStrategy);

    public ItemEncodedPattern() {
        this.func_77625_d(64);
    }

    public ActionResult<ItemStack> func_77659_a(World w, EntityPlayer player, EnumHand hand) {
        this.clearPattern(player.func_184586_b(hand), player);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return this.clearPattern(player.func_184586_b(hand), player) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    private boolean clearPattern(ItemStack stack, EntityPlayer player) {
        if (player.func_70093_af()) {
            SIMPLE_CACHE.remove(stack);
            if (Platform.isClient()) {
                return false;
            }
            InventoryPlayer inv = player.field_71071_by;
            ItemStack is = AEApi.instance().definitions().materials().blankPattern().maybeStack(stack.func_190916_E()).orElse(ItemStack.field_190927_a);
            if (!is.func_190926_b()) {
                for (int s = 0; s < player.field_71071_by.func_70302_i_(); ++s) {
                    if (inv.func_70301_a(s) != stack) continue;
                    inv.func_70299_a(s, is);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        String encoder;
        NBTTagCompound tag;
        ICraftingPatternDetails details = this.getPatternForItem(stack, world);
        if (details == null) {
            if (!stack.func_77942_o()) {
                return;
            }
            stack.func_151001_c(TextFormatting.RED + GuiText.InvalidPattern.getLocal());
            InvalidPatternHelper invalid = new InvalidPatternHelper(stack);
            String label = (invalid.isCraftable() ? GuiText.Crafts.getLocal() : GuiText.Creates.getLocal()) + ": ";
            String and = ' ' + GuiText.And.getLocal() + ' ';
            String with = GuiText.With.getLocal() + ": ";
            boolean first = true;
            for (InvalidPatternHelper.PatternIngredient output : invalid.getOutputs()) {
                lines.add((first ? label : and) + output.getFormattedToolTip());
                first = false;
            }
            first = true;
            for (InvalidPatternHelper.PatternIngredient input : invalid.getInputs()) {
                lines.add((first ? with : and) + input.getFormattedToolTip());
                first = false;
            }
            if (invalid.isCraftable()) {
                String substitutionLabel = GuiText.Substitute.getLocal() + " ";
                String canSubstitute = invalid.canSubstitute() ? GuiText.Yes.getLocal() : GuiText.No.getLocal();
                lines.add(substitutionLabel + canSubstitute);
            }
            return;
        }
        if (stack.func_82837_s()) {
            stack.func_190919_e("display");
        }
        boolean isCrafting = details.isCraftable();
        boolean substitute = details.canSubstitute();
        IAEItemStack[] in = details.getCondensedInputs();
        IAEItemStack[] out = details.getCondensedOutputs();
        String label = (isCrafting ? GuiText.Crafts.getLocal() : GuiText.Creates.getLocal()) + ": ";
        String and = ' ' + GuiText.And.getLocal() + ' ';
        String with = GuiText.With.getLocal() + ": ";
        boolean first = true;
        for (IAEItemStack anOut : out) {
            if (anOut == null) continue;
            lines.add((first ? label : and) + anOut.getStackSize() + ' ' + Platform.getItemDisplayName(anOut));
            first = false;
        }
        first = true;
        for (IAEItemStack anIn : in) {
            if (anIn == null) continue;
            lines.add((first ? with : and) + anIn.getStackSize() + ' ' + Platform.getItemDisplayName(anIn));
            first = false;
        }
        if (isCrafting) {
            String substitutionLabel = GuiText.Substitute.getLocal() + " ";
            String canSubstitute = substitute ? GuiText.Yes.getLocal() : GuiText.No.getLocal();
            lines.add(substitutionLabel + canSubstitute);
        }
        if ((tag = stack.func_77978_p()) != null && !(encoder = tag.func_74779_i("encoderName")).isEmpty()) {
            lines.add(String.format(GuiText.PatternEncoder.getLocal(), encoder));
        }
    }

    @Override
    public ICraftingPatternDetails getPatternForItem(ItemStack is, World w) {
        try {
            return new PatternHelper(is, w);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public ItemStack getOutput(ItemStack item) {
        ItemStack out = SIMPLE_CACHE.get(item);
        if (out != null) {
            return out;
        }
        World w = AppEng.proxy.getWorld();
        if (w == null) {
            return ItemStack.field_190927_a;
        }
        ICraftingPatternDetails details = this.getPatternForItem(item, w);
        out = details != null ? details.getOutputs()[0].createItemStack() : ItemStack.field_190927_a;
        SIMPLE_CACHE.put(item, out);
        return out;
    }
}

