/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.PartItemStack;
import appeng.api.parts.SelectedPart;
import appeng.api.util.DimensionalCoord;
import appeng.util.LookDirection;
import appeng.util.Platform;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WrenchClickHook {
    @SubscribeEvent
    public void playerInteract(PlayerInteractEvent event) {
        if (event.getHand() != EnumHand.MAIN_HAND) {
            return;
        }
        if (event instanceof PlayerInteractEvent.RightClickBlock && !event.getEntityPlayer().field_70170_p.field_72995_K) {
            EntityPlayer player = event.getEntityPlayer();
            if (player instanceof FakePlayer) {
                return;
            }
            EnumHand hand = event.getHand();
            BlockPos pos = event.getPos();
            World world = event.getWorld();
            ItemStack held = event.getItemStack();
            if (player.func_70093_af() && Platform.isWrench(player, held, pos)) {
                Block block = world.func_180495_p(pos).func_177230_c();
                TileEntity tile = world.func_175625_s(pos);
                if (!(tile instanceof IPartHost)) {
                    return;
                }
                IPartHost host = (IPartHost)tile;
                if (!Platform.hasPermissions(new DimensionalCoord(world, pos), player)) {
                    return;
                }
                LookDirection dir = Platform.getPlayerRay(player, player.func_70047_e());
                RayTraceResult mop = block.func_180636_a(world.func_180495_p(pos), world, pos, dir.getA(), dir.getB());
                if (mop != null) {
                    SelectedPart sp = host.selectPartGlobal(mop.field_72307_f);
                    if (sp == null) {
                        return;
                    }
                    ArrayList<ItemStack> is = new ArrayList<ItemStack>();
                    IPart part = sp.part;
                    if (part != null) {
                        ISecurityGrid sg;
                        IGrid g;
                        IEnergyGrid eg;
                        IGridNode node = part.getGridNode();
                        if (node != null && node.isActive() && (eg = (IEnergyGrid)(g = node.getGrid()).getCache(IEnergyGrid.class)).isNetworkPowered() && !(sg = (ISecurityGrid)g.getCache(ISecurityGrid.class)).hasPermission(player, SecurityPermissions.BUILD)) {
                            return;
                        }
                        is.add(part.getItemStack(PartItemStack.WRENCH));
                        part.getDrops(is, true);
                        host.removePart(sp.side, false);
                    }
                    if (sp.facade != null) {
                        is.add(sp.facade.getItemStack());
                        host.getFacadeContainer().removeFacade(host, sp.side);
                        Platform.notifyBlocksOfNeighbors(world, pos);
                    }
                    if (host.isEmpty()) {
                        host.cleanup();
                    }
                    if (!is.isEmpty()) {
                        Platform.spawnDrops(world, pos, is);
                    }
                } else {
                    player.func_184609_a(hand);
                }
            }
        }
    }
}

