/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.util;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.fluids.util.AEFluidInventory;
import appeng.fluids.util.AEFluidStack;
import appeng.fluids.util.IAEFluidInventory;
import java.util.function.Supplier;
import net.minecraftforge.fluids.FluidStack;

public class AENetworkFluidInventory
extends AEFluidInventory {
    private final Supplier<IStorageGrid> supplier;
    private final IActionSource source;

    public AENetworkFluidInventory(Supplier<IStorageGrid> networkSupplier, IActionSource source, IAEFluidInventory handler, int slots, int capcity) {
        super(handler, slots, capcity);
        this.supplier = networkSupplier;
        this.source = source;
    }

    @Override
    public int fill(FluidStack fluid, boolean doFill) {
        if (fluid == null || fluid.amount <= 0) {
            return 0;
        }
        IStorageGrid storage = this.supplier.get();
        if (storage != null) {
            int originAmt = fluid.amount;
            IMEMonitor<IAEFluidStack> dest = storage.getInventory(AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class));
            IAEFluidStack overflow = dest.injectItems(AEFluidStack.fromFluidStack(fluid), doFill ? Actionable.MODULATE : Actionable.SIMULATE, this.source);
            if (overflow != null && overflow.getStackSize() == (long)originAmt) {
                return super.fill(fluid, doFill);
            }
            if (overflow != null) {
                return (int)((long)originAmt - overflow.getStackSize());
            }
            return originAmt;
        }
        return super.fill(fluid, doFill);
    }
}

